"use strict";

exports.__esModule = true;
exports.getChildren = getChildren;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function processChildren(c) {
  var slides = [];

  _react.default.Children.toArray(c).forEach(function (child) {
    if (child.type && child.type.displayName === 'SwiperSlide') {
      slides.push(child);
    } else if (child.props && child.props.children) {
      processChildren(child.props.children).forEach(function (slide) {
        return slides.push(slide);
      });
    }
  });

  return slides;
}

function getChildren(c) {
  var slides = [];
  var slots = {
    'container-start': [],
    'container-end': [],
    'wrapper-start': [],
    'wrapper-end': []
  };

  _react.default.Children.toArray(c).forEach(function (child) {
    if (child.type && child.type.displayName === 'SwiperSlide') {
      slides.push(child);
    } else if (child.props && child.props.slot && slots[child.props.slot]) {
      slots[child.props.slot].push(child);
    } else if (child.props && child.props.children) {
      var foundSlides = processChildren(child.props.children);

      if (foundSlides.length > 0) {
        foundSlides.forEach(function (slide) {
          return slides.push(slide);
        });
      } else {
        slots['container-end'].push(child);
      }
    } else {
      slots['container-end'].push(child);
    }
  });

  return {
    slides: slides,
    slots: slots
  };
}