import { EurekaClient } from 'eureka-js-client';
interface IEureka {
    port: number;
    appName: string;
    services: string[];
}
export default class Eurekaclient {
    private eureka;
    private opts;
    private pool;
    constructor(options: IEureka);
    /**
     * 启动eureka
     * @returns Promise<Eureka>
     */
    start(): Promise<void>;
    /**
     * stop
     */
    stop(): void;
    /**
     * 获取指定应用的ip
     * @param {(string | number)} name 应用名
     * @param {(string)} localIp 客户端IP
     * @param {string} [filterGroup] 要过滤的group service
     */
    getHost(name: string | number, localIp: string, filterGroup?: string): string;
    /** 获取代理信息(客户端IP, serviceGroupKey) */
    getProxyInfoFromReq(req: any): {
        ip: any;
        serviceGroupKey: string;
    };
    /**
     * 获取所有eureka
     */
    getAllEurekas(): EurekaClient.EurekaInstanceConfig[];
    /**
     * 获取所有实例下的host
     */
    getAllHostName(): import("./pool").IEurekaObjs;
    /**
     * 检查eureka服务是否掉线，掉线则重新注册服务
     * @param {string} appName
     * @memberof Eurekaclient
     */
    checkServiceHasNeedRegistry(appName: string): void;
}
export {};
