"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var eureka_js_client_1 = require("eureka-js-client");
var address = require('address');
var ip = address.ip() || '127.0.0.1';
function getParams(options) {
    var port = options.port, appName = options.appName;
    var env = process.env.NODE_ENV || 'dev';
    var eurekaHosts = {
        dev: ['http://eureka.duibadev.com.cn'],
        test: ['http://eureka.duibatest.com.cn'],
        autotest: ['http://autotest-eureka.duibatest.com.cn'],
        aliyunTest: ['http://10.170.1.121:1025'],
        pre: ['http://10.30.10.61:1025'],
        prod: ['http://10.10.10.21:1025', 'http://10.20.10.22:1025']
    };
    var msg;
    if (!env) {
        msg = '无法获取到NODE_ENV';
    }
    else if (!eurekaHosts[env]) {
        msg = "NODE_ENV\u9519\u8BEF\uFF0C\u53EA\u80FD\u4E3A" + Object.keys(eurekaHosts).join(',');
    }
    if (msg) {
        console.error(new Error("Eureka Error\uFF0C" + msg));
        process.exit(1);
    }
    return {
        // application instance information
        instance: {
            instanceId: ip + ":" + appName + ":" + port,
            hostName: ip,
            app: appName,
            ipAddr: ip,
            status: 'UP',
            port: { $: port, '@enabled': 'true' },
            securePort: { $: '443', '@enabled': 'false' },
            homePageUrl: "http://" + ip + ":" + port + "/",
            statusPageUrl: "http://" + ip + ":" + port + "/info",
            healthCheckUrl: "http://" + ip + ":" + port + "/health",
            lastDirtyTimestamp: +new Date(),
            vipAddress: appName,
            secureVipAddress: appName,
            dataCenterInfo: {
                '@class': 'com.netflix.appinfo.InstanceInfo$DefaultDataCenterInfo',
                name: 'MyOwn'
            },
            metadata: {
                weight: '100',
                'duiba.service.group.key': process.env.DUIBA_SERVICE_GROUP_KEY,
                zone: process.env.ZONE || 'defaultZone',
                'run.in.docker': process.env.RUN_IN_DOCKER || "false",
                'runInSingleJarMode': process.env.RUN_IN_DOCKER || "false",
                'duiba.perf.scene.id': process.env.DUIBA_PERF_SCENE_ID
            }
        },
        eureka: {
            // eureka server host / port
            serviceUrls: {
                default: eurekaHosts[env].map(function (el) { return el + "/eureka/apps/"; })
            }
        }
    };
}
function client(options) {
    var params = getParams(options);
    var client = new eureka_js_client_1.Eureka(params);
    return client;
}
exports.default = client;
//# sourceMappingURL=client.js.map