#### eureka-client-ts


``` javascript

// typescript
import Eurekaclient from 'eureka-client-ts'

// commonJs
const Eurekaclient = require('eureka-client-ts').default

const eureka = new Eurekaclient({
  port: 3000,
  appName: 'huhu',
  services: ['duiba-manager-web'],
});

(async () => {
  await eureka.start();
  global['eureka'] = eureka;
})();

const { ip, serviceGroupKey } = getProxyInfoFromReq(req)  // koa 参数为ctx.req
global['eureka'].getHost('duiba-manager-web', ip, serviceGroupKey);
```

#### start 启动 eureka 

#### stop 停止 eureka

#### getHost<name: string | number, filterGroup?: string>
> 优先使用本地, 其次查询有配置项的host，其次查询同网段的，都不满足，随便取一个

#### getProxyInfoFromReq<req: Response>
> 获取客户端IP(开发环境优先访问本地)，以及多场景的cookie

#### getAllEurekas 获取所有eureka

#### getAllHostName 获取所有实例下的host


### [混合云策略](http://cf.dui88.com/pages/viewpage.action?pageId=38788463)
