// Aliyun OSS SDK for JavaScript v6.18.0
// Copyright Aliyun.com, Inc. or its affiliates. All Rights Reserved.
// License at https://github.com/ali-sdk/ali-oss/blob/master/LICENSE
(function (global) {
  (function (f) {
    if (typeof exports === 'object' && typeof module !== 'undefined') {
      module.exports = f();
    } else if (typeof define === 'function' && define.amd) {
      define([], f);
    } else {
      var g;
      if (typeof window !== 'undefined') {
        g = window;
      } else if (typeof global !== 'undefined') {
        g = global;
      } else if (typeof self !== 'undefined') {
        g = self;
      } else {
        g = this;
      }
      g.OSS = f();
    }
  })(function () {
    var define, module, exports;
    return (function () {
      function r(e, n, t) {
        function o(i, f) {
          if (!n[i]) {
            if (!e[i]) {
              var c = 'function' == typeof require && require;
              if (!f && c) return c(i, !0);
              if (u) return u(i, !0);
              var a = new Error("Cannot find module '" + i + "'");
              throw ((a.code = 'MODULE_NOT_FOUND'), a);
            }
            var p = (n[i] = { exports: {} });
            e[i][0].call(
              p.exports,
              function (r) {
                var n = e[i][1][r];
                return o(n || r);
              },
              p,
              p.exports,
              r,
              e,
              n,
              t
            );
          }
          return n[i].exports;
        }
        for (var u = 'function' == typeof require && require, i = 0; i < t.length; i++) o(t[i]);
        return o;
      }
      return r;
    })()(
      {
        1: [
          function (require, module, exports) {
            'use strict';

            var OSS = require('./browser/client');

            OSS.Buffer = require('buffer').Buffer;
            OSS.urllib = require('../shims/xhr');
            OSS.version = require('./browser/version').version;
            module.exports = OSS;
          },
          { '../shims/xhr': 449, './browser/client': 3, './browser/version': 6, buffer: 89 }
        ],
        2: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.array.slice.js');

            var assert = require('assert');

            var _require = require('../common/utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var proto = exports;

            function isArray(arr) {
              if (Array.isArray) return Array.isArray(arr);
              return Object.prototype.toString.call(arr) === '[object Array]';
            }

            function toArray(obj) {
              if (!obj) return [];
              if (isArray(obj)) return obj;
              return [obj];
            }
            /**
             * Bucket opertaions
             */
            // TODO: OSS server currently do not support CORS requests for bucket operations
            // proto.listBuckets = function* listBuckets(query, options) {
            //   // prefix, marker, max-keys
            //   var result = yield this.request({
            //     method: 'GET',
            //     query: query,
            //     timeout: options && options.timeout,
            //     ctx: options && options.ctx,
            //   });
            //
            //   if (result.status === 200) {
            //     var data = yield this.parseXML(result.data);
            //     var buckets = data.Buckets || null;
            //     if (buckets) {
            //       if (buckets.Bucket) {
            //         buckets = buckets.Bucket;
            //       }
            //       if (!isArray(buckets)) {
            //         buckets = [buckets];
            //       }
            //       buckets = buckets.map(function (item) {
            //         return {
            //           name: item.Name,
            //           region: item.Location,
            //           creationDate: item.CreationDate,
            //         };
            //       });
            //     }
            //     return {
            //       buckets: buckets,
            //       owner: {
            //         id: data.Owner.ID,
            //         displayName: data.Owner.DisplayName,
            //       },
            //       isTruncated: data.IsTruncated === 'true',
            //       nextMarker: data.NextMarker || null,
            //       res: result.res
            //     };
            //   }
            //
            //   throw yield this.requestError(result);
            // };

            proto.useBucket = function useBucket(name) {
              _checkBucketName(name);

              this.options.bucket = name;
              return this;
            };

            proto.setBucket = function useBucket(name) {
              _checkBucketName(name);

              this.options.bucket = name;
              return this;
            };

            proto.getBucket = function getBucket() {
              return this.options.bucket;
            };

            proto.deleteBucket = /*#__PURE__*/ (function () {
              var _deleteBucket = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            params = this._bucketRequestParams('DELETE', name, '', options);
                            _context.next = 3;
                            return this.request(params);

                          case 3:
                            result = _context.sent;

                            if (!(result.status === 200 || result.status === 204)) {
                              _context.next = 6;
                              break;
                            }

                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 6:
                            _context.next = 8;
                            return this.requestError(result);

                          case 8:
                            throw _context.sent;

                          case 9:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function deleteBucket(_x, _x2) {
                return _deleteBucket.apply(this, arguments);
              }

              return deleteBucket;
            })(); // acl

            proto.putBucketACL = /*#__PURE__*/ (function () {
              var _putBucketACL = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee2(name, acl, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee2$(_context2) {
                      while (1) {
                        switch ((_context2.prev = _context2.next)) {
                          case 0:
                            params = this._bucketRequestParams('PUT', name, 'acl', options);
                            params.headers = {
                              'x-oss-acl': acl
                            };
                            params.successStatuses = [200];
                            _context2.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context2.sent;
                            return _context2.abrupt('return', {
                              bucket: (result.headers.location && result.headers.location.substring(1)) || null,
                              res: result.res
                            });

                          case 7:
                          case 'end':
                            return _context2.stop();
                        }
                      }
                    },
                    _callee2,
                    this
                  );
                })
              );

              function putBucketACL(_x3, _x4, _x5) {
                return _putBucketACL.apply(this, arguments);
              }

              return putBucketACL;
            })();

            proto.getBucketACL = /*#__PURE__*/ (function () {
              var _getBucketACL = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee3(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee3$(_context3) {
                      while (1) {
                        switch ((_context3.prev = _context3.next)) {
                          case 0:
                            params = this._bucketRequestParams('GET', name, 'acl', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context3.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context3.sent;
                            return _context3.abrupt('return', {
                              acl: result.data.AccessControlList.Grant,
                              owner: {
                                id: result.data.Owner.ID,
                                displayName: result.data.Owner.DisplayName
                              },
                              res: result.res
                            });

                          case 7:
                          case 'end':
                            return _context3.stop();
                        }
                      }
                    },
                    _callee3,
                    this
                  );
                })
              );

              function getBucketACL(_x6, _x7) {
                return _getBucketACL.apply(this, arguments);
              }

              return getBucketACL;
            })(); // logging

            proto.putBucketLogging = /*#__PURE__*/ (function () {
              var _putBucketLogging = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee4(name, prefix, options) {
                  var params, xml, result;
                  return _regenerator.default.wrap(
                    function _callee4$(_context4) {
                      while (1) {
                        switch ((_context4.prev = _context4.next)) {
                          case 0:
                            params = this._bucketRequestParams('PUT', name, 'logging', options);
                            xml =
                              '<?xml version="1.0" encoding="UTF-8"?>\n<BucketLoggingStatus>\n<LoggingEnabled>\n<TargetBucket>'.concat(
                                name,
                                '</TargetBucket>\n'
                              );

                            if (prefix) {
                              xml += '<TargetPrefix>'.concat(prefix, '</TargetPrefix>\n');
                            }

                            xml += '</LoggingEnabled>\n</BucketLoggingStatus>';
                            params.content = xml;
                            params.mime = 'xml';
                            params.successStatuses = [200];
                            _context4.next = 9;
                            return this.request(params);

                          case 9:
                            result = _context4.sent;
                            return _context4.abrupt('return', {
                              res: result.res
                            });

                          case 11:
                          case 'end':
                            return _context4.stop();
                        }
                      }
                    },
                    _callee4,
                    this
                  );
                })
              );

              function putBucketLogging(_x8, _x9, _x10) {
                return _putBucketLogging.apply(this, arguments);
              }

              return putBucketLogging;
            })();

            proto.getBucketLogging = /*#__PURE__*/ (function () {
              var _getBucketLogging = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee5(name, options) {
                  var params, result, enable;
                  return _regenerator.default.wrap(
                    function _callee5$(_context5) {
                      while (1) {
                        switch ((_context5.prev = _context5.next)) {
                          case 0:
                            params = this._bucketRequestParams('GET', name, 'logging', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context5.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context5.sent;
                            enable = result.data.LoggingEnabled;
                            return _context5.abrupt('return', {
                              enable: !!enable,
                              prefix: (enable && enable.TargetPrefix) || null,
                              res: result.res
                            });

                          case 8:
                          case 'end':
                            return _context5.stop();
                        }
                      }
                    },
                    _callee5,
                    this
                  );
                })
              );

              function getBucketLogging(_x11, _x12) {
                return _getBucketLogging.apply(this, arguments);
              }

              return getBucketLogging;
            })();

            proto.deleteBucketLogging = /*#__PURE__*/ (function () {
              var _deleteBucketLogging = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee6(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee6$(_context6) {
                      while (1) {
                        switch ((_context6.prev = _context6.next)) {
                          case 0:
                            params = this._bucketRequestParams('DELETE', name, 'logging', options);
                            params.successStatuses = [204, 200];
                            _context6.next = 4;
                            return this.request(params);

                          case 4:
                            result = _context6.sent;
                            return _context6.abrupt('return', {
                              res: result.res
                            });

                          case 6:
                          case 'end':
                            return _context6.stop();
                        }
                      }
                    },
                    _callee6,
                    this
                  );
                })
              );

              function deleteBucketLogging(_x13, _x14) {
                return _deleteBucketLogging.apply(this, arguments);
              }

              return deleteBucketLogging;
            })();

            proto.putBucketCORS = /*#__PURE__*/ (function () {
              var _putBucketCORS = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee7(name, rules, options) {
                  var params, xml, parseOrigin, parseMethod, parseHeader, parseExposeHeader, i, l, rule, result;
                  return _regenerator.default.wrap(
                    function _callee7$(_context7) {
                      while (1) {
                        switch ((_context7.prev = _context7.next)) {
                          case 0:
                            rules = rules || [];
                            assert(rules.length, 'rules is required');
                            rules.forEach(function (rule) {
                              assert(rule.allowedOrigin, 'allowedOrigin is required');
                              assert(rule.allowedMethod, 'allowedMethod is required');
                            });
                            params = this._bucketRequestParams('PUT', name, 'cors', options);
                            xml = '<?xml version="1.0" encoding="UTF-8"?>\n<CORSConfiguration>';

                            parseOrigin = function parseOrigin(val) {
                              xml += '<AllowedOrigin>'.concat(val, '</AllowedOrigin>');
                            };

                            parseMethod = function parseMethod(val) {
                              xml += '<AllowedMethod>'.concat(val, '</AllowedMethod>');
                            };

                            parseHeader = function parseHeader(val) {
                              xml += '<AllowedHeader>'.concat(val, '</AllowedHeader>');
                            };

                            parseExposeHeader = function parseExposeHeader(val) {
                              xml += '<ExposeHeader>'.concat(val, '</ExposeHeader>');
                            };

                            for (i = 0, l = rules.length; i < l; i++) {
                              rule = rules[i];
                              xml += '<CORSRule>';
                              toArray(rule.allowedOrigin).forEach(parseOrigin);
                              toArray(rule.allowedMethod).forEach(parseMethod);
                              toArray(rule.allowedHeader).forEach(parseHeader);
                              toArray(rule.exposeHeader).forEach(parseExposeHeader);

                              if (rule.maxAgeSeconds) {
                                xml += '<MaxAgeSeconds>'.concat(rule.maxAgeSeconds, '</MaxAgeSeconds>');
                              }

                              xml += '</CORSRule>';
                            }

                            xml += '</CORSConfiguration>';
                            params.content = xml;
                            params.mime = 'xml';
                            params.successStatuses = [200];
                            _context7.next = 16;
                            return this.request(params);

                          case 16:
                            result = _context7.sent;
                            return _context7.abrupt('return', {
                              res: result.res
                            });

                          case 18:
                          case 'end':
                            return _context7.stop();
                        }
                      }
                    },
                    _callee7,
                    this
                  );
                })
              );

              function putBucketCORS(_x15, _x16, _x17) {
                return _putBucketCORS.apply(this, arguments);
              }

              return putBucketCORS;
            })();

            proto.getBucketCORS = /*#__PURE__*/ (function () {
              var _getBucketCORS = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee8(name, options) {
                  var params, result, rules, CORSRule;
                  return _regenerator.default.wrap(
                    function _callee8$(_context8) {
                      while (1) {
                        switch ((_context8.prev = _context8.next)) {
                          case 0:
                            params = this._bucketRequestParams('GET', name, 'cors', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context8.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context8.sent;
                            rules = [];

                            if (result.data && result.data.CORSRule) {
                              CORSRule = result.data.CORSRule;
                              if (!isArray(CORSRule)) CORSRule = [CORSRule];
                              CORSRule.forEach(function (rule) {
                                var r = {};
                                Object.keys(rule).forEach(function (key) {
                                  r[key.slice(0, 1).toLowerCase() + key.slice(1, key.length)] = rule[key];
                                });
                                rules.push(r);
                              });
                            }

                            return _context8.abrupt('return', {
                              rules: rules,
                              res: result.res
                            });

                          case 9:
                          case 'end':
                            return _context8.stop();
                        }
                      }
                    },
                    _callee8,
                    this
                  );
                })
              );

              function getBucketCORS(_x18, _x19) {
                return _getBucketCORS.apply(this, arguments);
              }

              return getBucketCORS;
            })();

            proto.deleteBucketCORS = /*#__PURE__*/ (function () {
              var _deleteBucketCORS = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee9(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee9$(_context9) {
                      while (1) {
                        switch ((_context9.prev = _context9.next)) {
                          case 0:
                            params = this._bucketRequestParams('DELETE', name, 'cors', options);
                            params.successStatuses = [204];
                            _context9.next = 4;
                            return this.request(params);

                          case 4:
                            result = _context9.sent;
                            return _context9.abrupt('return', {
                              res: result.res
                            });

                          case 6:
                          case 'end':
                            return _context9.stop();
                        }
                      }
                    },
                    _callee9,
                    this
                  );
                })
              );

              function deleteBucketCORS(_x20, _x21) {
                return _deleteBucketCORS.apply(this, arguments);
              }

              return deleteBucketCORS;
            })(); // referer

            proto.putBucketReferer = /*#__PURE__*/ (function () {
              var _putBucketReferer = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee10(name, allowEmpty, referers, options) {
                  var params, xml, i, result;
                  return _regenerator.default.wrap(
                    function _callee10$(_context10) {
                      while (1) {
                        switch ((_context10.prev = _context10.next)) {
                          case 0:
                            params = this._bucketRequestParams('PUT', name, 'referer', options);
                            xml = '<?xml version="1.0" encoding="UTF-8"?>\n<RefererConfiguration>\n';
                            xml += '  <AllowEmptyReferer>'.concat(
                              allowEmpty ? 'true' : 'false',
                              '</AllowEmptyReferer>\n'
                            );

                            if (referers && referers.length > 0) {
                              xml += '  <RefererList>\n';

                              for (i = 0; i < referers.length; i++) {
                                xml += '    <Referer>'.concat(referers[i], '</Referer>\n');
                              }

                              xml += '  </RefererList>\n';
                            } else {
                              xml += '  <RefererList />\n';
                            }

                            xml += '</RefererConfiguration>';
                            params.content = xml;
                            params.mime = 'xml';
                            params.successStatuses = [200];
                            _context10.next = 10;
                            return this.request(params);

                          case 10:
                            result = _context10.sent;
                            return _context10.abrupt('return', {
                              res: result.res
                            });

                          case 12:
                          case 'end':
                            return _context10.stop();
                        }
                      }
                    },
                    _callee10,
                    this
                  );
                })
              );

              function putBucketReferer(_x22, _x23, _x24, _x25) {
                return _putBucketReferer.apply(this, arguments);
              }

              return putBucketReferer;
            })();

            proto.getBucketReferer = /*#__PURE__*/ (function () {
              var _getBucketReferer = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee11(name, options) {
                  var params, result, referers;
                  return _regenerator.default.wrap(
                    function _callee11$(_context11) {
                      while (1) {
                        switch ((_context11.prev = _context11.next)) {
                          case 0:
                            params = this._bucketRequestParams('GET', name, 'referer', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context11.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context11.sent;
                            referers = result.data.RefererList.Referer || null;

                            if (referers) {
                              if (!isArray(referers)) {
                                referers = [referers];
                              }
                            }

                            return _context11.abrupt('return', {
                              allowEmpty: result.data.AllowEmptyReferer === 'true',
                              referers: referers,
                              res: result.res
                            });

                          case 9:
                          case 'end':
                            return _context11.stop();
                        }
                      }
                    },
                    _callee11,
                    this
                  );
                })
              );

              function getBucketReferer(_x26, _x27) {
                return _getBucketReferer.apply(this, arguments);
              }

              return getBucketReferer;
            })();

            proto.deleteBucketReferer = /*#__PURE__*/ (function () {
              var _deleteBucketReferer = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee12(name, options) {
                  return _regenerator.default.wrap(
                    function _callee12$(_context12) {
                      while (1) {
                        switch ((_context12.prev = _context12.next)) {
                          case 0:
                            _context12.next = 2;
                            return this.putBucketReferer(name, true, null, options);

                          case 2:
                            return _context12.abrupt('return', _context12.sent);

                          case 3:
                          case 'end':
                            return _context12.stop();
                        }
                      }
                    },
                    _callee12,
                    this
                  );
                })
              );

              function deleteBucketReferer(_x28, _x29) {
                return _deleteBucketReferer.apply(this, arguments);
              }

              return deleteBucketReferer;
            })(); // private apis

            proto._bucketRequestParams = function _bucketRequestParams(method, bucket, subres, options) {
              return {
                method: method,
                bucket: bucket,
                subres: subres,
                timeout: options && options.timeout,
                ctx: options && options.ctx
              };
            };
          },
          {
            '../common/utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            assert: 81,
            'core-js/modules/es.array.slice.js': 278,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        3: [
          function (require, module, exports) {
            (function (Buffer, process) {
              (function () {
                'use strict';

                var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

                var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

                var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

                require('core-js/modules/es.function.name.js');

                require('core-js/modules/es.regexp.exec.js');

                require('core-js/modules/es.string.split.js');

                require('core-js/modules/es.object.assign.js');

                require('core-js/modules/es.array.includes.js');

                require('core-js/modules/es.string.replace.js');

                require('core-js/modules/es.array.concat.js');

                require('core-js/modules/es.symbol.js');

                require('core-js/modules/es.symbol.description.js');

                require('core-js/modules/es.array.slice.js');

                require('core-js/modules/es.object.to-string.js');

                require('core-js/modules/es.promise.js');

                require('core-js/modules/es.regexp.to-string.js');

                var debug = require('debug')('ali-oss');

                var xml = require('xml2js');

                var AgentKeepalive = require('agentkeepalive');

                var merge = require('merge-descriptors');

                var platform = require('platform');

                var utility = require('utility');

                var urllib = require('urllib');

                var pkg = require('./version');

                var bowser = require('bowser');

                var signUtils = require('../common/signUtils');

                var _initOptions = require('../common/client/initOptions');

                var _require = require('../common/utils/createRequest'),
                  createRequest = _require.createRequest;

                var _require2 = require('../common/utils/encoder'),
                  encoder = _require2.encoder;

                var _require3 = require('../common/client/getReqUrl'),
                  getReqUrl = _require3.getReqUrl;

                var _require4 = require('../common/utils/setSTSToken'),
                  setSTSToken = _require4.setSTSToken;

                var _require5 = require('../common/utils/retry'),
                  retry = _require5.retry;

                var _require6 = require('../common/utils/isFunction'),
                  isFunction = _require6.isFunction;

                var globalHttpAgent = new AgentKeepalive();

                function _unSupportBrowserTip() {
                  var name = platform.name,
                    version = platform.version;

                  if (name && name.toLowerCase && name.toLowerCase() === 'ie' && version.split('.')[0] < 10) {
                    // eslint-disable-next-line no-console
                    console.warn('ali-oss does not support the current browser');
                  }
                } // check local web protocol,if https secure default set true , if http secure default set false

                function isHttpsWebProtocol() {
                  // for web worker not use window.location.
                  // eslint-disable-next-line no-restricted-globals
                  return location && location.protocol === 'https:';
                }

                function Client(options, ctx) {
                  _unSupportBrowserTip();

                  if (!(this instanceof Client)) {
                    return new Client(options, ctx);
                  }

                  if (options && options.inited) {
                    this.options = options;
                  } else {
                    this.options = Client.initOptions(options);
                  }

                  this.options.cancelFlag = false; // cancel flag: if true need to be cancelled, default false
                  // support custom agent and urllib client

                  if (this.options.urllib) {
                    this.urllib = this.options.urllib;
                  } else {
                    this.urllib = urllib;
                    this.agent = this.options.agent || globalHttpAgent;
                  }

                  this.ctx = ctx;
                  this.userAgent = this._getUserAgent();
                  this.stsTokenFreshTime = new Date(); // record the time difference between client and server

                  this.options.amendTimeSkewed = 0;
                }
                /**
                 * Expose `Client`
                 */

                module.exports = Client;

                Client.initOptions = function initOptions(options) {
                  if (!options.stsToken) {
                    console.warn(
                      'Please use STS Token for safety, see more details at https://help.aliyun.com/document_detail/32077.html'
                    );
                  }

                  var opts = Object.assign(
                    {
                      secure: isHttpsWebProtocol(),
                      // for browser compatibility disable fetch.
                      useFetch: false
                    },
                    options
                  );
                  return _initOptions(opts);
                };
                /**
                 * prototype
                 */

                var proto = Client.prototype; // mount debug on proto

                proto.debug = debug;
                /**
                 * Object operations
                 */

                merge(proto, require('./object'));
                /**
                 * Bucket operations
                 */

                merge(proto, require('./bucket'));
                merge(proto, require('../common/bucket/getBucketWebsite'));
                merge(proto, require('../common/bucket/putBucketWebsite'));
                merge(proto, require('../common/bucket/deleteBucketWebsite')); // lifecycle

                merge(proto, require('../common/bucket/getBucketLifecycle'));
                merge(proto, require('../common/bucket/putBucketLifecycle'));
                merge(proto, require('../common/bucket/deleteBucketLifecycle')); // multiversion

                merge(proto, require('../common/bucket/putBucketVersioning'));
                merge(proto, require('../common/bucket/getBucketVersioning')); // inventory

                merge(proto, require('../common/bucket/getBucketInventory'));
                merge(proto, require('../common/bucket/deleteBucketInventory'));
                merge(proto, require('../common/bucket/listBucketInventory'));
                merge(proto, require('../common/bucket/putBucketInventory')); // worm

                merge(proto, require('../common/bucket/abortBucketWorm'));
                merge(proto, require('../common/bucket/completeBucketWorm'));
                merge(proto, require('../common/bucket/extendBucketWorm'));
                merge(proto, require('../common/bucket/getBucketWorm'));
                merge(proto, require('../common/bucket/initiateBucketWorm')); // multipart upload

                merge(proto, require('./managed-upload'));
                /**
                 * common multipart-copy support node and browser
                 */

                merge(proto, require('../common/multipart-copy'));
                /**
                 * Multipart operations
                 */

                merge(proto, require('../common/multipart'));
                /**
                 * Common module parallel
                 */

                merge(proto, require('../common/parallel'));
                /**
                 * get OSS signature
                 * @param {String} stringToSign
                 * @return {String} the signature
                 */

                proto.signature = function signature(stringToSign) {
                  this.debug('authorization stringToSign: %s', stringToSign, 'info');
                  return signUtils.computeSignature(
                    this.options.accessKeySecret,
                    stringToSign,
                    this.options.headerEncoding
                  );
                };

                proto._getReqUrl = getReqUrl;
                /**
                 * get author header
                 *
                 * "Authorization: OSS " + Access Key Id + ":" + Signature
                 *
                 * Signature = base64(hmac-sha1(Access Key Secret + "\n"
                 *  + VERB + "\n"
                 *  + CONTENT-MD5 + "\n"
                 *  + CONTENT-TYPE + "\n"
                 *  + DATE + "\n"
                 *  + CanonicalizedOSSHeaders
                 *  + CanonicalizedResource))
                 *
                 * @param {String} method
                 * @param {String} resource
                 * @param {Object} header
                 * @return {String}
                 *
                 * @api private
                 */

                proto.authorization = function authorization(method, resource, subres, headers) {
                  var stringToSign = signUtils.buildCanonicalString(method.toUpperCase(), resource, {
                    headers: headers,
                    parameters: subres
                  });
                  return signUtils.authorization(
                    this.options.accessKeyId,
                    this.options.accessKeySecret,
                    stringToSign,
                    this.options.headerEncoding
                  );
                };
                /**
                 * request oss server
                 * @param {Object} params
                 *   - {String} object
                 *   - {String} bucket
                 *   - {Object} [headers]
                 *   - {Object} [query]
                 *   - {Buffer} [content]
                 *   - {Stream} [stream]
                 *   - {Stream} [writeStream]
                 *   - {String} [mime]
                 *   - {Boolean} [xmlResponse]
                 *   - {Boolean} [customResponse]
                 *   - {Number} [timeout]
                 *   - {Object} [ctx] request context, default is `this.ctx`
                 *
                 * @api private
                 */

                proto.request = /*#__PURE__*/ (function () {
                  var _ref = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee(params) {
                      var _this = this;

                      return _regenerator.default.wrap(
                        function _callee$(_context) {
                          while (1) {
                            switch ((_context.prev = _context.next)) {
                              case 0:
                                if (!this.options.retryMax) {
                                  _context.next = 6;
                                  break;
                                }

                                _context.next = 3;
                                return retry(request.bind(this), this.options.retryMax, {
                                  errorHandler: function errorHandler(err) {
                                    var _errHandle = function _errHandle(_err) {
                                      if (params.stream) return false;
                                      var statusErr = [-1, -2].includes(_err.status);

                                      var requestErrorRetryHandle =
                                        _this.options.requestErrorRetryHandle ||
                                        function () {
                                          return true;
                                        };

                                      return statusErr && requestErrorRetryHandle(_err);
                                    };

                                    if (_errHandle(err)) return true;
                                    return false;
                                  }
                                })(params);

                              case 3:
                                return _context.abrupt('return', _context.sent);

                              case 6:
                                return _context.abrupt('return', request.call(this, params));

                              case 7:
                              case 'end':
                                return _context.stop();
                            }
                          }
                        },
                        _callee,
                        this
                      );
                    })
                  );

                  return function (_x) {
                    return _ref.apply(this, arguments);
                  };
                })();

                function request(_x2) {
                  return _request.apply(this, arguments);
                }

                function _request() {
                  _request = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee3(params) {
                      var reqParams, result, reqErr, useStream, err, parseData;
                      return _regenerator.default.wrap(
                        function _callee3$(_context3) {
                          while (1) {
                            switch ((_context3.prev = _context3.next)) {
                              case 0:
                                if (!(this.options.stsToken && isFunction(this.options.refreshSTSToken))) {
                                  _context3.next = 3;
                                  break;
                                }

                                _context3.next = 3;
                                return setSTSToken.call(this);

                              case 3:
                                reqParams = createRequest.call(this, params);

                                if (!this.options.useFetch) {
                                  reqParams.params.mode = 'disable-fetch';
                                }

                                useStream = !!params.stream;
                                _context3.prev = 6;
                                _context3.next = 9;
                                return this.urllib.request(reqParams.url, reqParams.params);

                              case 9:
                                result = _context3.sent;
                                this.debug(
                                  'response %s %s, got %s, headers: %j',
                                  params.method,
                                  reqParams.url,
                                  result.status,
                                  result.headers,
                                  'info'
                                );
                                _context3.next = 16;
                                break;

                              case 13:
                                _context3.prev = 13;
                                _context3.t0 = _context3['catch'](6);
                                reqErr = _context3.t0;

                              case 16:
                                if (
                                  !(
                                    result &&
                                    params.successStatuses &&
                                    params.successStatuses.indexOf(result.status) === -1
                                  )
                                ) {
                                  _context3.next = 28;
                                  break;
                                }

                                _context3.next = 19;
                                return this.requestError(result);

                              case 19:
                                err = _context3.sent;

                                if (!(err.code === 'RequestTimeTooSkewed' && !useStream)) {
                                  _context3.next = 25;
                                  break;
                                }

                                this.options.amendTimeSkewed = +new Date(err.serverTime) - new Date();
                                _context3.next = 24;
                                return this.request(params);

                              case 24:
                                return _context3.abrupt('return', _context3.sent);

                              case 25:
                                err.params = params;
                                _context3.next = 32;
                                break;

                              case 28:
                                if (!reqErr) {
                                  _context3.next = 32;
                                  break;
                                }

                                _context3.next = 31;
                                return this.requestError(reqErr);

                              case 31:
                                err = _context3.sent;

                              case 32:
                                if (!err) {
                                  _context3.next = 34;
                                  break;
                                }

                                throw err;

                              case 34:
                                if (!params.xmlResponse) {
                                  _context3.next = 39;
                                  break;
                                }

                                _context3.next = 37;
                                return this.parseXML(result.data);

                              case 37:
                                parseData = _context3.sent;
                                result.data = parseData;

                              case 39:
                                return _context3.abrupt('return', result);

                              case 40:
                              case 'end':
                                return _context3.stop();
                            }
                          }
                        },
                        _callee3,
                        this,
                        [[6, 13]]
                      );
                    })
                  );
                  return _request.apply(this, arguments);
                }

                proto._getResource = function _getResource(params) {
                  var resource = '/';
                  if (params.bucket) resource += ''.concat(params.bucket, '/');
                  if (params.object) resource += encoder(params.object, this.options.headerEncoding);
                  return resource;
                };

                proto._escape = function _escape(name) {
                  return utility.encodeURIComponent(name).replace(/%2F/g, '/');
                };
                /*
                 * Get User-Agent for browser & node.js
                 * @example
                 *   aliyun-sdk-nodejs/4.1.2 Node.js 5.3.0 on Darwin 64-bit
                 *   aliyun-sdk-js/4.1.2 Safari 9.0 on Apple iPhone(iOS 9.2.1)
                 *   aliyun-sdk-js/4.1.2 Chrome 43.0.2357.134 32-bit on Windows Server 2008 R2 / 7 64-bit
                 */

                proto._getUserAgent = function _getUserAgent() {
                  var agent = process && process.browser ? 'js' : 'nodejs';
                  var sdk = 'aliyun-sdk-'.concat(agent, '/').concat(pkg.version);
                  var plat = platform.description;

                  if (!plat && process) {
                    plat = 'Node.js '
                      .concat(process.version.slice(1), ' on ')
                      .concat(process.platform, ' ')
                      .concat(process.arch);
                  }

                  return this._checkUserAgent(''.concat(sdk, ' ').concat(plat));
                };

                proto._checkUserAgent = function _checkUserAgent(ua) {
                  var userAgent = ua.replace(/\u03b1/, 'alpha').replace(/\u03b2/, 'beta');
                  return userAgent;
                };
                /*
                 * Check Browser And Version
                 * @param {String} [name] browser name: like IE, Chrome, Firefox
                 * @param {String} [version] browser major version: like 10(IE 10.x), 55(Chrome 55.x), 50(Firefox 50.x)
                 * @return {Bool} true or false
                 * @api private
                 */

                proto.checkBrowserAndVersion = function checkBrowserAndVersion(name, version) {
                  return bowser.name === name && bowser.version.split('.')[0] === version;
                };
                /**
                 * thunkify xml.parseString
                 * @param {String|Buffer} str
                 *
                 * @api private
                 */

                proto.parseXML = function parseXMLThunk(str) {
                  return new Promise(function (resolve, reject) {
                    if (Buffer.isBuffer(str)) {
                      str = str.toString();
                    }

                    xml.parseString(
                      str,
                      {
                        explicitRoot: false,
                        explicitArray: false
                      },
                      function (err, result) {
                        if (err) {
                          reject(err);
                        } else {
                          resolve(result);
                        }
                      }
                    );
                  });
                };
                /**
                 * generater a request error with request response
                 * @param {Object} result
                 *
                 * @api private
                 */

                proto.requestError = /*#__PURE__*/ (function () {
                  var _requestError = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee2(result) {
                      var err, message, info, msg;
                      return _regenerator.default.wrap(
                        function _callee2$(_context2) {
                          while (1) {
                            switch ((_context2.prev = _context2.next)) {
                              case 0:
                                err = null;

                                if (!(!result.data || !result.data.length)) {
                                  _context2.next = 5;
                                  break;
                                }

                                if (result.status === -1 || result.status === -2) {
                                  // -1 is net error , -2 is timeout
                                  err = new Error(result.message);
                                  err.name = result.name;
                                  err.status = result.status;
                                  err.code = result.name;
                                } else {
                                  // HEAD not exists resource
                                  if (result.status === 404) {
                                    err = new Error('Object not exists');
                                    err.name = 'NoSuchKeyError';
                                    err.status = 404;
                                    err.code = 'NoSuchKey';
                                  } else if (result.status === 412) {
                                    err = new Error('Pre condition failed');
                                    err.name = 'PreconditionFailedError';
                                    err.status = 412;
                                    err.code = 'PreconditionFailed';
                                  } else {
                                    err = new Error('Unknow error, status: '.concat(result.status));
                                    err.name = 'UnknownError';
                                    err.status = result.status;
                                  }

                                  err.requestId = result.headers['x-oss-request-id'];
                                  err.host = '';
                                }

                                _context2.next = 32;
                                break;

                              case 5:
                                message = String(result.data);
                                this.debug('request response error data: %s', message, 'error');
                                _context2.prev = 7;
                                _context2.next = 10;
                                return this.parseXML(message);

                              case 10:
                                _context2.t0 = _context2.sent;

                                if (_context2.t0) {
                                  _context2.next = 13;
                                  break;
                                }

                                _context2.t0 = {};

                              case 13:
                                info = _context2.t0;
                                _context2.next = 23;
                                break;

                              case 16:
                                _context2.prev = 16;
                                _context2.t1 = _context2['catch'](7);
                                this.debug(message, 'error');
                                _context2.t1.message += '\nraw xml: '.concat(message);
                                _context2.t1.status = result.status;
                                _context2.t1.requestId = result.headers['x-oss-request-id'];
                                return _context2.abrupt('return', _context2.t1);

                              case 23:
                                msg = info.Message || 'unknow request error, status: '.concat(result.status);

                                if (info.Condition) {
                                  msg += ' (condition: '.concat(info.Condition, ')');
                                }

                                err = new Error(msg);
                                err.name = info.Code ? ''.concat(info.Code, 'Error') : 'UnknownError';
                                err.status = result.status;
                                err.code = info.Code;
                                err.requestId = info.RequestId;
                                err.hostId = info.HostId;
                                err.serverTime = info.ServerTime;

                              case 32:
                                this.debug('generate error %j', err, 'error');
                                return _context2.abrupt('return', err);

                              case 34:
                              case 'end':
                                return _context2.stop();
                            }
                          }
                        },
                        _callee2,
                        this,
                        [[7, 16]]
                      );
                    })
                  );

                  function requestError(_x3) {
                    return _requestError.apply(this, arguments);
                  }

                  return requestError;
                })();
              }).call(this);
            }).call(this, { isBuffer: require('../../node_modules/is-buffer/index.js') }, require('_process'));
          },
          {
            '../../node_modules/is-buffer/index.js': 354,
            '../common/bucket/abortBucketWorm': 7,
            '../common/bucket/completeBucketWorm': 8,
            '../common/bucket/deleteBucketInventory': 9,
            '../common/bucket/deleteBucketLifecycle': 10,
            '../common/bucket/deleteBucketWebsite': 11,
            '../common/bucket/extendBucketWorm': 12,
            '../common/bucket/getBucketInventory': 13,
            '../common/bucket/getBucketLifecycle': 14,
            '../common/bucket/getBucketVersioning': 15,
            '../common/bucket/getBucketWebsite': 16,
            '../common/bucket/getBucketWorm': 17,
            '../common/bucket/initiateBucketWorm': 18,
            '../common/bucket/listBucketInventory': 19,
            '../common/bucket/putBucketInventory': 20,
            '../common/bucket/putBucketLifecycle': 21,
            '../common/bucket/putBucketVersioning': 22,
            '../common/bucket/putBucketWebsite': 23,
            '../common/client/getReqUrl': 25,
            '../common/client/initOptions': 26,
            '../common/multipart': 30,
            '../common/multipart-copy': 29,
            '../common/parallel': 49,
            '../common/signUtils': 50,
            '../common/utils/createRequest': 55,
            '../common/utils/encoder': 58,
            '../common/utils/isFunction': 66,
            '../common/utils/retry': 72,
            '../common/utils/setSTSToken': 74,
            './bucket': 2,
            './managed-upload': 4,
            './object': 5,
            './version': 6,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            _process: 441,
            agentkeepalive: 80,
            bowser: 86,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.includes.js': 274,
            'core-js/modules/es.array.slice.js': 278,
            'core-js/modules/es.function.name.js': 281,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.promise.js': 294,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/es.string.split.js': 306,
            'core-js/modules/es.symbol.description.js': 309,
            'core-js/modules/es.symbol.js': 312,
            debug: 439,
            'merge-descriptors': 357,
            platform: 364,
            urllib: 449,
            utility: 448,
            xml2js: 400
          }
        ],
        4: [
          function (require, module, exports) {
            (function (Buffer) {
              (function () {
                'use strict';

                var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

                var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

                require('core-js/modules/es.function.name.js');

                require('core-js/modules/es.object.to-string.js');

                require('core-js/modules/es.promise.js');

                require('core-js/modules/es.array.from.js');

                require('core-js/modules/es.string.iterator.js');

                require('core-js/modules/es.array.map.js');

                require('core-js/modules/es.array.filter.js');

                require('core-js/modules/es.array.find.js');

                require('core-js/modules/es.array.concat.js');

                require('core-js/modules/es.regexp.to-string.js');

                require('core-js/modules/es.array.slice.js');

                require('core-js/modules/es.array.iterator.js');

                require('core-js/modules/es.array-buffer.slice.js');

                require('core-js/modules/es.typed-array.uint8-array.js');

                require('core-js/modules/es.typed-array.copy-within.js');

                require('core-js/modules/es.typed-array.every.js');

                require('core-js/modules/es.typed-array.fill.js');

                require('core-js/modules/es.typed-array.filter.js');

                require('core-js/modules/es.typed-array.find.js');

                require('core-js/modules/es.typed-array.find-index.js');

                require('core-js/modules/es.typed-array.for-each.js');

                require('core-js/modules/es.typed-array.includes.js');

                require('core-js/modules/es.typed-array.index-of.js');

                require('core-js/modules/es.typed-array.iterator.js');

                require('core-js/modules/es.typed-array.join.js');

                require('core-js/modules/es.typed-array.last-index-of.js');

                require('core-js/modules/es.typed-array.map.js');

                require('core-js/modules/es.typed-array.reduce.js');

                require('core-js/modules/es.typed-array.reduce-right.js');

                require('core-js/modules/es.typed-array.reverse.js');

                require('core-js/modules/es.typed-array.set.js');

                require('core-js/modules/es.typed-array.slice.js');

                require('core-js/modules/es.typed-array.some.js');

                require('core-js/modules/es.typed-array.sort.js');

                require('core-js/modules/es.typed-array.subarray.js');

                require('core-js/modules/es.typed-array.to-locale-string.js');

                require('core-js/modules/es.typed-array.to-string.js');

                var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

                // var debug = require('debug')('ali-oss:multipart');
                var util = require('util');

                var path = require('path');

                var mime = require('mime');

                var copy = require('copy-to');

                var _require = require('../common/utils/isBlob'),
                  isBlob = _require.isBlob;

                var _require2 = require('../common/utils/isFile'),
                  isFile = _require2.isFile;

                var _require3 = require('../common/utils/isBuffer'),
                  isBuffer = _require3.isBuffer;

                var proto = exports;
                /**
                 * Multipart operations
                 */

                /**
                 * Upload a file to OSS using multipart uploads
                 * @param {String} name
                 * @param {String|File|Buffer} file
                 * @param {Object} options
                 *        {Object} options.callback The callback parameter is composed of a JSON string encoded in Base64
                 *        {String} options.callback.url the OSS sends a callback request to this URL
                 *        {String} options.callback.host The host header value for initiating callback requests
                 *        {String} options.callback.body The value of the request body when a callback is initiated
                 *        {String} options.callback.contentType The Content-Type of the callback requests initiatiated
                 *        {Object} options.callback.customValue Custom parameters are a map of key-values, e.g:
                 *                  customValue = {
                 *                    key1: 'value1',
                 *                    key2: 'value2'
                 *                  }
                 */

                proto.multipartUpload = /*#__PURE__*/ (function () {
                  var _multipartUpload = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee(name, file) {
                      var options,
                        minPartSize,
                        fileSize,
                        result,
                        ret,
                        initResult,
                        uploadId,
                        partSize,
                        checkpoint,
                        _args = arguments;
                      return _regenerator.default.wrap(
                        function _callee$(_context) {
                          while (1) {
                            switch ((_context.prev = _context.next)) {
                              case 0:
                                options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
                                this.resetCancelFlag();
                                options.disabledMD5 = options.disabledMD5 === undefined ? true : !!options.disabledMD5;

                                if (!(options.checkpoint && options.checkpoint.uploadId)) {
                                  _context.next = 8;
                                  break;
                                }

                                if (file && isFile(file)) options.checkpoint.file = file;
                                _context.next = 7;
                                return this._resumeMultipart(options.checkpoint, options);

                              case 7:
                                return _context.abrupt('return', _context.sent);

                              case 8:
                                minPartSize = 100 * 1024;

                                if (!options.mime) {
                                  if (isFile(file)) {
                                    options.mime = mime.getType(path.extname(file.name));
                                  } else if (isBlob(file)) {
                                    options.mime = file.type;
                                  } else if (isBuffer(file)) {
                                    options.mime = '';
                                  } else {
                                    options.mime = mime.getType(path.extname(file));
                                  }
                                }

                                options.headers = options.headers || {};

                                this._convertMetaToHeaders(options.meta, options.headers);

                                _context.next = 14;
                                return this._getFileSize(file);

                              case 14:
                                fileSize = _context.sent;

                                if (!(fileSize < minPartSize)) {
                                  _context.next = 26;
                                  break;
                                }

                                options.contentLength = fileSize;
                                _context.next = 19;
                                return this.put(name, file, options);

                              case 19:
                                result = _context.sent;

                                if (!(options && options.progress)) {
                                  _context.next = 23;
                                  break;
                                }

                                _context.next = 23;
                                return options.progress(1);

                              case 23:
                                ret = {
                                  res: result.res,
                                  bucket: this.options.bucket,
                                  name: name,
                                  etag: result.res.headers.etag
                                };

                                if ((options.headers && options.headers['x-oss-callback']) || options.callback) {
                                  ret.data = result.data;
                                }

                                return _context.abrupt('return', ret);

                              case 26:
                                if (!(options.partSize && !(parseInt(options.partSize, 10) === options.partSize))) {
                                  _context.next = 28;
                                  break;
                                }

                                throw new Error('partSize must be int number');

                              case 28:
                                if (!(options.partSize && options.partSize < minPartSize)) {
                                  _context.next = 30;
                                  break;
                                }

                                throw new Error('partSize must not be smaller than '.concat(minPartSize));

                              case 30:
                                _context.next = 32;
                                return this.initMultipartUpload(name, options);

                              case 32:
                                initResult = _context.sent;
                                uploadId = initResult.uploadId;
                                partSize = this._getPartSize(fileSize, options.partSize);
                                checkpoint = {
                                  file: file,
                                  name: name,
                                  fileSize: fileSize,
                                  partSize: partSize,
                                  uploadId: uploadId,
                                  doneParts: []
                                };

                                if (!(options && options.progress)) {
                                  _context.next = 39;
                                  break;
                                }

                                _context.next = 39;
                                return options.progress(0, checkpoint, initResult.res);

                              case 39:
                                _context.next = 41;
                                return this._resumeMultipart(checkpoint, options);

                              case 41:
                                return _context.abrupt('return', _context.sent);

                              case 42:
                              case 'end':
                                return _context.stop();
                            }
                          }
                        },
                        _callee,
                        this
                      );
                    })
                  );

                  function multipartUpload(_x, _x2) {
                    return _multipartUpload.apply(this, arguments);
                  }

                  return multipartUpload;
                })();
                /*
                 * Resume multipart upload from checkpoint. The checkpoint will be
                 * updated after each successful part upload.
                 * @param {Object} checkpoint the checkpoint
                 * @param {Object} options
                 */

                proto._resumeMultipart = /*#__PURE__*/ (function () {
                  var _resumeMultipart2 = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee3(checkpoint, options) {
                      var that,
                        file,
                        fileSize,
                        partSize,
                        uploadId,
                        doneParts,
                        name,
                        internalDoneParts,
                        partOffs,
                        numParts,
                        multipartFinish,
                        uploadPartJob,
                        all,
                        done,
                        todo,
                        defaultParallel,
                        parallel,
                        jobErr,
                        abortEvent;
                      return _regenerator.default.wrap(
                        function _callee3$(_context3) {
                          while (1) {
                            switch ((_context3.prev = _context3.next)) {
                              case 0:
                                that = this;

                                if (!this.isCancel()) {
                                  _context3.next = 3;
                                  break;
                                }

                                throw this._makeCancelEvent();

                              case 3:
                                (file = checkpoint.file),
                                  (fileSize = checkpoint.fileSize),
                                  (partSize = checkpoint.partSize),
                                  (uploadId = checkpoint.uploadId),
                                  (doneParts = checkpoint.doneParts),
                                  (name = checkpoint.name);
                                internalDoneParts = [];

                                if (doneParts.length > 0) {
                                  copy(doneParts).to(internalDoneParts);
                                }

                                partOffs = this._divideParts(fileSize, partSize);
                                numParts = partOffs.length;
                                multipartFinish = false;

                                uploadPartJob = function uploadPartJob(self, partNo) {
                                  // eslint-disable-next-line no-async-promise-executor
                                  return new Promise(
                                    /*#__PURE__*/ (function () {
                                      var _ref = (0, _asyncToGenerator2.default)(
                                        /*#__PURE__*/ _regenerator.default.mark(function _callee2(resolve, reject) {
                                          var pi, content, data, result, tempErr;
                                          return _regenerator.default.wrap(
                                            function _callee2$(_context2) {
                                              while (1) {
                                                switch ((_context2.prev = _context2.next)) {
                                                  case 0:
                                                    _context2.prev = 0;

                                                    if (self.isCancel()) {
                                                      _context2.next = 29;
                                                      break;
                                                    }

                                                    pi = partOffs[partNo - 1];
                                                    _context2.next = 5;
                                                    return self._createBuffer(file, pi.start, pi.end);

                                                  case 5:
                                                    content = _context2.sent;
                                                    data = {
                                                      content: content,
                                                      size: pi.end - pi.start
                                                    };
                                                    _context2.prev = 7;
                                                    _context2.next = 10;
                                                    return self._uploadPart(name, uploadId, partNo, data, options);

                                                  case 10:
                                                    result = _context2.sent;
                                                    _context2.next = 18;
                                                    break;

                                                  case 13:
                                                    _context2.prev = 13;
                                                    _context2.t0 = _context2['catch'](7);

                                                    if (!(_context2.t0.status === 404)) {
                                                      _context2.next = 17;
                                                      break;
                                                    }

                                                    throw self._makeAbortEvent();

                                                  case 17:
                                                    throw _context2.t0;

                                                  case 18:
                                                    if (!(!self.isCancel() && !multipartFinish)) {
                                                      _context2.next = 26;
                                                      break;
                                                    }

                                                    checkpoint.doneParts.push({
                                                      number: partNo,
                                                      etag: result.res.headers.etag
                                                    });

                                                    if (!options.progress) {
                                                      _context2.next = 23;
                                                      break;
                                                    }

                                                    _context2.next = 23;
                                                    return options.progress(
                                                      doneParts.length / (numParts + 1),
                                                      checkpoint,
                                                      result.res
                                                    );

                                                  case 23:
                                                    resolve({
                                                      number: partNo,
                                                      etag: result.res.headers.etag
                                                    });
                                                    _context2.next = 27;
                                                    break;

                                                  case 26:
                                                    resolve();

                                                  case 27:
                                                    _context2.next = 30;
                                                    break;

                                                  case 29:
                                                    resolve();

                                                  case 30:
                                                    _context2.next = 41;
                                                    break;

                                                  case 32:
                                                    _context2.prev = 32;
                                                    _context2.t1 = _context2['catch'](0);
                                                    tempErr = new Error();
                                                    tempErr.name = _context2.t1.name;
                                                    tempErr.message = _context2.t1.message;
                                                    tempErr.stack = _context2.t1.stack;
                                                    tempErr.partNum = partNo;
                                                    copy(_context2.t1).to(tempErr);
                                                    reject(tempErr);

                                                  case 41:
                                                  case 'end':
                                                    return _context2.stop();
                                                }
                                              }
                                            },
                                            _callee2,
                                            null,
                                            [
                                              [0, 32],
                                              [7, 13]
                                            ]
                                          );
                                        })
                                      );

                                      return function (_x5, _x6) {
                                        return _ref.apply(this, arguments);
                                      };
                                    })()
                                  );
                                };

                                all = Array.from(new Array(numParts), function (x, i) {
                                  return i + 1;
                                });
                                done = internalDoneParts.map(function (p) {
                                  return p.number;
                                });
                                todo = all.filter(function (p) {
                                  return done.indexOf(p) < 0;
                                });
                                defaultParallel = 5;
                                parallel = options.parallel || defaultParallel; // upload in parallel

                                _context3.next = 17;
                                return this._parallel(todo, parallel, function (value) {
                                  return new Promise(function (resolve, reject) {
                                    uploadPartJob(that, value)
                                      .then(function (result) {
                                        if (result) {
                                          internalDoneParts.push(result);
                                        }

                                        resolve();
                                      })
                                      .catch(function (err) {
                                        reject(err);
                                      });
                                  });
                                });

                              case 17:
                                jobErr = _context3.sent;
                                multipartFinish = true;
                                abortEvent = jobErr.find(function (err) {
                                  return err.name === 'abort';
                                });

                                if (!abortEvent) {
                                  _context3.next = 22;
                                  break;
                                }

                                throw abortEvent;

                              case 22:
                                if (!this.isCancel()) {
                                  _context3.next = 25;
                                  break;
                                }

                                uploadPartJob = null;
                                throw this._makeCancelEvent();

                              case 25:
                                if (!(jobErr && jobErr.length > 0)) {
                                  _context3.next = 28;
                                  break;
                                }

                                jobErr[0].message = 'Failed to upload some parts with error: '
                                  .concat(jobErr[0].toString(), ' part_num: ')
                                  .concat(jobErr[0].partNum);
                                throw jobErr[0];

                              case 28:
                                _context3.next = 30;
                                return this.completeMultipartUpload(name, uploadId, internalDoneParts, options);

                              case 30:
                                return _context3.abrupt('return', _context3.sent);

                              case 31:
                              case 'end':
                                return _context3.stop();
                            }
                          }
                        },
                        _callee3,
                        this
                      );
                    })
                  );

                  function _resumeMultipart(_x3, _x4) {
                    return _resumeMultipart2.apply(this, arguments);
                  }

                  return _resumeMultipart;
                })();
                /**
                 * Get file size
                 */

                proto._getFileSize = /*#__PURE__*/ (function () {
                  var _getFileSize2 = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee4(file) {
                      return _regenerator.default.wrap(function _callee4$(_context4) {
                        while (1) {
                          switch ((_context4.prev = _context4.next)) {
                            case 0:
                              if (!isBuffer(file)) {
                                _context4.next = 4;
                                break;
                              }

                              return _context4.abrupt('return', file.length);

                            case 4:
                              if (!(isBlob(file) || isFile(file))) {
                                _context4.next = 6;
                                break;
                              }

                              return _context4.abrupt('return', file.size);

                            case 6:
                              throw new Error('_getFileSize requires Buffer/File/Blob.');

                            case 7:
                            case 'end':
                              return _context4.stop();
                          }
                        }
                      }, _callee4);
                    })
                  );

                  function _getFileSize(_x7) {
                    return _getFileSize2.apply(this, arguments);
                  }

                  return _getFileSize;
                })();
                /*
                 * Readable stream for Web File
                 */

                var _require4 = require('stream'),
                  Readable = _require4.Readable;

                function WebFileReadStream(file, options) {
                  if (!(this instanceof WebFileReadStream)) {
                    return new WebFileReadStream(file, options);
                  }

                  Readable.call(this, options);
                  this.file = file;
                  this.reader = new FileReader();
                  this.start = 0;
                  this.finish = false;
                  this.fileBuffer = null;
                }

                util.inherits(WebFileReadStream, Readable);

                WebFileReadStream.prototype.readFileAndPush = function readFileAndPush(size) {
                  if (this.fileBuffer) {
                    var pushRet = true;

                    while (pushRet && this.fileBuffer && this.start < this.fileBuffer.length) {
                      var start = this.start;
                      var end = start + size;
                      end = end > this.fileBuffer.length ? this.fileBuffer.length : end;
                      this.start = end;
                      pushRet = this.push(this.fileBuffer.slice(start, end));
                    }
                  }
                };

                WebFileReadStream.prototype._read = function _read(size) {
                  if (
                    (this.file && this.start >= this.file.size) ||
                    (this.fileBuffer && this.start >= this.fileBuffer.length) ||
                    this.finish ||
                    (this.start === 0 && !this.file)
                  ) {
                    if (!this.finish) {
                      this.fileBuffer = null;
                      this.finish = true;
                    }

                    this.push(null);
                    return;
                  }

                  var defaultReadSize = 16 * 1024;
                  size = size || defaultReadSize;
                  var that = this;

                  this.reader.onload = function onload(e) {
                    that.fileBuffer = Buffer.from(new Uint8Array(e.target.result));
                    that.file = null;
                    that.readFileAndPush(size);
                  };

                  if (this.start === 0) {
                    this.reader.readAsArrayBuffer(this.file);
                  } else {
                    this.readFileAndPush(size);
                  }
                };

                function getBuffer(file) {
                  // Some browsers do not support Blob.prototype.arrayBuffer, such as IE
                  if (file.arrayBuffer) return file.arrayBuffer();
                  return new Promise(function (resolve, reject) {
                    var reader = new FileReader();

                    reader.onload = function (e) {
                      resolve(e.target.result);
                    };

                    reader.onerror = function (e) {
                      reject(e);
                    };

                    reader.readAsArrayBuffer(file);
                  });
                }

                proto._createBuffer = /*#__PURE__*/ (function () {
                  var _createBuffer2 = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee5(file, start, end) {
                      var _file, fileContent;

                      return _regenerator.default.wrap(function _callee5$(_context5) {
                        while (1) {
                          switch ((_context5.prev = _context5.next)) {
                            case 0:
                              if (!(isBlob(file) || isFile(file))) {
                                _context5.next = 8;
                                break;
                              }

                              _file = file.slice(start, end);
                              _context5.next = 4;
                              return getBuffer(_file);

                            case 4:
                              fileContent = _context5.sent;
                              return _context5.abrupt('return', Buffer.from(fileContent));

                            case 8:
                              if (!isBuffer(file)) {
                                _context5.next = 12;
                                break;
                              }

                              return _context5.abrupt('return', file.subarray(start, end));

                            case 12:
                              throw new Error('_createBuffer requires File/Blob/Buffer.');

                            case 13:
                            case 'end':
                              return _context5.stop();
                          }
                        }
                      }, _callee5);
                    })
                  );

                  function _createBuffer(_x8, _x9, _x10) {
                    return _createBuffer2.apply(this, arguments);
                  }

                  return _createBuffer;
                })();

                proto._getPartSize = function _getPartSize(fileSize, partSize) {
                  var maxNumParts = 10 * 1000;
                  var defaultPartSize = 1 * 1024 * 1024;
                  if (!partSize) partSize = defaultPartSize;
                  var safeSize = Math.ceil(fileSize / maxNumParts);

                  if (partSize < safeSize) {
                    partSize = safeSize;
                    console.warn(
                      'partSize has been set to '.concat(
                        partSize,
                        ', because the partSize you provided causes partNumber to be greater than 10,000'
                      )
                    );
                  }

                  return partSize;
                };

                proto._divideParts = function _divideParts(fileSize, partSize) {
                  var numParts = Math.ceil(fileSize / partSize);
                  var partOffs = [];

                  for (var i = 0; i < numParts; i++) {
                    var start = partSize * i;
                    var end = Math.min(start + partSize, fileSize);
                    partOffs.push({
                      start: start,
                      end: end
                    });
                  }

                  return partOffs;
                };
              }).call(this);
            }).call(this, require('buffer').Buffer);
          },
          {
            '../common/utils/isBlob': 63,
            '../common/utils/isBuffer': 64,
            '../common/utils/isFile': 65,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            buffer: 89,
            'copy-to': 91,
            'core-js/modules/es.array-buffer.slice.js': 268,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.filter.js': 271,
            'core-js/modules/es.array.find.js': 272,
            'core-js/modules/es.array.from.js': 273,
            'core-js/modules/es.array.iterator.js': 275,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.array.slice.js': 278,
            'core-js/modules/es.function.name.js': 281,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.promise.js': 294,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.string.iterator.js': 302,
            'core-js/modules/es.typed-array.copy-within.js': 314,
            'core-js/modules/es.typed-array.every.js': 315,
            'core-js/modules/es.typed-array.fill.js': 316,
            'core-js/modules/es.typed-array.filter.js': 317,
            'core-js/modules/es.typed-array.find-index.js': 318,
            'core-js/modules/es.typed-array.find.js': 319,
            'core-js/modules/es.typed-array.for-each.js': 320,
            'core-js/modules/es.typed-array.includes.js': 321,
            'core-js/modules/es.typed-array.index-of.js': 322,
            'core-js/modules/es.typed-array.iterator.js': 323,
            'core-js/modules/es.typed-array.join.js': 324,
            'core-js/modules/es.typed-array.last-index-of.js': 325,
            'core-js/modules/es.typed-array.map.js': 326,
            'core-js/modules/es.typed-array.reduce-right.js': 327,
            'core-js/modules/es.typed-array.reduce.js': 328,
            'core-js/modules/es.typed-array.reverse.js': 329,
            'core-js/modules/es.typed-array.set.js': 330,
            'core-js/modules/es.typed-array.slice.js': 331,
            'core-js/modules/es.typed-array.some.js': 332,
            'core-js/modules/es.typed-array.sort.js': 333,
            'core-js/modules/es.typed-array.subarray.js': 334,
            'core-js/modules/es.typed-array.to-locale-string.js': 335,
            'core-js/modules/es.typed-array.to-string.js': 336,
            'core-js/modules/es.typed-array.uint8-array.js': 337,
            mime: 359,
            path: 363,
            stream: 387,
            util: 394
          }
        ],
        5: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            require('core-js/modules/es.function.name.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/es.regexp.to-string.js');

            require('core-js/modules/es.array.map.js');

            require('core-js/modules/es.number.constructor.js');

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.promise.js');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            // const debug = require('debug')('ali-oss:object');
            var fs = require('fs');

            var copy = require('copy-to');

            var path = require('path');

            var mime = require('mime');

            var callback = require('../common/callback');

            var merge = require('merge-descriptors');

            var _require = require('../common/utils/isBlob'),
              isBlob = _require.isBlob;

            var _require2 = require('../common/utils/isFile'),
              isFile = _require2.isFile;

            var _require3 = require('../common/utils/isBuffer'),
              isBuffer = _require3.isBuffer;

            var _require4 = require('../common/utils/obj2xml'),
              obj2xml = _require4.obj2xml; // var assert = require('assert');

            var proto = exports;
            /**
             * Object operations
             */

            /**
             * append an object from String(file path)/Buffer/ReadableStream
             * @param {String} name the object key
             * @param {Mixed} file String(file path)/Buffer/ReadableStream
             * @param {Object} options
             * @return {Object}
             */

            proto.append = /*#__PURE__*/ (function () {
              var _append = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, file, options) {
                  var result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = options || {};
                            if (options.position === undefined) options.position = '0';
                            options.subres = {
                              append: '',
                              position: options.position
                            };
                            options.method = 'POST';
                            _context.next = 6;
                            return this.put(name, file, options);

                          case 6:
                            result = _context.sent;
                            result.nextAppendPosition = result.res.headers['x-oss-next-append-position'];
                            return _context.abrupt('return', result);

                          case 9:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function append(_x, _x2, _x3) {
                return _append.apply(this, arguments);
              }

              return append;
            })();
            /**
             * put an object from String(file path)/Buffer/ReadableStream
             * @param {String} name the object key
             * @param {Mixed} file String(file path)/Buffer/ReadableStream
             * @param {Object} options
             *        {Object} options.callback The callback parameter is composed of a JSON string encoded in Base64
             *        {String} options.callback.url  the OSS sends a callback request to this URL
             *        {String} options.callback.host  The host header value for initiating callback requests
             *        {String} options.callback.body  The value of the request body when a callback is initiated
             *        {String} options.callback.contentType  The Content-Type of the callback requests initiatiated
             *        {Object} options.callback.customValue  Custom parameters are a map of key-values, e.g:
             *                  customValue = {
             *                    key1: 'value1',
             *                    key2: 'value2'
             *                  }
             * @return {Object}
             */

            proto.put = /*#__PURE__*/ (function () {
              var _put = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee2(name, file, options) {
                  var content, method, params, result, ret;
                  return _regenerator.default.wrap(
                    function _callee2$(_context2) {
                      while (1) {
                        switch ((_context2.prev = _context2.next)) {
                          case 0:
                            options = options || {};
                            options.disabledMD5 = options.disabledMD5 === undefined ? true : !!options.disabledMD5;
                            options.headers = options.headers || {};
                            name = this._objectName(name);

                            if (!isBuffer(file)) {
                              _context2.next = 8;
                              break;
                            }

                            content = file;
                            _context2.next = 19;
                            break;

                          case 8:
                            if (!(isBlob(file) || isFile(file))) {
                              _context2.next = 18;
                              break;
                            }

                            if (!options.mime) {
                              if (isFile(file)) {
                                options.mime = mime.getType(path.extname(file.name));
                              } else {
                                options.mime = file.type;
                              }
                            }

                            _context2.next = 12;
                            return this._createBuffer(file, 0, file.size);

                          case 12:
                            content = _context2.sent;
                            _context2.next = 15;
                            return this._getFileSize(file);

                          case 15:
                            options.contentLength = _context2.sent;
                            _context2.next = 19;
                            break;

                          case 18:
                            throw new TypeError('Must provide Buffer/Blob/File for put.');

                          case 19:
                            this._convertMetaToHeaders(options.meta, options.headers);

                            method = options.method || 'PUT';
                            params = this._objectRequestParams(method, name, options);
                            callback.encodeCallback(params, options);
                            params.mime = options.mime;
                            params.disabledMD5 = options.disabledMD5;
                            params.content = content;
                            params.successStatuses = [200];
                            _context2.next = 29;
                            return this.request(params);

                          case 29:
                            result = _context2.sent;
                            ret = {
                              name: name,
                              url: this._objectUrl(name),
                              res: result.res
                            };

                            if (params.headers && params.headers['x-oss-callback']) {
                              ret.data = JSON.parse(result.data.toString());
                            }

                            return _context2.abrupt('return', ret);

                          case 33:
                          case 'end':
                            return _context2.stop();
                        }
                      }
                    },
                    _callee2,
                    this
                  );
                })
              );

              function put(_x4, _x5, _x6) {
                return _put.apply(this, arguments);
              }

              return put;
            })();
            /**
             * put an object from ReadableStream. If `options.contentLength` is
             * not provided, chunked encoding is used.
             * @param {String} name the object key
             * @param {Readable} stream the ReadableStream
             * @param {Object} options
             * @return {Object}
             */

            proto.putStream = /*#__PURE__*/ (function () {
              var _putStream = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee3(name, stream, options) {
                  var method, params, result, ret;
                  return _regenerator.default.wrap(
                    function _callee3$(_context3) {
                      while (1) {
                        switch ((_context3.prev = _context3.next)) {
                          case 0:
                            options = options || {};
                            options.headers = options.headers || {};
                            name = this._objectName(name);

                            if (options.contentLength) {
                              options.headers['Content-Length'] = options.contentLength;
                            } else {
                              options.headers['Transfer-Encoding'] = 'chunked';
                            }

                            this._convertMetaToHeaders(options.meta, options.headers);

                            method = options.method || 'PUT';
                            params = this._objectRequestParams(method, name, options);
                            callback.encodeCallback(params, options);
                            params.mime = options.mime;
                            params.stream = stream;
                            params.successStatuses = [200];
                            _context3.next = 13;
                            return this.request(params);

                          case 13:
                            result = _context3.sent;
                            ret = {
                              name: name,
                              url: this._objectUrl(name),
                              res: result.res
                            };

                            if (params.headers && params.headers['x-oss-callback']) {
                              ret.data = JSON.parse(result.data.toString());
                            }

                            return _context3.abrupt('return', ret);

                          case 17:
                          case 'end':
                            return _context3.stop();
                        }
                      }
                    },
                    _callee3,
                    this
                  );
                })
              );

              function putStream(_x7, _x8, _x9) {
                return _putStream.apply(this, arguments);
              }

              return putStream;
            })();

            merge(proto, require('../common/object/copyObject'));
            merge(proto, require('../common/object/getObjectTagging'));
            merge(proto, require('../common/object/putObjectTagging'));
            merge(proto, require('../common/object/deleteObjectTagging'));
            merge(proto, require('../common/image'));
            merge(proto, require('../common/object/getBucketVersions'));
            merge(proto, require('../common/object/getACL'));
            merge(proto, require('../common/object/putACL'));
            merge(proto, require('../common/object/head'));
            merge(proto, require('../common/object/delete'));
            merge(proto, require('../common/object/get'));
            merge(proto, require('../common/object/putSymlink'));
            merge(proto, require('../common/object/getSymlink'));
            merge(proto, require('../common/object/deleteMulti'));
            merge(proto, require('../common/object/getObjectMeta'));
            merge(proto, require('../common/object/getObjectUrl'));
            merge(proto, require('../common/object/generateObjectUrl'));
            merge(proto, require('../common/object/signatureUrl'));
            merge(proto, require('../common/object/asyncSignatureUrl'));

            proto.putMeta = /*#__PURE__*/ (function () {
              var _putMeta = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee4(name, meta, options) {
                  var copyResult;
                  return _regenerator.default.wrap(
                    function _callee4$(_context4) {
                      while (1) {
                        switch ((_context4.prev = _context4.next)) {
                          case 0:
                            _context4.next = 2;
                            return this.copy(name, name, {
                              meta: meta || {},
                              timeout: options && options.timeout,
                              ctx: options && options.ctx
                            });

                          case 2:
                            copyResult = _context4.sent;
                            return _context4.abrupt('return', copyResult);

                          case 4:
                          case 'end':
                            return _context4.stop();
                        }
                      }
                    },
                    _callee4,
                    this
                  );
                })
              );

              function putMeta(_x10, _x11, _x12) {
                return _putMeta.apply(this, arguments);
              }

              return putMeta;
            })();

            proto.list = /*#__PURE__*/ (function () {
              var _list = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee5(query, options) {
                  var params, result, objects, that, prefixes;
                  return _regenerator.default.wrap(
                    function _callee5$(_context5) {
                      while (1) {
                        switch ((_context5.prev = _context5.next)) {
                          case 0:
                            // prefix, marker, max-keys, delimiter
                            params = this._objectRequestParams('GET', '', options);
                            params.query = query;
                            params.xmlResponse = true;
                            params.successStatuses = [200];
                            _context5.next = 6;
                            return this.request(params);

                          case 6:
                            result = _context5.sent;
                            objects = result.data.Contents || [];
                            that = this;

                            if (objects) {
                              if (!Array.isArray(objects)) {
                                objects = [objects];
                              }

                              objects = objects.map(function (obj) {
                                return {
                                  name: obj.Key,
                                  url: that._objectUrl(obj.Key),
                                  lastModified: obj.LastModified,
                                  etag: obj.ETag,
                                  type: obj.Type,
                                  size: Number(obj.Size),
                                  storageClass: obj.StorageClass,
                                  owner: {
                                    id: obj.Owner.ID,
                                    displayName: obj.Owner.DisplayName
                                  }
                                };
                              });
                            }

                            prefixes = result.data.CommonPrefixes || null;

                            if (prefixes) {
                              if (!Array.isArray(prefixes)) {
                                prefixes = [prefixes];
                              }

                              prefixes = prefixes.map(function (item) {
                                return item.Prefix;
                              });
                            }

                            return _context5.abrupt('return', {
                              res: result.res,
                              objects: objects,
                              prefixes: prefixes,
                              nextMarker: result.data.NextMarker || null,
                              isTruncated: result.data.IsTruncated === 'true'
                            });

                          case 13:
                          case 'end':
                            return _context5.stop();
                        }
                      }
                    },
                    _callee5,
                    this
                  );
                })
              );

              function list(_x13, _x14) {
                return _list.apply(this, arguments);
              }

              return list;
            })();

            proto.listV2 = /*#__PURE__*/ (function () {
              var _listV = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee6(query) {
                  var options,
                    continuation_token,
                    params,
                    result,
                    objects,
                    that,
                    prefixes,
                    _args6 = arguments;
                  return _regenerator.default.wrap(
                    function _callee6$(_context6) {
                      while (1) {
                        switch ((_context6.prev = _context6.next)) {
                          case 0:
                            options = _args6.length > 1 && _args6[1] !== undefined ? _args6[1] : {};
                            continuation_token = query['continuation-token'] || query.continuationToken;

                            if (continuation_token) {
                              options.subres = Object.assign(
                                {
                                  'continuation-token': continuation_token
                                },
                                options.subres
                              );
                            }

                            params = this._objectRequestParams('GET', '', options);
                            params.query = Object.assign(
                              {
                                'list-type': 2
                              },
                              query
                            );
                            delete params.query['continuation-token'];
                            delete params.query.continuationToken;
                            params.xmlResponse = true;
                            params.successStatuses = [200];
                            _context6.next = 11;
                            return this.request(params);

                          case 11:
                            result = _context6.sent;
                            objects = result.data.Contents || [];
                            that = this;

                            if (objects) {
                              if (!Array.isArray(objects)) {
                                objects = [objects];
                              }

                              objects = objects.map(function (obj) {
                                var owner = null;

                                if (obj.Owner) {
                                  owner = {
                                    id: obj.Owner.ID,
                                    displayName: obj.Owner.DisplayName
                                  };
                                }

                                return {
                                  name: obj.Key,
                                  url: that._objectUrl(obj.Key),
                                  lastModified: obj.LastModified,
                                  etag: obj.ETag,
                                  type: obj.Type,
                                  size: Number(obj.Size),
                                  storageClass: obj.StorageClass,
                                  owner: owner
                                };
                              });
                            }

                            prefixes = result.data.CommonPrefixes || null;

                            if (prefixes) {
                              if (!Array.isArray(prefixes)) {
                                prefixes = [prefixes];
                              }

                              prefixes = prefixes.map(function (item) {
                                return item.Prefix;
                              });
                            }

                            return _context6.abrupt('return', {
                              res: result.res,
                              objects: objects,
                              prefixes: prefixes,
                              isTruncated: result.data.IsTruncated === 'true',
                              keyCount: +result.data.KeyCount,
                              continuationToken: result.data.ContinuationToken || null,
                              nextContinuationToken: result.data.NextContinuationToken || null
                            });

                          case 18:
                          case 'end':
                            return _context6.stop();
                        }
                      }
                    },
                    _callee6,
                    this
                  );
                })
              );

              function listV2(_x15) {
                return _listV.apply(this, arguments);
              }

              return listV2;
            })();
            /**
             * Restore Object
             * @param {String} name the object key
             * @param {Object} options
             * @returns {{res}}
             */

            proto.restore = /*#__PURE__*/ (function () {
              var _restore = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee7(name) {
                  var options,
                    params,
                    paramsXMLObj,
                    result,
                    _args7 = arguments;
                  return _regenerator.default.wrap(
                    function _callee7$(_context7) {
                      while (1) {
                        switch ((_context7.prev = _context7.next)) {
                          case 0:
                            options =
                              _args7.length > 1 && _args7[1] !== undefined
                                ? _args7[1]
                                : {
                                    type: 'Archive'
                                  };
                            options = options || {};
                            options.subres = Object.assign(
                              {
                                restore: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            params = this._objectRequestParams('POST', name, options);

                            if (options.type === 'ColdArchive') {
                              paramsXMLObj = {
                                RestoreRequest: {
                                  Days: options.Days ? options.Days : 2,
                                  JobParameters: {
                                    Tier: options.JobParameters ? options.JobParameters : 'Standard'
                                  }
                                }
                              };
                              params.content = obj2xml(paramsXMLObj, {
                                headers: true
                              });
                              params.mime = 'xml';
                            }

                            params.successStatuses = [202];
                            _context7.next = 9;
                            return this.request(params);

                          case 9:
                            result = _context7.sent;
                            return _context7.abrupt('return', {
                              res: result.res
                            });

                          case 11:
                          case 'end':
                            return _context7.stop();
                        }
                      }
                    },
                    _callee7,
                    this
                  );
                })
              );

              function restore(_x16) {
                return _restore.apply(this, arguments);
              }

              return restore;
            })();

            proto._objectUrl = function _objectUrl(name) {
              return this._getReqUrl({
                bucket: this.options.bucket,
                object: name
              });
            };
            /**
             * generator request params
             * @return {Object} params
             *
             * @api private
             */

            proto._objectRequestParams = function _objectRequestParams(method, name, options) {
              if (!this.options.bucket && !this.options.cname) {
                throw new Error('Please create a bucket first');
              }

              options = options || {};
              name = this._objectName(name);
              var params = {
                object: name,
                bucket: this.options.bucket,
                method: method,
                subres: options && options.subres,
                timeout: options && options.timeout,
                ctx: options && options.ctx
              };

              if (options.headers) {
                params.headers = {};
                copy(options.headers).to(params.headers);
              }

              return params;
            };

            proto._objectName = function _objectName(name) {
              return name.replace(/^\/+/, '');
            };

            proto._convertMetaToHeaders = function _convertMetaToHeaders(meta, headers) {
              if (!meta) {
                return;
              }

              Object.keys(meta).forEach(function (k) {
                headers['x-oss-meta-'.concat(k)] = meta[k];
              });
            };

            proto._deleteFileSafe = function _deleteFileSafe(filepath) {
              var _this = this;

              return new Promise(function (resolve) {
                fs.exists(filepath, function (exists) {
                  if (!exists) {
                    resolve();
                  } else {
                    fs.unlink(filepath, function (err) {
                      if (err) {
                        _this.debug('unlink %j error: %s', filepath, err, 'error');
                      }

                      resolve();
                    });
                  }
                });
              });
            };
          },
          {
            '../common/callback': 24,
            '../common/image': 27,
            '../common/object/asyncSignatureUrl': 31,
            '../common/object/copyObject': 32,
            '../common/object/delete': 33,
            '../common/object/deleteMulti': 34,
            '../common/object/deleteObjectTagging': 35,
            '../common/object/generateObjectUrl': 36,
            '../common/object/get': 37,
            '../common/object/getACL': 38,
            '../common/object/getBucketVersions': 39,
            '../common/object/getObjectMeta': 40,
            '../common/object/getObjectTagging': 41,
            '../common/object/getObjectUrl': 42,
            '../common/object/getSymlink': 43,
            '../common/object/head': 44,
            '../common/object/putACL': 45,
            '../common/object/putObjectTagging': 46,
            '../common/object/putSymlink': 47,
            '../common/object/signatureUrl': 48,
            '../common/utils/isBlob': 63,
            '../common/utils/isBuffer': 64,
            '../common/utils/isFile': 65,
            '../common/utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'copy-to': 91,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.function.name.js': 281,
            'core-js/modules/es.number.constructor.js': 283,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.promise.js': 294,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338,
            fs: 87,
            'merge-descriptors': 357,
            mime: 359,
            path: 363
          }
        ],
        6: [
          function (require, module, exports) {
            'use strict';

            exports.version = '6.18.0';
          },
          {}
        ],
        7: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.abortBucketWorm = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            function abortBucketWorm(_x, _x2) {
              return _abortBucketWorm.apply(this, arguments);
            }

            function _abortBucketWorm() {
              _abortBucketWorm = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            checkBucketName_1.checkBucketName(name);
                            params = this._bucketRequestParams('DELETE', name, 'worm', options);
                            _context.next = 4;
                            return this.request(params);

                          case 4:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res,
                              status: result.status
                            });

                          case 6:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _abortBucketWorm.apply(this, arguments);
            }

            exports.abortBucketWorm = abortBucketWorm;
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        8: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.completeBucketWorm = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            function completeBucketWorm(_x, _x2, _x3) {
              return _completeBucketWorm.apply(this, arguments);
            }

            function _completeBucketWorm() {
              _completeBucketWorm = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, wormId, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            checkBucketName_1.checkBucketName(name);
                            params = this._bucketRequestParams(
                              'POST',
                              name,
                              {
                                wormId: wormId
                              },
                              options
                            );
                            _context.next = 4;
                            return this.request(params);

                          case 4:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res,
                              status: result.status
                            });

                          case 6:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _completeBucketWorm.apply(this, arguments);
            }

            exports.completeBucketWorm = completeBucketWorm;
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        9: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.deleteBucketInventory = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');
            /**
             * deleteBucketInventory
             * @param {String} bucketName - bucket name
             * @param {String} inventoryId
             * @param {Object} options
             */

            function deleteBucketInventory(_x, _x2) {
              return _deleteBucketInventory.apply(this, arguments);
            }

            function _deleteBucketInventory() {
              _deleteBucketInventory = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(bucketName, inventoryId) {
                  var options,
                    subres,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
                            subres = Object.assign(
                              {
                                inventory: '',
                                inventoryId: inventoryId
                              },
                              options.subres
                            );
                            checkBucketName_1.checkBucketName(bucketName);
                            params = this._bucketRequestParams('DELETE', bucketName, subres, options);
                            params.successStatuses = [204];
                            _context.next = 7;
                            return this.request(params);

                          case 7:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              status: result.status,
                              res: result.res
                            });

                          case 9:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _deleteBucketInventory.apply(this, arguments);
            }

            exports.deleteBucketInventory = deleteBucketInventory;
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        10: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var proto = exports;

            proto.deleteBucketLifecycle = /*#__PURE__*/ (function () {
              var _deleteBucketLifecycle = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            _checkBucketName(name);

                            params = this._bucketRequestParams('DELETE', name, 'lifecycle', options);
                            params.successStatuses = [204];
                            _context.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 7:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function deleteBucketLifecycle(_x, _x2) {
                return _deleteBucketLifecycle.apply(this, arguments);
              }

              return deleteBucketLifecycle;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        11: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var proto = exports;

            proto.deleteBucketWebsite = /*#__PURE__*/ (function () {
              var _deleteBucketWebsite = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            _checkBucketName(name);

                            params = this._bucketRequestParams('DELETE', name, 'website', options);
                            params.successStatuses = [204];
                            _context.next = 5;
                            return this.request(params);

                          case 5:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 7:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function deleteBucketWebsite(_x, _x2) {
                return _deleteBucketWebsite.apply(this, arguments);
              }

              return deleteBucketWebsite;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        12: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.extendBucketWorm = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            var obj2xml_1 = require('../utils/obj2xml');

            function extendBucketWorm(_x, _x2, _x3, _x4) {
              return _extendBucketWorm.apply(this, arguments);
            }

            function _extendBucketWorm() {
              _extendBucketWorm = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, wormId, days, options) {
                  var params, paramlXMLObJ, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            checkBucketName_1.checkBucketName(name);
                            params = this._bucketRequestParams(
                              'POST',
                              name,
                              {
                                wormExtend: '',
                                wormId: wormId
                              },
                              options
                            );
                            paramlXMLObJ = {
                              ExtendWormConfiguration: {
                                RetentionPeriodInDays: days
                              }
                            };
                            params.mime = 'xml';
                            params.content = obj2xml_1.obj2xml(paramlXMLObJ, {
                              headers: true
                            });
                            params.successStatuses = [200];
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res,
                              status: result.status
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _extendBucketWorm.apply(this, arguments);
            }

            exports.extendBucketWorm = extendBucketWorm;
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        13: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.getBucketInventory = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            var formatInventoryConfig_1 = require('../utils/formatInventoryConfig');
            /**
             * getBucketInventory
             * @param {String} bucketName - bucket name
             * @param {String} inventoryId
             * @param {Object} options
             */

            function getBucketInventory(_x, _x2) {
              return _getBucketInventory.apply(this, arguments);
            }

            function _getBucketInventory() {
              _getBucketInventory = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(bucketName, inventoryId) {
                  var options,
                    subres,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
                            subres = Object.assign(
                              {
                                inventory: '',
                                inventoryId: inventoryId
                              },
                              options.subres
                            );
                            checkBucketName_1.checkBucketName(bucketName);
                            params = this._bucketRequestParams('GET', bucketName, subres, options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              status: result.status,
                              res: result.res,
                              inventory: formatInventoryConfig_1.formatInventoryConfig(result.data)
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _getBucketInventory.apply(this, arguments);
            }

            exports.getBucketInventory = getBucketInventory;
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/formatInventoryConfig': 59,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        14: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.array.map.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var _require2 = require('../utils/isArray'),
              isArray = _require2.isArray;

            var _require3 = require('../utils/formatObjKey'),
              formatObjKey = _require3.formatObjKey;

            var proto = exports;

            proto.getBucketLifecycle = /*#__PURE__*/ (function () {
              var _getBucketLifecycle = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result, rules;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            _checkBucketName(name);

                            params = this._bucketRequestParams('GET', name, 'lifecycle', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context.next = 6;
                            return this.request(params);

                          case 6:
                            result = _context.sent;
                            rules = result.data.Rule || null;

                            if (rules) {
                              if (!isArray(rules)) {
                                rules = [rules];
                              }

                              rules = rules.map(function (_) {
                                if (_.ID) {
                                  _.id = _.ID;
                                  delete _.ID;
                                }

                                if (_.Tag && !isArray(_.Tag)) {
                                  _.Tag = [_.Tag];
                                }

                                return formatObjKey(_, 'firstLowerCase');
                              });
                            }

                            return _context.abrupt('return', {
                              rules: rules,
                              res: result.res
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getBucketLifecycle(_x, _x2) {
                return _getBucketLifecycle.apply(this, arguments);
              }

              return getBucketLifecycle;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/formatObjKey': 60,
            '../utils/isArray': 62,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.map.js': 277
          }
        ],
        15: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var proto = exports;
            /**
             * getBucketVersioning
             * @param {String} bucketName - bucket name
             */

            proto.getBucketVersioning = /*#__PURE__*/ (function () {
              var _getBucketVersioning = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(bucketName, options) {
                  var params, result, versionStatus;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            _checkBucketName(bucketName);

                            params = this._bucketRequestParams('GET', bucketName, 'versioning', options);
                            params.xmlResponse = true;
                            params.successStatuses = [200];
                            _context.next = 6;
                            return this.request(params);

                          case 6:
                            result = _context.sent;
                            versionStatus = result.data.Status;
                            return _context.abrupt('return', {
                              status: result.status,
                              versionStatus: versionStatus,
                              res: result.res
                            });

                          case 9:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getBucketVersioning(_x, _x2) {
                return _getBucketVersioning.apply(this, arguments);
              }

              return getBucketVersioning;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        16: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var _require2 = require('../utils/isObject'),
              isObject = _require2.isObject;

            var proto = exports;

            proto.getBucketWebsite = /*#__PURE__*/ (function () {
              var _getBucketWebsite = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result, routingRules;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            _checkBucketName(name);

                            params = this._bucketRequestParams('GET', name, 'website', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context.next = 6;
                            return this.request(params);

                          case 6:
                            result = _context.sent;
                            routingRules = [];

                            if (result.data.RoutingRules && result.data.RoutingRules.RoutingRule) {
                              if (isObject(result.data.RoutingRules.RoutingRule)) {
                                routingRules = [result.data.RoutingRules.RoutingRule];
                              } else {
                                routingRules = result.data.RoutingRules.RoutingRule;
                              }
                            }

                            return _context.abrupt('return', {
                              index: (result.data.IndexDocument && result.data.IndexDocument.Suffix) || '',
                              supportSubDir:
                                (result.data.IndexDocument && result.data.IndexDocument.SupportSubDir) || 'false',
                              type: result.data.IndexDocument && result.data.IndexDocument.Type,
                              routingRules: routingRules,
                              error: (result.data.ErrorDocument && result.data.ErrorDocument.Key) || null,
                              res: result.res
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getBucketWebsite(_x, _x2) {
                return _getBucketWebsite.apply(this, arguments);
              }

              return getBucketWebsite;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/isObject': 68,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        17: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.getBucketWorm = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            var dataFix_1 = require('../utils/dataFix');

            function getBucketWorm(_x, _x2) {
              return _getBucketWorm.apply(this, arguments);
            }

            function _getBucketWorm() {
              _getBucketWorm = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            checkBucketName_1.checkBucketName(name);
                            params = this._bucketRequestParams('GET', name, 'worm', options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context.next = 6;
                            return this.request(params);

                          case 6:
                            result = _context.sent;
                            dataFix_1.dataFix(result.data, {
                              lowerFirst: true,
                              rename: {
                                RetentionPeriodInDays: 'days'
                              }
                            });
                            return _context.abrupt(
                              'return',
                              Object.assign(Object.assign({}, result.data), {
                                res: result.res,
                                status: result.status
                              })
                            );

                          case 9:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _getBucketWorm.apply(this, arguments);
            }

            exports.getBucketWorm = getBucketWorm;
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/dataFix': 56,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        18: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.initiateBucketWorm = void 0;

            var obj2xml_1 = require('../utils/obj2xml');

            var checkBucketName_1 = require('../utils/checkBucketName');

            function initiateBucketWorm(_x, _x2, _x3) {
              return _initiateBucketWorm.apply(this, arguments);
            }

            function _initiateBucketWorm() {
              _initiateBucketWorm = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, days, options) {
                  var params, paramlXMLObJ, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            checkBucketName_1.checkBucketName(name);
                            params = this._bucketRequestParams('POST', name, 'worm', options);
                            paramlXMLObJ = {
                              InitiateWormConfiguration: {
                                RetentionPeriodInDays: days
                              }
                            };
                            params.mime = 'xml';
                            params.content = obj2xml_1.obj2xml(paramlXMLObJ, {
                              headers: true
                            });
                            params.successStatuses = [200];
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res,
                              wormId: result.res.headers['x-oss-worm-id'],
                              status: result.status
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _initiateBucketWorm.apply(this, arguments);
            }

            exports.initiateBucketWorm = initiateBucketWorm;
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        19: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.listBucketInventory = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            var formatInventoryConfig_1 = require('../utils/formatInventoryConfig');
            /**
             * listBucketInventory
             * @param {String} bucketName - bucket name
             * @param {String} inventoryId
             * @param {Object} options
             */

            function listBucketInventory(_x) {
              return _listBucketInventory.apply(this, arguments);
            }

            function _listBucketInventory() {
              _listBucketInventory = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(bucketName) {
                  var options,
                    continuationToken,
                    subres,
                    params,
                    result,
                    data,
                    res,
                    status,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            continuationToken = options.continuationToken;
                            subres = Object.assign(
                              {
                                inventory: ''
                              },
                              continuationToken && {
                                'continuation-token': continuationToken
                              },
                              options.subres
                            );
                            checkBucketName_1.checkBucketName(bucketName);
                            params = this._bucketRequestParams('GET', bucketName, subres, options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context.next = 9;
                            return this.request(params);

                          case 9:
                            result = _context.sent;
                            (data = result.data), (res = result.res), (status = result.status);
                            return _context.abrupt('return', {
                              isTruncated: data.IsTruncated === 'true',
                              nextContinuationToken: data.NextContinuationToken,
                              inventoryList: formatInventoryConfig_1.formatInventoryConfig(
                                data.InventoryConfiguration,
                                true
                              ),
                              status: status,
                              res: res
                            });

                          case 12:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _listBucketInventory.apply(this, arguments);
            }

            exports.listBucketInventory = listBucketInventory;
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/formatInventoryConfig': 59,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        20: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.array.concat.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.putBucketInventory = void 0;

            var checkBucketName_1 = require('../utils/checkBucketName');

            var obj2xml_1 = require('../utils/obj2xml');
            /**
             * putBucketInventory
             * @param {String} bucketName - bucket name
             * @param {Inventory} inventory
             * @param {Object} options
             */

            function putBucketInventory(_x, _x2) {
              return _putBucketInventory.apply(this, arguments);
            }

            function _putBucketInventory() {
              _putBucketInventory = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(bucketName, inventory) {
                  var options,
                    subres,
                    OSSBucketDestination,
                    optionalFields,
                    includedObjectVersions,
                    destinationBucketPrefix,
                    rolePrefix,
                    paramXMLObj,
                    paramXML,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
                            subres = Object.assign(
                              {
                                inventory: '',
                                inventoryId: inventory.id
                              },
                              options.subres
                            );
                            checkBucketName_1.checkBucketName(bucketName);
                            (OSSBucketDestination = inventory.OSSBucketDestination),
                              (optionalFields = inventory.optionalFields),
                              (includedObjectVersions = inventory.includedObjectVersions);
                            destinationBucketPrefix = 'acs:oss:::';
                            rolePrefix = 'acs:ram::'.concat(OSSBucketDestination.accountId, ':role/');
                            paramXMLObj = {
                              InventoryConfiguration: {
                                Id: inventory.id,
                                IsEnabled: inventory.isEnabled,
                                Filter: {
                                  Prefix: inventory.prefix || ''
                                },
                                Destination: {
                                  OSSBucketDestination: {
                                    Format: OSSBucketDestination.format,
                                    AccountId: OSSBucketDestination.accountId,
                                    RoleArn: ''.concat(rolePrefix).concat(OSSBucketDestination.rolename),
                                    Bucket: ''.concat(destinationBucketPrefix).concat(OSSBucketDestination.bucket),
                                    Prefix: OSSBucketDestination.prefix || '',
                                    Encryption: OSSBucketDestination.encryption || ''
                                  }
                                },
                                Schedule: {
                                  Frequency: inventory.frequency
                                },
                                IncludedObjectVersions: includedObjectVersions,
                                OptionalFields: {
                                  Field:
                                    (optionalFields === null || optionalFields === void 0
                                      ? void 0
                                      : optionalFields.field) || []
                                }
                              }
                            };
                            paramXML = obj2xml_1.obj2xml(paramXMLObj, {
                              headers: true,
                              firstUpperCase: true
                            });
                            params = this._bucketRequestParams('PUT', bucketName, subres, options);
                            params.successStatuses = [200];
                            params.mime = 'xml';
                            params.content = paramXML;
                            _context.next = 14;
                            return this.request(params);

                          case 14:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              status: result.status,
                              res: result.res
                            });

                          case 16:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _putBucketInventory.apply(this, arguments);
            }

            exports.putBucketInventory = putBucketInventory;
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        21: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.array.includes.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            /* eslint-disable no-use-before-define */
            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var _require2 = require('../utils/isArray'),
              isArray = _require2.isArray;

            var _require3 = require('../utils/deepCopy'),
              deepCopy = _require3.deepCopy;

            var _require4 = require('../utils/isObject'),
              isObject = _require4.isObject;

            var _require5 = require('../utils/obj2xml'),
              obj2xml = _require5.obj2xml;

            var _require6 = require('../utils/checkObjectTag'),
              checkObjectTag = _require6.checkObjectTag;

            var _require7 = require('../utils/getStrBytesCount'),
              getStrBytesCount = _require7.getStrBytesCount;

            var proto = exports;

            proto.putBucketLifecycle = /*#__PURE__*/ (function () {
              var _putBucketLifecycle = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, rules, options) {
                  var params, Rule, paramXMLObj, paramXML, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            _checkBucketName(name);

                            if (isArray(rules)) {
                              _context.next = 3;
                              break;
                            }

                            throw new Error('rules must be Array');

                          case 3:
                            params = this._bucketRequestParams('PUT', name, 'lifecycle', options);
                            Rule = [];
                            paramXMLObj = {
                              LifecycleConfiguration: {
                                Rule: Rule
                              }
                            };
                            rules.forEach(function (_) {
                              defaultDaysAndDate2Expiration(_); // todo delete, 兼容旧版本

                              checkRule(_);

                              if (_.id) {
                                _.ID = _.id;
                                delete _.id;
                              }

                              Rule.push(_);
                            });
                            paramXML = obj2xml(paramXMLObj, {
                              headers: true,
                              firstUpperCase: true
                            });
                            params.content = paramXML;
                            params.mime = 'xml';
                            params.successStatuses = [200];
                            _context.next = 13;
                            return this.request(params);

                          case 13:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 15:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function putBucketLifecycle(_x, _x2, _x3) {
                return _putBucketLifecycle.apply(this, arguments);
              }

              return putBucketLifecycle;
            })(); // todo delete, 兼容旧版本

            function defaultDaysAndDate2Expiration(obj) {
              if (obj.days) {
                obj.expiration = {
                  days: obj.days
                };
              }

              if (obj.date) {
                obj.expiration = {
                  createdBeforeDate: obj.date
                };
              }
            }

            function checkDaysAndDate(obj, key) {
              var days = obj.days,
                createdBeforeDate = obj.createdBeforeDate;

              if (!days && !createdBeforeDate) {
                throw new Error(''.concat(key, ' must includes days or createdBeforeDate'));
              } else if (days && !/^[1-9][0-9]*$/.test(days)) {
                throw new Error('days must be a positive integer');
              } else if (createdBeforeDate && !/\d{4}-\d{2}-\d{2}T00:00:00.000Z/.test(createdBeforeDate)) {
                throw new Error('createdBeforeDate must be date and conform to iso8601 format');
              }
            }

            function handleCheckTag(tag) {
              if (!isArray(tag) && !isObject(tag)) {
                throw new Error('tag must be Object or Array');
              }

              tag = isObject(tag) ? [tag] : tag;
              var tagObj = {};
              var tagClone = deepCopy(tag);
              tagClone.forEach(function (v) {
                tagObj[v.key] = v.value;
              });
              checkObjectTag(tagObj);
            }

            function checkRule(rule) {
              if (rule.id && getStrBytesCount(rule.id) > 255) throw new Error('ID is composed of 255 bytes at most');
              if (rule.prefix === undefined) throw new Error('Rule must includes prefix');
              if (!['Enabled', 'Disabled'].includes(rule.status))
                throw new Error('Status must be  Enabled or Disabled');

              if (rule.transition) {
                if (!['IA', 'Archive'].includes(rule.transition.storageClass))
                  throw new Error('StorageClass must be  IA or Archive');
                checkDaysAndDate(rule.transition, 'Transition');
              }

              if (rule.expiration) {
                if (!rule.expiration.expiredObjectDeleteMarker) {
                  checkDaysAndDate(rule.expiration, 'Expiration');
                } else if (rule.expiration.days || rule.expiration.createdBeforeDate) {
                  throw new Error('expiredObjectDeleteMarker cannot be used with days or createdBeforeDate');
                }
              }

              if (rule.abortMultipartUpload) {
                checkDaysAndDate(rule.abortMultipartUpload, 'AbortMultipartUpload');
              }

              if (
                !rule.expiration &&
                !rule.abortMultipartUpload &&
                !rule.transition &&
                !rule.noncurrentVersionTransition
              ) {
                throw new Error(
                  'Rule must includes expiration or abortMultipartUpload or transition or noncurrentVersionTransition'
                );
              }

              if (rule.tag) {
                if (rule.abortMultipartUpload) {
                  throw new Error('Tag cannot be used with abortMultipartUpload');
                }

                handleCheckTag(rule.tag);
              }
            }
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/checkObjectTag': 53,
            '../utils/deepCopy': 57,
            '../utils/getStrBytesCount': 61,
            '../utils/isArray': 62,
            '../utils/isObject': 68,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.includes.js': 274,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        22: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.array.includes.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var _require2 = require('../utils/obj2xml'),
              obj2xml = _require2.obj2xml;

            var proto = exports;
            /**
             * putBucketVersioning
             * @param {String} name - bucket name
             * @param {String} status
             * @param {Object} options
             */

            proto.putBucketVersioning = /*#__PURE__*/ (function () {
              var _putBucketVersioning = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, status) {
                  var options,
                    params,
                    paramXMLObj,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};

                            _checkBucketName(name);

                            if (['Enabled', 'Suspended'].includes(status)) {
                              _context.next = 4;
                              break;
                            }

                            throw new Error('status must be Enabled or Suspended');

                          case 4:
                            params = this._bucketRequestParams('PUT', name, 'versioning', options);
                            paramXMLObj = {
                              VersioningConfiguration: {
                                Status: status
                              }
                            };
                            params.mime = 'xml';
                            params.content = obj2xml(paramXMLObj, {
                              headers: true
                            });
                            _context.next = 10;
                            return this.request(params);

                          case 10:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res,
                              status: result.status
                            });

                          case 12:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function putBucketVersioning(_x, _x2) {
                return _putBucketVersioning.apply(this, arguments);
              }

              return putBucketVersioning;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.includes.js': 274
          }
        ],
        23: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var _require2 = require('../utils/obj2xml'),
              obj2xml = _require2.obj2xml;

            var _require3 = require('../utils/isArray'),
              isArray = _require3.isArray;

            var proto = exports;

            proto.putBucketWebsite = /*#__PURE__*/ (function () {
              var _putBucketWebsite = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var config,
                    options,
                    params,
                    IndexDocument,
                    WebsiteConfiguration,
                    website,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            config = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options = _args.length > 2 ? _args[2] : undefined;

                            _checkBucketName(name);

                            params = this._bucketRequestParams('PUT', name, 'website', options);
                            IndexDocument = {
                              Suffix: config.index || 'index.html'
                            };
                            WebsiteConfiguration = {
                              IndexDocument: IndexDocument
                            };
                            website = {
                              WebsiteConfiguration: WebsiteConfiguration
                            };

                            if (config.supportSubDir) {
                              IndexDocument.SupportSubDir = config.supportSubDir;
                            }

                            if (config.type) {
                              IndexDocument.Type = config.type;
                            }

                            if (config.error) {
                              WebsiteConfiguration.ErrorDocument = {
                                Key: config.error
                              };
                            }

                            if (!(config.routingRules !== undefined)) {
                              _context.next = 14;
                              break;
                            }

                            if (isArray(config.routingRules)) {
                              _context.next = 13;
                              break;
                            }

                            throw new Error('RoutingRules must be Array');

                          case 13:
                            WebsiteConfiguration.RoutingRules = {
                              RoutingRule: config.routingRules
                            };

                          case 14:
                            website = obj2xml(website);
                            params.content = website;
                            params.mime = 'xml';
                            params.successStatuses = [200];
                            _context.next = 20;
                            return this.request(params);

                          case 20:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 22:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function putBucketWebsite(_x) {
                return _putBucketWebsite.apply(this, arguments);
              }

              return putBucketWebsite;
            })();
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/isArray': 62,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79
          }
        ],
        24: [
          function (require, module, exports) {
            (function (Buffer) {
              (function () {
                'use strict';

                require('core-js/modules/es.object.to-string.js');

                require('core-js/modules/es.regexp.to-string.js');

                require('core-js/modules/web.dom-collections.for-each.js');

                require('core-js/modules/es.object.keys.js');

                exports.encodeCallback = function encodeCallback(reqParams, options) {
                  reqParams.headers = reqParams.headers || {};

                  if (!Object.prototype.hasOwnProperty.call(reqParams.headers, 'x-oss-callback')) {
                    if (options.callback) {
                      var json = {
                        callbackUrl: encodeURI(options.callback.url),
                        callbackBody: options.callback.body
                      };

                      if (options.callback.host) {
                        json.callbackHost = options.callback.host;
                      }

                      if (options.callback.contentType) {
                        json.callbackBodyType = options.callback.contentType;
                      }

                      var callback = Buffer.from(JSON.stringify(json)).toString('base64');
                      reqParams.headers['x-oss-callback'] = callback;

                      if (options.callback.customValue) {
                        var callbackVar = {};
                        Object.keys(options.callback.customValue).forEach(function (key) {
                          callbackVar['x:'.concat(key)] = options.callback.customValue[key].toString();
                        });
                        reqParams.headers['x-oss-callback-var'] = Buffer.from(JSON.stringify(callbackVar)).toString(
                          'base64'
                        );
                      }
                    }
                  }
                };
              }).call(this);
            }).call(this, require('buffer').Buffer);
          },
          {
            buffer: 89,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        25: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.array.concat.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            var __importDefault =
              (void 0 && (void 0).__importDefault) ||
              function (mod) {
                return mod && mod.__esModule
                  ? mod
                  : {
                      default: mod
                    };
              };

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.getReqUrl = void 0;

            var copy_to_1 = __importDefault(require('copy-to'));

            var url_1 = __importDefault(require('url'));

            var merge_descriptors_1 = __importDefault(require('merge-descriptors'));

            var is_type_of_1 = __importDefault(require('is-type-of'));

            var isIP_1 = require('../utils/isIP');

            var checkConfigValid_1 = require('../utils/checkConfigValid');

            function getReqUrl(params) {
              var ep = {};
              var isCname = this.options.cname;
              checkConfigValid_1.checkConfigValid(this.options.endpoint, 'endpoint');
              copy_to_1.default(this.options.endpoint, false).to(ep);

              if (params.bucket && !isCname && !isIP_1.isIP(ep.hostname) && !this.options.sldEnable) {
                ep.host = ''.concat(params.bucket, '.').concat(ep.host);
              }

              var resourcePath = '/';

              if (params.bucket && this.options.sldEnable) {
                resourcePath += ''.concat(params.bucket, '/');
              }

              if (params.object) {
                // Preserve '/' in result url
                resourcePath += this._escape(params.object).replace(/\+/g, '%2B');
              }

              ep.pathname = resourcePath;
              var query = {};

              if (params.query) {
                merge_descriptors_1.default(query, params.query);
              }

              if (params.subres) {
                var subresAsQuery = {};

                if (is_type_of_1.default.string(params.subres)) {
                  subresAsQuery[params.subres] = '';
                } else if (is_type_of_1.default.array(params.subres)) {
                  params.subres.forEach(function (k) {
                    subresAsQuery[k] = '';
                  });
                } else {
                  subresAsQuery = params.subres;
                }

                merge_descriptors_1.default(query, subresAsQuery);
              }

              ep.query = query;
              return url_1.default.format(ep);
            }

            exports.getReqUrl = getReqUrl;
          },
          {
            '../utils/checkConfigValid': 52,
            '../utils/isIP': 67,
            'copy-to': 91,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338,
            'is-type-of': 440,
            'merge-descriptors': 357,
            url: 446
          }
        ],
        26: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.array.concat.js');

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.string.trim.js');

            var ms = require('humanize-ms');

            var urlutil = require('url');

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var _require2 = require('../utils/setRegion'),
              setRegion = _require2.setRegion;

            var _require3 = require('../utils/checkConfigValid'),
              checkConfigValid = _require3.checkConfigValid;

            function setEndpoint(endpoint, secure) {
              checkConfigValid(endpoint, 'endpoint');
              var url = urlutil.parse(endpoint);

              if (!url.protocol) {
                url = urlutil.parse('http'.concat(secure ? 's' : '', '://').concat(endpoint));
              }

              if (url.protocol !== 'http:' && url.protocol !== 'https:') {
                throw new Error('Endpoint protocol must be http or https.');
              }

              return url;
            }

            module.exports = function (options) {
              if (!options || !options.accessKeyId || !options.accessKeySecret) {
                throw new Error('require accessKeyId, accessKeySecret');
              }

              if (options.stsToken && !options.refreshSTSToken && !options.refreshSTSTokenInterval) {
                console.warn(
                  "It's recommended to set 'refreshSTSToken' and 'refreshSTSTokenInterval' to refresh" +
                    ' stsToken、accessKeyId、accessKeySecret automatically when sts token has expired'
                );
              }

              if (options.bucket) {
                _checkBucketName(options.bucket);
              }

              var opts = Object.assign(
                {
                  region: 'oss-cn-hangzhou',
                  internal: false,
                  secure: false,
                  timeout: 60000,
                  bucket: null,
                  endpoint: null,
                  cname: false,
                  isRequestPay: false,
                  sldEnable: false,
                  headerEncoding: 'utf-8',
                  refreshSTSToken: null,
                  refreshSTSTokenInterval: 60000 * 5,
                  retryMax: 0
                },
                options
              );
              opts.accessKeyId = opts.accessKeyId.trim();
              opts.accessKeySecret = opts.accessKeySecret.trim();

              if (opts.timeout) {
                opts.timeout = ms(opts.timeout);
              }

              if (opts.endpoint) {
                opts.endpoint = setEndpoint(opts.endpoint, opts.secure);
              } else if (opts.region) {
                opts.endpoint = setRegion(opts.region, opts.internal, opts.secure);
              } else {
                throw new Error('require options.endpoint or options.region');
              }

              opts.inited = true;
              return opts;
            };
          },
          {
            '../utils/checkBucketName': 51,
            '../utils/checkConfigValid': 52,
            '../utils/setRegion': 73,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.string.trim.js': 307,
            'humanize-ms': 345,
            url: 446
          }
        ],
        27: [
          function (require, module, exports) {
            'use strict';

            var merge = require('merge-descriptors');

            var proto = exports;
            merge(proto, require('./processObjectSave'));
          },
          { './processObjectSave': 28, 'merge-descriptors': 357 }
        ],
        28: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.array.concat.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            /* eslint-disable no-use-before-define */
            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var querystring = require('querystring');

            var _require2 = require('js-base64'),
              str2Base64 = _require2.Base64.encode;

            var proto = exports;

            proto.processObjectSave = /*#__PURE__*/ (function () {
              var _processObjectSave = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(
                  function _callee(sourceObject, targetObject, process, targetBucket) {
                    var params, bucketParam, content, result;
                    return _regenerator.default.wrap(
                      function _callee$(_context) {
                        while (1) {
                          switch ((_context.prev = _context.next)) {
                            case 0:
                              checkArgs(sourceObject, 'sourceObject');
                              checkArgs(targetObject, 'targetObject');
                              checkArgs(process, 'process');
                              targetObject = this._objectName(targetObject);

                              if (targetBucket) {
                                _checkBucketName(targetBucket);
                              }

                              params = this._objectRequestParams('POST', sourceObject, {
                                subres: 'x-oss-process'
                              });
                              bucketParam = targetBucket ? ',b_'.concat(str2Base64(targetBucket)) : '';
                              targetObject = str2Base64(targetObject);
                              content = {
                                'x-oss-process': ''
                                  .concat(process, '|sys/saveas,o_')
                                  .concat(targetObject)
                                  .concat(bucketParam)
                              };
                              params.content = querystring.stringify(content);
                              _context.next = 12;
                              return this.request(params);

                            case 12:
                              result = _context.sent;
                              return _context.abrupt('return', {
                                res: result.res,
                                status: result.res.status
                              });

                            case 14:
                            case 'end':
                              return _context.stop();
                          }
                        }
                      },
                      _callee,
                      this
                    );
                  }
                )
              );

              function processObjectSave(_x, _x2, _x3, _x4) {
                return _processObjectSave.apply(this, arguments);
              }

              return processObjectSave;
            })();

            function checkArgs(name, key) {
              if (!name) {
                throw new Error(''.concat(key, ' is required'));
              }

              if (typeof name !== 'string') {
                throw new Error(''.concat(key, ' must be String'));
              }
            }
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.concat.js': 269,
            'js-base64': 356,
            querystring: 370
          }
        ],
        29: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.array.concat.js');

            require('core-js/modules/es.function.name.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/es.promise.js');

            require('core-js/modules/es.array.from.js');

            require('core-js/modules/es.string.iterator.js');

            require('core-js/modules/es.array.map.js');

            require('core-js/modules/es.array.filter.js');

            require('core-js/modules/es.array.find.js');

            require('core-js/modules/es.regexp.to-string.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            /* eslint-disable no-async-promise-executor */
            var debug = require('debug')('ali-oss:multipart-copy');

            var copy = require('copy-to');

            var proto = exports;
            /**
             * Upload a part copy in a multipart from the source bucket/object
             * used with initMultipartUpload and completeMultipartUpload.
             * @param {String} name copy object name
             * @param {String} uploadId the upload id
             * @param {Number} partNo the part number
             * @param {String} range  like 0-102400  part size need to copy
             * @param {Object} sourceData
             *        {String} sourceData.sourceKey  the source object name
             *        {String} sourceData.sourceBucketName  the source bucket name
             * @param {Object} options
             */

            /* eslint max-len: [0] */

            proto.uploadPartCopy = /*#__PURE__*/ (function () {
              var _uploadPartCopy = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, uploadId, partNo, range, sourceData) {
                  var options,
                    versionId,
                    copySource,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 5 && _args[5] !== undefined ? _args[5] : {};
                            options.headers = options.headers || {};
                            versionId = options.versionId || (options.subres && options.subres.versionId) || null;

                            if (versionId) {
                              copySource = '/'
                                .concat(sourceData.sourceBucketName, '/')
                                .concat(encodeURIComponent(sourceData.sourceKey), '?versionId=')
                                .concat(versionId);
                            } else {
                              copySource = '/'
                                .concat(sourceData.sourceBucketName, '/')
                                .concat(encodeURIComponent(sourceData.sourceKey));
                            }

                            options.headers['x-oss-copy-source'] = copySource;

                            if (range) {
                              options.headers['x-oss-copy-source-range'] = 'bytes='.concat(range);
                            }

                            options.subres = {
                              partNumber: partNo,
                              uploadId: uploadId
                            };
                            params = this._objectRequestParams('PUT', name, options);
                            params.mime = options.mime;
                            params.successStatuses = [200];
                            _context.next = 12;
                            return this.request(params);

                          case 12:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              name: name,
                              etag: result.res.headers.etag,
                              res: result.res
                            });

                          case 14:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function uploadPartCopy(_x, _x2, _x3, _x4, _x5) {
                return _uploadPartCopy.apply(this, arguments);
              }

              return uploadPartCopy;
            })();
            /**
             * @param {String} name copy object name
             * @param {Object} sourceData
             *        {String} sourceData.sourceKey  the source object name
             *        {String} sourceData.sourceBucketName  the source bucket name
             *        {Number} sourceData.startOffset  data copy start byte offset, e.g: 0
             *        {Number} sourceData.endOffset  data copy end byte offset, e.g: 102400
             * @param {Object} options
             *        {Number} options.partSize
             */

            proto.multipartUploadCopy = /*#__PURE__*/ (function () {
              var _multipartUploadCopy = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee2(name, sourceData) {
                  var options,
                    _options$versionId,
                    versionId,
                    metaOpt,
                    objectMeta,
                    fileSize,
                    minPartSize,
                    copySize,
                    init,
                    uploadId,
                    partSize,
                    checkpoint,
                    _args2 = arguments;

                  return _regenerator.default.wrap(
                    function _callee2$(_context2) {
                      while (1) {
                        switch ((_context2.prev = _context2.next)) {
                          case 0:
                            options = _args2.length > 2 && _args2[2] !== undefined ? _args2[2] : {};
                            this.resetCancelFlag();
                            (_options$versionId = options.versionId),
                              (versionId = _options$versionId === void 0 ? null : _options$versionId);
                            metaOpt = {
                              versionId: versionId
                            };
                            _context2.next = 6;
                            return this._getObjectMeta(sourceData.sourceBucketName, sourceData.sourceKey, metaOpt);

                          case 6:
                            objectMeta = _context2.sent;
                            fileSize = objectMeta.res.headers['content-length'];
                            sourceData.startOffset = sourceData.startOffset || 0;
                            sourceData.endOffset = sourceData.endOffset || fileSize;

                            if (!(options.checkpoint && options.checkpoint.uploadId)) {
                              _context2.next = 14;
                              break;
                            }

                            _context2.next = 13;
                            return this._resumeMultipartCopy(options.checkpoint, sourceData, options);

                          case 13:
                            return _context2.abrupt('return', _context2.sent);

                          case 14:
                            minPartSize = 100 * 1024;
                            copySize = sourceData.endOffset - sourceData.startOffset;

                            if (!(copySize < minPartSize)) {
                              _context2.next = 18;
                              break;
                            }

                            throw new Error('copySize must not be smaller than '.concat(minPartSize));

                          case 18:
                            if (!(options.partSize && options.partSize < minPartSize)) {
                              _context2.next = 20;
                              break;
                            }

                            throw new Error('partSize must not be smaller than '.concat(minPartSize));

                          case 20:
                            _context2.next = 22;
                            return this.initMultipartUpload(name, options);

                          case 22:
                            init = _context2.sent;
                            uploadId = init.uploadId;
                            partSize = this._getPartSize(copySize, options.partSize);
                            checkpoint = {
                              name: name,
                              copySize: copySize,
                              partSize: partSize,
                              uploadId: uploadId,
                              doneParts: []
                            };

                            if (!(options && options.progress)) {
                              _context2.next = 29;
                              break;
                            }

                            _context2.next = 29;
                            return options.progress(0, checkpoint, init.res);

                          case 29:
                            _context2.next = 31;
                            return this._resumeMultipartCopy(checkpoint, sourceData, options);

                          case 31:
                            return _context2.abrupt('return', _context2.sent);

                          case 32:
                          case 'end':
                            return _context2.stop();
                        }
                      }
                    },
                    _callee2,
                    this
                  );
                })
              );

              function multipartUploadCopy(_x6, _x7) {
                return _multipartUploadCopy.apply(this, arguments);
              }

              return multipartUploadCopy;
            })();
            /*
             * Resume multipart copy from checkpoint. The checkpoint will be
             * updated after each successful part copy.
             * @param {Object} checkpoint the checkpoint
             * @param {Object} options
             */

            proto._resumeMultipartCopy = /*#__PURE__*/ (function () {
              var _resumeMultipartCopy2 = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee4(checkpoint, sourceData, options) {
                  var _options$versionId2,
                    versionId,
                    metaOpt,
                    copySize,
                    partSize,
                    uploadId,
                    doneParts,
                    name,
                    partOffs,
                    numParts,
                    uploadPartCopyOptions,
                    uploadPartJob,
                    all,
                    done,
                    todo,
                    defaultParallel,
                    parallel,
                    i,
                    errors,
                    abortEvent,
                    err;

                  return _regenerator.default.wrap(
                    function _callee4$(_context4) {
                      while (1) {
                        switch ((_context4.prev = _context4.next)) {
                          case 0:
                            if (!this.isCancel()) {
                              _context4.next = 2;
                              break;
                            }

                            throw this._makeCancelEvent();

                          case 2:
                            (_options$versionId2 = options.versionId),
                              (versionId = _options$versionId2 === void 0 ? null : _options$versionId2);
                            metaOpt = {
                              versionId: versionId
                            };
                            (copySize = checkpoint.copySize),
                              (partSize = checkpoint.partSize),
                              (uploadId = checkpoint.uploadId),
                              (doneParts = checkpoint.doneParts),
                              (name = checkpoint.name);
                            partOffs = this._divideMultipartCopyParts(copySize, partSize, sourceData.startOffset);
                            numParts = partOffs.length;
                            uploadPartCopyOptions = {
                              headers: {}
                            };

                            if (options.copyheaders) {
                              copy(options.copyheaders).to(uploadPartCopyOptions.headers);
                            }

                            if (versionId) {
                              copy(metaOpt).to(uploadPartCopyOptions);
                            }

                            uploadPartJob = function uploadPartJob(self, partNo, source) {
                              return new Promise(
                                /*#__PURE__*/ (function () {
                                  var _ref = (0, _asyncToGenerator2.default)(
                                    /*#__PURE__*/ _regenerator.default.mark(function _callee3(resolve, reject) {
                                      var pi, range, result;
                                      return _regenerator.default.wrap(
                                        function _callee3$(_context3) {
                                          while (1) {
                                            switch ((_context3.prev = _context3.next)) {
                                              case 0:
                                                _context3.prev = 0;

                                                if (self.isCancel()) {
                                                  _context3.next = 22;
                                                  break;
                                                }

                                                pi = partOffs[partNo - 1];
                                                range = ''.concat(pi.start, '-').concat(pi.end - 1);
                                                _context3.prev = 4;
                                                _context3.next = 7;
                                                return self.uploadPartCopy(
                                                  name,
                                                  uploadId,
                                                  partNo,
                                                  range,
                                                  source,
                                                  uploadPartCopyOptions
                                                );

                                              case 7:
                                                result = _context3.sent;
                                                _context3.next = 15;
                                                break;

                                              case 10:
                                                _context3.prev = 10;
                                                _context3.t0 = _context3['catch'](4);

                                                if (!(_context3.t0.status === 404)) {
                                                  _context3.next = 14;
                                                  break;
                                                }

                                                throw self._makeAbortEvent();

                                              case 14:
                                                throw _context3.t0;

                                              case 15:
                                                if (self.isCancel()) {
                                                  _context3.next = 22;
                                                  break;
                                                }

                                                debug('content-range '.concat(result.res.headers['content-range']));
                                                doneParts.push({
                                                  number: partNo,
                                                  etag: result.res.headers.etag
                                                });
                                                checkpoint.doneParts = doneParts;

                                                if (!(options && options.progress)) {
                                                  _context3.next = 22;
                                                  break;
                                                }

                                                _context3.next = 22;
                                                return options.progress(
                                                  doneParts.length / numParts,
                                                  checkpoint,
                                                  result.res
                                                );

                                              case 22:
                                                resolve();
                                                _context3.next = 29;
                                                break;

                                              case 25:
                                                _context3.prev = 25;
                                                _context3.t1 = _context3['catch'](0);
                                                _context3.t1.partNum = partNo;
                                                reject(_context3.t1);

                                              case 29:
                                              case 'end':
                                                return _context3.stop();
                                            }
                                          }
                                        },
                                        _callee3,
                                        null,
                                        [
                                          [0, 25],
                                          [4, 10]
                                        ]
                                      );
                                    })
                                  );

                                  return function (_x11, _x12) {
                                    return _ref.apply(this, arguments);
                                  };
                                })()
                              );
                            };

                            all = Array.from(new Array(numParts), function (x, i) {
                              return i + 1;
                            });
                            done = doneParts.map(function (p) {
                              return p.number;
                            });
                            todo = all.filter(function (p) {
                              return done.indexOf(p) < 0;
                            });
                            defaultParallel = 5;
                            parallel = options.parallel || defaultParallel;

                            if (!(this.checkBrowserAndVersion('Internet Explorer', '10') || parallel === 1)) {
                              _context4.next = 28;
                              break;
                            }

                            i = 0;

                          case 18:
                            if (!(i < todo.length)) {
                              _context4.next = 26;
                              break;
                            }

                            if (!this.isCancel()) {
                              _context4.next = 21;
                              break;
                            }

                            throw this._makeCancelEvent();

                          case 21:
                            _context4.next = 23;
                            return uploadPartJob(this, todo[i], sourceData);

                          case 23:
                            i++;
                            _context4.next = 18;
                            break;

                          case 26:
                            _context4.next = 40;
                            break;

                          case 28:
                            _context4.next = 30;
                            return this._parallelNode(todo, parallel, uploadPartJob, sourceData);

                          case 30:
                            errors = _context4.sent;
                            abortEvent = errors.find(function (err) {
                              return err.name === 'abort';
                            });

                            if (!abortEvent) {
                              _context4.next = 34;
                              break;
                            }

                            throw abortEvent;

                          case 34:
                            if (!this.isCancel()) {
                              _context4.next = 36;
                              break;
                            }

                            throw this._makeCancelEvent();

                          case 36:
                            if (!(errors && errors.length > 0)) {
                              _context4.next = 40;
                              break;
                            }

                            err = errors[0];
                            err.message = 'Failed to copy some parts with error: '
                              .concat(err.toString(), ' part_num: ')
                              .concat(err.partNum);
                            throw err;

                          case 40:
                            _context4.next = 42;
                            return this.completeMultipartUpload(name, uploadId, doneParts, options);

                          case 42:
                            return _context4.abrupt('return', _context4.sent);

                          case 43:
                          case 'end':
                            return _context4.stop();
                        }
                      }
                    },
                    _callee4,
                    this
                  );
                })
              );

              function _resumeMultipartCopy(_x8, _x9, _x10) {
                return _resumeMultipartCopy2.apply(this, arguments);
              }

              return _resumeMultipartCopy;
            })();

            proto._divideMultipartCopyParts = function _divideMultipartCopyParts(fileSize, partSize, startOffset) {
              var numParts = Math.ceil(fileSize / partSize);
              var partOffs = [];

              for (var i = 0; i < numParts; i++) {
                var start = partSize * i + startOffset;
                var end = Math.min(start + partSize, fileSize + startOffset);
                partOffs.push({
                  start: start,
                  end: end
                });
              }

              return partOffs;
            };
            /**
             * Get Object Meta
             * @param {String} bucket  bucket name
             * @param {String} name   object name
             * @param {Object} options
             */

            proto._getObjectMeta = /*#__PURE__*/ (function () {
              var _getObjectMeta2 = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee5(bucket, name, options) {
                  var currentBucket, data;
                  return _regenerator.default.wrap(
                    function _callee5$(_context5) {
                      while (1) {
                        switch ((_context5.prev = _context5.next)) {
                          case 0:
                            currentBucket = this.getBucket();
                            this.setBucket(bucket);
                            _context5.next = 4;
                            return this.head(name, options);

                          case 4:
                            data = _context5.sent;
                            this.setBucket(currentBucket);
                            return _context5.abrupt('return', data);

                          case 7:
                          case 'end':
                            return _context5.stop();
                        }
                      }
                    },
                    _callee5,
                    this
                  );
                })
              );

              function _getObjectMeta(_x13, _x14, _x15) {
                return _getObjectMeta2.apply(this, arguments);
              }

              return _getObjectMeta;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'copy-to': 91,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.filter.js': 271,
            'core-js/modules/es.array.find.js': 272,
            'core-js/modules/es.array.from.js': 273,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.function.name.js': 281,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.promise.js': 294,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.string.iterator.js': 302,
            debug: 439
          }
        ],
        30: [
          function (require, module, exports) {
            (function (process) {
              (function () {
                'use strict';

                require('core-js/modules/es.object.keys.js');

                require('core-js/modules/es.symbol.js');

                require('core-js/modules/es.object.get-own-property-descriptor.js');

                require('core-js/modules/web.dom-collections.for-each.js');

                require('core-js/modules/es.object.get-own-property-descriptors.js');

                var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

                var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

                require('core-js/modules/es.array.map.js');

                require('core-js/modules/es.array.filter.js');

                require('core-js/modules/es.object.to-string.js');

                require('core-js/modules/es.array.sort.js');

                require('core-js/modules/es.array.concat.js');

                require('core-js/modules/es.regexp.to-string.js');

                var _defineProperty2 = _interopRequireDefault(require('@babel/runtime/helpers/defineProperty'));

                var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

                function ownKeys(object, enumerableOnly) {
                  var keys = Object.keys(object);
                  if (Object.getOwnPropertySymbols) {
                    var symbols = Object.getOwnPropertySymbols(object);
                    enumerableOnly &&
                      (symbols = symbols.filter(function (sym) {
                        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
                      })),
                      keys.push.apply(keys, symbols);
                  }
                  return keys;
                }

                function _objectSpread(target) {
                  for (var i = 1; i < arguments.length; i++) {
                    var source = null != arguments[i] ? arguments[i] : {};
                    i % 2
                      ? ownKeys(Object(source), !0).forEach(function (key) {
                          (0, _defineProperty2.default)(target, key, source[key]);
                        })
                      : Object.getOwnPropertyDescriptors
                      ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source))
                      : ownKeys(Object(source)).forEach(function (key) {
                          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
                        });
                  }
                  return target;
                }

                var copy = require('copy-to');

                var callback = require('./callback');

                var _require = require('./utils/deepCopy'),
                  deepCopyWith = _require.deepCopyWith;

                var _require2 = require('./utils/isBuffer'),
                  isBuffer = _require2.isBuffer;

                var _require3 = require('./utils/omit'),
                  omit = _require3.omit;

                var proto = exports;
                /**
                 * List the on-going multipart uploads
                 * https://help.aliyun.com/document_detail/31997.html
                 * @param {Object} options
                 * @return {Array} the multipart uploads
                 */

                proto.listUploads = /*#__PURE__*/ (function () {
                  var _listUploads = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee(query, options) {
                      var opt, params, result, uploads;
                      return _regenerator.default.wrap(
                        function _callee$(_context) {
                          while (1) {
                            switch ((_context.prev = _context.next)) {
                              case 0:
                                options = options || {};
                                opt = {};
                                copy(options).to(opt);
                                opt.subres = 'uploads';
                                params = this._objectRequestParams('GET', '', opt);
                                params.query = query;
                                params.xmlResponse = true;
                                params.successStatuses = [200];
                                _context.next = 10;
                                return this.request(params);

                              case 10:
                                result = _context.sent;
                                uploads = result.data.Upload || [];

                                if (!Array.isArray(uploads)) {
                                  uploads = [uploads];
                                }

                                uploads = uploads.map(function (up) {
                                  return {
                                    name: up.Key,
                                    uploadId: up.UploadId,
                                    initiated: up.Initiated
                                  };
                                });
                                return _context.abrupt('return', {
                                  res: result.res,
                                  uploads: uploads,
                                  bucket: result.data.Bucket,
                                  nextKeyMarker: result.data.NextKeyMarker,
                                  nextUploadIdMarker: result.data.NextUploadIdMarker,
                                  isTruncated: result.data.IsTruncated === 'true'
                                });

                              case 15:
                              case 'end':
                                return _context.stop();
                            }
                          }
                        },
                        _callee,
                        this
                      );
                    })
                  );

                  function listUploads(_x, _x2) {
                    return _listUploads.apply(this, arguments);
                  }

                  return listUploads;
                })();
                /**
                 * List the done uploadPart parts
                 * @param {String} name object name
                 * @param {String} uploadId multipart upload id
                 * @param {Object} query
                 * {Number} query.max-parts The maximum part number in the response of the OSS. Default value: 1000
                 * {Number} query.part-number-marker Starting position of a specific list.
                 * {String} query.encoding-type Specify the encoding of the returned content and the encoding type.
                 * @param {Object} options
                 * @return {Object} result
                 */

                proto.listParts = /*#__PURE__*/ (function () {
                  var _listParts = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee2(name, uploadId, query, options) {
                      var opt, params, result;
                      return _regenerator.default.wrap(
                        function _callee2$(_context2) {
                          while (1) {
                            switch ((_context2.prev = _context2.next)) {
                              case 0:
                                options = options || {};
                                opt = {};
                                copy(options).to(opt);
                                opt.subres = {
                                  uploadId: uploadId
                                };
                                params = this._objectRequestParams('GET', name, opt);
                                params.query = query;
                                params.xmlResponse = true;
                                params.successStatuses = [200];
                                _context2.next = 10;
                                return this.request(params);

                              case 10:
                                result = _context2.sent;
                                return _context2.abrupt('return', {
                                  res: result.res,
                                  uploadId: result.data.UploadId,
                                  bucket: result.data.Bucket,
                                  name: result.data.Key,
                                  partNumberMarker: result.data.PartNumberMarker,
                                  nextPartNumberMarker: result.data.NextPartNumberMarker,
                                  maxParts: result.data.MaxParts,
                                  isTruncated: result.data.IsTruncated,
                                  parts: result.data.Part || []
                                });

                              case 12:
                              case 'end':
                                return _context2.stop();
                            }
                          }
                        },
                        _callee2,
                        this
                      );
                    })
                  );

                  function listParts(_x3, _x4, _x5, _x6) {
                    return _listParts.apply(this, arguments);
                  }

                  return listParts;
                })();
                /**
                 * Abort a multipart upload transaction
                 * @param {String} name the object name
                 * @param {String} uploadId the upload id
                 * @param {Object} options
                 */

                proto.abortMultipartUpload = /*#__PURE__*/ (function () {
                  var _abortMultipartUpload = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee3(name, uploadId, options) {
                      var opt, params, result;
                      return _regenerator.default.wrap(
                        function _callee3$(_context3) {
                          while (1) {
                            switch ((_context3.prev = _context3.next)) {
                              case 0:
                                this._stop();

                                options = options || {};
                                opt = {};
                                copy(options).to(opt);
                                opt.subres = {
                                  uploadId: uploadId
                                };
                                params = this._objectRequestParams('DELETE', name, opt);
                                params.successStatuses = [204];
                                _context3.next = 9;
                                return this.request(params);

                              case 9:
                                result = _context3.sent;
                                return _context3.abrupt('return', {
                                  res: result.res
                                });

                              case 11:
                              case 'end':
                                return _context3.stop();
                            }
                          }
                        },
                        _callee3,
                        this
                      );
                    })
                  );

                  function abortMultipartUpload(_x7, _x8, _x9) {
                    return _abortMultipartUpload.apply(this, arguments);
                  }

                  return abortMultipartUpload;
                })();
                /**
                 * Initiate a multipart upload transaction
                 * @param {String} name the object name
                 * @param {Object} options
                 * @return {String} upload id
                 */

                proto.initMultipartUpload = /*#__PURE__*/ (function () {
                  var _initMultipartUpload = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee4(name, options) {
                      var opt, params, result;
                      return _regenerator.default.wrap(
                        function _callee4$(_context4) {
                          while (1) {
                            switch ((_context4.prev = _context4.next)) {
                              case 0:
                                options = options || {};
                                opt = {};
                                copy(options).to(opt);
                                opt.headers = opt.headers || {};

                                this._convertMetaToHeaders(options.meta, opt.headers);

                                opt.subres = 'uploads';
                                params = this._objectRequestParams('POST', name, opt);
                                params.mime = options.mime;
                                params.xmlResponse = true;
                                params.successStatuses = [200];
                                _context4.next = 12;
                                return this.request(params);

                              case 12:
                                result = _context4.sent;
                                return _context4.abrupt('return', {
                                  res: result.res,
                                  bucket: result.data.Bucket,
                                  name: result.data.Key,
                                  uploadId: result.data.UploadId
                                });

                              case 14:
                              case 'end':
                                return _context4.stop();
                            }
                          }
                        },
                        _callee4,
                        this
                      );
                    })
                  );

                  function initMultipartUpload(_x10, _x11) {
                    return _initMultipartUpload.apply(this, arguments);
                  }

                  return initMultipartUpload;
                })();
                /**
                 * Upload a part in a multipart upload transaction
                 * @param {String} name the object name
                 * @param {String} uploadId the upload id
                 * @param {Integer} partNo the part number
                 * @param {File} file upload File, whole File
                 * @param {Integer} start  part start bytes  e.g: 102400
                 * @param {Integer} end  part end bytes  e.g: 204800
                 * @param {Object} options
                 */

                proto.uploadPart = /*#__PURE__*/ (function () {
                  var _uploadPart2 = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(
                      function _callee5(name, uploadId, partNo, file, start, end, options) {
                        var data, isBrowserEnv;
                        return _regenerator.default.wrap(
                          function _callee5$(_context5) {
                            while (1) {
                              switch ((_context5.prev = _context5.next)) {
                                case 0:
                                  data = {
                                    size: end - start
                                  };
                                  isBrowserEnv = process && process.browser;

                                  if (!isBrowserEnv) {
                                    _context5.next = 8;
                                    break;
                                  }

                                  _context5.next = 5;
                                  return this._createBuffer(file, start, end);

                                case 5:
                                  data.content = _context5.sent;
                                  _context5.next = 11;
                                  break;

                                case 8:
                                  _context5.next = 10;
                                  return this._createStream(file, start, end);

                                case 10:
                                  data.stream = _context5.sent;

                                case 11:
                                  _context5.next = 13;
                                  return this._uploadPart(name, uploadId, partNo, data, options);

                                case 13:
                                  return _context5.abrupt('return', _context5.sent);

                                case 14:
                                case 'end':
                                  return _context5.stop();
                              }
                            }
                          },
                          _callee5,
                          this
                        );
                      }
                    )
                  );

                  function uploadPart(_x12, _x13, _x14, _x15, _x16, _x17, _x18) {
                    return _uploadPart2.apply(this, arguments);
                  }

                  return uploadPart;
                })();
                /**
                 * Complete a multipart upload transaction
                 * @param {String} name the object name
                 * @param {String} uploadId the upload id
                 * @param {Array} parts the uploaded parts, each in the structure:
                 *        {Integer} number partNo
                 *        {String} etag  part etag  uploadPartCopy result.res.header.etag
                 * @param {Object} options
                 *         {Object} options.callback The callback parameter is composed of a JSON string encoded in Base64
                 *         {String} options.callback.url  the OSS sends a callback request to this URL
                 *         {String} options.callback.host  The host header value for initiating callback requests
                 *         {String} options.callback.body  The value of the request body when a callback is initiated
                 *         {String} options.callback.contentType  The Content-Type of the callback requests initiatiated
                 *         {Object} options.callback.customValue  Custom parameters are a map of key-values, e.g:
                 *                   customValue = {
                 *                     key1: 'value1',
                 *                     key2: 'value2'
                 *                   }
                 */

                proto.completeMultipartUpload = /*#__PURE__*/ (function () {
                  var _completeMultipartUpload = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee6(name, uploadId, parts, options) {
                      var completeParts, xml, i, p, opt, params, result, ret;
                      return _regenerator.default.wrap(
                        function _callee6$(_context6) {
                          while (1) {
                            switch ((_context6.prev = _context6.next)) {
                              case 0:
                                completeParts = parts
                                  .concat()
                                  .sort(function (a, b) {
                                    return a.number - b.number;
                                  })
                                  .filter(function (item, index, arr) {
                                    return !index || item.number !== arr[index - 1].number;
                                  });
                                xml = '<?xml version="1.0" encoding="UTF-8"?>\n<CompleteMultipartUpload>\n';

                                for (i = 0; i < completeParts.length; i++) {
                                  p = completeParts[i];
                                  xml += '<Part>\n';
                                  xml += '<PartNumber>'.concat(p.number, '</PartNumber>\n');
                                  xml += '<ETag>'.concat(p.etag, '</ETag>\n');
                                  xml += '</Part>\n';
                                }

                                xml += '</CompleteMultipartUpload>';
                                options = options || {};
                                opt = {};
                                opt = deepCopyWith(options, function (_) {
                                  if (isBuffer(_)) return null;
                                });
                                opt.subres = {
                                  uploadId: uploadId
                                };
                                opt.headers = omit(opt.headers, [
                                  'x-oss-server-side-encryption',
                                  'x-oss-storage-class'
                                ]);
                                params = this._objectRequestParams('POST', name, opt);
                                callback.encodeCallback(params, opt);
                                params.mime = 'xml';
                                params.content = xml;

                                if (!(params.headers && params.headers['x-oss-callback'])) {
                                  params.xmlResponse = true;
                                }

                                params.successStatuses = [200];
                                _context6.next = 17;
                                return this.request(params);

                              case 17:
                                result = _context6.sent;

                                if (!options.progress) {
                                  _context6.next = 21;
                                  break;
                                }

                                _context6.next = 21;
                                return options.progress(1, null, result.res);

                              case 21:
                                ret = {
                                  res: result.res,
                                  bucket: params.bucket,
                                  name: name,
                                  etag: result.res.headers.etag
                                };

                                if (params.headers && params.headers['x-oss-callback']) {
                                  ret.data = JSON.parse(result.data.toString());
                                }

                                return _context6.abrupt('return', ret);

                              case 24:
                              case 'end':
                                return _context6.stop();
                            }
                          }
                        },
                        _callee6,
                        this
                      );
                    })
                  );

                  function completeMultipartUpload(_x19, _x20, _x21, _x22) {
                    return _completeMultipartUpload.apply(this, arguments);
                  }

                  return completeMultipartUpload;
                })();
                /**
                 * Upload a part in a multipart upload transaction
                 * @param {String} name the object name
                 * @param {String} uploadId the upload id
                 * @param {Integer} partNo the part number
                 * @param {Object} data the body data
                 * @param {Object} options
                 */

                proto._uploadPart = /*#__PURE__*/ (function () {
                  var _uploadPart3 = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee7(name, uploadId, partNo, data, options) {
                      var opt, params, isBrowserEnv, result;
                      return _regenerator.default.wrap(
                        function _callee7$(_context7) {
                          while (1) {
                            switch ((_context7.prev = _context7.next)) {
                              case 0:
                                options = options || {};
                                opt = {};
                                copy(options).to(opt);
                                opt.headers = opt.headers || {};
                                opt.headers = _objectSpread(
                                  _objectSpread({}, opt.headers),
                                  {},
                                  {
                                    'Content-Length': data.size
                                  }
                                ); // Uploading shards does not require x-oss server side encryption

                                opt.headers = omit(opt.headers, ['x-oss-server-side-encryption']);
                                opt.subres = {
                                  partNumber: partNo,
                                  uploadId: uploadId
                                };
                                params = this._objectRequestParams('PUT', name, opt);
                                params.mime = opt.mime;
                                isBrowserEnv = process && process.browser;
                                isBrowserEnv ? (params.content = data.content) : (params.stream = data.stream);
                                params.successStatuses = [200];
                                params.disabledMD5 = options.disabledMD5;
                                _context7.next = 15;
                                return this.request(params);

                              case 15:
                                result = _context7.sent;

                                if (result.res.headers.etag) {
                                  _context7.next = 18;
                                  break;
                                }

                                throw new Error(
                                  'Please set the etag of expose-headers in OSS \n https://help.aliyun.com/document_detail/32069.html'
                                );

                              case 18:
                                if (data.stream) {
                                  data.stream = null;
                                  params.stream = null;
                                }

                                return _context7.abrupt('return', {
                                  name: name,
                                  etag: result.res.headers.etag,
                                  res: result.res
                                });

                              case 20:
                              case 'end':
                                return _context7.stop();
                            }
                          }
                        },
                        _callee7,
                        this
                      );
                    })
                  );

                  function _uploadPart(_x23, _x24, _x25, _x26, _x27) {
                    return _uploadPart3.apply(this, arguments);
                  }

                  return _uploadPart;
                })();
              }).call(this);
            }).call(this, require('_process'));
          },
          {
            './callback': 24,
            './utils/deepCopy': 57,
            './utils/isBuffer': 64,
            './utils/omit': 71,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/defineProperty': 76,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            _process: 441,
            'copy-to': 91,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.filter.js': 271,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.array.sort.js': 279,
            'core-js/modules/es.object.get-own-property-descriptor.js': 286,
            'core-js/modules/es.object.get-own-property-descriptors.js': 287,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.symbol.js': 312,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        31: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var urlutil = require('url');

            var utility = require('utility');

            var copy = require('copy-to');

            var signHelper = require('../../common/signUtils');

            var _require = require('../utils/isIP'),
              isIP = _require.isIP;

            var _require2 = require('../utils/setSTSToken'),
              setSTSToken = _require2.setSTSToken;

            var _require3 = require('../utils/isFunction'),
              isFunction = _require3.isFunction;

            var proto = exports;

            proto.asyncSignatureUrl = /*#__PURE__*/ (function () {
              var _asyncSignatureUrl = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var expires, params, resource, signRes, url;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            if (!isIP(this.options.endpoint.hostname)) {
                              _context.next = 2;
                              break;
                            }

                            throw new Error('can not get the object URL when endpoint is IP');

                          case 2:
                            options = options || {};
                            name = this._objectName(name);
                            options.method = options.method || 'GET';
                            expires = utility.timestamp() + (options.expires || 1800);
                            params = {
                              bucket: this.options.bucket,
                              object: name
                            };
                            resource = this._getResource(params);

                            if (!(this.options.stsToken && isFunction(this.options.refreshSTSToken))) {
                              _context.next = 11;
                              break;
                            }

                            _context.next = 11;
                            return setSTSToken.call(this);

                          case 11:
                            if (this.options.stsToken) {
                              options['security-token'] = this.options.stsToken;
                            }

                            signRes = signHelper._signatureForURL(
                              this.options.accessKeySecret,
                              options,
                              resource,
                              expires
                            );
                            url = urlutil.parse(this._getReqUrl(params));
                            url.query = {
                              OSSAccessKeyId: this.options.accessKeyId,
                              Expires: expires,
                              Signature: signRes.Signature
                            };
                            copy(signRes.subResource).to(url.query);
                            return _context.abrupt('return', url.format());

                          case 17:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function asyncSignatureUrl(_x, _x2) {
                return _asyncSignatureUrl.apply(this, arguments);
              }

              return asyncSignatureUrl;
            })();
          },
          {
            '../../common/signUtils': 50,
            '../utils/isFunction': 66,
            '../utils/isIP': 67,
            '../utils/setSTSToken': 74,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'copy-to': 91,
            url: 446,
            utility: 448
          }
        ],
        32: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.array.find.js');

            require('core-js/modules/es.array.includes.js');

            require('core-js/modules/es.array.concat.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            var _typeof2 = _interopRequireDefault(require('@babel/runtime/helpers/typeof'));

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/checkBucketName'),
              _checkBucketName = _require.checkBucketName;

            var proto = exports;
            var REPLACE_HEDERS = [
              'content-type',
              'content-encoding',
              'content-language',
              'content-disposition',
              'cache-control',
              'expires'
            ];

            proto.copy = /*#__PURE__*/ (function () {
              var _copy = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, sourceName, bucketName, options) {
                  var params, result, data;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            if ((0, _typeof2.default)(bucketName) === 'object') {
                              options = bucketName; // 兼容旧版本，旧版本第三个参数为options
                            }

                            options = options || {};
                            options.headers = options.headers || {};
                            Object.keys(options.headers).forEach(function (key) {
                              options.headers['x-oss-copy-source-'.concat(key.toLowerCase())] = options.headers[key];
                            });

                            if (
                              options.meta ||
                              Object.keys(options.headers).find(function (_) {
                                return REPLACE_HEDERS.includes(_.toLowerCase());
                              })
                            ) {
                              options.headers['x-oss-metadata-directive'] = 'REPLACE';
                            }

                            this._convertMetaToHeaders(options.meta, options.headers);

                            sourceName = this._getSourceName(sourceName, bucketName);

                            if (options.versionId) {
                              sourceName = ''.concat(sourceName, '?versionId=').concat(options.versionId);
                            }

                            options.headers['x-oss-copy-source'] = sourceName;
                            params = this._objectRequestParams('PUT', name, options);
                            params.xmlResponse = true;
                            params.successStatuses = [200, 304];
                            _context.next = 14;
                            return this.request(params);

                          case 14:
                            result = _context.sent;
                            data = result.data;

                            if (data) {
                              data = {
                                etag: data.ETag,
                                lastModified: data.LastModified
                              };
                            }

                            return _context.abrupt('return', {
                              data: data,
                              res: result.res
                            });

                          case 18:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function copy(_x, _x2, _x3, _x4) {
                return _copy.apply(this, arguments);
              }

              return copy;
            })(); // todo delete

            proto._getSourceName = function _getSourceName(sourceName, bucketName) {
              if (typeof bucketName === 'string') {
                sourceName = this._objectName(sourceName);
              } else if (sourceName[0] !== '/') {
                bucketName = this.options.bucket;
              } else {
                bucketName = sourceName.replace(/\/(.+?)(\/.*)/, '$1');
                sourceName = sourceName.replace(/(\/.+?\/)(.*)/, '$2');
              }

              _checkBucketName(bucketName);

              sourceName = encodeURIComponent(sourceName);
              sourceName = '/'.concat(bucketName, '/').concat(sourceName);
              return sourceName;
            };
          },
          {
            '../utils/checkBucketName': 51,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/helpers/typeof': 78,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.find.js': 272,
            'core-js/modules/es.array.includes.js': 274,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        33: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /**
             * delete
             * @param {String} name - object name
             * @param {Object} options
             * @param {{res}}
             */

            proto.delete = /*#__PURE__*/ (function () {
              var _delete2 = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var options,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options.subres = Object.assign({}, options.subres);

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            params = this._objectRequestParams('DELETE', name, options);
                            params.successStatuses = [204];
                            _context.next = 7;
                            return this.request(params);

                          case 7:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 9:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function _delete(_x) {
                return _delete2.apply(this, arguments);
              }

              return _delete;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        34: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            /* eslint-disable object-curly-newline */
            var utility = require('utility');

            var _require = require('../utils/obj2xml'),
              obj2xml = _require.obj2xml;

            var proto = exports;

            proto.deleteMulti = /*#__PURE__*/ (function () {
              var _deleteMulti = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(names) {
                  var options,
                    objects,
                    i,
                    object,
                    _names$i,
                    key,
                    versionId,
                    paramXMLObj,
                    paramXML,
                    params,
                    result,
                    r,
                    deleted,
                    _args = arguments;

                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            objects = [];

                            if (!(!names || !names.length)) {
                              _context.next = 4;
                              break;
                            }

                            throw new Error('names is required');

                          case 4:
                            for (i = 0; i < names.length; i++) {
                              object = {};

                              if (typeof names[i] === 'string') {
                                object.Key = utility.escape(this._objectName(names[i]));
                              } else {
                                (_names$i = names[i]), (key = _names$i.key), (versionId = _names$i.versionId);
                                object.Key = utility.escape(this._objectName(key));
                                object.VersionId = versionId;
                              }

                              objects.push(object);
                            }

                            paramXMLObj = {
                              Delete: {
                                Quiet: !!options.quiet,
                                Object: objects
                              }
                            };
                            paramXML = obj2xml(paramXMLObj, {
                              headers: true
                            });
                            options.subres = Object.assign(
                              {
                                delete: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            params = this._objectRequestParams('POST', '', options);
                            params.mime = 'xml';
                            params.content = paramXML;
                            params.xmlResponse = true;
                            params.successStatuses = [200];
                            _context.next = 16;
                            return this.request(params);

                          case 16:
                            result = _context.sent;
                            r = result.data;
                            deleted = (r && r.Deleted) || null;

                            if (deleted) {
                              if (!Array.isArray(deleted)) {
                                deleted = [deleted];
                              }
                            }

                            return _context.abrupt('return', {
                              res: result.res,
                              deleted: deleted || []
                            });

                          case 21:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function deleteMulti(_x) {
                return _deleteMulti.apply(this, arguments);
              }

              return deleteMulti;
            })();
          },
          {
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284,
            utility: 448
          }
        ],
        35: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /**
             * deleteObjectTagging
             * @param {String} name - object name
             * @param {Object} options
             */

            proto.deleteObjectTagging = /*#__PURE__*/ (function () {
              var _deleteObjectTagging = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var options,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options.subres = Object.assign(
                              {
                                tagging: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            name = this._objectName(name);
                            params = this._objectRequestParams('DELETE', name, options);
                            params.successStatuses = [204];
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              status: result.status,
                              res: result.res
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function deleteObjectTagging(_x) {
                return _deleteObjectTagging.apply(this, arguments);
              }

              return deleteObjectTagging;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        36: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.array.concat.js');

            var urlutil = require('url');

            var _require = require('../utils/isIP'),
              isIP = _require.isIP;

            var proto = exports;
            /**
             * Get Object url by name
             * @param {String} name - object name
             * @param {String} [baseUrl] - If provide `baseUrl`, will use `baseUrl` instead the default `endpoint and bucket`.
             * @return {String} object url include bucket
             */

            proto.generateObjectUrl = function generateObjectUrl(name, baseUrl) {
              if (isIP(this.options.endpoint.hostname)) {
                throw new Error('can not get the object URL when endpoint is IP');
              }

              if (!baseUrl) {
                baseUrl = this.options.endpoint.format();
                var copyUrl = urlutil.parse(baseUrl);
                var bucket = this.options.bucket;
                copyUrl.hostname = ''.concat(bucket, '.').concat(copyUrl.hostname);
                copyUrl.host = ''.concat(bucket, '.').concat(copyUrl.host);
                baseUrl = copyUrl.format();
              } else if (baseUrl[baseUrl.length - 1] !== '/') {
                baseUrl += '/';
              }

              return baseUrl + this._escape(this._objectName(name));
            };
          },
          { '../utils/isIP': 67, 'core-js/modules/es.array.concat.js': 269, url: 446 }
        ],
        37: [
          function (require, module, exports) {
            (function (process) {
              (function () {
                'use strict';

                var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

                var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

                require('core-js/modules/es.object.assign.js');

                var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

                var fs = require('fs');

                var is = require('is-type-of');

                var proto = exports;
                /**
                 * get
                 * @param {String} name - object name
                 * @param {String | Stream} file
                 * @param {Object} options
                 * @param {{res}}
                 */

                proto.get = /*#__PURE__*/ (function () {
                  var _get = (0, _asyncToGenerator2.default)(
                    /*#__PURE__*/ _regenerator.default.mark(function _callee(name, file) {
                      var options,
                        writeStream,
                        needDestroy,
                        isBrowserEnv,
                        responseCacheControl,
                        defaultSubresOptions,
                        result,
                        params,
                        _args = arguments;
                      return _regenerator.default.wrap(
                        function _callee$(_context) {
                          while (1) {
                            switch ((_context.prev = _context.next)) {
                              case 0:
                                options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
                                writeStream = null;
                                needDestroy = false;

                                if (is.writableStream(file)) {
                                  writeStream = file;
                                } else if (is.string(file)) {
                                  writeStream = fs.createWriteStream(file);
                                  needDestroy = true;
                                } else {
                                  // get(name, options)
                                  options = file;
                                }

                                options = options || {};
                                isBrowserEnv = process && process.browser;
                                responseCacheControl = options.responseCacheControl === null ? '' : 'no-cache';
                                defaultSubresOptions =
                                  isBrowserEnv && responseCacheControl
                                    ? {
                                        'response-cache-control': responseCacheControl
                                      }
                                    : {};
                                options.subres = Object.assign(defaultSubresOptions, options.subres);

                                if (options.versionId) {
                                  options.subres.versionId = options.versionId;
                                }

                                if (options.process) {
                                  options.subres['x-oss-process'] = options.process;
                                }

                                _context.prev = 11;
                                params = this._objectRequestParams('GET', name, options);
                                params.writeStream = writeStream;
                                params.successStatuses = [200, 206, 304];
                                _context.next = 17;
                                return this.request(params);

                              case 17:
                                result = _context.sent;

                                if (needDestroy) {
                                  writeStream.destroy();
                                }

                                _context.next = 28;
                                break;

                              case 21:
                                _context.prev = 21;
                                _context.t0 = _context['catch'](11);

                                if (!needDestroy) {
                                  _context.next = 27;
                                  break;
                                }

                                writeStream.destroy(); // should delete the exists file before throw error

                                _context.next = 27;
                                return this._deleteFileSafe(file);

                              case 27:
                                throw _context.t0;

                              case 28:
                                return _context.abrupt('return', {
                                  res: result.res,
                                  content: result.data
                                });

                              case 29:
                              case 'end':
                                return _context.stop();
                            }
                          }
                        },
                        _callee,
                        this,
                        [[11, 21]]
                      );
                    })
                  );

                  function get(_x, _x2) {
                    return _get.apply(this, arguments);
                  }

                  return get;
                })();
              }).call(this);
            }).call(this, require('_process'));
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            _process: 441,
            'core-js/modules/es.object.assign.js': 284,
            fs: 87,
            'is-type-of': 440
          }
        ],
        38: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /*
             * Get object's ACL
             * @param {String} name the object key
             * @param {Object} options
             * @return {Object}
             */

            proto.getACL = /*#__PURE__*/ (function () {
              var _getACL = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var options,
                    params,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options.subres = Object.assign(
                              {
                                acl: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            name = this._objectName(name);
                            params = this._objectRequestParams('GET', name, options);
                            params.successStatuses = [200];
                            params.xmlResponse = true;
                            _context.next = 9;
                            return this.request(params);

                          case 9:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              acl: result.data.AccessControlList.Grant,
                              owner: {
                                id: result.data.Owner.ID,
                                displayName: result.data.Owner.DisplayName
                              },
                              res: result.res
                            });

                          case 11:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getACL(_x) {
                return _getACL.apply(this, arguments);
              }

              return getACL;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        39: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.array.map.js');

            require('core-js/modules/es.number.constructor.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            /* eslint-disable no-use-before-define */
            var proto = exports;

            var _require = require('../utils/isObject'),
              isObject = _require.isObject;

            var _require2 = require('../utils/isArray'),
              isArray = _require2.isArray;

            proto.getBucketVersions = getBucketVersions;
            proto.listObjectVersions = getBucketVersions;

            function getBucketVersions() {
              return _getBucketVersions.apply(this, arguments);
            }

            function _getBucketVersions() {
              _getBucketVersions = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee() {
                  var query,
                    options,
                    params,
                    result,
                    objects,
                    deleteMarker,
                    that,
                    prefixes,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            query = _args.length > 0 && _args[0] !== undefined ? _args[0] : {};
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};

                            if (!(query.versionIdMarker && query.keyMarker === undefined)) {
                              _context.next = 4;
                              break;
                            }

                            throw new Error('A version-id marker cannot be specified without a key marker');

                          case 4:
                            options.subres = Object.assign(
                              {
                                versions: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            params = this._objectRequestParams('GET', '', options);
                            params.xmlResponse = true;
                            params.successStatuses = [200];
                            params.query = formatQuery(query);
                            _context.next = 12;
                            return this.request(params);

                          case 12:
                            result = _context.sent;
                            objects = result.data.Version || [];
                            deleteMarker = result.data.DeleteMarker || [];
                            that = this;

                            if (objects) {
                              if (!Array.isArray(objects)) {
                                objects = [objects];
                              }

                              objects = objects.map(function (obj) {
                                return {
                                  name: obj.Key,
                                  url: that._objectUrl(obj.Key),
                                  lastModified: obj.LastModified,
                                  isLatest: obj.IsLatest === 'true',
                                  versionId: obj.VersionId,
                                  etag: obj.ETag,
                                  type: obj.Type,
                                  size: Number(obj.Size),
                                  storageClass: obj.StorageClass,
                                  owner: {
                                    id: obj.Owner.ID,
                                    displayName: obj.Owner.DisplayName
                                  }
                                };
                              });
                            }

                            if (deleteMarker) {
                              if (!isArray(deleteMarker)) {
                                deleteMarker = [deleteMarker];
                              }

                              deleteMarker = deleteMarker.map(function (obj) {
                                return {
                                  name: obj.Key,
                                  lastModified: obj.LastModified,
                                  versionId: obj.VersionId,
                                  owner: {
                                    id: obj.Owner.ID,
                                    displayName: obj.Owner.DisplayName
                                  }
                                };
                              });
                            }

                            prefixes = result.data.CommonPrefixes || null;

                            if (prefixes) {
                              if (!isArray(prefixes)) {
                                prefixes = [prefixes];
                              }

                              prefixes = prefixes.map(function (item) {
                                return item.Prefix;
                              });
                            }

                            return _context.abrupt('return', {
                              res: result.res,
                              objects: objects,
                              deleteMarker: deleteMarker,
                              prefixes: prefixes,
                              // attirbute of legacy error
                              nextMarker: result.data.NextKeyMarker || null,
                              // attirbute of legacy error
                              NextVersionIdMarker: result.data.NextVersionIdMarker || null,
                              nextKeyMarker: result.data.NextKeyMarker || null,
                              nextVersionIdMarker: result.data.NextVersionIdMarker || null,
                              isTruncated: result.data.IsTruncated === 'true'
                            });

                          case 21:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _getBucketVersions.apply(this, arguments);
            }

            function camel2Line(name) {
              return name.replace(/([A-Z])/g, '-$1').toLowerCase();
            }

            function formatQuery() {
              var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
              var obj = {};

              if (isObject(query)) {
                Object.keys(query).forEach(function (key) {
                  obj[camel2Line(key)] = query[key];
                });
              }

              return obj;
            }
          },
          {
            '../utils/isArray': 62,
            '../utils/isObject': 68,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.number.constructor.js': 283,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        40: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /**
             * getObjectMeta
             * @param {String} name - object name
             * @param {Object} options
             * @param {{res}}
             */

            proto.getObjectMeta = /*#__PURE__*/ (function () {
              var _getObjectMeta = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = options || {};
                            name = this._objectName(name);
                            options.subres = Object.assign(
                              {
                                objectMeta: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            params = this._objectRequestParams('HEAD', name, options);
                            params.successStatuses = [200];
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              status: result.status,
                              res: result.res
                            });

                          case 10:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getObjectMeta(_x, _x2) {
                return _getObjectMeta.apply(this, arguments);
              }

              return getObjectMeta;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        41: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;

            var _require = require('../utils/isObject'),
              isObject = _require.isObject;
            /**
             * getObjectTagging
             * @param {String} name - object name
             * @param {Object} options
             * @return {Object}
             */

            proto.getObjectTagging = /*#__PURE__*/ (function () {
              var _getObjectTagging = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var options,
                    params,
                    result,
                    Tagging,
                    Tag,
                    tag,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options.subres = Object.assign(
                              {
                                tagging: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            name = this._objectName(name);
                            params = this._objectRequestParams('GET', name, options);
                            params.successStatuses = [200];
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            _context.next = 11;
                            return this.parseXML(result.data);

                          case 11:
                            Tagging = _context.sent;
                            Tag = Tagging.TagSet.Tag;
                            Tag = Tag && isObject(Tag) ? [Tag] : Tag || [];
                            tag = {};
                            Tag.forEach(function (item) {
                              tag[item.Key] = item.Value;
                            });
                            return _context.abrupt('return', {
                              status: result.status,
                              res: result.res,
                              tag: tag
                            });

                          case 17:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getObjectTagging(_x) {
                return _getObjectTagging.apply(this, arguments);
              }

              return getObjectTagging;
            })();
          },
          {
            '../utils/isObject': 68,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        42: [
          function (require, module, exports) {
            'use strict';

            var _require = require('../utils/isIP'),
              isIP = _require.isIP;

            var proto = exports;
            /**
             * Get Object url by name
             * @param {String} name - object name
             * @param {String} [baseUrl] - If provide `baseUrl`,
             *        will use `baseUrl` instead the default `endpoint`.
             * @return {String} object url
             */

            proto.getObjectUrl = function getObjectUrl(name, baseUrl) {
              if (isIP(this.options.endpoint.hostname)) {
                throw new Error('can not get the object URL when endpoint is IP');
              }

              if (!baseUrl) {
                baseUrl = this.options.endpoint.format();
              } else if (baseUrl[baseUrl.length - 1] !== '/') {
                baseUrl += '/';
              }

              return baseUrl + this._escape(this._objectName(name));
            };
          },
          { '../utils/isIP': 67 }
        ],
        43: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /**
             * getSymlink
             * @param {String} name - object name
             * @param {Object} options
             * @param {{res}}
             */

            proto.getSymlink = /*#__PURE__*/ (function () {
              var _getSymlink = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var options,
                    params,
                    result,
                    target,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options.subres = Object.assign(
                              {
                                symlink: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            name = this._objectName(name);
                            params = this._objectRequestParams('GET', name, options);
                            params.successStatuses = [200];
                            _context.next = 8;
                            return this.request(params);

                          case 8:
                            result = _context.sent;
                            target = result.res.headers['x-oss-symlink-target'];
                            return _context.abrupt('return', {
                              targetName: decodeURIComponent(target),
                              res: result.res
                            });

                          case 11:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function getSymlink(_x) {
                return _getSymlink.apply(this, arguments);
              }

              return getSymlink;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        44: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /**
             * head
             * @param {String} name - object name
             * @param {Object} options
             * @param {{res}}
             */

            proto.head = /*#__PURE__*/ (function () {
              var _head = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name) {
                  var options,
                    params,
                    result,
                    data,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
                            options.subres = Object.assign({}, options.subres);

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            params = this._objectRequestParams('HEAD', name, options);
                            params.successStatuses = [200, 304];
                            _context.next = 7;
                            return this.request(params);

                          case 7:
                            result = _context.sent;
                            data = {
                              meta: null,
                              res: result.res,
                              status: result.status
                            };

                            if (result.status === 200) {
                              Object.keys(result.headers).forEach(function (k) {
                                if (k.indexOf('x-oss-meta-') === 0) {
                                  if (!data.meta) {
                                    data.meta = {};
                                  }

                                  data.meta[k.substring(11)] = result.headers[k];
                                }
                              });
                            }

                            return _context.abrupt('return', data);

                          case 11:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function head(_x) {
                return _head.apply(this, arguments);
              }

              return head;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        45: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /*
             * Set object's ACL
             * @param {String} name the object key
             * @param {String} acl the object ACL
             * @param {Object} options
             */

            proto.putACL = /*#__PURE__*/ (function () {
              var _putACL = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, acl, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = options || {};
                            options.subres = Object.assign(
                              {
                                acl: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            options.headers = options.headers || {};
                            options.headers['x-oss-object-acl'] = acl;
                            name = this._objectName(name);
                            params = this._objectRequestParams('PUT', name, options);
                            params.successStatuses = [200];
                            _context.next = 10;
                            return this.request(params);

                          case 10:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 12:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function putACL(_x, _x2, _x3) {
                return _putACL.apply(this, arguments);
              }

              return putACL;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        46: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            require('core-js/modules/es.array.map.js');

            require('core-js/modules/es.object.keys.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('../utils/obj2xml'),
              obj2xml = _require.obj2xml;

            var _require2 = require('../utils/checkObjectTag'),
              checkObjectTag = _require2.checkObjectTag;

            var proto = exports;
            /**
             * putObjectTagging
             * @param {String} name - object name
             * @param {Object} tag -  object tag, eg: `{a: "1", b: "2"}`
             * @param {Object} options
             */

            proto.putObjectTagging = /*#__PURE__*/ (function () {
              var _putObjectTagging = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, tag) {
                  var options,
                    params,
                    paramXMLObj,
                    result,
                    _args = arguments;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = _args.length > 2 && _args[2] !== undefined ? _args[2] : {};
                            checkObjectTag(tag);
                            options.subres = Object.assign(
                              {
                                tagging: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            name = this._objectName(name);
                            params = this._objectRequestParams('PUT', name, options);
                            params.successStatuses = [200];
                            tag = Object.keys(tag).map(function (key) {
                              return {
                                Key: key,
                                Value: tag[key]
                              };
                            });
                            paramXMLObj = {
                              Tagging: {
                                TagSet: {
                                  Tag: tag
                                }
                              }
                            };
                            params.mime = 'xml';
                            params.content = obj2xml(paramXMLObj);
                            _context.next = 13;
                            return this.request(params);

                          case 13:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res,
                              status: result.status
                            });

                          case 15:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function putObjectTagging(_x, _x2) {
                return _putObjectTagging.apply(this, arguments);
              }

              return putObjectTagging;
            })();
          },
          {
            '../utils/checkObjectTag': 53,
            '../utils/obj2xml': 70,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.keys.js': 289
          }
        ],
        47: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var proto = exports;
            /**
             * putSymlink
             * @param {String} name - object name
             * @param {String} targetName - target name
             * @param {Object} options
             * @param {{res}}
             */

            proto.putSymlink = /*#__PURE__*/ (function () {
              var _putSymlink = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(name, targetName, options) {
                  var params, result;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            options = options || {};
                            options.headers = options.headers || {};
                            targetName = this._escape(this._objectName(targetName));

                            this._convertMetaToHeaders(options.meta, options.headers);

                            options.headers['x-oss-symlink-target'] = targetName;
                            options.subres = Object.assign(
                              {
                                symlink: ''
                              },
                              options.subres
                            );

                            if (options.versionId) {
                              options.subres.versionId = options.versionId;
                            }

                            if (options.storageClass) {
                              options.headers['x-oss-storage-class'] = options.storageClass;
                            }

                            name = this._objectName(name);
                            params = this._objectRequestParams('PUT', name, options);
                            params.successStatuses = [200];
                            _context.next = 13;
                            return this.request(params);

                          case 13:
                            result = _context.sent;
                            return _context.abrupt('return', {
                              res: result.res
                            });

                          case 15:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );

              function putSymlink(_x, _x2, _x3) {
                return _putSymlink.apply(this, arguments);
              }

              return putSymlink;
            })();
          },
          {
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.object.assign.js': 284
          }
        ],
        48: [
          function (require, module, exports) {
            'use strict';

            var urlutil = require('url');

            var utility = require('utility');

            var copy = require('copy-to');

            var signHelper = require('../../common/signUtils');

            var _require = require('../utils/isIP'),
              isIP = _require.isIP;

            var proto = exports;
            /**
             *  signatureUrl
             * @deprecated will be deprecated in 7.x
             * @param {String} name object name
             * @param {Object} options  options
             */

            proto.signatureUrl = function signatureUrl(name, options) {
              if (isIP(this.options.endpoint.hostname)) {
                throw new Error('can not get the object URL when endpoint is IP');
              }

              options = options || {};
              name = this._objectName(name);
              options.method = options.method || 'GET';
              var expires = utility.timestamp() + (options.expires || 1800);
              var params = {
                bucket: this.options.bucket,
                object: name
              };

              var resource = this._getResource(params);

              if (this.options.stsToken) {
                options['security-token'] = this.options.stsToken;
              }

              var signRes = signHelper._signatureForURL(this.options.accessKeySecret, options, resource, expires);

              var url = urlutil.parse(this._getReqUrl(params));
              url.query = {
                OSSAccessKeyId: this.options.accessKeyId,
                Expires: expires,
                Signature: signRes.Signature
              };
              copy(signRes.subResource).to(url.query);
              return url.format();
            };
          },
          { '../../common/signUtils': 50, '../utils/isIP': 67, 'copy-to': 91, url: 446, utility: 448 }
        ],
        49: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.array.iterator.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/es.promise.js');

            require('core-js/modules/es.string.iterator.js');

            require('core-js/modules/web.dom-collections.iterator.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.function.name.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            var _require = require('./utils/isArray'),
              isArray = _require.isArray;

            var proto = exports;

            proto._parallelNode = /*#__PURE__*/ (function () {
              var _parallelNode2 = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee(todo, parallel, fn, sourceData) {
                  var that, jobErr, jobs, tempBatch, remainder, batch, taskIndex, i;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            that = this; // upload in parallel

                            jobErr = [];
                            jobs = [];
                            tempBatch = todo.length / parallel;
                            remainder = todo.length % parallel;
                            batch = remainder === 0 ? tempBatch : (todo.length - remainder) / parallel + 1;
                            taskIndex = 1;
                            i = 0;

                          case 8:
                            if (!(i < todo.length)) {
                              _context.next = 26;
                              break;
                            }

                            if (!that.isCancel()) {
                              _context.next = 11;
                              break;
                            }

                            return _context.abrupt('break', 26);

                          case 11:
                            if (sourceData) {
                              jobs.push(fn(that, todo[i], sourceData));
                            } else {
                              jobs.push(fn(that, todo[i]));
                            }

                            if (!(jobs.length === parallel || (taskIndex === batch && i === todo.length - 1))) {
                              _context.next = 23;
                              break;
                            }

                            _context.prev = 13;
                            taskIndex += 1;
                            /* eslint no-await-in-loop: [0] */

                            _context.next = 17;
                            return Promise.all(jobs);

                          case 17:
                            _context.next = 22;
                            break;

                          case 19:
                            _context.prev = 19;
                            _context.t0 = _context['catch'](13);
                            jobErr.push(_context.t0);

                          case 22:
                            jobs = [];

                          case 23:
                            i++;
                            _context.next = 8;
                            break;

                          case 26:
                            return _context.abrupt('return', jobErr);

                          case 27:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this,
                    [[13, 19]]
                  );
                })
              );

              function _parallelNode(_x, _x2, _x3, _x4) {
                return _parallelNode2.apply(this, arguments);
              }

              return _parallelNode;
            })();

            proto._parallel = function _parallel(todo, parallel, jobPromise) {
              var that = this;
              return new Promise(function (resolve) {
                var _jobErr = [];

                if (parallel <= 0 || !todo) {
                  resolve(_jobErr);
                  return;
                }

                function onlyOnce(fn) {
                  return function () {
                    if (fn === null) throw new Error('Callback was already called.');
                    var callFn = fn;
                    fn = null;

                    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                      args[_key] = arguments[_key];
                    }

                    callFn.apply(this, args);
                  };
                }

                function createArrayIterator(coll) {
                  var i = -1;
                  var len = coll.length;
                  return function next() {
                    return ++i < len && !that.isCancel()
                      ? {
                          value: coll[i],
                          key: i
                        }
                      : null;
                  };
                }

                var nextElem = createArrayIterator(todo);
                var done = false;
                var running = 0;
                var looping = false;

                function iterateeCallback(err) {
                  running -= 1;

                  if (err) {
                    done = true;

                    _jobErr.push(err);

                    resolve(_jobErr);
                  } else if (done && running <= 0) {
                    done = true;
                    resolve(_jobErr);
                  } else if (!looping) {
                    /* eslint no-use-before-define: [0] */
                    if (that.isCancel()) {
                      resolve(_jobErr);
                    } else {
                      replenish();
                    }
                  }
                }

                function iteratee(value, callback) {
                  jobPromise(value)
                    .then(function (result) {
                      callback(null, result);
                    })
                    .catch(function (err) {
                      callback(err);
                    });
                }

                function replenish() {
                  looping = true;

                  while (running < parallel && !done && !that.isCancel()) {
                    var elem = nextElem();

                    if (elem === null || _jobErr.length > 0) {
                      done = true;

                      if (running <= 0) {
                        resolve(_jobErr);
                      }

                      return;
                    }

                    running += 1;
                    iteratee(elem.value, onlyOnce(iterateeCallback));
                  }

                  looping = false;
                }

                replenish();
              });
            };
            /**
             * cancel operation, now can use with multipartUpload
             * @param {Object} abort
             *        {String} anort.name object key
             *        {String} anort.uploadId upload id
             *        {String} anort.options timeout
             */

            proto.cancel = function cancel(abort) {
              this.options.cancelFlag = true;

              if (isArray(this.multipartUploadStreams)) {
                this.multipartUploadStreams.forEach(function (_) {
                  if (_.destroyed === false) {
                    var err = {
                      name: 'cancel',
                      message: 'cancel'
                    };

                    _.destroy(err);
                  }
                });
              }

              this.multipartUploadStreams = [];

              if (abort) {
                this.abortMultipartUpload(abort.name, abort.uploadId, abort.options);
              }
            };

            proto.isCancel = function isCancel() {
              return this.options.cancelFlag;
            };

            proto.resetCancelFlag = function resetCancelFlag() {
              this.options.cancelFlag = false;
            };

            proto._stop = function _stop() {
              this.options.cancelFlag = true;
            }; // cancel is not error , so create an object

            proto._makeCancelEvent = function _makeCancelEvent() {
              var cancelEvent = {
                status: 0,
                name: 'cancel'
              };
              return cancelEvent;
            }; // abort is not error , so create an object

            proto._makeAbortEvent = function _makeAbortEvent() {
              var abortEvent = {
                status: 0,
                name: 'abort',
                message: 'upload task has been abort'
              };
              return abortEvent;
            };
          },
          {
            './utils/isArray': 62,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.iterator.js': 275,
            'core-js/modules/es.function.name.js': 281,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.promise.js': 294,
            'core-js/modules/es.string.iterator.js': 302,
            'core-js/modules/web.dom-collections.for-each.js': 338,
            'core-js/modules/web.dom-collections.iterator.js': 339
          }
        ],
        50: [
          function (require, module, exports) {
            (function (Buffer) {
              (function () {
                'use strict';

                require('core-js/modules/es.string.trim.js');

                require('core-js/modules/es.array.sort.js');

                require('core-js/modules/es.array.join.js');

                require('core-js/modules/es.object.to-string.js');

                require('core-js/modules/web.dom-collections.for-each.js');

                require('core-js/modules/es.object.keys.js');

                require('core-js/modules/es.array.concat.js');

                require('core-js/modules/es.regexp.to-string.js');

                var crypto = require('./../../shims/crypto/crypto.js');

                var is = require('is-type-of');

                var _require = require('./utils/lowercaseKeyHeader'),
                  lowercaseKeyHeader = _require.lowercaseKeyHeader;
                /**
                 *
                 * @param {String} resourcePath
                 * @param {Object} parameters
                 * @return
                 */

                exports.buildCanonicalizedResource = function buildCanonicalizedResource(resourcePath, parameters) {
                  var canonicalizedResource = ''.concat(resourcePath);
                  var separatorString = '?';

                  if (is.string(parameters) && parameters.trim() !== '') {
                    canonicalizedResource += separatorString + parameters;
                  } else if (is.array(parameters)) {
                    parameters.sort();
                    canonicalizedResource += separatorString + parameters.join('&');
                  } else if (parameters) {
                    var compareFunc = function compareFunc(entry1, entry2) {
                      if (entry1[0] > entry2[0]) {
                        return 1;
                      } else if (entry1[0] < entry2[0]) {
                        return -1;
                      }

                      return 0;
                    };

                    var processFunc = function processFunc(key) {
                      canonicalizedResource += separatorString + key;

                      if (parameters[key] || parameters[key] === 0) {
                        canonicalizedResource += '='.concat(parameters[key]);
                      }

                      separatorString = '&';
                    };

                    Object.keys(parameters).sort(compareFunc).forEach(processFunc);
                  }

                  return canonicalizedResource;
                };
                /**
                 * @param {String} method
                 * @param {String} resourcePath
                 * @param {Object} request
                 * @param {String} expires
                 * @return {String} canonicalString
                 */

                exports.buildCanonicalString = function canonicalString(method, resourcePath, request, expires) {
                  request = request || {};
                  var headers = lowercaseKeyHeader(request.headers);
                  var OSS_PREFIX = 'x-oss-';
                  var ossHeaders = [];
                  var headersToSign = {};
                  var signContent = [
                    method.toUpperCase(),
                    headers['content-md5'] || '',
                    headers['content-type'],
                    expires || headers['x-oss-date']
                  ];
                  Object.keys(headers).forEach(function (key) {
                    var lowerKey = key.toLowerCase();

                    if (lowerKey.indexOf(OSS_PREFIX) === 0) {
                      headersToSign[lowerKey] = String(headers[key]).trim();
                    }
                  });
                  Object.keys(headersToSign)
                    .sort()
                    .forEach(function (key) {
                      ossHeaders.push(''.concat(key, ':').concat(headersToSign[key]));
                    });
                  signContent = signContent.concat(ossHeaders);
                  signContent.push(this.buildCanonicalizedResource(resourcePath, request.parameters));
                  return signContent.join('\n');
                };
                /**
                 * @param {String} accessKeySecret
                 * @param {String} canonicalString
                 */

                exports.computeSignature = function computeSignature(accessKeySecret, canonicalString) {
                  var headerEncoding = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'utf-8';
                  var signature = crypto.createHmac('sha1', accessKeySecret);
                  return signature.update(Buffer.from(canonicalString, headerEncoding)).digest('base64');
                };
                /**
                 * @param {String} accessKeyId
                 * @param {String} accessKeySecret
                 * @param {String} canonicalString
                 */

                exports.authorization = function authorization(
                  accessKeyId,
                  accessKeySecret,
                  canonicalString,
                  headerEncoding
                ) {
                  return 'OSS '
                    .concat(accessKeyId, ':')
                    .concat(this.computeSignature(accessKeySecret, canonicalString, headerEncoding));
                };
                /**
                 *
                 * @param {String} accessKeySecret
                 * @param {Object} options
                 * @param {String} resource
                 * @param {Number} expires
                 */

                exports._signatureForURL = function _signatureForURL(accessKeySecret) {
                  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
                  var resource = arguments.length > 2 ? arguments[2] : undefined;
                  var expires = arguments.length > 3 ? arguments[3] : undefined;
                  var headerEncoding = arguments.length > 4 ? arguments[4] : undefined;
                  var headers = {};
                  var _options$subResource = options.subResource,
                    subResource = _options$subResource === void 0 ? {} : _options$subResource;

                  if (options.process) {
                    var processKeyword = 'x-oss-process';
                    subResource[processKeyword] = options.process;
                  }

                  if (options.trafficLimit) {
                    var trafficLimitKey = 'x-oss-traffic-limit';
                    subResource[trafficLimitKey] = options.trafficLimit;
                  }

                  if (options.response) {
                    Object.keys(options.response).forEach(function (k) {
                      var key = 'response-'.concat(k.toLowerCase());
                      subResource[key] = options.response[k];
                    });
                  }

                  Object.keys(options).forEach(function (key) {
                    var lowerKey = key.toLowerCase();
                    var value = options[key];

                    if (lowerKey.indexOf('x-oss-') === 0) {
                      headers[lowerKey] = value;
                    } else if (lowerKey.indexOf('content-md5') === 0) {
                      headers[key] = value;
                    } else if (lowerKey.indexOf('content-type') === 0) {
                      headers[key] = value;
                    }
                  });

                  if (Object.prototype.hasOwnProperty.call(options, 'security-token')) {
                    subResource['security-token'] = options['security-token'];
                  }

                  if (Object.prototype.hasOwnProperty.call(options, 'callback')) {
                    var json = {
                      callbackUrl: encodeURI(options.callback.url),
                      callbackBody: options.callback.body
                    };

                    if (options.callback.host) {
                      json.callbackHost = options.callback.host;
                    }

                    if (options.callback.contentType) {
                      json.callbackBodyType = options.callback.contentType;
                    }

                    subResource.callback = Buffer.from(JSON.stringify(json)).toString('base64');

                    if (options.callback.customValue) {
                      var callbackVar = {};
                      Object.keys(options.callback.customValue).forEach(function (key) {
                        callbackVar['x:'.concat(key)] = options.callback.customValue[key];
                      });
                      subResource['callback-var'] = Buffer.from(JSON.stringify(callbackVar)).toString('base64');
                    }
                  }

                  var canonicalString = this.buildCanonicalString(
                    options.method,
                    resource,
                    {
                      headers: headers,
                      parameters: subResource
                    },
                    expires.toString()
                  );
                  return {
                    Signature: this.computeSignature(accessKeySecret, canonicalString, headerEncoding),
                    subResource: subResource
                  };
                };
              }).call(this);
            }).call(this, require('buffer').Buffer);
          },
          {
            './../../shims/crypto/crypto.js': 435,
            './utils/lowercaseKeyHeader': 69,
            buffer: 89,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.join.js': 276,
            'core-js/modules/es.array.sort.js': 279,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.string.trim.js': 307,
            'core-js/modules/web.dom-collections.for-each.js': 338,
            'is-type-of': 440
          }
        ],
        51: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.regexp.exec.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.checkBucketName = void 0;

            exports.checkBucketName = function (name) {
              var createBucket = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
              var bucketRegex = createBucket
                ? /^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$/
                : /^[a-z0-9_][a-z0-9-_]{1,61}[a-z0-9_]$/;

              if (!bucketRegex.test(name)) {
                throw new Error('The bucket must be conform to the specifications');
              }
            };
          },
          { 'core-js/modules/es.regexp.exec.js': 299 }
        ],
        52: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.regexp.exec.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.checkConfigValid = void 0;
            var checkConfigMap = {
              endpoint: checkEndpoint,
              region: /^[a-zA-Z0-9\-_]+$/
            };

            function checkEndpoint(endpoint) {
              if (typeof endpoint === 'string') {
                return /^[a-zA-Z0-9._:/-]+$/.test(endpoint);
              } else if (endpoint.host) {
                return /^[a-zA-Z0-9._:/-]+$/.test(endpoint.host);
              }

              return false;
            }

            exports.checkConfigValid = function (conf, key) {
              if (checkConfigMap[key]) {
                var isConfigValid = true;

                if (checkConfigMap[key] instanceof Function) {
                  isConfigValid = checkConfigMap[key](conf);
                } else {
                  isConfigValid = checkConfigMap[key].test(conf);
                }

                if (!isConfigValid) {
                  throw new Error('The '.concat(key, ' must be conform to the specifications'));
                }
              }
            };
          },
          { 'core-js/modules/es.regexp.exec.js': 299 }
        ],
        53: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.array.concat.js');

            require('core-js/modules/es.object.entries.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.checkObjectTag = void 0;

            var _require = require('./checkValid'),
              checkValid = _require.checkValid;

            var _require2 = require('./isObject'),
              isObject = _require2.isObject;

            var commonRules = [
              {
                validator: function validator(value) {
                  if (typeof value !== 'string') {
                    throw new Error('the key and value of the tag must be String');
                  }
                }
              },
              {
                pattern: /^[a-zA-Z0-9 +-=._:/]+$/,
                msg: 'tag can contain letters, numbers, spaces, and the following symbols: plus sign (+), hyphen (-), equal sign (=), period (.), underscore (_), colon (:), and forward slash (/)'
              }
            ];
            var rules = {
              key: [].concat(commonRules, [
                {
                  pattern: /^.{1,128}$/,
                  msg: 'tag key can be a maximum of 128 bytes in length'
                }
              ]),
              value: [].concat(commonRules, [
                {
                  pattern: /^.{0,256}$/,
                  msg: 'tag value can be a maximum of 256 bytes in length'
                }
              ])
            };

            function checkObjectTag(tag) {
              if (!isObject(tag)) {
                throw new Error('tag must be Object');
              }

              var entries = Object.entries(tag);

              if (entries.length > 10) {
                throw new Error('maximum of 10 tags for a object');
              }

              var rulesIndexKey = ['key', 'value'];
              entries.forEach(function (keyValue) {
                keyValue.forEach(function (item, index) {
                  checkValid(item, rules[rulesIndexKey[index]]);
                });
              });
            }

            exports.checkObjectTag = checkObjectTag;
          },
          {
            './checkValid': 54,
            './isObject': 68,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.object.entries.js': 285,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        54: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.regexp.exec.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.checkValid = void 0;

            function checkValid(_value, _rules) {
              _rules.forEach(function (rule) {
                if (rule.validator) {
                  rule.validator(_value);
                } else if (rule.pattern && !rule.pattern.test(_value)) {
                  throw new Error(rule.msg);
                }
              });
            }

            exports.checkValid = checkValid;
          },
          {
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        55: [
          function (require, module, exports) {
            (function (Buffer) {
              (function () {
                'use strict';

                require('core-js/modules/es.array.includes.js');

                require('core-js/modules/es.string.includes.js');

                require('core-js/modules/es.object.assign.js');

                require('core-js/modules/es.array.concat.js');

                Object.defineProperty(exports, '__esModule', {
                  value: true
                });
                exports.createRequest = void 0;

                var crypto = require('./../../../shims/crypto/crypto.js');

                var debug = require('debug')('ali-oss');

                var mime = require('mime');

                var dateFormat = require('dateformat');

                var copy = require('copy-to');

                var path = require('path');

                var _require = require('./encoder'),
                  encoder = _require.encoder;

                var _require2 = require('./isIP'),
                  isIP = _require2.isIP;

                var _require3 = require('./setRegion'),
                  setRegion = _require3.setRegion;

                var _require4 = require('../client/getReqUrl'),
                  getReqUrl = _require4.getReqUrl;

                function getHeader(headers, name) {
                  return headers[name] || headers[name.toLowerCase()];
                }

                function delHeader(headers, name) {
                  delete headers[name];
                  delete headers[name.toLowerCase()];
                }

                function createRequest(params) {
                  var date = new Date();

                  if (this.options.amendTimeSkewed) {
                    date = +new Date() + this.options.amendTimeSkewed;
                  }

                  var headers = {
                    'x-oss-date': dateFormat(date, "UTC:ddd, dd mmm yyyy HH:MM:ss 'GMT'")
                  };

                  if (typeof window !== 'undefined') {
                    headers['x-oss-user-agent'] = this.userAgent;
                  }

                  if (this.userAgent.includes('nodejs')) {
                    headers['User-Agent'] = this.userAgent;
                  }

                  if (this.options.isRequestPay) {
                    Object.assign(headers, {
                      'x-oss-request-payer': 'requester'
                    });
                  }

                  if (this.options.stsToken) {
                    headers['x-oss-security-token'] = this.options.stsToken;
                  }

                  copy(params.headers).to(headers);

                  if (!getHeader(headers, 'Content-Type')) {
                    if (params.mime && params.mime.indexOf('/') > 0) {
                      headers['Content-Type'] = params.mime;
                    } else {
                      headers['Content-Type'] = mime.getType(params.mime || path.extname(params.object || ''));
                    }
                  }

                  if (!getHeader(headers, 'Content-Type')) {
                    delHeader(headers, 'Content-Type');
                  }

                  if (params.content) {
                    if (!params.disabledMD5) {
                      if (!params.headers || !params.headers['Content-MD5']) {
                        headers['Content-MD5'] = crypto
                          .createHash('md5')
                          .update(Buffer.from(params.content, 'utf8'))
                          .digest('base64');
                      } else {
                        headers['Content-MD5'] = params.headers['Content-MD5'];
                      }
                    }

                    if (!headers['Content-Length']) {
                      headers['Content-Length'] = params.content.length;
                    }
                  }

                  var hasOwnProperty = Object.prototype.hasOwnProperty;

                  for (var k in headers) {
                    if (headers[k] && hasOwnProperty.call(headers, k)) {
                      headers[k] = encoder(String(headers[k]), this.options.headerEncoding);
                    }
                  }

                  var authResource = this._getResource(params);

                  headers.authorization = this.authorization(
                    params.method,
                    authResource,
                    params.subres,
                    headers,
                    this.options.headerEncoding
                  ); // const url = this._getReqUrl(params);

                  if (isIP(this.options.endpoint.hostname)) {
                    var _this$options = this.options,
                      region = _this$options.region,
                      internal = _this$options.internal,
                      secure = _this$options.secure;
                    var hostInfo = setRegion(region, internal, secure);
                    headers.host = ''.concat(params.bucket, '.').concat(hostInfo.host);
                  }

                  var url = getReqUrl.bind(this)(params);
                  debug('request %s %s, with headers %j, !!stream: %s', params.method, url, headers, !!params.stream);
                  var timeout = params.timeout || this.options.timeout;
                  var reqParams = {
                    method: params.method,
                    content: params.content,
                    stream: params.stream,
                    headers: headers,
                    timeout: timeout,
                    writeStream: params.writeStream,
                    customResponse: params.customResponse,
                    ctx: params.ctx || this.ctx
                  };

                  if (this.agent) {
                    reqParams.agent = this.agent;
                  }

                  if (this.httpsAgent) {
                    reqParams.httpsAgent = this.httpsAgent;
                  }

                  reqParams.enableProxy = !!this.options.enableProxy;
                  reqParams.proxy = this.options.proxy ? this.options.proxy : null;
                  return {
                    url: url,
                    params: reqParams
                  };
                }

                exports.createRequest = createRequest;
              }).call(this);
            }).call(this, require('buffer').Buffer);
          },
          {
            '../client/getReqUrl': 25,
            './../../../shims/crypto/crypto.js': 435,
            './encoder': 58,
            './isIP': 67,
            './setRegion': 73,
            buffer: 89,
            'copy-to': 91,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.includes.js': 274,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.string.includes.js': 301,
            dateformat: 341,
            debug: 439,
            mime: 359,
            path: 363
          }
        ],
        56: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.entries.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            require('core-js/modules/es.array.includes.js');

            require('core-js/modules/es.object.keys.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.dataFix = void 0;

            var isObject_1 = require('./isObject');

            var TRUE = ['true', 'TRUE', '1', 1];
            var FALSE = ['false', 'FALSE', '0', 0];

            function dataFix(o, conf, finalKill) {
              if (!isObject_1.isObject(o)) return;
              var _conf$remove = conf.remove,
                remove = _conf$remove === void 0 ? [] : _conf$remove,
                _conf$rename = conf.rename,
                rename = _conf$rename === void 0 ? {} : _conf$rename,
                _conf$camel = conf.camel,
                camel = _conf$camel === void 0 ? [] : _conf$camel,
                _conf$bool = conf.bool,
                bool = _conf$bool === void 0 ? [] : _conf$bool,
                _conf$lowerFirst = conf.lowerFirst,
                lowerFirst = _conf$lowerFirst === void 0 ? false : _conf$lowerFirst; // 删除不需要的数据

              remove.forEach(function (v) {
                return delete o[v];
              }); // 重命名

              Object.entries(rename).forEach(function (v) {
                if (!o[v[0]]) return;
                if (o[v[1]]) return;
                o[v[1]] = o[v[0]];
                delete o[v[0]];
              }); // 驼峰化

              camel.forEach(function (v) {
                if (!o[v]) return;
                var afterKey = v
                  .replace(/^(.)/, function ($0) {
                    return $0.toLowerCase();
                  })
                  .replace(/-(\w)/g, function (_, $1) {
                    return $1.toUpperCase();
                  });
                if (o[afterKey]) return;
                o[afterKey] = o[v]; // todo 暂时兼容以前数据，不做删除
                // delete o[v];
              }); // 转换值为布尔值

              bool.forEach(function (v) {
                o[v] = fixBool(o[v]);
              }); // finalKill

              if (typeof finalKill === 'function') {
                finalKill(o);
              } // 首字母转小写

              fixLowerFirst(o, lowerFirst);
              return dataFix;
            }

            exports.dataFix = dataFix;

            function fixBool(value) {
              if (!value) return false;
              if (TRUE.includes(value)) return true;
              return FALSE.includes(value) ? false : value;
            }

            function fixLowerFirst(o, lowerFirst) {
              if (lowerFirst) {
                Object.keys(o).forEach(function (key) {
                  var lowerK = key.replace(/^\w/, function (match) {
                    return match.toLowerCase();
                  });

                  if (typeof o[lowerK] === 'undefined') {
                    o[lowerK] = o[key];
                    delete o[key];
                  }
                });
              }
            }
          },
          {
            './isObject': 68,
            'core-js/modules/es.array.includes.js': 274,
            'core-js/modules/es.object.entries.js': 285,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        57: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            require('core-js/modules/es.array.slice.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            var _typeof2 = _interopRequireDefault(require('@babel/runtime/helpers/typeof'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.deepCopyWith = exports.deepCopy = void 0;

            var isBuffer_1 = require('./isBuffer');

            exports.deepCopy = function (obj) {
              if (obj === null || (0, _typeof2.default)(obj) !== 'object') {
                return obj;
              }

              if (isBuffer_1.isBuffer(obj)) {
                return obj.slice();
              }

              var copy = Array.isArray(obj) ? [] : {};
              Object.keys(obj).forEach(function (key) {
                copy[key] = exports.deepCopy(obj[key]);
              });
              return copy;
            };

            exports.deepCopyWith = function (obj, customizer) {
              function deepCopyWithHelper(value, innerKey, innerObject) {
                var result = customizer(value, innerKey, innerObject);
                if (result !== undefined) return result;

                if (value === null || (0, _typeof2.default)(value) !== 'object') {
                  return value;
                }

                if (isBuffer_1.isBuffer(value)) {
                  return value.slice();
                }

                var copy = Array.isArray(value) ? [] : {};
                Object.keys(value).forEach(function (k) {
                  copy[k] = deepCopyWithHelper(value[k], k, value);
                });
                return copy;
              }

              if (customizer) {
                return deepCopyWithHelper(obj, '', null);
              } else {
                return exports.deepCopy(obj);
              }
            };
          },
          {
            './isBuffer': 64,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/helpers/typeof': 78,
            'core-js/modules/es.array.slice.js': 278,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        58: [
          function (require, module, exports) {
            (function (Buffer) {
              (function () {
                'use strict';

                require('core-js/modules/es.object.to-string.js');

                require('core-js/modules/es.regexp.to-string.js');

                Object.defineProperty(exports, '__esModule', {
                  value: true
                });
                exports.encoder = void 0;

                function encoder(str) {
                  var encoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'utf-8';
                  if (encoding === 'utf-8') return str;
                  return Buffer.from(str).toString('latin1');
                }

                exports.encoder = encoder;
              }).call(this);
            }).call(this, require('buffer').Buffer);
          },
          { buffer: 89, 'core-js/modules/es.object.to-string.js': 290, 'core-js/modules/es.regexp.to-string.js': 300 }
        ],
        59: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.array.map.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.formatInventoryConfig = void 0;

            var dataFix_1 = require('../utils/dataFix');

            var isObject_1 = require('../utils/isObject');

            var isArray_1 = require('../utils/isArray');

            var formatObjKey_1 = require('../utils/formatObjKey');

            function formatInventoryConfig(inventoryConfig) {
              var toArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
              if (toArray && isObject_1.isObject(inventoryConfig)) inventoryConfig = [inventoryConfig];

              if (isArray_1.isArray(inventoryConfig)) {
                inventoryConfig = inventoryConfig.map(formatFn);
              } else {
                inventoryConfig = formatFn(inventoryConfig);
              }

              return inventoryConfig;
            }

            exports.formatInventoryConfig = formatInventoryConfig;

            function formatFn(_) {
              dataFix_1.dataFix(
                _,
                {
                  bool: ['IsEnabled']
                },
                function (conf) {
                  var _a, _b; // prefix

                  conf.prefix = conf.Filter.Prefix;
                  delete conf.Filter; // OSSBucketDestination

                  conf.OSSBucketDestination = conf.Destination.OSSBucketDestination; // OSSBucketDestination.rolename

                  conf.OSSBucketDestination.rolename = conf.OSSBucketDestination.RoleArn.replace(/.*\//, '');
                  delete conf.OSSBucketDestination.RoleArn; // OSSBucketDestination.bucket

                  conf.OSSBucketDestination.bucket = conf.OSSBucketDestination.Bucket.replace(/.*:::/, '');
                  delete conf.OSSBucketDestination.Bucket;
                  delete conf.Destination; // frequency

                  conf.frequency = conf.Schedule.Frequency;
                  delete conf.Schedule.Frequency; // optionalFields

                  if (
                    ((_a = conf === null || conf === void 0 ? void 0 : conf.OptionalFields) === null || _a === void 0
                      ? void 0
                      : _a.Field) &&
                    !isArray_1.isArray((_b = conf.OptionalFields) === null || _b === void 0 ? void 0 : _b.Field)
                  )
                    conf.OptionalFields.Field = [conf.OptionalFields.Field];
                }
              ); // firstLowerCase

              _ = formatObjKey_1.formatObjKey(_, 'firstLowerCase', {
                exclude: ['OSSBucketDestination', 'SSE-OSS', 'SSE-KMS']
              });
              return _;
            }
          },
          {
            '../utils/dataFix': 56,
            '../utils/formatObjKey': 60,
            '../utils/isArray': 62,
            '../utils/isObject': 68,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.replace.js': 304
          }
        ],
        60: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.array.includes.js');

            require('core-js/modules/es.string.includes.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            var _typeof2 = _interopRequireDefault(require('@babel/runtime/helpers/typeof'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.formatObjKey = void 0;

            function formatObjKey(obj, type, options) {
              if (obj === null || (0, _typeof2.default)(obj) !== 'object') {
                return obj;
              }

              var o;

              if (Array.isArray(obj)) {
                o = [];

                for (var i = 0; i < obj.length; i++) {
                  o.push(formatObjKey(obj[i], type, options));
                }
              } else {
                o = {};
                Object.keys(obj).forEach(function (key) {
                  o[handelFormat(key, type, options)] = formatObjKey(obj[key], type, options);
                });
              }

              return o;
            }

            exports.formatObjKey = formatObjKey;

            function handelFormat(key, type, options) {
              if (options && options.exclude && options.exclude.includes(key)) return key;

              if (type === 'firstUpperCase') {
                key = key.replace(/^./, function (_) {
                  return _.toUpperCase();
                });
              } else if (type === 'firstLowerCase') {
                key = key.replace(/^./, function (_) {
                  return _.toLowerCase();
                });
              }

              return key;
            }
          },
          {
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/helpers/typeof': 78,
            'core-js/modules/es.array.includes.js': 274,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.includes.js': 301,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        61: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.regexp.exec.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.getStrBytesCount = void 0;

            function getStrBytesCount(str) {
              var bytesCount = 0;

              for (var i = 0; i < str.length; i++) {
                var c = str.charAt(i);

                if (/^[\u00-\uff]$/.test(c)) {
                  bytesCount += 1;
                } else {
                  bytesCount += 2;
                }
              }

              return bytesCount;
            }

            exports.getStrBytesCount = getStrBytesCount;
          },
          { 'core-js/modules/es.regexp.exec.js': 299 }
        ],
        62: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.object.to-string.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.isArray = void 0;

            exports.isArray = function (obj) {
              return Object.prototype.toString.call(obj) === '[object Array]';
            };
          },
          { 'core-js/modules/es.object.to-string.js': 290 }
        ],
        63: [
          function (require, module, exports) {
            'use strict';

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.isBlob = void 0;

            function isBlob(blob) {
              return typeof Blob !== 'undefined' && blob instanceof Blob;
            }

            exports.isBlob = isBlob;
          },
          {}
        ],
        64: [
          function (require, module, exports) {
            (function (Buffer) {
              (function () {
                'use strict';

                Object.defineProperty(exports, '__esModule', {
                  value: true
                });
                exports.isBuffer = void 0;

                function isBuffer(obj) {
                  return Buffer.isBuffer(obj);
                }

                exports.isBuffer = isBuffer;
              }).call(this);
            }).call(this, { isBuffer: require('../../../node_modules/is-buffer/index.js') });
          },
          { '../../../node_modules/is-buffer/index.js': 354 }
        ],
        65: [
          function (require, module, exports) {
            'use strict';

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.isFile = void 0;

            exports.isFile = function (obj) {
              return typeof File !== 'undefined' && obj instanceof File;
            };
          },
          {}
        ],
        66: [
          function (require, module, exports) {
            'use strict';

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.isFunction = void 0;

            exports.isFunction = function (v) {
              return typeof v === 'function';
            };
          },
          {}
        ],
        67: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.regexp.exec.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.isIP = void 0; // it provide commont methods for node and browser , we will add more solutions later in this file

            /**
             * Judge isIP include ipv4 or ipv6
             * @param {String} options
             * @return {Array} the multipart uploads
             */

            exports.isIP = function (host) {
              var ipv4Regex = /^(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}$/;
              var ipv6Regex =
                /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
              return ipv4Regex.test(host) || ipv6Regex.test(host);
            };
          },
          { 'core-js/modules/es.regexp.exec.js': 299 }
        ],
        68: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.object.to-string.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.isObject = void 0;

            exports.isObject = function (obj) {
              return Object.prototype.toString.call(obj) === '[object Object]';
            };
          },
          { 'core-js/modules/es.object.to-string.js': 290 }
        ],
        69: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.lowercaseKeyHeader = void 0;

            var isObject_1 = require('./isObject');

            function lowercaseKeyHeader(headers) {
              var lowercaseHeader = {};

              if (isObject_1.isObject(headers)) {
                Object.keys(headers).forEach(function (key) {
                  lowercaseHeader[key.toLowerCase()] = headers[key];
                });
              }

              return lowercaseHeader;
            }

            exports.lowercaseKeyHeader = lowercaseKeyHeader;
          },
          {
            './isObject': 68,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        70: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.string.replace.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/web.dom-collections.for-each.js');

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.array.concat.js');

            require('core-js/modules/es.array.join.js');

            require('core-js/modules/es.array.map.js');

            require('core-js/modules/es.regexp.to-string.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.obj2xml = void 0;

            var formatObjKey_1 = require('./formatObjKey');

            function type(params) {
              return Object.prototype.toString
                .call(params)
                .replace(/(.*? |])/g, '')
                .toLowerCase();
            }

            function obj2xml(obj, options) {
              var s = '';

              if (options && options.headers) {
                s = '<?xml version="1.0" encoding="UTF-8"?>\n';
              }

              if (options && options.firstUpperCase) {
                obj = formatObjKey_1.formatObjKey(obj, 'firstUpperCase');
              }

              if (type(obj) === 'object') {
                Object.keys(obj).forEach(function (key) {
                  // filter undefined or null
                  if (type(obj[key]) !== 'undefined' && type(obj[key]) !== 'null') {
                    if (type(obj[key]) === 'string' || type(obj[key]) === 'number') {
                      s += '<'.concat(key, '>').concat(obj[key], '</').concat(key, '>');
                    } else if (type(obj[key]) === 'object') {
                      s += '<'.concat(key, '>').concat(obj2xml(obj[key]), '</').concat(key, '>');
                    } else if (type(obj[key]) === 'array') {
                      s += obj[key]
                        .map(function (keyChild) {
                          return '<'.concat(key, '>').concat(obj2xml(keyChild), '</').concat(key, '>');
                        })
                        .join('');
                    } else {
                      s += '<'.concat(key, '>').concat(obj[key].toString(), '</').concat(key, '>');
                    }
                  }
                });
              } else {
                s += obj.toString();
              }

              return s;
            }

            exports.obj2xml = obj2xml;
          },
          {
            './formatObjKey': 60,
            'core-js/modules/es.array.concat.js': 269,
            'core-js/modules/es.array.join.js': 276,
            'core-js/modules/es.array.map.js': 277,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.regexp.to-string.js': 300,
            'core-js/modules/es.string.replace.js': 304,
            'core-js/modules/web.dom-collections.for-each.js': 338
          }
        ],
        71: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.array.slice.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/es.function.name.js');

            require('core-js/modules/es.array.from.js');

            require('core-js/modules/es.string.iterator.js');

            require('core-js/modules/es.regexp.exec.js');

            require('core-js/modules/es.symbol.js');

            require('core-js/modules/es.symbol.description.js');

            require('core-js/modules/es.symbol.iterator.js');

            require('core-js/modules/es.array.iterator.js');

            require('core-js/modules/web.dom-collections.iterator.js');

            require('core-js/modules/es.object.assign.js');

            function _createForOfIteratorHelper(o, allowArrayLike) {
              var it = (typeof Symbol !== 'undefined' && o[Symbol.iterator]) || o['@@iterator'];
              if (!it) {
                if (
                  Array.isArray(o) ||
                  (it = _unsupportedIterableToArray(o)) ||
                  (allowArrayLike && o && typeof o.length === 'number')
                ) {
                  if (it) o = it;
                  var i = 0;
                  var F = function F() {};
                  return {
                    s: F,
                    n: function n() {
                      if (i >= o.length) return { done: true };
                      return { done: false, value: o[i++] };
                    },
                    e: function e(_e) {
                      throw _e;
                    },
                    f: F
                  };
                }
                throw new TypeError(
                  'Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.'
                );
              }
              var normalCompletion = true,
                didErr = false,
                err;
              return {
                s: function s() {
                  it = it.call(o);
                },
                n: function n() {
                  var step = it.next();
                  normalCompletion = step.done;
                  return step;
                },
                e: function e(_e2) {
                  didErr = true;
                  err = _e2;
                },
                f: function f() {
                  try {
                    if (!normalCompletion && it.return != null) it.return();
                  } finally {
                    if (didErr) throw err;
                  }
                }
              };
            }

            function _unsupportedIterableToArray(o, minLen) {
              if (!o) return;
              if (typeof o === 'string') return _arrayLikeToArray(o, minLen);
              var n = Object.prototype.toString.call(o).slice(8, -1);
              if (n === 'Object' && o.constructor) n = o.constructor.name;
              if (n === 'Map' || n === 'Set') return Array.from(o);
              if (n === 'Arguments' || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
                return _arrayLikeToArray(o, minLen);
            }

            function _arrayLikeToArray(arr, len) {
              if (len == null || len > arr.length) len = arr.length;
              for (var i = 0, arr2 = new Array(len); i < len; i++) {
                arr2[i] = arr[i];
              }
              return arr2;
            }

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.omit = void 0;

            function omit(originalObject, keysToOmit) {
              var cloneObject = Object.assign({}, originalObject);

              var _iterator = _createForOfIteratorHelper(keysToOmit),
                _step;

              try {
                for (_iterator.s(); !(_step = _iterator.n()).done; ) {
                  var path = _step.value;
                  delete cloneObject[path];
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }

              return cloneObject;
            }

            exports.omit = omit;
          },
          {
            'core-js/modules/es.array.from.js': 273,
            'core-js/modules/es.array.iterator.js': 275,
            'core-js/modules/es.array.slice.js': 278,
            'core-js/modules/es.function.name.js': 281,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.to-string.js': 290,
            'core-js/modules/es.regexp.exec.js': 299,
            'core-js/modules/es.string.iterator.js': 302,
            'core-js/modules/es.symbol.description.js': 309,
            'core-js/modules/es.symbol.iterator.js': 311,
            'core-js/modules/es.symbol.js': 312,
            'core-js/modules/web.dom-collections.iterator.js': 339
          }
        ],
        72: [
          function (require, module, exports) {
            'use strict';

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/es.promise.js');

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.retry = void 0;

            function retry(func, retryMax) {
              var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
              var retryNum = 0;
              var _config$retryDelay = config.retryDelay,
                retryDelay = _config$retryDelay === void 0 ? 500 : _config$retryDelay,
                _config$errorHandler = config.errorHandler,
                errorHandler =
                  _config$errorHandler === void 0
                    ? function () {
                        return true;
                      }
                    : _config$errorHandler;

              var funcR = function funcR() {
                for (var _len = arguments.length, arg = new Array(_len), _key = 0; _key < _len; _key++) {
                  arg[_key] = arguments[_key];
                }

                return new Promise(function (resolve, reject) {
                  func
                    .apply(void 0, arg)
                    .then(function (result) {
                      retryNum = 0;
                      resolve(result);
                    })
                    .catch(function (err) {
                      if (retryNum < retryMax && errorHandler(err)) {
                        retryNum++;
                        setTimeout(function () {
                          resolve(funcR.apply(void 0, arg));
                        }, retryDelay);
                      } else {
                        retryNum = 0;
                        reject(err);
                      }
                    });
                });
              };

              return funcR;
            }

            exports.retry = retry;
          },
          { 'core-js/modules/es.object.to-string.js': 290, 'core-js/modules/es.promise.js': 294 }
        ],
        73: [
          function (require, module, exports) {
            'use strict';

            var __importDefault =
              (void 0 && (void 0).__importDefault) ||
              function (mod) {
                return mod && mod.__esModule
                  ? mod
                  : {
                      default: mod
                    };
              };

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.setRegion = void 0;

            var url_1 = __importDefault(require('url'));

            var checkConfigValid_1 = require('./checkConfigValid');

            function setRegion(region) {
              var internal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
              var secure = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
              checkConfigValid_1.checkConfigValid(region, 'region');
              var protocol = secure ? 'https://' : 'http://';
              var suffix = internal ? '-internal.aliyuncs.com' : '.aliyuncs.com';
              var prefix = 'vpc100-oss-cn-'; // aliyun VPC region: https://help.aliyun.com/knowledge_detail/38740.html

              if (region.substr(0, prefix.length) === prefix) {
                suffix = '.aliyuncs.com';
              }

              return url_1.default.parse(protocol + region + suffix);
            }

            exports.setRegion = setRegion;
          },
          { './checkConfigValid': 52, url: 446 }
        ],
        74: [
          function (require, module, exports) {
            'use strict';

            var _interopRequireDefault = require('@babel/runtime/helpers/interopRequireDefault');

            var _regenerator = _interopRequireDefault(require('@babel/runtime/regenerator'));

            require('core-js/modules/es.object.keys.js');

            require('core-js/modules/es.object.to-string.js');

            require('core-js/modules/es.array.find.js');

            require('core-js/modules/es.object.assign.js');

            var _asyncToGenerator2 = _interopRequireDefault(require('@babel/runtime/helpers/asyncToGenerator'));

            Object.defineProperty(exports, '__esModule', {
              value: true
            });
            exports.checkCredentials = exports.setSTSToken = void 0;

            var formatObjKey_1 = require('./formatObjKey');

            function setSTSToken() {
              return _setSTSToken.apply(this, arguments);
            }

            function _setSTSToken() {
              _setSTSToken = (0, _asyncToGenerator2.default)(
                /*#__PURE__*/ _regenerator.default.mark(function _callee() {
                  var now, credentials;
                  return _regenerator.default.wrap(
                    function _callee$(_context) {
                      while (1) {
                        switch ((_context.prev = _context.next)) {
                          case 0:
                            if (!this.options) this.options = {};
                            now = new Date();

                            if (!this.stsTokenFreshTime) {
                              _context.next = 14;
                              break;
                            }

                            if (!(+now - this.stsTokenFreshTime >= this.options.refreshSTSTokenInterval)) {
                              _context.next = 12;
                              break;
                            }

                            this.stsTokenFreshTime = now;
                            _context.next = 7;
                            return this.options.refreshSTSToken();

                          case 7:
                            credentials = _context.sent;
                            credentials = formatObjKey_1.formatObjKey(credentials, 'firstLowerCase');

                            if (credentials.securityToken) {
                              credentials.stsToken = credentials.securityToken;
                            }

                            checkCredentials(credentials);
                            Object.assign(this.options, credentials);

                          case 12:
                            _context.next = 15;
                            break;

                          case 14:
                            this.stsTokenFreshTime = now;

                          case 15:
                            return _context.abrupt('return', null);

                          case 16:
                          case 'end':
                            return _context.stop();
                        }
                      }
                    },
                    _callee,
                    this
                  );
                })
              );
              return _setSTSToken.apply(this, arguments);
            }

            exports.setSTSToken = setSTSToken;

            function checkCredentials(obj) {
              var stsTokenKey = ['accessKeySecret', 'accessKeyId', 'stsToken'];
              var objKeys = Object.keys(obj);
              stsTokenKey.forEach(function (_) {
                if (
                  !objKeys.find(function (key) {
                    return key === _;
                  })
                ) {
                  throw Error('refreshSTSToken must return contains '.concat(_));
                }
              });
            }

            exports.checkCredentials = checkCredentials;
          },
          {
            './formatObjKey': 60,
            '@babel/runtime/helpers/asyncToGenerator': 75,
            '@babel/runtime/helpers/interopRequireDefault': 77,
            '@babel/runtime/regenerator': 79,
            'core-js/modules/es.array.find.js': 272,
            'core-js/modules/es.object.assign.js': 284,
            'core-js/modules/es.object.keys.js': 289,
            'core-js/modules/es.object.to-string.js': 290
          }
        ],
        75: [
          function (require, module, exports) {
            function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
              try {
                var info = gen[key](arg);
                var value = info.value;
              } catch (error) {
                reject(error);
                return;
              }

              if (info.done) {
                resolve(value);
              } else {
                Promise.resolve(value).then(_next, _throw);
              }
            }

            function _asyncToGenerator(fn) {
              return function () {
                var self = this,
                  args = arguments;
                return new Promise(function (resolve, reject) {
                  var gen = fn.apply(self, args);

                  function _next(value) {
                    asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'next', value);
                  }

                  function _throw(err) {
                    asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'throw', err);
                  }

                  _next(undefined);
                });
              };
            }

            (module.exports = _asyncToGenerator),
              (module.exports.__esModule = true),
              (module.exports['default'] = module.exports);
          },
          {}
        ],
        76: [
          function (require, module, exports) {
            function _defineProperty(obj, key, value) {
              if (key in obj) {
                Object.defineProperty(obj, key, {
                  value: value,
                  enumerable: true,
                  configurable: true,
                  writable: true
                });
              } else {
                obj[key] = value;
              }

              return obj;
            }

            (module.exports = _defineProperty),
              (module.exports.__esModule = true),
              (module.exports['default'] = module.exports);
          },
          {}
        ],
        77: [
          function (require, module, exports) {
            function _interopRequireDefault(obj) {
              return obj && obj.__esModule
                ? obj
                : {
                    default: obj
                  };
            }

            (module.exports = _interopRequireDefault),
              (module.exports.__esModule = true),
              (module.exports['default'] = module.exports);
          },
          {}
        ],
        78: [
          function (require, module, exports) {
            function _typeof(obj) {
              '@babel/helpers - typeof';

              return (
                ((module.exports = _typeof =
                  'function' == typeof Symbol && 'symbol' == typeof Symbol.iterator
                    ? function (obj) {
                        return typeof obj;
                      }
                    : function (obj) {
                        return obj &&
                          'function' == typeof Symbol &&
                          obj.constructor === Symbol &&
                          obj !== Symbol.prototype
                          ? 'symbol'
                          : typeof obj;
                      }),
                (module.exports.__esModule = true),
                (module.exports['default'] = module.exports)),
                _typeof(obj)
              );
            }

            (module.exports = _typeof),
              (module.exports.__esModule = true),
              (module.exports['default'] = module.exports);
          },
          {}
        ],
        79: [
          function (require, module, exports) {
            module.exports = require('regenerator-runtime');
          },
          { 'regenerator-runtime': 384 }
        ],
        80: [
          function (require, module, exports) {
            module.exports = noop;
            module.exports.HttpsAgent = noop;

            // Noop function for browser since native api's don't use agents.
            function noop() {}
          },
          {}
        ],
        81: [
          function (require, module, exports) {
            (function (global) {
              (function () {
                'use strict';

                var objectAssign = require('object-assign');

                // compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
                // original notice:

                /*!
                 * The buffer module from node.js, for the browser.
                 *
                 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
                 * @license  MIT
                 */
                function compare(a, b) {
                  if (a === b) {
                    return 0;
                  }

                  var x = a.length;
                  var y = b.length;

                  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                    if (a[i] !== b[i]) {
                      x = a[i];
                      y = b[i];
                      break;
                    }
                  }

                  if (x < y) {
                    return -1;
                  }
                  if (y < x) {
                    return 1;
                  }
                  return 0;
                }
                function isBuffer(b) {
                  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
                    return global.Buffer.isBuffer(b);
                  }
                  return !!(b != null && b._isBuffer);
                }

                // based on node assert, original notice:
                // NB: The URL to the CommonJS spec is kept just for tradition.
                //     node-assert has evolved a lot since then, both in API and behavior.

                // http://wiki.commonjs.org/wiki/Unit_Testing/1.0
                //
                // THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
                //
                // Originally from narwhal.js (http://narwhaljs.org)
                // Copyright (c) 2009 Thomas Robinson <280north.com>
                //
                // Permission is hereby granted, free of charge, to any person obtaining a copy
                // of this software and associated documentation files (the 'Software'), to
                // deal in the Software without restriction, including without limitation the
                // rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
                // sell copies of the Software, and to permit persons to whom the Software is
                // furnished to do so, subject to the following conditions:
                //
                // The above copyright notice and this permission notice shall be included in
                // all copies or substantial portions of the Software.
                //
                // THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
                // IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
                // FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
                // AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
                // ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
                // WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

                var util = require('util/');
                var hasOwn = Object.prototype.hasOwnProperty;
                var pSlice = Array.prototype.slice;
                var functionsHaveNames = (function () {
                  return function foo() {}.name === 'foo';
                })();
                function pToString(obj) {
                  return Object.prototype.toString.call(obj);
                }
                function isView(arrbuf) {
                  if (isBuffer(arrbuf)) {
                    return false;
                  }
                  if (typeof global.ArrayBuffer !== 'function') {
                    return false;
                  }
                  if (typeof ArrayBuffer.isView === 'function') {
                    return ArrayBuffer.isView(arrbuf);
                  }
                  if (!arrbuf) {
                    return false;
                  }
                  if (arrbuf instanceof DataView) {
                    return true;
                  }
                  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
                    return true;
                  }
                  return false;
                }
                // 1. The assert module provides functions that throw
                // AssertionError's when particular conditions are not met. The
                // assert module must conform to the following interface.

                var assert = (module.exports = ok);

                // 2. The AssertionError is defined in assert.
                // new assert.AssertionError({ message: message,
                //                             actual: actual,
                //                             expected: expected })

                var regex = /\s*function\s+([^\(\s]*)\s*/;
                // based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
                function getName(func) {
                  if (!util.isFunction(func)) {
                    return;
                  }
                  if (functionsHaveNames) {
                    return func.name;
                  }
                  var str = func.toString();
                  var match = str.match(regex);
                  return match && match[1];
                }
                assert.AssertionError = function AssertionError(options) {
                  this.name = 'AssertionError';
                  this.actual = options.actual;
                  this.expected = options.expected;
                  this.operator = options.operator;
                  if (options.message) {
                    this.message = options.message;
                    this.generatedMessage = false;
                  } else {
                    this.message = getMessage(this);
                    this.generatedMessage = true;
                  }
                  var stackStartFunction = options.stackStartFunction || fail;
                  if (Error.captureStackTrace) {
                    Error.captureStackTrace(this, stackStartFunction);
                  } else {
                    // non v8 browsers so we can have a stacktrace
                    var err = new Error();
                    if (err.stack) {
                      var out = err.stack;

                      // try to strip useless frames
                      var fn_name = getName(stackStartFunction);
                      var idx = out.indexOf('\n' + fn_name);
                      if (idx >= 0) {
                        // once we have located the function frame
                        // we need to strip out everything before it (and its line)
                        var next_line = out.indexOf('\n', idx + 1);
                        out = out.substring(next_line + 1);
                      }

                      this.stack = out;
                    }
                  }
                };

                // assert.AssertionError instanceof Error
                util.inherits(assert.AssertionError, Error);

                function truncate(s, n) {
                  if (typeof s === 'string') {
                    return s.length < n ? s : s.slice(0, n);
                  } else {
                    return s;
                  }
                }
                function inspect(something) {
                  if (functionsHaveNames || !util.isFunction(something)) {
                    return util.inspect(something);
                  }
                  var rawname = getName(something);
                  var name = rawname ? ': ' + rawname : '';
                  return '[Function' + name + ']';
                }
                function getMessage(self) {
                  return (
                    truncate(inspect(self.actual), 128) +
                    ' ' +
                    self.operator +
                    ' ' +
                    truncate(inspect(self.expected), 128)
                  );
                }

                // At present only the three keys mentioned above are used and
                // understood by the spec. Implementations or sub modules can pass
                // other keys to the AssertionError's constructor - they will be
                // ignored.

                // 3. All of the following functions must throw an AssertionError
                // when a corresponding condition is not met, with a message that
                // may be undefined if not provided.  All assertion methods provide
                // both the actual and expected values to the assertion error for
                // display purposes.

                function fail(actual, expected, message, operator, stackStartFunction) {
                  throw new assert.AssertionError({
                    message: message,
                    actual: actual,
                    expected: expected,
                    operator: operator,
                    stackStartFunction: stackStartFunction
                  });
                }

                // EXTENSION! allows for well behaved errors defined elsewhere.
                assert.fail = fail;

                // 4. Pure assertion tests whether a value is truthy, as determined
                // by !!guard.
                // assert.ok(guard, message_opt);
                // This statement is equivalent to assert.equal(true, !!guard,
                // message_opt);. To test strictly for the value true, use
                // assert.strictEqual(true, guard, message_opt);.

                function ok(value, message) {
                  if (!value) fail(value, true, message, '==', assert.ok);
                }
                assert.ok = ok;

                // 5. The equality assertion tests shallow, coercive equality with
                // ==.
                // assert.equal(actual, expected, message_opt);

                assert.equal = function equal(actual, expected, message) {
                  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
                };

                // 6. The non-equality assertion tests for whether two objects are not equal
                // with != assert.notEqual(actual, expected, message_opt);

                assert.notEqual = function notEqual(actual, expected, message) {
                  if (actual == expected) {
                    fail(actual, expected, message, '!=', assert.notEqual);
                  }
                };

                // 7. The equivalence assertion tests a deep equality relation.
                // assert.deepEqual(actual, expected, message_opt);

                assert.deepEqual = function deepEqual(actual, expected, message) {
                  if (!_deepEqual(actual, expected, false)) {
                    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
                  }
                };

                assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
                  if (!_deepEqual(actual, expected, true)) {
                    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
                  }
                };

                function _deepEqual(actual, expected, strict, memos) {
                  // 7.1. All identical values are equivalent, as determined by ===.
                  if (actual === expected) {
                    return true;
                  } else if (isBuffer(actual) && isBuffer(expected)) {
                    return compare(actual, expected) === 0;

                    // 7.2. If the expected value is a Date object, the actual value is
                    // equivalent if it is also a Date object that refers to the same time.
                  } else if (util.isDate(actual) && util.isDate(expected)) {
                    return actual.getTime() === expected.getTime();

                    // 7.3 If the expected value is a RegExp object, the actual value is
                    // equivalent if it is also a RegExp object with the same source and
                    // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
                  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
                    return (
                      actual.source === expected.source &&
                      actual.global === expected.global &&
                      actual.multiline === expected.multiline &&
                      actual.lastIndex === expected.lastIndex &&
                      actual.ignoreCase === expected.ignoreCase
                    );

                    // 7.4. Other pairs that do not both pass typeof value == 'object',
                    // equivalence is determined by ==.
                  } else if (
                    (actual === null || typeof actual !== 'object') &&
                    (expected === null || typeof expected !== 'object')
                  ) {
                    return strict ? actual === expected : actual == expected;

                    // If both values are instances of typed arrays, wrap their underlying
                    // ArrayBuffers in a Buffer each to increase performance
                    // This optimization requires the arrays to have the same type as checked by
                    // Object.prototype.toString (aka pToString). Never perform binary
                    // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
                    // bit patterns are not identical.
                  } else if (
                    isView(actual) &&
                    isView(expected) &&
                    pToString(actual) === pToString(expected) &&
                    !(actual instanceof Float32Array || actual instanceof Float64Array)
                  ) {
                    return compare(new Uint8Array(actual.buffer), new Uint8Array(expected.buffer)) === 0;

                    // 7.5 For all other Object pairs, including Array objects, equivalence is
                    // determined by having the same number of owned properties (as verified
                    // with Object.prototype.hasOwnProperty.call), the same set of keys
                    // (although not necessarily the same order), equivalent values for every
                    // corresponding key, and an identical 'prototype' property. Note: this
                    // accounts for both named and indexed properties on Arrays.
                  } else if (isBuffer(actual) !== isBuffer(expected)) {
                    return false;
                  } else {
                    memos = memos || { actual: [], expected: [] };

                    var actualIndex = memos.actual.indexOf(actual);
                    if (actualIndex !== -1) {
                      if (actualIndex === memos.expected.indexOf(expected)) {
                        return true;
                      }
                    }

                    memos.actual.push(actual);
                    memos.expected.push(expected);

                    return objEquiv(actual, expected, strict, memos);
                  }
                }

                function isArguments(object) {
                  return Object.prototype.toString.call(object) == '[object Arguments]';
                }

                function objEquiv(a, b, strict, actualVisitedObjects) {
                  if (a === null || a === undefined || b === null || b === undefined) return false;
                  // if one is a primitive, the other must be same
                  if (util.isPrimitive(a) || util.isPrimitive(b)) return a === b;
                  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b)) return false;
                  var aIsArgs = isArguments(a);
                  var bIsArgs = isArguments(b);
                  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs)) return false;
                  if (aIsArgs) {
                    a = pSlice.call(a);
                    b = pSlice.call(b);
                    return _deepEqual(a, b, strict);
                  }
                  var ka = objectKeys(a);
                  var kb = objectKeys(b);
                  var key, i;
                  // having the same number of owned properties (keys incorporates
                  // hasOwnProperty)
                  if (ka.length !== kb.length) return false;
                  //the same set of keys (although not necessarily the same order),
                  ka.sort();
                  kb.sort();
                  //~~~cheap key test
                  for (i = ka.length - 1; i >= 0; i--) {
                    if (ka[i] !== kb[i]) return false;
                  }
                  //equivalent values for every corresponding key, and
                  //~~~possibly expensive deep test
                  for (i = ka.length - 1; i >= 0; i--) {
                    key = ka[i];
                    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects)) return false;
                  }
                  return true;
                }

                // 8. The non-equivalence assertion tests for any deep inequality.
                // assert.notDeepEqual(actual, expected, message_opt);

                assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
                  if (_deepEqual(actual, expected, false)) {
                    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
                  }
                };

                assert.notDeepStrictEqual = notDeepStrictEqual;
                function notDeepStrictEqual(actual, expected, message) {
                  if (_deepEqual(actual, expected, true)) {
                    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
                  }
                }

                // 9. The strict equality assertion tests strict equality, as determined by ===.
                // assert.strictEqual(actual, expected, message_opt);

                assert.strictEqual = function strictEqual(actual, expected, message) {
                  if (actual !== expected) {
                    fail(actual, expected, message, '===', assert.strictEqual);
                  }
                };

                // 10. The strict non-equality assertion tests for strict inequality, as
                // determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

                assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
                  if (actual === expected) {
                    fail(actual, expected, message, '!==', assert.notStrictEqual);
                  }
                };

                function expectedException(actual, expected) {
                  if (!actual || !expected) {
                    return false;
                  }

                  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
                    return expected.test(actual);
                  }

                  try {
                    if (actual instanceof expected) {
                      return true;
                    }
                  } catch (e) {
                    // Ignore.  The instanceof check doesn't work for arrow functions.
                  }

                  if (Error.isPrototypeOf(expected)) {
                    return false;
                  }

                  return expected.call({}, actual) === true;
                }

                function _tryBlock(block) {
                  var error;
                  try {
                    block();
                  } catch (e) {
                    error = e;
                  }
                  return error;
                }

                function _throws(shouldThrow, block, expected, message) {
                  var actual;

                  if (typeof block !== 'function') {
                    throw new TypeError('"block" argument must be a function');
                  }

                  if (typeof expected === 'string') {
                    message = expected;
                    expected = null;
                  }

                  actual = _tryBlock(block);

                  message =
                    (expected && expected.name ? ' (' + expected.name + ').' : '.') + (message ? ' ' + message : '.');

                  if (shouldThrow && !actual) {
                    fail(actual, expected, 'Missing expected exception' + message);
                  }

                  var userProvidedMessage = typeof message === 'string';
                  var isUnwantedException = !shouldThrow && util.isError(actual);
                  var isUnexpectedException = !shouldThrow && actual && !expected;

                  if (
                    (isUnwantedException && userProvidedMessage && expectedException(actual, expected)) ||
                    isUnexpectedException
                  ) {
                    fail(actual, expected, 'Got unwanted exception' + message);
                  }

                  if (
                    (shouldThrow && actual && expected && !expectedException(actual, expected)) ||
                    (!shouldThrow && actual)
                  ) {
                    throw actual;
                  }
                }

                // 11. Expected to throw an error:
                // assert.throws(block, Error_opt, message_opt);

                assert.throws = function (block, /*optional*/ error, /*optional*/ message) {
                  _throws(true, block, error, message);
                };

                // EXTENSION! This is annoying to write outside this module.
                assert.doesNotThrow = function (block, /*optional*/ error, /*optional*/ message) {
                  _throws(false, block, error, message);
                };

                assert.ifError = function (err) {
                  if (err) throw err;
                };

                // Expose a strict only variant of assert
                function strict(value, message) {
                  if (!value) fail(value, true, message, '==', strict);
                }
                assert.strict = objectAssign(strict, assert, {
                  equal: assert.strictEqual,
                  deepEqual: assert.deepStrictEqual,
                  notEqual: assert.notStrictEqual,
                  notDeepEqual: assert.notDeepStrictEqual
                });
                assert.strict.strict = assert.strict;

                var objectKeys =
                  Object.keys ||
                  function (obj) {
                    var keys = [];
                    for (var key in obj) {
                      if (hasOwn.call(obj, key)) keys.push(key);
                    }
                    return keys;
                  };
              }).call(this);
            }).call(
              this,
              typeof global !== 'undefined'
                ? global
                : typeof self !== 'undefined'
                ? self
                : typeof window !== 'undefined'
                ? window
                : {}
            );
          },
          { 'object-assign': 362, 'util/': 84 }
        ],
        82: [
          function (require, module, exports) {
            if (typeof Object.create === 'function') {
              // implementation from standard node.js 'util' module
              module.exports = function inherits(ctor, superCtor) {
                ctor.super_ = superCtor;
                ctor.prototype = Object.create(superCtor.prototype, {
                  constructor: {
                    value: ctor,
                    enumerable: false,
                    writable: true,
                    configurable: true
                  }
                });
              };
            } else {
              // old school shim for old browsers
              module.exports = function inherits(ctor, superCtor) {
                ctor.super_ = superCtor;
                var TempCtor = function () {};
                TempCtor.prototype = superCtor.prototype;
                ctor.prototype = new TempCtor();
                ctor.prototype.constructor = ctor;
              };
            }
          },
          {}
        ],
        83: [
          function (require, module, exports) {
            module.exports = function isBuffer(arg) {
              return (
                arg &&
                typeof arg === 'object' &&
                typeof arg.copy === 'function' &&
                typeof arg.fill === 'function' &&
                typeof arg.readUInt8 === 'function'
              );
            };
          },
          {}
        ],
        84: [
          function (require, module, exports) {
            (function (process, global) {
              (function () {
                // Copyright Joyent, Inc. and other Node contributors.
                //
                // Permission is hereby granted, free of charge, to any person obtaining a
                // copy of this software and associated documentation files (the
                // "Software"), to deal in the Software without restriction, including
                // without limitation the rights to use, copy, modify, merge, publish,
                // distribute, sublicense, and/or sell copies of the Software, and to permit
                // persons to whom the Software is furnished to do so, subject to the
                // following conditions:
                //
                // The above copyright notice and this permission notice shall be included
                // in all copies or substantial portions of the Software.
                //
                // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
                // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
                // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
                // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
                // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
                // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
                // USE OR OTHER DEALINGS IN THE SOFTWARE.

                var formatRegExp = /%[sdj%]/g;
                exports.format = function (f) {
                  if (!isString(f)) {
                    var objects = [];
                    for (var i = 0; i < arguments.length; i++) {
                      objects.push(inspect(arguments[i]));
                    }
                    return objects.join(' ');
                  }

                  var i = 1;
                  var args = arguments;
                  var len = args.length;
                  var str = String(f).replace(formatRegExp, function (x) {
                    if (x === '%%') return '%';
                    if (i >= len) return x;
                    switch (x) {
                      case '%s':
                        return String(args[i++]);
                      case '%d':
                        return Number(args[i++]);
                      case '%j':
                        try {
                          return JSON.stringify(args[i++]);
                        } catch (_) {
                          return '[Circular]';
                        }
                      default:
                        return x;
                    }
                  });
                  for (var x = args[i]; i < len; x = args[++i]) {
                    if (isNull(x) || !isObject(x)) {
                      str += ' ' + x;
                    } else {
                      str += ' ' + inspect(x);
                    }
                  }
                  return str;
                };

                // Mark that a method should not be used.
                // Returns a modified function which warns once by default.
                // If --no-deprecation is set, then it is a no-op.
                exports.deprecate = function (fn, msg) {
                  // Allow for deprecating things in the process of starting up.
                  if (isUndefined(global.process)) {
                    return function () {
                      return exports.deprecate(fn, msg).apply(this, arguments);
                    };
                  }

                  if (process.noDeprecation === true) {
                    return fn;
                  }

                  var warned = false;
                  function deprecated() {
                    if (!warned) {
                      if (process.throwDeprecation) {
                        throw new Error(msg);
                      } else if (process.traceDeprecation) {
                        console.trace(msg);
                      } else {
                        console.error(msg);
                      }
                      warned = true;
                    }
                    return fn.apply(this, arguments);
                  }

                  return deprecated;
                };

                var debugs = {};
                var debugEnviron;
                exports.debuglog = function (set) {
                  if (isUndefined(debugEnviron)) debugEnviron = process.env.NODE_DEBUG || '';
                  set = set.toUpperCase();
                  if (!debugs[set]) {
                    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
                      var pid = process.pid;
                      debugs[set] = function () {
                        var msg = exports.format.apply(exports, arguments);
                        console.error('%s %d: %s', set, pid, msg);
                      };
                    } else {
                      debugs[set] = function () {};
                    }
                  }
                  return debugs[set];
                };

                /**
                 * Echos the value of a value. Trys to print the value out
                 * in the best way possible given the different types.
                 *
                 * @param {Object} obj The object to print out.
                 * @param {Object} opts Optional options object that alters the output.
                 */
                /* legacy: obj, showHidden, depth, colors*/
                function inspect(obj, opts) {
                  // default options
                  var ctx = {
                    seen: [],
                    stylize: stylizeNoColor
                  };
                  // legacy...
                  if (arguments.length >= 3) ctx.depth = arguments[2];
                  if (arguments.length >= 4) ctx.colors = arguments[3];
                  if (isBoolean(opts)) {
                    // legacy...
                    ctx.showHidden = opts;
                  } else if (opts) {
                    // got an "options" object
                    exports._extend(ctx, opts);
                  }
                  // set default options
                  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
                  if (isUndefined(ctx.depth)) ctx.depth = 2;
                  if (isUndefined(ctx.colors)) ctx.colors = false;
                  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
                  if (ctx.colors) ctx.stylize = stylizeWithColor;
                  return formatValue(ctx, obj, ctx.depth);
                }
                exports.inspect = inspect;

                // http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
                inspect.colors = {
                  bold: [1, 22],
                  italic: [3, 23],
                  underline: [4, 24],
                  inverse: [7, 27],
                  white: [37, 39],
                  grey: [90, 39],
                  black: [30, 39],
                  blue: [34, 39],
                  cyan: [36, 39],
                  green: [32, 39],
                  magenta: [35, 39],
                  red: [31, 39],
                  yellow: [33, 39]
                };

                // Don't use 'blue' not visible on cmd.exe
                inspect.styles = {
                  special: 'cyan',
                  number: 'yellow',
                  boolean: 'yellow',
                  undefined: 'grey',
                  null: 'bold',
                  string: 'green',
                  date: 'magenta',
                  // "name": intentionally not styling
                  regexp: 'red'
                };

                function stylizeWithColor(str, styleType) {
                  var style = inspect.styles[styleType];

                  if (style) {
                    return (
                      '\u001b[' + inspect.colors[style][0] + 'm' + str + '\u001b[' + inspect.colors[style][1] + 'm'
                    );
                  } else {
                    return str;
                  }
                }

                function stylizeNoColor(str, styleType) {
                  return str;
                }

                function arrayToHash(array) {
                  var hash = {};

                  array.forEach(function (val, idx) {
                    hash[val] = true;
                  });

                  return hash;
                }

                function formatValue(ctx, value, recurseTimes) {
                  // Provide a hook for user-specified inspect functions.
                  // Check that value is an object with an inspect function on it
                  if (
                    ctx.customInspect &&
                    value &&
                    isFunction(value.inspect) &&
                    // Filter out the util module, it's inspect function is special
                    value.inspect !== exports.inspect &&
                    // Also filter out any prototype objects using the circular check.
                    !(value.constructor && value.constructor.prototype === value)
                  ) {
                    var ret = value.inspect(recurseTimes, ctx);
                    if (!isString(ret)) {
                      ret = formatValue(ctx, ret, recurseTimes);
                    }
                    return ret;
                  }

                  // Primitive types cannot have properties
                  var primitive = formatPrimitive(ctx, value);
                  if (primitive) {
                    return primitive;
                  }

                  // Look up the keys of the object.
                  var keys = Object.keys(value);
                  var visibleKeys = arrayToHash(keys);

                  if (ctx.showHidden) {
                    keys = Object.getOwnPropertyNames(value);
                  }

                  // IE doesn't make error fields non-enumerable
                  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
                  if (isError(value) && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
                    return formatError(value);
                  }

                  // Some type of object without properties can be shortcutted.
                  if (keys.length === 0) {
                    if (isFunction(value)) {
                      var name = value.name ? ': ' + value.name : '';
                      return ctx.stylize('[Function' + name + ']', 'special');
                    }
                    if (isRegExp(value)) {
                      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
                    }
                    if (isDate(value)) {
                      return ctx.stylize(Date.prototype.toString.call(value), 'date');
                    }
                    if (isError(value)) {
                      return formatError(value);
                    }
                  }

                  var base = '',
                    array = false,
                    braces = ['{', '}'];

                  // Make Array say that they are Array
                  if (isArray(value)) {
                    array = true;
                    braces = ['[', ']'];
                  }

                  // Make functions say that they are functions
                  if (isFunction(value)) {
                    var n = value.name ? ': ' + value.name : '';
                    base = ' [Function' + n + ']';
                  }

                  // Make RegExps say that they are RegExps
                  if (isRegExp(value)) {
                    base = ' ' + RegExp.prototype.toString.call(value);
                  }

                  // Make dates with properties first say the date
                  if (isDate(value)) {
                    base = ' ' + Date.prototype.toUTCString.call(value);
                  }

                  // Make error with message first say the error
                  if (isError(value)) {
                    base = ' ' + formatError(value);
                  }

                  if (keys.length === 0 && (!array || value.length == 0)) {
                    return braces[0] + base + braces[1];
                  }

                  if (recurseTimes < 0) {
                    if (isRegExp(value)) {
                      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
                    } else {
                      return ctx.stylize('[Object]', 'special');
                    }
                  }

                  ctx.seen.push(value);

                  var output;
                  if (array) {
                    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
                  } else {
                    output = keys.map(function (key) {
                      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
                    });
                  }

                  ctx.seen.pop();

                  return reduceToSingleString(output, base, braces);
                }

                function formatPrimitive(ctx, value) {
                  if (isUndefined(value)) return ctx.stylize('undefined', 'undefined');
                  if (isString(value)) {
                    var simple =
                      "'" + JSON.stringify(value).replace(/^"|"$/g, '').replace(/'/g, "\\'").replace(/\\"/g, '"') + "'";
                    return ctx.stylize(simple, 'string');
                  }
                  if (isNumber(value)) return ctx.stylize('' + value, 'number');
                  if (isBoolean(value)) return ctx.stylize('' + value, 'boolean');
                  // For some reason typeof null is "object", so special case here.
                  if (isNull(value)) return ctx.stylize('null', 'null');
                }

                function formatError(value) {
                  return '[' + Error.prototype.toString.call(value) + ']';
                }

                function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
                  var output = [];
                  for (var i = 0, l = value.length; i < l; ++i) {
                    if (hasOwnProperty(value, String(i))) {
                      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys, String(i), true));
                    } else {
                      output.push('');
                    }
                  }
                  keys.forEach(function (key) {
                    if (!key.match(/^\d+$/)) {
                      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys, key, true));
                    }
                  });
                  return output;
                }

                function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
                  var name, str, desc;
                  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
                  if (desc.get) {
                    if (desc.set) {
                      str = ctx.stylize('[Getter/Setter]', 'special');
                    } else {
                      str = ctx.stylize('[Getter]', 'special');
                    }
                  } else {
                    if (desc.set) {
                      str = ctx.stylize('[Setter]', 'special');
                    }
                  }
                  if (!hasOwnProperty(visibleKeys, key)) {
                    name = '[' + key + ']';
                  }
                  if (!str) {
                    if (ctx.seen.indexOf(desc.value) < 0) {
                      if (isNull(recurseTimes)) {
                        str = formatValue(ctx, desc.value, null);
                      } else {
                        str = formatValue(ctx, desc.value, recurseTimes - 1);
                      }
                      if (str.indexOf('\n') > -1) {
                        if (array) {
                          str = str
                            .split('\n')
                            .map(function (line) {
                              return '  ' + line;
                            })
                            .join('\n')
                            .substr(2);
                        } else {
                          str =
                            '\n' +
                            str
                              .split('\n')
                              .map(function (line) {
                                return '   ' + line;
                              })
                              .join('\n');
                        }
                      }
                    } else {
                      str = ctx.stylize('[Circular]', 'special');
                    }
                  }
                  if (isUndefined(name)) {
                    if (array && key.match(/^\d+$/)) {
                      return str;
                    }
                    name = JSON.stringify('' + key);
                    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
                      name = name.substr(1, name.length - 2);
                      name = ctx.stylize(name, 'name');
                    } else {
                      name = name
                        .replace(/'/g, "\\'")
                        .replace(/\\"/g, '"')
                        .replace(/(^"|"$)/g, "'");
                      name = ctx.stylize(name, 'string');
                    }
                  }

                  return name + ': ' + str;
                }

                function reduceToSingleString(output, base, braces) {
                  var numLinesEst = 0;
                  var length = output.reduce(function (prev, cur) {
                    numLinesEst++;
                    if (cur.indexOf('\n') >= 0) numLinesEst++;
                    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
                  }, 0);

                  if (length > 60) {
                    return braces[0] + (base === '' ? '' : base + '\n ') + ' ' + output.join(',\n  ') + ' ' + braces[1];
                  }

                  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
                }

                // NOTE: These type checking functions intentionally don't use `instanceof`
                // because it is fragile and can be easily faked with `Object.create()`.
                function isArray(ar) {
                  return Array.isArray(ar);
                }
                exports.isArray = isArray;

                function isBoolean(arg) {
                  return typeof arg === 'boolean';
                }
                exports.isBoolean = isBoolean;

                function isNull(arg) {
                  return arg === null;
                }
                exports.isNull = isNull;

                function isNullOrUndefined(arg) {
                  return arg == null;
                }
                exports.isNullOrUndefined = isNullOrUndefined;

                function isNumber(arg) {
                  return typeof arg === 'number';
                }
                exports.isNumber = isNumber;

                function isString(arg) {
                  return typeof arg === 'string';
                }
                exports.isString = isString;

                function isSymbol(arg) {
                  return typeof arg === 'symbol';
                }
                exports.isSymbol = isSymbol;

                function isUndefined(arg) {
                  return arg === void 0;
                }
                exports.isUndefined = isUndefined;

                function isRegExp(re) {
                  return isObject(re) && objectToString(re) === '[object RegExp]';
                }
                exports.isRegExp = isRegExp;

                function isObject(arg) {
                  return typeof arg === 'object' && arg !== null;
                }
                exports.isObject = isObject;

                function isDate(d) {
                  return isObject(d) && objectToString(d) === '[object Date]';
                }
                exports.isDate = isDate;

                function isError(e) {
                  return isObject(e) && (objectToString(e) === '[object Error]' || e instanceof Error);
                }
                exports.isError = isError;

                function isFunction(arg) {
                  return typeof arg === 'function';
                }
                exports.isFunction = isFunction;

                function isPrimitive(arg) {
                  return (
                    arg === null ||
                    typeof arg === 'boolean' ||
                    typeof arg === 'number' ||
                    typeof arg === 'string' ||
                    typeof arg === 'symbol' || // ES6 symbol
                    typeof arg === 'undefined'
                  );
                }
                exports.isPrimitive = isPrimitive;

                exports.isBuffer = require('./support/isBuffer');

                function objectToString(o) {
                  return Object.prototype.toString.call(o);
                }

                function pad(n) {
                  return n < 10 ? '0' + n.toString(10) : n.toString(10);
                }

                var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

                // 26 Feb 16:19:34
                function timestamp() {
                  var d = new Date();
                  var time = [pad(d.getHours()), pad(d.getMinutes()), pad(d.getSeconds())].join(':');
                  return [d.getDate(), months[d.getMonth()], time].join(' ');
                }

                // log is just a thin wrapper to console.log that prepends a timestamp
                exports.log = function () {
                  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
                };

                /**
                 * Inherit the prototype methods from one constructor into another.
                 *
                 * The Function.prototype.inherits from lang.js rewritten as a standalone
                 * function (not on Function.prototype). NOTE: If this file is to be loaded
                 * during bootstrapping this function needs to be rewritten using some native
                 * functions as prototype setup using normal JavaScript does not work as
                 * expected during bootstrapping (see mirror.js in r114903).
                 *
                 * @param {function} ctor Constructor function which needs to inherit the
                 *     prototype.
                 * @param {function} superCtor Constructor function to inherit prototype from.
                 */
                exports.inherits = require('inherits');

                exports._extend = function (origin, add) {
                  // Don't do anything if add isn't an object
                  if (!add || !isObject(add)) return origin;

                  var keys = Object.keys(add);
                  var i = keys.length;
                  while (i--) {
                    origin[keys[i]] = add[keys[i]];
                  }
                  return origin;
                };

                function hasOwnProperty(obj, prop) {
                  return Object.prototype.hasOwnProperty.call(obj, prop);
                }
              }).call(this);
            }).call(
              this,
              require('_process'),
              typeof global !== 'undefined'
                ? global
                : typeof self !== 'undefined'
                ? self
                : typeof window !== 'undefined'
                ? window
                : {}
            );
          },
          { './support/isBuffer': 83, _process: 441, inherits: 82 }
        ],
        85: [
          function (require, module, exports) {
            'use strict';

            exports.byteLength = byteLength;
            exports.toByteArray = toByteArray;
            exports.fromByteArray = fromByteArray;

            var lookup = [];
            var revLookup = [];
            var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;

            var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
            for (var i = 0, len = code.length; i < len; ++i) {
              lookup[i] = code[i];
              revLookup[code.charCodeAt(i)] = i;
            }

            // Support decoding URL-safe base64 strings, as Node.js does.
            // See: https://en.wikipedia.org/wiki/Base64#URL_applications
            revLookup['-'.charCodeAt(0)] = 62;
            revLookup['_'.charCodeAt(0)] = 63;

            function getLens(b64) {
              var len = b64.length;

              if (len % 4 > 0) {
                throw new Error('Invalid string. Length must be a multiple of 4');
              }

              // Trim off extra bytes after placeholder bytes are found
              // See: https://github.com/beatgammit/base64-js/issues/42
              var validLen = b64.indexOf('=');
              if (validLen === -1) validLen = len;

              var placeHoldersLen = validLen === len ? 0 : 4 - (validLen % 4);

              return [validLen, placeHoldersLen];
            }

            // base64 is 4/3 + up to two characters of the original data
            function byteLength(b64) {
              var lens = getLens(b64);
              var validLen = lens[0];
              var placeHoldersLen = lens[1];
              return ((validLen + placeHoldersLen) * 3) / 4 - placeHoldersLen;
            }

            function _byteLength(b64, validLen, placeHoldersLen) {
              return ((validLen + placeHoldersLen) * 3) / 4 - placeHoldersLen;
            }

            function toByteArray(b64) {
              var tmp;
              var lens = getLens(b64);
              var validLen = lens[0];
              var placeHoldersLen = lens[1];

              var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));

              var curByte = 0;

              // if there are placeholders, only get up to the last complete 4 chars
              var len = placeHoldersLen > 0 ? validLen - 4 : validLen;

              var i;
              for (i = 0; i < len; i += 4) {
                tmp =
                  (revLookup[b64.charCodeAt(i)] << 18) |
                  (revLookup[b64.charCodeAt(i + 1)] << 12) |
                  (revLookup[b64.charCodeAt(i + 2)] << 6) |
                  revLookup[b64.charCodeAt(i + 3)];
                arr[curByte++] = (tmp >> 16) & 0xff;
                arr[curByte++] = (tmp >> 8) & 0xff;
                arr[curByte++] = tmp & 0xff;
              }

              if (placeHoldersLen === 2) {
                tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
                arr[curByte++] = tmp & 0xff;
              }

              if (placeHoldersLen === 1) {
                tmp =
                  (revLookup[b64.charCodeAt(i)] << 10) |
                  (revLookup[b64.charCodeAt(i + 1)] << 4) |
                  (revLookup[b64.charCodeAt(i + 2)] >> 2);
                arr[curByte++] = (tmp >> 8) & 0xff;
                arr[curByte++] = tmp & 0xff;
              }

              return arr;
            }

            function tripletToBase64(num) {
              return (
                lookup[(num >> 18) & 0x3f] + lookup[(num >> 12) & 0x3f] + lookup[(num >> 6) & 0x3f] + lookup[num & 0x3f]
              );
            }

            function encodeChunk(uint8, start, end) {
              var tmp;
              var output = [];
              for (var i = start; i < end; i += 3) {
                tmp = ((uint8[i] << 16) & 0xff0000) + ((uint8[i + 1] << 8) & 0xff00) + (uint8[i + 2] & 0xff);
                output.push(tripletToBase64(tmp));
              }
              return output.join('');
            }

            function fromByteArray(uint8) {
              var tmp;
              var len = uint8.length;
              var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
              var parts = [];
              var maxChunkLength = 16383; // must be multiple of 3

              // go through the array every three bytes, we'll deal with trailing stuff later
              for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
                parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
              }

              // pad the end with zeros, but make sure to not forget the extra bytes
              if (extraBytes === 1) {
                tmp = uint8[len - 1];
                parts.push(lookup[tmp >> 2] + lookup[(tmp << 4) & 0x3f] + '==');
              } else if (extraBytes === 2) {
                tmp = (uint8[len - 2] << 8) + uint8[len - 1];
                parts.push(lookup[tmp >> 10] + lookup[(tmp >> 4) & 0x3f] + lookup[(tmp << 2) & 0x3f] + '=');
              }

              return parts.join('');
            }
          },
          {}
        ],
        86: [
          function (require, module, exports) {
            /*!
             * Bowser - a browser detector
             * https://github.com/ded/bowser
             * MIT License | (c) Dustin Diaz 2015
             */

            !(function (root, name, definition) {
              if (typeof module != 'undefined' && module.exports) module.exports = definition();
              else if (typeof define == 'function' && define.amd) define(name, definition);
              else root[name] = definition();
            })(this, 'bowser', function () {
              /**
               * See useragents.js for examples of navigator.userAgent
               */

              var t = true;

              function detect(ua) {
                function getFirstMatch(regex) {
                  var match = ua.match(regex);
                  return (match && match.length > 1 && match[1]) || '';
                }

                function getSecondMatch(regex) {
                  var match = ua.match(regex);
                  return (match && match.length > 1 && match[2]) || '';
                }

                var iosdevice = getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),
                  likeAndroid = /like android/i.test(ua),
                  android = !likeAndroid && /android/i.test(ua),
                  nexusMobile = /nexus\s*[0-6]\s*/i.test(ua),
                  nexusTablet = !nexusMobile && /nexus\s*[0-9]+/i.test(ua),
                  chromeos = /CrOS/.test(ua),
                  silk = /silk/i.test(ua),
                  sailfish = /sailfish/i.test(ua),
                  tizen = /tizen/i.test(ua),
                  webos = /(web|hpw)(o|0)s/i.test(ua),
                  windowsphone = /windows phone/i.test(ua),
                  samsungBrowser = /SamsungBrowser/i.test(ua),
                  windows = !windowsphone && /windows/i.test(ua),
                  mac = !iosdevice && !silk && /macintosh/i.test(ua),
                  linux = !android && !sailfish && !tizen && !webos && /linux/i.test(ua),
                  edgeVersion = getSecondMatch(/edg([ea]|ios)\/(\d+(\.\d+)?)/i),
                  versionIdentifier = getFirstMatch(/version\/(\d+(\.\d+)?)/i),
                  tablet = /tablet/i.test(ua) && !/tablet pc/i.test(ua),
                  mobile = !tablet && /[^-]mobi/i.test(ua),
                  xbox = /xbox/i.test(ua),
                  result;

                if (/opera/i.test(ua)) {
                  //  an old Opera
                  result = {
                    name: 'Opera',
                    opera: t,
                    version: versionIdentifier || getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)
                  };
                } else if (/opr\/|opios/i.test(ua)) {
                  // a new Opera
                  result = {
                    name: 'Opera',
                    opera: t,
                    version: getFirstMatch(/(?:opr|opios)[\s\/](\d+(\.\d+)?)/i) || versionIdentifier
                  };
                } else if (/SamsungBrowser/i.test(ua)) {
                  result = {
                    name: 'Samsung Internet for Android',
                    samsungBrowser: t,
                    version: versionIdentifier || getFirstMatch(/(?:SamsungBrowser)[\s\/](\d+(\.\d+)?)/i)
                  };
                } else if (/Whale/i.test(ua)) {
                  result = {
                    name: 'NAVER Whale browser',
                    whale: t,
                    version: getFirstMatch(/(?:whale)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/MZBrowser/i.test(ua)) {
                  result = {
                    name: 'MZ Browser',
                    mzbrowser: t,
                    version: getFirstMatch(/(?:MZBrowser)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/coast/i.test(ua)) {
                  result = {
                    name: 'Opera Coast',
                    coast: t,
                    version: versionIdentifier || getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)
                  };
                } else if (/focus/i.test(ua)) {
                  result = {
                    name: 'Focus',
                    focus: t,
                    version: getFirstMatch(/(?:focus)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/yabrowser/i.test(ua)) {
                  result = {
                    name: 'Yandex Browser',
                    yandexbrowser: t,
                    version: versionIdentifier || getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)
                  };
                } else if (/ucbrowser/i.test(ua)) {
                  result = {
                    name: 'UC Browser',
                    ucbrowser: t,
                    version: getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/mxios/i.test(ua)) {
                  result = {
                    name: 'Maxthon',
                    maxthon: t,
                    version: getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/epiphany/i.test(ua)) {
                  result = {
                    name: 'Epiphany',
                    epiphany: t,
                    version: getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/puffin/i.test(ua)) {
                  result = {
                    name: 'Puffin',
                    puffin: t,
                    version: getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)
                  };
                } else if (/sleipnir/i.test(ua)) {
                  result = {
                    name: 'Sleipnir',
                    sleipnir: t,
                    version: getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (/k-meleon/i.test(ua)) {
                  result = {
                    name: 'K-Meleon',
                    kMeleon: t,
                    version: getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)
                  };
                } else if (windowsphone) {
                  result = {
                    name: 'Windows Phone',
                    osname: 'Windows Phone',
                    windowsphone: t
                  };
                  if (edgeVersion) {
                    result.msedge = t;
                    result.version = edgeVersion;
                  } else {
                    result.msie = t;
                    result.version = getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i);
                  }
                } else if (/msie|trident/i.test(ua)) {
                  result = {
                    name: 'Internet Explorer',
                    msie: t,
                    version: getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)
                  };
                } else if (chromeos) {
                  result = {
                    name: 'Chrome',
                    osname: 'Chrome OS',
                    chromeos: t,
                    chromeBook: t,
                    chrome: t,
                    version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
                  };
                } else if (/edg([ea]|ios)/i.test(ua)) {
                  result = {
                    name: 'Microsoft Edge',
                    msedge: t,
                    version: edgeVersion
                  };
                } else if (/vivaldi/i.test(ua)) {
                  result = {
                    name: 'Vivaldi',
                    vivaldi: t,
                    version: getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i) || versionIdentifier
                  };
                } else if (sailfish) {
                  result = {
                    name: 'Sailfish',
                    osname: 'Sailfish OS',
                    sailfish: t,
                    version: getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)
                  };
                } else if (/seamonkey\//i.test(ua)) {
                  result = {
                    name: 'SeaMonkey',
                    seamonkey: t,
                    version: getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)
                  };
                } else if (/firefox|iceweasel|fxios/i.test(ua)) {
                  result = {
                    name: 'Firefox',
                    firefox: t,
                    version: getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)
                  };
                  if (/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)) {
                    result.firefoxos = t;
                    result.osname = 'Firefox OS';
                  }
                } else if (silk) {
                  result = {
                    name: 'Amazon Silk',
                    silk: t,
                    version: getFirstMatch(/silk\/(\d+(\.\d+)?)/i)
                  };
                } else if (/phantom/i.test(ua)) {
                  result = {
                    name: 'PhantomJS',
                    phantom: t,
                    version: getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)
                  };
                } else if (/slimerjs/i.test(ua)) {
                  result = {
                    name: 'SlimerJS',
                    slimer: t,
                    version: getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)
                  };
                } else if (/blackberry|\bbb\d+/i.test(ua) || /rim\stablet/i.test(ua)) {
                  result = {
                    name: 'BlackBerry',
                    osname: 'BlackBerry OS',
                    blackberry: t,
                    version: versionIdentifier || getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)
                  };
                } else if (webos) {
                  result = {
                    name: 'WebOS',
                    osname: 'WebOS',
                    webos: t,
                    version: versionIdentifier || getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)
                  };
                  /touchpad\//i.test(ua) && (result.touchpad = t);
                } else if (/bada/i.test(ua)) {
                  result = {
                    name: 'Bada',
                    osname: 'Bada',
                    bada: t,
                    version: getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)
                  };
                } else if (tizen) {
                  result = {
                    name: 'Tizen',
                    osname: 'Tizen',
                    tizen: t,
                    version: getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i) || versionIdentifier
                  };
                } else if (/qupzilla/i.test(ua)) {
                  result = {
                    name: 'QupZilla',
                    qupzilla: t,
                    version: getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i) || versionIdentifier
                  };
                } else if (/chromium/i.test(ua)) {
                  result = {
                    name: 'Chromium',
                    chromium: t,
                    version: getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i) || versionIdentifier
                  };
                } else if (/chrome|crios|crmo/i.test(ua)) {
                  result = {
                    name: 'Chrome',
                    chrome: t,
                    version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
                  };
                } else if (android) {
                  result = {
                    name: 'Android',
                    version: versionIdentifier
                  };
                } else if (/safari|applewebkit/i.test(ua)) {
                  result = {
                    name: 'Safari',
                    safari: t
                  };
                  if (versionIdentifier) {
                    result.version = versionIdentifier;
                  }
                } else if (iosdevice) {
                  result = {
                    name: iosdevice == 'iphone' ? 'iPhone' : iosdevice == 'ipad' ? 'iPad' : 'iPod'
                  };
                  // WTF: version is not part of user agent in web apps
                  if (versionIdentifier) {
                    result.version = versionIdentifier;
                  }
                } else if (/googlebot/i.test(ua)) {
                  result = {
                    name: 'Googlebot',
                    googlebot: t,
                    version: getFirstMatch(/googlebot\/(\d+(\.\d+))/i) || versionIdentifier
                  };
                } else {
                  result = {
                    name: getFirstMatch(/^(.*)\/(.*) /),
                    version: getSecondMatch(/^(.*)\/(.*) /)
                  };
                }

                // set webkit or gecko flag for browsers based on these engines
                if (!result.msedge && /(apple)?webkit/i.test(ua)) {
                  if (/(apple)?webkit\/537\.36/i.test(ua)) {
                    result.name = result.name || 'Blink';
                    result.blink = t;
                  } else {
                    result.name = result.name || 'Webkit';
                    result.webkit = t;
                  }
                  if (!result.version && versionIdentifier) {
                    result.version = versionIdentifier;
                  }
                } else if (!result.opera && /gecko\//i.test(ua)) {
                  result.name = result.name || 'Gecko';
                  result.gecko = t;
                  result.version = result.version || getFirstMatch(/gecko\/(\d+(\.\d+)?)/i);
                }

                // set OS flags for platforms that have multiple browsers
                if (!result.windowsphone && (android || result.silk)) {
                  result.android = t;
                  result.osname = 'Android';
                } else if (!result.windowsphone && iosdevice) {
                  result[iosdevice] = t;
                  result.ios = t;
                  result.osname = 'iOS';
                } else if (mac) {
                  result.mac = t;
                  result.osname = 'macOS';
                } else if (xbox) {
                  result.xbox = t;
                  result.osname = 'Xbox';
                } else if (windows) {
                  result.windows = t;
                  result.osname = 'Windows';
                } else if (linux) {
                  result.linux = t;
                  result.osname = 'Linux';
                }

                function getWindowsVersion(s) {
                  switch (s) {
                    case 'NT':
                      return 'NT';
                    case 'XP':
                      return 'XP';
                    case 'NT 5.0':
                      return '2000';
                    case 'NT 5.1':
                      return 'XP';
                    case 'NT 5.2':
                      return '2003';
                    case 'NT 6.0':
                      return 'Vista';
                    case 'NT 6.1':
                      return '7';
                    case 'NT 6.2':
                      return '8';
                    case 'NT 6.3':
                      return '8.1';
                    case 'NT 10.0':
                      return '10';
                    default:
                      return undefined;
                  }
                }

                // OS version extraction
                var osVersion = '';
                if (result.windows) {
                  osVersion = getWindowsVersion(getFirstMatch(/Windows ((NT|XP)( \d\d?.\d)?)/i));
                } else if (result.windowsphone) {
                  osVersion = getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);
                } else if (result.mac) {
                  osVersion = getFirstMatch(/Mac OS X (\d+([_\.\s]\d+)*)/i);
                  osVersion = osVersion.replace(/[_\s]/g, '.');
                } else if (iosdevice) {
                  osVersion = getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);
                  osVersion = osVersion.replace(/[_\s]/g, '.');
                } else if (android) {
                  osVersion = getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);
                } else if (result.webos) {
                  osVersion = getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);
                } else if (result.blackberry) {
                  osVersion = getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);
                } else if (result.bada) {
                  osVersion = getFirstMatch(/bada\/(\d+(\.\d+)*)/i);
                } else if (result.tizen) {
                  osVersion = getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);
                }
                if (osVersion) {
                  result.osversion = osVersion;
                }

                // device type extraction
                var osMajorVersion = !result.windows && osVersion.split('.')[0];
                if (
                  tablet ||
                  nexusTablet ||
                  iosdevice == 'ipad' ||
                  (android && (osMajorVersion == 3 || (osMajorVersion >= 4 && !mobile))) ||
                  result.silk
                ) {
                  result.tablet = t;
                } else if (
                  mobile ||
                  iosdevice == 'iphone' ||
                  iosdevice == 'ipod' ||
                  android ||
                  nexusMobile ||
                  result.blackberry ||
                  result.webos ||
                  result.bada
                ) {
                  result.mobile = t;
                }

                // Graded Browser Support
                // http://developer.yahoo.com/yui/articles/gbs
                if (
                  result.msedge ||
                  (result.msie && result.version >= 10) ||
                  (result.yandexbrowser && result.version >= 15) ||
                  (result.vivaldi && result.version >= 1.0) ||
                  (result.chrome && result.version >= 20) ||
                  (result.samsungBrowser && result.version >= 4) ||
                  (result.whale && compareVersions([result.version, '1.0']) === 1) ||
                  (result.mzbrowser && compareVersions([result.version, '6.0']) === 1) ||
                  (result.focus && compareVersions([result.version, '1.0']) === 1) ||
                  (result.firefox && result.version >= 20.0) ||
                  (result.safari && result.version >= 6) ||
                  (result.opera && result.version >= 10.0) ||
                  (result.ios && result.osversion && result.osversion.split('.')[0] >= 6) ||
                  (result.blackberry && result.version >= 10.1) ||
                  (result.chromium && result.version >= 20)
                ) {
                  result.a = t;
                } else if (
                  (result.msie && result.version < 10) ||
                  (result.chrome && result.version < 20) ||
                  (result.firefox && result.version < 20.0) ||
                  (result.safari && result.version < 6) ||
                  (result.opera && result.version < 10.0) ||
                  (result.ios && result.osversion && result.osversion.split('.')[0] < 6) ||
                  (result.chromium && result.version < 20)
                ) {
                  result.c = t;
                } else result.x = t;

                return result;
              }

              var bowser = detect(typeof navigator !== 'undefined' ? navigator.userAgent || '' : '');

              bowser.test = function (browserList) {
                for (var i = 0; i < browserList.length; ++i) {
                  var browserItem = browserList[i];
                  if (typeof browserItem === 'string') {
                    if (browserItem in bowser) {
                      return true;
                    }
                  }
                }
                return false;
              };

              /**
               * Get version precisions count
               *
               * @example
               *   getVersionPrecision("1.10.3") // 3
               *
               * @param  {string} version
               * @return {number}
               */
              function getVersionPrecision(version) {
                return version.split('.').length;
              }

              /**
               * Array::map polyfill
               *
               * @param  {Array} arr
               * @param  {Function} iterator
               * @return {Array}
               */
              function map(arr, iterator) {
                var result = [],
                  i;
                if (Array.prototype.map) {
                  return Array.prototype.map.call(arr, iterator);
                }
                for (i = 0; i < arr.length; i++) {
                  result.push(iterator(arr[i]));
                }
                return result;
              }

              /**
               * Calculate browser version weight
               *
               * @example
               *   compareVersions(['1.10.2.1',  '1.8.2.1.90'])    // 1
               *   compareVersions(['1.010.2.1', '1.09.2.1.90']);  // 1
               *   compareVersions(['1.10.2.1',  '1.10.2.1']);     // 0
               *   compareVersions(['1.10.2.1',  '1.0800.2']);     // -1
               *
               * @param  {Array<String>} versions versions to compare
               * @return {Number} comparison result
               */
              function compareVersions(versions) {
                // 1) get common precision for both versions, for example for "10.0" and "9" it should be 2
                var precision = Math.max(getVersionPrecision(versions[0]), getVersionPrecision(versions[1]));
                var chunks = map(versions, function (version) {
                  var delta = precision - getVersionPrecision(version);

                  // 2) "9" -> "9.0" (for precision = 2)
                  version = version + new Array(delta + 1).join('.0');

                  // 3) "9.0" -> ["000000000"", "000000009"]
                  return map(version.split('.'), function (chunk) {
                    return new Array(20 - chunk.length).join('0') + chunk;
                  }).reverse();
                });

                // iterate in reverse order by reversed chunks array
                while (--precision >= 0) {
                  // 4) compare: "000000009" > "000000010" = false (but "9" > "10" = true)
                  if (chunks[0][precision] > chunks[1][precision]) {
                    return 1;
                  } else if (chunks[0][precision] === chunks[1][precision]) {
                    if (precision === 0) {
                      // all version chunks are same
                      return 0;
                    }
                  } else {
                    return -1;
                  }
                }
              }

              /**
               * Check if browser is unsupported
               *
               * @example
               *   bowser.isUnsupportedBrowser({
               *     msie: "10",
               *     firefox: "23",
               *     chrome: "29",
               *     safari: "5.1",
               *     opera: "16",
               *     phantom: "534"
               *   });
               *
               * @param  {Object}  minVersions map of minimal version to browser
               * @param  {Boolean} [strictMode = false] flag to return false if browser wasn't found in map
               * @param  {String}  [ua] user agent string
               * @return {Boolean}
               */
              function isUnsupportedBrowser(minVersions, strictMode, ua) {
                var _bowser = bowser;

                // make strictMode param optional with ua param usage
                if (typeof strictMode === 'string') {
                  ua = strictMode;
                  strictMode = void 0;
                }

                if (strictMode === void 0) {
                  strictMode = false;
                }
                if (ua) {
                  _bowser = detect(ua);
                }

                var version = '' + _bowser.version;
                for (var browser in minVersions) {
                  if (minVersions.hasOwnProperty(browser)) {
                    if (_bowser[browser]) {
                      if (typeof minVersions[browser] !== 'string') {
                        throw new Error(
                          'Browser version in the minVersion map should be a string: ' +
                            browser +
                            ': ' +
                            String(minVersions)
                        );
                      }

                      // browser version and min supported version.
                      return compareVersions([version, minVersions[browser]]) < 0;
                    }
                  }
                }

                return strictMode; // not found
              }

              /**
               * Check if browser is supported
               *
               * @param  {Object} minVersions map of minimal version to browser
               * @param  {Boolean} [strictMode = false] flag to return false if browser wasn't found in map
               * @param  {String}  [ua] user agent string
               * @return {Boolean}
               */
              function check(minVersions, strictMode, ua) {
                return !isUnsupportedBrowser(minVersions, strictMode, ua);
              }

              bowser.isUnsupportedBrowser = isUnsupportedBrowser;
              bowser.compareVersions = compareVersions;
              bowser.check = check;

              /*
               * Set our detect method to the main bowser object so we can
               * reuse it to test other user agents.
               * This is needed to implement future tests.
               */
              bowser._detect = detect;

              /*
               * Set our detect public method to the main bowser object
               * This is needed to implement bowser in server side
               */
              bowser.detect = detect;
              return bowser;
            });
          },
          {}
        ],
        87: [function (require, module, exports) {}, {}],
        88: [
          function (require, module, exports) {
            // Copyright Joyent, Inc. and other Node contributors.
            //
            // Permission is hereby granted, free of charge, to any person obtaining a
            // copy of this software and associated documentation files (the
            // "Software"), to deal in the Software without restriction, including
            // without limitation the rights to use, copy, modify, merge, publish,
            // distribute, sublicense, and/or sell copies of the Software, and to permit
            // persons to whom the Software is furnished to do so, subject to the
            // following conditions:
            //
            // The above copyright notice and this permission notice shall be included
            // in all copies or substantial portions of the Software.
            //
            // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
            // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
            // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
            // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
            // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
            // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
            // USE OR OTHER DEALINGS IN THE SOFTWARE.

            var Buffer = require('buffer').Buffer;

            var isBufferEncoding =
              Buffer.isEncoding ||
              function (encoding) {
                switch (encoding && encoding.toLowerCase()) {
                  case 'hex':
                  case 'utf8':
                  case 'utf-8':
                  case 'ascii':
                  case 'binary':
                  case 'base64':
                  case 'ucs2':
                  case 'ucs-2':
                  case 'utf16le':
                  case 'utf-16le':
                  case 'raw':
                    return true;
                  default:
                    return false;
                }
              };

            function assertEncoding(encoding) {
              if (encoding && !isBufferEncoding(encoding)) {
                throw new Error('Unknown encoding: ' + encoding);
              }
            }

            // StringDecoder provides an interface for efficiently splitting a series of
            // buffers into a series of JS strings without breaking apart multi-byte
            // characters. CESU-8 is handled as part of the UTF-8 encoding.
            //
            // @TODO Handling all encodings inside a single object makes it very difficult
            // to reason about this code, so it should be split up in the future.
            // @TODO There should be a utf8-strict encoding that rejects invalid UTF-8 code
            // points as used by CESU-8.
            var StringDecoder = (exports.StringDecoder = function (encoding) {
              this.encoding = (encoding || 'utf8').toLowerCase().replace(/[-_]/, '');
              assertEncoding(encoding);
              switch (this.encoding) {
                case 'utf8':
                  // CESU-8 represents each of Surrogate Pair by 3-bytes
                  this.surrogateSize = 3;
                  break;
                case 'ucs2':
                case 'utf16le':
                  // UTF-16 represents each of Surrogate Pair by 2-bytes
                  this.surrogateSize = 2;
                  this.detectIncompleteChar = utf16DetectIncompleteChar;
                  break;
                case 'base64':
                  // Base-64 stores 3 bytes in 4 chars, and pads the remainder.
                  this.surrogateSize = 3;
                  this.detectIncompleteChar = base64DetectIncompleteChar;
                  break;
                default:
                  this.write = passThroughWrite;
                  return;
              }

              // Enough space to store all bytes of a single character. UTF-8 needs 4
              // bytes, but CESU-8 may require up to 6 (3 bytes per surrogate).
              this.charBuffer = new Buffer(6);
              // Number of bytes received for the current incomplete multi-byte character.
              this.charReceived = 0;
              // Number of bytes expected for the current incomplete multi-byte character.
              this.charLength = 0;
            });

            // write decodes the given buffer and returns it as JS string that is
            // guaranteed to not contain any partial multi-byte characters. Any partial
            // character found at the end of the buffer is buffered up, and will be
            // returned when calling write again with the remaining bytes.
            //
            // Note: Converting a Buffer containing an orphan surrogate to a String
            // currently works, but converting a String to a Buffer (via `new Buffer`, or
            // Buffer#write) will replace incomplete surrogates with the unicode
            // replacement character. See https://codereview.chromium.org/121173009/ .
            StringDecoder.prototype.write = function (buffer) {
              var charStr = '';
              // if our last write ended with an incomplete multibyte character
              while (this.charLength) {
                // determine how many remaining bytes this buffer has to offer for this char
                var available =
                  buffer.length >= this.charLength - this.charReceived
                    ? this.charLength - this.charReceived
                    : buffer.length;

                // add the new bytes to the char buffer
                buffer.copy(this.charBuffer, this.charReceived, 0, available);
                this.charReceived += available;

                if (this.charReceived < this.charLength) {
                  // still not enough chars in this buffer? wait for more ...
                  return '';
                }

                // remove bytes belonging to the current character from the buffer
                buffer = buffer.slice(available, buffer.length);

                // get the character that was split
                charStr = this.charBuffer.slice(0, this.charLength).toString(this.encoding);

                // CESU-8: lead surrogate (D800-DBFF) is also the incomplete character
                var charCode = charStr.charCodeAt(charStr.length - 1);
                if (charCode >= 0xd800 && charCode <= 0xdbff) {
                  this.charLength += this.surrogateSize;
                  charStr = '';
                  continue;
                }
                this.charReceived = this.charLength = 0;

                // if there are no more bytes in this buffer, just emit our char
                if (buffer.length === 0) {
                  return charStr;
                }
                break;
              }

              // determine and set charLength / charReceived
              this.detectIncompleteChar(buffer);

              var end = buffer.length;
              if (this.charLength) {
                // buffer the incomplete character bytes we got
                buffer.copy(this.charBuffer, 0, buffer.length - this.charReceived, end);
                end -= this.charReceived;
              }

              charStr += buffer.toString(this.encoding, 0, end);

              var end = charStr.length - 1;
              var charCode = charStr.charCodeAt(end);
              // CESU-8: lead surrogate (D800-DBFF) is also the incomplete character
              if (charCode >= 0xd800 && charCode <= 0xdbff) {
                var size = this.surrogateSize;
                this.charLength += size;
                this.charReceived += size;
                this.charBuffer.copy(this.charBuffer, size, 0, size);
                buffer.copy(this.charBuffer, 0, 0, size);
                return charStr.substring(0, end);
              }

              // or just emit the charStr
              return charStr;
            };

            // detectIncompleteChar determines if there is an incomplete UTF-8 character at
            // the end of the given buffer. If so, it sets this.charLength to the byte
            // length that character, and sets this.charReceived to the number of bytes
            // that are available for this character.
            StringDecoder.prototype.detectIncompleteChar = function (buffer) {
              // determine how many bytes we have to check at the end of this buffer
              var i = buffer.length >= 3 ? 3 : buffer.length;

              // Figure out if one of the last i bytes of our buffer announces an
              // incomplete char.
              for (; i > 0; i--) {
                var c = buffer[buffer.length - i];

                // See http://en.wikipedia.org/wiki/UTF-8#Description

                // 110XXXXX
                if (i == 1 && c >> 5 == 0x06) {
                  this.charLength = 2;
                  break;
                }

                // 1110XXXX
                if (i <= 2 && c >> 4 == 0x0e) {
                  this.charLength = 3;
                  break;
                }

                // 11110XXX
                if (i <= 3 && c >> 3 == 0x1e) {
                  this.charLength = 4;
                  break;
                }
              }
              this.charReceived = i;
            };

            StringDecoder.prototype.end = function (buffer) {
              var res = '';
              if (buffer && buffer.length) res = this.write(buffer);

              if (this.charReceived) {
                var cr = this.charReceived;
                var buf = this.charBuffer;
                var enc = this.encoding;
                res += buf.slice(0, cr).toString(enc);
              }

              return res;
            };

            function passThroughWrite(buffer) {
              return buffer.toString(this.encoding);
            }

            function utf16DetectIncompleteChar(buffer) {
              this.charReceived = buffer.length % 2;
              this.charLength = this.charReceived ? 2 : 0;
            }

            function base64DetectIncompleteChar(buffer) {
              this.charReceived = buffer.length % 3;
              this.charLength = this.charReceived ? 3 : 0;
            }
          },
          { buffer: 89 }
        ],
        89: [
          function (require, module, exports) {
            (function (global, Buffer) {
              (function () {
                /*!
                 * The buffer module from node.js, for the browser.
                 *
                 * @author   Feross Aboukhadijeh <http://feross.org>
                 * @license  MIT
                 */
                /* eslint-disable no-proto */

                'use strict';

                var base64 = require('base64-js');
                var ieee754 = require('ieee754');
                var isArray = require('isarray');

                exports.Buffer = Buffer;
                exports.SlowBuffer = SlowBuffer;
                exports.INSPECT_MAX_BYTES = 50;

                /**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
                Buffer.TYPED_ARRAY_SUPPORT =
                  global.TYPED_ARRAY_SUPPORT !== undefined ? global.TYPED_ARRAY_SUPPORT : typedArraySupport();

                /*
                 * Export kMaxLength after typed array support is determined.
                 */
                exports.kMaxLength = kMaxLength();

                function typedArraySupport() {
                  try {
                    var arr = new Uint8Array(1);
                    arr.__proto__ = {
                      __proto__: Uint8Array.prototype,
                      foo: function () {
                        return 42;
                      }
                    };
                    return (
                      arr.foo() === 42 && // typed array instances can be augmented
                      typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
                      arr.subarray(1, 1).byteLength === 0
                    ); // ie10 has broken `subarray`
                  } catch (e) {
                    return false;
                  }
                }

                function kMaxLength() {
                  return Buffer.TYPED_ARRAY_SUPPORT ? 0x7fffffff : 0x3fffffff;
                }

                function createBuffer(that, length) {
                  if (kMaxLength() < length) {
                    throw new RangeError('Invalid typed array length');
                  }
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    // Return an augmented `Uint8Array` instance, for best performance
                    that = new Uint8Array(length);
                    that.__proto__ = Buffer.prototype;
                  } else {
                    // Fallback: Return an object instance of the Buffer class
                    if (that === null) {
                      that = new Buffer(length);
                    }
                    that.length = length;
                  }

                  return that;
                }

                /**
                 * The Buffer constructor returns instances of `Uint8Array` that have their
                 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
                 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
                 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
                 * returns a single octet.
                 *
                 * The `Uint8Array` prototype remains unmodified.
                 */

                function Buffer(arg, encodingOrOffset, length) {
                  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
                    return new Buffer(arg, encodingOrOffset, length);
                  }

                  // Common case.
                  if (typeof arg === 'number') {
                    if (typeof encodingOrOffset === 'string') {
                      throw new Error('If encoding is specified then the first argument must be a string');
                    }
                    return allocUnsafe(this, arg);
                  }
                  return from(this, arg, encodingOrOffset, length);
                }

                Buffer.poolSize = 8192; // not used by this implementation

                // TODO: Legacy, not needed anymore. Remove in next major version.
                Buffer._augment = function (arr) {
                  arr.__proto__ = Buffer.prototype;
                  return arr;
                };

                function from(that, value, encodingOrOffset, length) {
                  if (typeof value === 'number') {
                    throw new TypeError('"value" argument must not be a number');
                  }

                  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
                    return fromArrayBuffer(that, value, encodingOrOffset, length);
                  }

                  if (typeof value === 'string') {
                    return fromString(that, value, encodingOrOffset);
                  }

                  return fromObject(that, value);
                }

                /**
                 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
                 * if value is a number.
                 * Buffer.from(str[, encoding])
                 * Buffer.from(array)
                 * Buffer.from(buffer)
                 * Buffer.from(arrayBuffer[, byteOffset[, length]])
                 **/
                Buffer.from = function (value, encodingOrOffset, length) {
                  return from(null, value, encodingOrOffset, length);
                };

                if (Buffer.TYPED_ARRAY_SUPPORT) {
                  Buffer.prototype.__proto__ = Uint8Array.prototype;
                  Buffer.__proto__ = Uint8Array;
                  if (typeof Symbol !== 'undefined' && Symbol.species && Buffer[Symbol.species] === Buffer) {
                    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
                    Object.defineProperty(Buffer, Symbol.species, {
                      value: null,
                      configurable: true
                    });
                  }
                }

                function assertSize(size) {
                  if (typeof size !== 'number') {
                    throw new TypeError('"size" argument must be a number');
                  } else if (size < 0) {
                    throw new RangeError('"size" argument must not be negative');
                  }
                }

                function alloc(that, size, fill, encoding) {
                  assertSize(size);
                  if (size <= 0) {
                    return createBuffer(that, size);
                  }
                  if (fill !== undefined) {
                    // Only pay attention to encoding if it's a string. This
                    // prevents accidentally sending in a number that would
                    // be interpretted as a start offset.
                    return typeof encoding === 'string'
                      ? createBuffer(that, size).fill(fill, encoding)
                      : createBuffer(that, size).fill(fill);
                  }
                  return createBuffer(that, size);
                }

                /**
                 * Creates a new filled Buffer instance.
                 * alloc(size[, fill[, encoding]])
                 **/
                Buffer.alloc = function (size, fill, encoding) {
                  return alloc(null, size, fill, encoding);
                };

                function allocUnsafe(that, size) {
                  assertSize(size);
                  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
                  if (!Buffer.TYPED_ARRAY_SUPPORT) {
                    for (var i = 0; i < size; ++i) {
                      that[i] = 0;
                    }
                  }
                  return that;
                }

                /**
                 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
                 * */
                Buffer.allocUnsafe = function (size) {
                  return allocUnsafe(null, size);
                };
                /**
                 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
                 */
                Buffer.allocUnsafeSlow = function (size) {
                  return allocUnsafe(null, size);
                };

                function fromString(that, string, encoding) {
                  if (typeof encoding !== 'string' || encoding === '') {
                    encoding = 'utf8';
                  }

                  if (!Buffer.isEncoding(encoding)) {
                    throw new TypeError('"encoding" must be a valid string encoding');
                  }

                  var length = byteLength(string, encoding) | 0;
                  that = createBuffer(that, length);

                  var actual = that.write(string, encoding);

                  if (actual !== length) {
                    // Writing a hex string, for example, that contains invalid characters will
                    // cause everything after the first invalid character to be ignored. (e.g.
                    // 'abxxcd' will be treated as 'ab')
                    that = that.slice(0, actual);
                  }

                  return that;
                }

                function fromArrayLike(that, array) {
                  var length = array.length < 0 ? 0 : checked(array.length) | 0;
                  that = createBuffer(that, length);
                  for (var i = 0; i < length; i += 1) {
                    that[i] = array[i] & 255;
                  }
                  return that;
                }

                function fromArrayBuffer(that, array, byteOffset, length) {
                  array.byteLength; // this throws if `array` is not a valid ArrayBuffer

                  if (byteOffset < 0 || array.byteLength < byteOffset) {
                    throw new RangeError("'offset' is out of bounds");
                  }

                  if (array.byteLength < byteOffset + (length || 0)) {
                    throw new RangeError("'length' is out of bounds");
                  }

                  if (byteOffset === undefined && length === undefined) {
                    array = new Uint8Array(array);
                  } else if (length === undefined) {
                    array = new Uint8Array(array, byteOffset);
                  } else {
                    array = new Uint8Array(array, byteOffset, length);
                  }

                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    // Return an augmented `Uint8Array` instance, for best performance
                    that = array;
                    that.__proto__ = Buffer.prototype;
                  } else {
                    // Fallback: Return an object instance of the Buffer class
                    that = fromArrayLike(that, array);
                  }
                  return that;
                }

                function fromObject(that, obj) {
                  if (Buffer.isBuffer(obj)) {
                    var len = checked(obj.length) | 0;
                    that = createBuffer(that, len);

                    if (that.length === 0) {
                      return that;
                    }

                    obj.copy(that, 0, 0, len);
                    return that;
                  }

                  if (obj) {
                    if ((typeof ArrayBuffer !== 'undefined' && obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
                      if (typeof obj.length !== 'number' || isnan(obj.length)) {
                        return createBuffer(that, 0);
                      }
                      return fromArrayLike(that, obj);
                    }

                    if (obj.type === 'Buffer' && isArray(obj.data)) {
                      return fromArrayLike(that, obj.data);
                    }
                  }

                  throw new TypeError(
                    'First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.'
                  );
                }

                function checked(length) {
                  // Note: cannot use `length < kMaxLength()` here because that fails when
                  // length is NaN (which is otherwise coerced to zero.)
                  if (length >= kMaxLength()) {
                    throw new RangeError(
                      'Attempt to allocate Buffer larger than maximum ' +
                        'size: 0x' +
                        kMaxLength().toString(16) +
                        ' bytes'
                    );
                  }
                  return length | 0;
                }

                function SlowBuffer(length) {
                  if (+length != length) {
                    // eslint-disable-line eqeqeq
                    length = 0;
                  }
                  return Buffer.alloc(+length);
                }

                Buffer.isBuffer = function isBuffer(b) {
                  return !!(b != null && b._isBuffer);
                };

                Buffer.compare = function compare(a, b) {
                  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
                    throw new TypeError('Arguments must be Buffers');
                  }

                  if (a === b) return 0;

                  var x = a.length;
                  var y = b.length;

                  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                    if (a[i] !== b[i]) {
                      x = a[i];
                      y = b[i];
                      break;
                    }
                  }

                  if (x < y) return -1;
                  if (y < x) return 1;
                  return 0;
                };

                Buffer.isEncoding = function isEncoding(encoding) {
                  switch (String(encoding).toLowerCase()) {
                    case 'hex':
                    case 'utf8':
                    case 'utf-8':
                    case 'ascii':
                    case 'latin1':
                    case 'binary':
                    case 'base64':
                    case 'ucs2':
                    case 'ucs-2':
                    case 'utf16le':
                    case 'utf-16le':
                      return true;
                    default:
                      return false;
                  }
                };

                Buffer.concat = function concat(list, length) {
                  if (!isArray(list)) {
                    throw new TypeError('"list" argument must be an Array of Buffers');
                  }

                  if (list.length === 0) {
                    return Buffer.alloc(0);
                  }

                  var i;
                  if (length === undefined) {
                    length = 0;
                    for (i = 0; i < list.length; ++i) {
                      length += list[i].length;
                    }
                  }

                  var buffer = Buffer.allocUnsafe(length);
                  var pos = 0;
                  for (i = 0; i < list.length; ++i) {
                    var buf = list[i];
                    if (!Buffer.isBuffer(buf)) {
                      throw new TypeError('"list" argument must be an Array of Buffers');
                    }
                    buf.copy(buffer, pos);
                    pos += buf.length;
                  }
                  return buffer;
                };

                function byteLength(string, encoding) {
                  if (Buffer.isBuffer(string)) {
                    return string.length;
                  }
                  if (
                    typeof ArrayBuffer !== 'undefined' &&
                    typeof ArrayBuffer.isView === 'function' &&
                    (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)
                  ) {
                    return string.byteLength;
                  }
                  if (typeof string !== 'string') {
                    string = '' + string;
                  }

                  var len = string.length;
                  if (len === 0) return 0;

                  // Use a for loop to avoid recursion
                  var loweredCase = false;
                  for (;;) {
                    switch (encoding) {
                      case 'ascii':
                      case 'latin1':
                      case 'binary':
                        return len;
                      case 'utf8':
                      case 'utf-8':
                      case undefined:
                        return utf8ToBytes(string).length;
                      case 'ucs2':
                      case 'ucs-2':
                      case 'utf16le':
                      case 'utf-16le':
                        return len * 2;
                      case 'hex':
                        return len >>> 1;
                      case 'base64':
                        return base64ToBytes(string).length;
                      default:
                        if (loweredCase) return utf8ToBytes(string).length; // assume utf8
                        encoding = ('' + encoding).toLowerCase();
                        loweredCase = true;
                    }
                  }
                }
                Buffer.byteLength = byteLength;

                function slowToString(encoding, start, end) {
                  var loweredCase = false;

                  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
                  // property of a typed array.

                  // This behaves neither like String nor Uint8Array in that we set start/end
                  // to their upper/lower bounds if the value passed is out of range.
                  // undefined is handled specially as per ECMA-262 6th Edition,
                  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
                  if (start === undefined || start < 0) {
                    start = 0;
                  }
                  // Return early if start > this.length. Done here to prevent potential uint32
                  // coercion fail below.
                  if (start > this.length) {
                    return '';
                  }

                  if (end === undefined || end > this.length) {
                    end = this.length;
                  }

                  if (end <= 0) {
                    return '';
                  }

                  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
                  end >>>= 0;
                  start >>>= 0;

                  if (end <= start) {
                    return '';
                  }

                  if (!encoding) encoding = 'utf8';

                  while (true) {
                    switch (encoding) {
                      case 'hex':
                        return hexSlice(this, start, end);

                      case 'utf8':
                      case 'utf-8':
                        return utf8Slice(this, start, end);

                      case 'ascii':
                        return asciiSlice(this, start, end);

                      case 'latin1':
                      case 'binary':
                        return latin1Slice(this, start, end);

                      case 'base64':
                        return base64Slice(this, start, end);

                      case 'ucs2':
                      case 'ucs-2':
                      case 'utf16le':
                      case 'utf-16le':
                        return utf16leSlice(this, start, end);

                      default:
                        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
                        encoding = (encoding + '').toLowerCase();
                        loweredCase = true;
                    }
                  }
                }

                // The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
                // Buffer instances.
                Buffer.prototype._isBuffer = true;

                function swap(b, n, m) {
                  var i = b[n];
                  b[n] = b[m];
                  b[m] = i;
                }

                Buffer.prototype.swap16 = function swap16() {
                  var len = this.length;
                  if (len % 2 !== 0) {
                    throw new RangeError('Buffer size must be a multiple of 16-bits');
                  }
                  for (var i = 0; i < len; i += 2) {
                    swap(this, i, i + 1);
                  }
                  return this;
                };

                Buffer.prototype.swap32 = function swap32() {
                  var len = this.length;
                  if (len % 4 !== 0) {
                    throw new RangeError('Buffer size must be a multiple of 32-bits');
                  }
                  for (var i = 0; i < len; i += 4) {
                    swap(this, i, i + 3);
                    swap(this, i + 1, i + 2);
                  }
                  return this;
                };

                Buffer.prototype.swap64 = function swap64() {
                  var len = this.length;
                  if (len % 8 !== 0) {
                    throw new RangeError('Buffer size must be a multiple of 64-bits');
                  }
                  for (var i = 0; i < len; i += 8) {
                    swap(this, i, i + 7);
                    swap(this, i + 1, i + 6);
                    swap(this, i + 2, i + 5);
                    swap(this, i + 3, i + 4);
                  }
                  return this;
                };

                Buffer.prototype.toString = function toString() {
                  var length = this.length | 0;
                  if (length === 0) return '';
                  if (arguments.length === 0) return utf8Slice(this, 0, length);
                  return slowToString.apply(this, arguments);
                };

                Buffer.prototype.equals = function equals(b) {
                  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer');
                  if (this === b) return true;
                  return Buffer.compare(this, b) === 0;
                };

                Buffer.prototype.inspect = function inspect() {
                  var str = '';
                  var max = exports.INSPECT_MAX_BYTES;
                  if (this.length > 0) {
                    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
                    if (this.length > max) str += ' ... ';
                  }
                  return '<Buffer ' + str + '>';
                };

                Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
                  if (!Buffer.isBuffer(target)) {
                    throw new TypeError('Argument must be a Buffer');
                  }

                  if (start === undefined) {
                    start = 0;
                  }
                  if (end === undefined) {
                    end = target ? target.length : 0;
                  }
                  if (thisStart === undefined) {
                    thisStart = 0;
                  }
                  if (thisEnd === undefined) {
                    thisEnd = this.length;
                  }

                  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
                    throw new RangeError('out of range index');
                  }

                  if (thisStart >= thisEnd && start >= end) {
                    return 0;
                  }
                  if (thisStart >= thisEnd) {
                    return -1;
                  }
                  if (start >= end) {
                    return 1;
                  }

                  start >>>= 0;
                  end >>>= 0;
                  thisStart >>>= 0;
                  thisEnd >>>= 0;

                  if (this === target) return 0;

                  var x = thisEnd - thisStart;
                  var y = end - start;
                  var len = Math.min(x, y);

                  var thisCopy = this.slice(thisStart, thisEnd);
                  var targetCopy = target.slice(start, end);

                  for (var i = 0; i < len; ++i) {
                    if (thisCopy[i] !== targetCopy[i]) {
                      x = thisCopy[i];
                      y = targetCopy[i];
                      break;
                    }
                  }

                  if (x < y) return -1;
                  if (y < x) return 1;
                  return 0;
                };

                // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
                // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
                //
                // Arguments:
                // - buffer - a Buffer to search
                // - val - a string, Buffer, or number
                // - byteOffset - an index into `buffer`; will be clamped to an int32
                // - encoding - an optional encoding, relevant is val is a string
                // - dir - true for indexOf, false for lastIndexOf
                function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
                  // Empty buffer means no match
                  if (buffer.length === 0) return -1;

                  // Normalize byteOffset
                  if (typeof byteOffset === 'string') {
                    encoding = byteOffset;
                    byteOffset = 0;
                  } else if (byteOffset > 0x7fffffff) {
                    byteOffset = 0x7fffffff;
                  } else if (byteOffset < -0x80000000) {
                    byteOffset = -0x80000000;
                  }
                  byteOffset = +byteOffset; // Coerce to Number.
                  if (isNaN(byteOffset)) {
                    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
                    byteOffset = dir ? 0 : buffer.length - 1;
                  }

                  // Normalize byteOffset: negative offsets start from the end of the buffer
                  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
                  if (byteOffset >= buffer.length) {
                    if (dir) return -1;
                    else byteOffset = buffer.length - 1;
                  } else if (byteOffset < 0) {
                    if (dir) byteOffset = 0;
                    else return -1;
                  }

                  // Normalize val
                  if (typeof val === 'string') {
                    val = Buffer.from(val, encoding);
                  }

                  // Finally, search either indexOf (if dir is true) or lastIndexOf
                  if (Buffer.isBuffer(val)) {
                    // Special case: looking for empty string/buffer always fails
                    if (val.length === 0) {
                      return -1;
                    }
                    return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
                  } else if (typeof val === 'number') {
                    val = val & 0xff; // Search for a byte value [0-255]
                    if (Buffer.TYPED_ARRAY_SUPPORT && typeof Uint8Array.prototype.indexOf === 'function') {
                      if (dir) {
                        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
                      } else {
                        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
                      }
                    }
                    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
                  }

                  throw new TypeError('val must be string, number or Buffer');
                }

                function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
                  var indexSize = 1;
                  var arrLength = arr.length;
                  var valLength = val.length;

                  if (encoding !== undefined) {
                    encoding = String(encoding).toLowerCase();
                    if (
                      encoding === 'ucs2' ||
                      encoding === 'ucs-2' ||
                      encoding === 'utf16le' ||
                      encoding === 'utf-16le'
                    ) {
                      if (arr.length < 2 || val.length < 2) {
                        return -1;
                      }
                      indexSize = 2;
                      arrLength /= 2;
                      valLength /= 2;
                      byteOffset /= 2;
                    }
                  }

                  function read(buf, i) {
                    if (indexSize === 1) {
                      return buf[i];
                    } else {
                      return buf.readUInt16BE(i * indexSize);
                    }
                  }

                  var i;
                  if (dir) {
                    var foundIndex = -1;
                    for (i = byteOffset; i < arrLength; i++) {
                      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
                        if (foundIndex === -1) foundIndex = i;
                        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
                      } else {
                        if (foundIndex !== -1) i -= i - foundIndex;
                        foundIndex = -1;
                      }
                    }
                  } else {
                    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
                    for (i = byteOffset; i >= 0; i--) {
                      var found = true;
                      for (var j = 0; j < valLength; j++) {
                        if (read(arr, i + j) !== read(val, j)) {
                          found = false;
                          break;
                        }
                      }
                      if (found) return i;
                    }
                  }

                  return -1;
                }

                Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
                  return this.indexOf(val, byteOffset, encoding) !== -1;
                };

                Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
                  return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
                };

                Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
                  return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
                };

                function hexWrite(buf, string, offset, length) {
                  offset = Number(offset) || 0;
                  var remaining = buf.length - offset;
                  if (!length) {
                    length = remaining;
                  } else {
                    length = Number(length);
                    if (length > remaining) {
                      length = remaining;
                    }
                  }

                  // must be an even number of digits
                  var strLen = string.length;
                  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string');

                  if (length > strLen / 2) {
                    length = strLen / 2;
                  }
                  for (var i = 0; i < length; ++i) {
                    var parsed = parseInt(string.substr(i * 2, 2), 16);
                    if (isNaN(parsed)) return i;
                    buf[offset + i] = parsed;
                  }
                  return i;
                }

                function utf8Write(buf, string, offset, length) {
                  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
                }

                function asciiWrite(buf, string, offset, length) {
                  return blitBuffer(asciiToBytes(string), buf, offset, length);
                }

                function latin1Write(buf, string, offset, length) {
                  return asciiWrite(buf, string, offset, length);
                }

                function base64Write(buf, string, offset, length) {
                  return blitBuffer(base64ToBytes(string), buf, offset, length);
                }

                function ucs2Write(buf, string, offset, length) {
                  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
                }

                Buffer.prototype.write = function write(string, offset, length, encoding) {
                  // Buffer#write(string)
                  if (offset === undefined) {
                    encoding = 'utf8';
                    length = this.length;
                    offset = 0;
                    // Buffer#write(string, encoding)
                  } else if (length === undefined && typeof offset === 'string') {
                    encoding = offset;
                    length = this.length;
                    offset = 0;
                    // Buffer#write(string, offset[, length][, encoding])
                  } else if (isFinite(offset)) {
                    offset = offset | 0;
                    if (isFinite(length)) {
                      length = length | 0;
                      if (encoding === undefined) encoding = 'utf8';
                    } else {
                      encoding = length;
                      length = undefined;
                    }
                    // legacy write(string, encoding, offset, length) - remove in v0.13
                  } else {
                    throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');
                  }

                  var remaining = this.length - offset;
                  if (length === undefined || length > remaining) length = remaining;

                  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
                    throw new RangeError('Attempt to write outside buffer bounds');
                  }

                  if (!encoding) encoding = 'utf8';

                  var loweredCase = false;
                  for (;;) {
                    switch (encoding) {
                      case 'hex':
                        return hexWrite(this, string, offset, length);

                      case 'utf8':
                      case 'utf-8':
                        return utf8Write(this, string, offset, length);

                      case 'ascii':
                        return asciiWrite(this, string, offset, length);

                      case 'latin1':
                      case 'binary':
                        return latin1Write(this, string, offset, length);

                      case 'base64':
                        // Warning: maxLength not taken into account in base64Write
                        return base64Write(this, string, offset, length);

                      case 'ucs2':
                      case 'ucs-2':
                      case 'utf16le':
                      case 'utf-16le':
                        return ucs2Write(this, string, offset, length);

                      default:
                        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
                        encoding = ('' + encoding).toLowerCase();
                        loweredCase = true;
                    }
                  }
                };

                Buffer.prototype.toJSON = function toJSON() {
                  return {
                    type: 'Buffer',
                    data: Array.prototype.slice.call(this._arr || this, 0)
                  };
                };

                function base64Slice(buf, start, end) {
                  if (start === 0 && end === buf.length) {
                    return base64.fromByteArray(buf);
                  } else {
                    return base64.fromByteArray(buf.slice(start, end));
                  }
                }

                function utf8Slice(buf, start, end) {
                  end = Math.min(buf.length, end);
                  var res = [];

                  var i = start;
                  while (i < end) {
                    var firstByte = buf[i];
                    var codePoint = null;
                    var bytesPerSequence = firstByte > 0xef ? 4 : firstByte > 0xdf ? 3 : firstByte > 0xbf ? 2 : 1;

                    if (i + bytesPerSequence <= end) {
                      var secondByte, thirdByte, fourthByte, tempCodePoint;

                      switch (bytesPerSequence) {
                        case 1:
                          if (firstByte < 0x80) {
                            codePoint = firstByte;
                          }
                          break;
                        case 2:
                          secondByte = buf[i + 1];
                          if ((secondByte & 0xc0) === 0x80) {
                            tempCodePoint = ((firstByte & 0x1f) << 0x6) | (secondByte & 0x3f);
                            if (tempCodePoint > 0x7f) {
                              codePoint = tempCodePoint;
                            }
                          }
                          break;
                        case 3:
                          secondByte = buf[i + 1];
                          thirdByte = buf[i + 2];
                          if ((secondByte & 0xc0) === 0x80 && (thirdByte & 0xc0) === 0x80) {
                            tempCodePoint =
                              ((firstByte & 0xf) << 0xc) | ((secondByte & 0x3f) << 0x6) | (thirdByte & 0x3f);
                            if (tempCodePoint > 0x7ff && (tempCodePoint < 0xd800 || tempCodePoint > 0xdfff)) {
                              codePoint = tempCodePoint;
                            }
                          }
                          break;
                        case 4:
                          secondByte = buf[i + 1];
                          thirdByte = buf[i + 2];
                          fourthByte = buf[i + 3];
                          if (
                            (secondByte & 0xc0) === 0x80 &&
                            (thirdByte & 0xc0) === 0x80 &&
                            (fourthByte & 0xc0) === 0x80
                          ) {
                            tempCodePoint =
                              ((firstByte & 0xf) << 0x12) |
                              ((secondByte & 0x3f) << 0xc) |
                              ((thirdByte & 0x3f) << 0x6) |
                              (fourthByte & 0x3f);
                            if (tempCodePoint > 0xffff && tempCodePoint < 0x110000) {
                              codePoint = tempCodePoint;
                            }
                          }
                      }
                    }

                    if (codePoint === null) {
                      // we did not generate a valid codePoint so insert a
                      // replacement char (U+FFFD) and advance only 1 byte
                      codePoint = 0xfffd;
                      bytesPerSequence = 1;
                    } else if (codePoint > 0xffff) {
                      // encode to utf16 (surrogate pair dance)
                      codePoint -= 0x10000;
                      res.push(((codePoint >>> 10) & 0x3ff) | 0xd800);
                      codePoint = 0xdc00 | (codePoint & 0x3ff);
                    }

                    res.push(codePoint);
                    i += bytesPerSequence;
                  }

                  return decodeCodePointsArray(res);
                }

                // Based on http://stackoverflow.com/a/22747272/680742, the browser with
                // the lowest limit is Chrome, with 0x10000 args.
                // We go 1 magnitude less, for safety
                var MAX_ARGUMENTS_LENGTH = 0x1000;

                function decodeCodePointsArray(codePoints) {
                  var len = codePoints.length;
                  if (len <= MAX_ARGUMENTS_LENGTH) {
                    return String.fromCharCode.apply(String, codePoints); // avoid extra slice()
                  }

                  // Decode in chunks to avoid "call stack size exceeded".
                  var res = '';
                  var i = 0;
                  while (i < len) {
                    res += String.fromCharCode.apply(String, codePoints.slice(i, (i += MAX_ARGUMENTS_LENGTH)));
                  }
                  return res;
                }

                function asciiSlice(buf, start, end) {
                  var ret = '';
                  end = Math.min(buf.length, end);

                  for (var i = start; i < end; ++i) {
                    ret += String.fromCharCode(buf[i] & 0x7f);
                  }
                  return ret;
                }

                function latin1Slice(buf, start, end) {
                  var ret = '';
                  end = Math.min(buf.length, end);

                  for (var i = start; i < end; ++i) {
                    ret += String.fromCharCode(buf[i]);
                  }
                  return ret;
                }

                function hexSlice(buf, start, end) {
                  var len = buf.length;

                  if (!start || start < 0) start = 0;
                  if (!end || end < 0 || end > len) end = len;

                  var out = '';
                  for (var i = start; i < end; ++i) {
                    out += toHex(buf[i]);
                  }
                  return out;
                }

                function utf16leSlice(buf, start, end) {
                  var bytes = buf.slice(start, end);
                  var res = '';
                  for (var i = 0; i < bytes.length; i += 2) {
                    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
                  }
                  return res;
                }

                Buffer.prototype.slice = function slice(start, end) {
                  var len = this.length;
                  start = ~~start;
                  end = end === undefined ? len : ~~end;

                  if (start < 0) {
                    start += len;
                    if (start < 0) start = 0;
                  } else if (start > len) {
                    start = len;
                  }

                  if (end < 0) {
                    end += len;
                    if (end < 0) end = 0;
                  } else if (end > len) {
                    end = len;
                  }

                  if (end < start) end = start;

                  var newBuf;
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    newBuf = this.subarray(start, end);
                    newBuf.__proto__ = Buffer.prototype;
                  } else {
                    var sliceLen = end - start;
                    newBuf = new Buffer(sliceLen, undefined);
                    for (var i = 0; i < sliceLen; ++i) {
                      newBuf[i] = this[i + start];
                    }
                  }

                  return newBuf;
                };

                /*
                 * Need to make sure that buffer isn't trying to write out of bounds.
                 */
                function checkOffset(offset, ext, length) {
                  if (offset % 1 !== 0 || offset < 0) throw new RangeError('offset is not uint');
                  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length');
                }

                Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
                  offset = offset | 0;
                  byteLength = byteLength | 0;
                  if (!noAssert) checkOffset(offset, byteLength, this.length);

                  var val = this[offset];
                  var mul = 1;
                  var i = 0;
                  while (++i < byteLength && (mul *= 0x100)) {
                    val += this[offset + i] * mul;
                  }

                  return val;
                };

                Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
                  offset = offset | 0;
                  byteLength = byteLength | 0;
                  if (!noAssert) {
                    checkOffset(offset, byteLength, this.length);
                  }

                  var val = this[offset + --byteLength];
                  var mul = 1;
                  while (byteLength > 0 && (mul *= 0x100)) {
                    val += this[offset + --byteLength] * mul;
                  }

                  return val;
                };

                Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 1, this.length);
                  return this[offset];
                };

                Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 2, this.length);
                  return this[offset] | (this[offset + 1] << 8);
                };

                Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 2, this.length);
                  return (this[offset] << 8) | this[offset + 1];
                };

                Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 4, this.length);

                  return (
                    (this[offset] | (this[offset + 1] << 8) | (this[offset + 2] << 16)) + this[offset + 3] * 0x1000000
                  );
                };

                Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 4, this.length);

                  return (
                    this[offset] * 0x1000000 + ((this[offset + 1] << 16) | (this[offset + 2] << 8) | this[offset + 3])
                  );
                };

                Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
                  offset = offset | 0;
                  byteLength = byteLength | 0;
                  if (!noAssert) checkOffset(offset, byteLength, this.length);

                  var val = this[offset];
                  var mul = 1;
                  var i = 0;
                  while (++i < byteLength && (mul *= 0x100)) {
                    val += this[offset + i] * mul;
                  }
                  mul *= 0x80;

                  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

                  return val;
                };

                Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
                  offset = offset | 0;
                  byteLength = byteLength | 0;
                  if (!noAssert) checkOffset(offset, byteLength, this.length);

                  var i = byteLength;
                  var mul = 1;
                  var val = this[offset + --i];
                  while (i > 0 && (mul *= 0x100)) {
                    val += this[offset + --i] * mul;
                  }
                  mul *= 0x80;

                  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

                  return val;
                };

                Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 1, this.length);
                  if (!(this[offset] & 0x80)) return this[offset];
                  return (0xff - this[offset] + 1) * -1;
                };

                Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 2, this.length);
                  var val = this[offset] | (this[offset + 1] << 8);
                  return val & 0x8000 ? val | 0xffff0000 : val;
                };

                Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 2, this.length);
                  var val = this[offset + 1] | (this[offset] << 8);
                  return val & 0x8000 ? val | 0xffff0000 : val;
                };

                Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 4, this.length);

                  return this[offset] | (this[offset + 1] << 8) | (this[offset + 2] << 16) | (this[offset + 3] << 24);
                };

                Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 4, this.length);

                  return (this[offset] << 24) | (this[offset + 1] << 16) | (this[offset + 2] << 8) | this[offset + 3];
                };

                Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 4, this.length);
                  return ieee754.read(this, offset, true, 23, 4);
                };

                Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 4, this.length);
                  return ieee754.read(this, offset, false, 23, 4);
                };

                Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 8, this.length);
                  return ieee754.read(this, offset, true, 52, 8);
                };

                Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
                  if (!noAssert) checkOffset(offset, 8, this.length);
                  return ieee754.read(this, offset, false, 52, 8);
                };

                function checkInt(buf, value, offset, ext, max, min) {
                  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
                  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
                  if (offset + ext > buf.length) throw new RangeError('Index out of range');
                }

                Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  byteLength = byteLength | 0;
                  if (!noAssert) {
                    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
                    checkInt(this, value, offset, byteLength, maxBytes, 0);
                  }

                  var mul = 1;
                  var i = 0;
                  this[offset] = value & 0xff;
                  while (++i < byteLength && (mul *= 0x100)) {
                    this[offset + i] = (value / mul) & 0xff;
                  }

                  return offset + byteLength;
                };

                Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  byteLength = byteLength | 0;
                  if (!noAssert) {
                    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
                    checkInt(this, value, offset, byteLength, maxBytes, 0);
                  }

                  var i = byteLength - 1;
                  var mul = 1;
                  this[offset + i] = value & 0xff;
                  while (--i >= 0 && (mul *= 0x100)) {
                    this[offset + i] = (value / mul) & 0xff;
                  }

                  return offset + byteLength;
                };

                Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
                  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
                  this[offset] = value & 0xff;
                  return offset + 1;
                };

                function objectWriteUInt16(buf, value, offset, littleEndian) {
                  if (value < 0) value = 0xffff + value + 1;
                  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
                    buf[offset + i] =
                      (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>> ((littleEndian ? i : 1 - i) * 8);
                  }
                }

                Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value & 0xff;
                    this[offset + 1] = value >>> 8;
                  } else {
                    objectWriteUInt16(this, value, offset, true);
                  }
                  return offset + 2;
                };

                Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value >>> 8;
                    this[offset + 1] = value & 0xff;
                  } else {
                    objectWriteUInt16(this, value, offset, false);
                  }
                  return offset + 2;
                };

                function objectWriteUInt32(buf, value, offset, littleEndian) {
                  if (value < 0) value = 0xffffffff + value + 1;
                  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
                    buf[offset + i] = (value >>> ((littleEndian ? i : 3 - i) * 8)) & 0xff;
                  }
                }

                Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset + 3] = value >>> 24;
                    this[offset + 2] = value >>> 16;
                    this[offset + 1] = value >>> 8;
                    this[offset] = value & 0xff;
                  } else {
                    objectWriteUInt32(this, value, offset, true);
                  }
                  return offset + 4;
                };

                Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value >>> 24;
                    this[offset + 1] = value >>> 16;
                    this[offset + 2] = value >>> 8;
                    this[offset + 3] = value & 0xff;
                  } else {
                    objectWriteUInt32(this, value, offset, false);
                  }
                  return offset + 4;
                };

                Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) {
                    var limit = Math.pow(2, 8 * byteLength - 1);

                    checkInt(this, value, offset, byteLength, limit - 1, -limit);
                  }

                  var i = 0;
                  var mul = 1;
                  var sub = 0;
                  this[offset] = value & 0xff;
                  while (++i < byteLength && (mul *= 0x100)) {
                    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
                      sub = 1;
                    }
                    this[offset + i] = (((value / mul) >> 0) - sub) & 0xff;
                  }

                  return offset + byteLength;
                };

                Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) {
                    var limit = Math.pow(2, 8 * byteLength - 1);

                    checkInt(this, value, offset, byteLength, limit - 1, -limit);
                  }

                  var i = byteLength - 1;
                  var mul = 1;
                  var sub = 0;
                  this[offset + i] = value & 0xff;
                  while (--i >= 0 && (mul *= 0x100)) {
                    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
                      sub = 1;
                    }
                    this[offset + i] = (((value / mul) >> 0) - sub) & 0xff;
                  }

                  return offset + byteLength;
                };

                Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
                  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
                  if (value < 0) value = 0xff + value + 1;
                  this[offset] = value & 0xff;
                  return offset + 1;
                };

                Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value & 0xff;
                    this[offset + 1] = value >>> 8;
                  } else {
                    objectWriteUInt16(this, value, offset, true);
                  }
                  return offset + 2;
                };

                Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value >>> 8;
                    this[offset + 1] = value & 0xff;
                  } else {
                    objectWriteUInt16(this, value, offset, false);
                  }
                  return offset + 2;
                };

                Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value & 0xff;
                    this[offset + 1] = value >>> 8;
                    this[offset + 2] = value >>> 16;
                    this[offset + 3] = value >>> 24;
                  } else {
                    objectWriteUInt32(this, value, offset, true);
                  }
                  return offset + 4;
                };

                Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
                  value = +value;
                  offset = offset | 0;
                  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
                  if (value < 0) value = 0xffffffff + value + 1;
                  if (Buffer.TYPED_ARRAY_SUPPORT) {
                    this[offset] = value >>> 24;
                    this[offset + 1] = value >>> 16;
                    this[offset + 2] = value >>> 8;
                    this[offset + 3] = value & 0xff;
                  } else {
                    objectWriteUInt32(this, value, offset, false);
                  }
                  return offset + 4;
                };

                function checkIEEE754(buf, value, offset, ext, max, min) {
                  if (offset + ext > buf.length) throw new RangeError('Index out of range');
                  if (offset < 0) throw new RangeError('Index out of range');
                }

                function writeFloat(buf, value, offset, littleEndian, noAssert) {
                  if (!noAssert) {
                    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e38, -3.4028234663852886e38);
                  }
                  ieee754.write(buf, value, offset, littleEndian, 23, 4);
                  return offset + 4;
                }

                Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
                  return writeFloat(this, value, offset, true, noAssert);
                };

                Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
                  return writeFloat(this, value, offset, false, noAssert);
                };

                function writeDouble(buf, value, offset, littleEndian, noAssert) {
                  if (!noAssert) {
                    checkIEEE754(buf, value, offset, 8, 1.7976931348623157e308, -1.7976931348623157e308);
                  }
                  ieee754.write(buf, value, offset, littleEndian, 52, 8);
                  return offset + 8;
                }

                Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
                  return writeDouble(this, value, offset, true, noAssert);
                };

                Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
                  return writeDouble(this, value, offset, false, noAssert);
                };

                // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
                Buffer.prototype.copy = function copy(target, targetStart, start, end) {
                  if (!start) start = 0;
                  if (!end && end !== 0) end = this.length;
                  if (targetStart >= target.length) targetStart = target.length;
                  if (!targetStart) targetStart = 0;
                  if (end > 0 && end < start) end = start;

                  // Copy 0 bytes; we're done
                  if (end === start) return 0;
                  if (target.length === 0 || this.length === 0) return 0;

                  // Fatal error conditions
                  if (targetStart < 0) {
                    throw new RangeError('targetStart out of bounds');
                  }
                  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds');
                  if (end < 0) throw new RangeError('sourceEnd out of bounds');

                  // Are we oob?
                  if (end > this.length) end = this.length;
                  if (target.length - targetStart < end - start) {
                    end = target.length - targetStart + start;
                  }

                  var len = end - start;
                  var i;

                  if (this === target && start < targetStart && targetStart < end) {
                    // descending copy from end
                    for (i = len - 1; i >= 0; --i) {
                      target[i + targetStart] = this[i + start];
                    }
                  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
                    // ascending copy from start
                    for (i = 0; i < len; ++i) {
                      target[i + targetStart] = this[i + start];
                    }
                  } else {
                    Uint8Array.prototype.set.call(target, this.subarray(start, start + len), targetStart);
                  }

                  return len;
                };

                // Usage:
                //    buffer.fill(number[, offset[, end]])
                //    buffer.fill(buffer[, offset[, end]])
                //    buffer.fill(string[, offset[, end]][, encoding])
                Buffer.prototype.fill = function fill(val, start, end, encoding) {
                  // Handle string cases:
                  if (typeof val === 'string') {
                    if (typeof start === 'string') {
                      encoding = start;
                      start = 0;
                      end = this.length;
                    } else if (typeof end === 'string') {
                      encoding = end;
                      end = this.length;
                    }
                    if (val.length === 1) {
                      var code = val.charCodeAt(0);
                      if (code < 256) {
                        val = code;
                      }
                    }
                    if (encoding !== undefined && typeof encoding !== 'string') {
                      throw new TypeError('encoding must be a string');
                    }
                    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
                      throw new TypeError('Unknown encoding: ' + encoding);
                    }
                  } else if (typeof val === 'number') {
                    val = val & 255;
                  }

                  // Invalid ranges are not set to a default, so can range check early.
                  if (start < 0 || this.length < start || this.length < end) {
                    throw new RangeError('Out of range index');
                  }

                  if (end <= start) {
                    return this;
                  }

                  start = start >>> 0;
                  end = end === undefined ? this.length : end >>> 0;

                  if (!val) val = 0;

                  var i;
                  if (typeof val === 'number') {
                    for (i = start; i < end; ++i) {
                      this[i] = val;
                    }
                  } else {
                    var bytes = Buffer.isBuffer(val) ? val : utf8ToBytes(new Buffer(val, encoding).toString());
                    var len = bytes.length;
                    for (i = 0; i < end - start; ++i) {
                      this[i + start] = bytes[i % len];
                    }
                  }

                  return this;
                };

                // HELPER FUNCTIONS
                // ================

                var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

                function base64clean(str) {
                  // Node strips out invalid characters like \n and \t from the string, base64-js does not
                  str = stringtrim(str).replace(INVALID_BASE64_RE, '');
                  // Node converts strings with length < 2 to ''
                  if (str.length < 2) return '';
                  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
                  while (str.length % 4 !== 0) {
                    str = str + '=';
                  }
                  return str;
                }

                function stringtrim(str) {
                  if (str.trim) return str.trim();
                  return str.replace(/^\s+|\s+$/g, '');
                }

                function toHex(n) {
                  if (n < 16) return '0' + n.toString(16);
                  return n.toString(16);
                }

                function utf8ToBytes(string, units) {
                  units = units || Infinity;
                  var codePoint;
                  var length = string.length;
                  var leadSurrogate = null;
                  var bytes = [];

                  for (var i = 0; i < length; ++i) {
                    codePoint = string.charCodeAt(i);

                    // is surrogate component
                    if (codePoint > 0xd7ff && codePoint < 0xe000) {
                      // last char was a lead
                      if (!leadSurrogate) {
                        // no lead yet
                        if (codePoint > 0xdbff) {
                          // unexpected trail
                          if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                          continue;
                        } else if (i + 1 === length) {
                          // unpaired lead
                          if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                          continue;
                        }

                        // valid lead
                        leadSurrogate = codePoint;

                        continue;
                      }

                      // 2 leads in a row
                      if (codePoint < 0xdc00) {
                        if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                        leadSurrogate = codePoint;
                        continue;
                      }

                      // valid surrogate pair
                      codePoint = (((leadSurrogate - 0xd800) << 10) | (codePoint - 0xdc00)) + 0x10000;
                    } else if (leadSurrogate) {
                      // valid bmp char, but last char was a lead
                      if ((units -= 3) > -1) bytes.push(0xef, 0xbf, 0xbd);
                    }

                    leadSurrogate = null;

                    // encode utf8
                    if (codePoint < 0x80) {
                      if ((units -= 1) < 0) break;
                      bytes.push(codePoint);
                    } else if (codePoint < 0x800) {
                      if ((units -= 2) < 0) break;
                      bytes.push((codePoint >> 0x6) | 0xc0, (codePoint & 0x3f) | 0x80);
                    } else if (codePoint < 0x10000) {
                      if ((units -= 3) < 0) break;
                      bytes.push(
                        (codePoint >> 0xc) | 0xe0,
                        ((codePoint >> 0x6) & 0x3f) | 0x80,
                        (codePoint & 0x3f) | 0x80
                      );
                    } else if (codePoint < 0x110000) {
                      if ((units -= 4) < 0) break;
                      bytes.push(
                        (codePoint >> 0x12) | 0xf0,
                        ((codePoint >> 0xc) & 0x3f) | 0x80,
                        ((codePoint >> 0x6) & 0x3f) | 0x80,
                        (codePoint & 0x3f) | 0x80
                      );
                    } else {
                      throw new Error('Invalid code point');
                    }
                  }

                  return bytes;
                }

                function asciiToBytes(str) {
                  var byteArray = [];
                  for (var i = 0; i < str.length; ++i) {
                    // Node's code seems to be doing this and not & 0x7F..
                    byteArray.push(str.charCodeAt(i) & 0xff);
                  }
                  return byteArray;
                }

                function utf16leToBytes(str, units) {
                  var c, hi, lo;
                  var byteArray = [];
                  for (var i = 0; i < str.length; ++i) {
                    if ((units -= 2) < 0) break;

                    c = str.charCodeAt(i);
                    hi = c >> 8;
                    lo = c % 256;
                    byteArray.push(lo);
                    byteArray.push(hi);
                  }

                  return byteArray;
                }

                function base64ToBytes(str) {
                  return base64.toByteArray(base64clean(str));
                }

                function blitBuffer(src, dst, offset, length) {
                  for (var i = 0; i < length; ++i) {
                    if (i + offset >= dst.length || i >= src.length) break;
                    dst[i + offset] = src[i];
                  }
                  return i;
                }

                function isnan(val) {
                  return val !== val; // eslint-disable-line no-self-compare
                }
              }).call(this);
            }).call(
              this,
              typeof global !== 'undefined'
                ? global
                : typeof self !== 'undefined'
                ? self
                : typeof window !== 'undefined'
                ? window
                : {},
              require('buffer').Buffer
            );
          },
          { 'base64-js': 85, buffer: 89, ieee754: 346, isarray: 355 }
        ],
        90: [
          function (require, module, exports) {
            module.exports = {
              100: 'Continue',
              101: 'Switching Protocols',
              102: 'Processing',
              200: 'OK',
              201: 'Created',
              202: 'Accepted',
              203: 'Non-Authoritative Information',
              204: 'No Content',
              205: 'Reset Content',
              206: 'Partial Content',
              207: 'Multi-Status',
              208: 'Already Reported',
              226: 'IM Used',
              300: 'Multiple Choices',
              301: 'Moved Permanently',
              302: 'Found',
              303: 'See Other',
              304: 'Not Modified',
              305: 'Use Proxy',
              307: 'Temporary Redirect',
              308: 'Permanent Redirect',
              400: 'Bad Request',
              401: 'Unauthorized',
              402: 'Payment Required',
              403: 'Forbidden',
              404: 'Not Found',
              405: 'Method Not Allowed',
              406: 'Not Acceptable',
              407: 'Proxy Authentication Required',
              408: 'Request Timeout',
              409: 'Conflict',
              410: 'Gone',
              411: 'Length Required',
              412: 'Precondition Failed',
              413: 'Payload Too Large',
              414: 'URI Too Long',
              415: 'Unsupported Media Type',
              416: 'Range Not Satisfiable',
              417: 'Expectation Failed',
              418: "I'm a teapot",
              421: 'Misdirected Request',
              422: 'Unprocessable Entity',
              423: 'Locked',
              424: 'Failed Dependency',
              425: 'Unordered Collection',
              426: 'Upgrade Required',
              428: 'Precondition Required',
              429: 'Too Many Requests',
              431: 'Request Header Fields Too Large',
              451: 'Unavailable For Legal Reasons',
              500: 'Internal Server Error',
              501: 'Not Implemented',
              502: 'Bad Gateway',
              503: 'Service Unavailable',
              504: 'Gateway Timeout',
              505: 'HTTP Version Not Supported',
              506: 'Variant Also Negotiates',
              507: 'Insufficient Storage',
              508: 'Loop Detected',
              509: 'Bandwidth Limit Exceeded',
              510: 'Not Extended',
              511: 'Network Authentication Required'
            };
          },
          {}
        ],
        91: [
          function (require, module, exports) {
            /*!
             * copy-to - index.js
             * Copyright(c) 2014 dead_horse <dead_horse@qq.com>
             * MIT Licensed
             */

            'use strict';

            /**
             * slice() reference.
             */

            var slice = Array.prototype.slice;

            /**
             * Expose copy
             *
             * ```
             * copy({foo: 'nar', hello: 'copy'}).to({hello: 'world'});
             * copy({foo: 'nar', hello: 'copy'}).toCover({hello: 'world'});
             * ```
             *
             * @param {Object} src
             * @return {Copy}
             */

            module.exports = Copy;

            /**
             * Copy
             * @param {Object} src
             * @param {Boolean} withAccess
             */

            function Copy(src, withAccess) {
              if (!(this instanceof Copy)) return new Copy(src, withAccess);
              this.src = src;
              this._withAccess = withAccess;
            }

            /**
             * copy properties include getter and setter
             * @param {[type]} val [description]
             * @return {[type]} [description]
             */

            Copy.prototype.withAccess = function (w) {
              this._withAccess = w !== false;
              return this;
            };

            /**
             * pick keys in src
             *
             * @api: public
             */

            Copy.prototype.pick = function (keys) {
              if (!Array.isArray(keys)) {
                keys = slice.call(arguments);
              }
              if (keys.length) {
                this.keys = keys;
              }
              return this;
            };

            /**
             * copy src to target,
             * do not cover any property target has
             * @param {Object} to
             *
             * @api: public
             */

            Copy.prototype.to = function (to) {
              to = to || {};

              if (!this.src) return to;
              var keys = this.keys || Object.keys(this.src);

              if (!this._withAccess) {
                for (var i = 0; i < keys.length; i++) {
                  key = keys[i];
                  if (to[key] !== undefined) continue;
                  to[key] = this.src[key];
                }
                return to;
              }

              for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                if (!notDefined(to, key)) continue;
                var getter = this.src.__lookupGetter__(key);
                var setter = this.src.__lookupSetter__(key);
                if (getter) to.__defineGetter__(key, getter);
                if (setter) to.__defineSetter__(key, setter);

                if (!getter && !setter) {
                  to[key] = this.src[key];
                }
              }
              return to;
            };

            /**
             * copy src to target,
             * override any property target has
             * @param {Object} to
             *
             * @api: public
             */

            Copy.prototype.toCover = function (to) {
              var keys = this.keys || Object.keys(this.src);

              for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                delete to[key];
                var getter = this.src.__lookupGetter__(key);
                var setter = this.src.__lookupSetter__(key);
                if (getter) to.__defineGetter__(key, getter);
                if (setter) to.__defineSetter__(key, setter);

                if (!getter && !setter) {
                  to[key] = this.src[key];
                }
              }
            };

            Copy.prototype.override = Copy.prototype.toCover;

            /**
             * append another object to src
             * @param {Obj} obj
             * @return {Copy}
             */

            Copy.prototype.and = function (obj) {
              var src = {};
              this.to(src);
              this.src = obj;
              this.to(src);
              this.src = src;

              return this;
            };

            /**
             * check obj[key] if not defiend
             * @param {Object} obj
             * @param {String} key
             * @return {Boolean}
             */

            function notDefined(obj, key) {
              return (
                obj[key] === undefined &&
                obj.__lookupGetter__(key) === undefined &&
                obj.__lookupSetter__(key) === undefined
              );
            }
          },
          {}
        ],
        92: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isCallable = require('../internals/is-callable');
            var tryToString = require('../internals/try-to-string');

            var TypeError = global.TypeError;

            // `Assert: IsCallable(argument) is true`
            module.exports = function (argument) {
              if (isCallable(argument)) return argument;
              throw TypeError(tryToString(argument) + ' is not a function');
            };
          },
          { '../internals/global': 160, '../internals/is-callable': 173, '../internals/try-to-string': 254 }
        ],
        93: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isConstructor = require('../internals/is-constructor');
            var tryToString = require('../internals/try-to-string');

            var TypeError = global.TypeError;

            // `Assert: IsConstructor(argument) is true`
            module.exports = function (argument) {
              if (isConstructor(argument)) return argument;
              throw TypeError(tryToString(argument) + ' is not a constructor');
            };
          },
          { '../internals/global': 160, '../internals/is-constructor': 174, '../internals/try-to-string': 254 }
        ],
        94: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isCallable = require('../internals/is-callable');

            var String = global.String;
            var TypeError = global.TypeError;

            module.exports = function (argument) {
              if (typeof argument == 'object' || isCallable(argument)) return argument;
              throw TypeError("Can't set " + String(argument) + ' as a prototype');
            };
          },
          { '../internals/global': 160, '../internals/is-callable': 173 }
        ],
        95: [
          function (require, module, exports) {
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var create = require('../internals/object-create');
            var definePropertyModule = require('../internals/object-define-property');

            var UNSCOPABLES = wellKnownSymbol('unscopables');
            var ArrayPrototype = Array.prototype;

            // Array.prototype[@@unscopables]
            // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
            if (ArrayPrototype[UNSCOPABLES] == undefined) {
              definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
                configurable: true,
                value: create(null)
              });
            }

            // add a key to Array.prototype[@@unscopables]
            module.exports = function (key) {
              ArrayPrototype[UNSCOPABLES][key] = true;
            };
          },
          {
            '../internals/object-create': 193,
            '../internals/object-define-property': 195,
            '../internals/well-known-symbol': 265
          }
        ],
        96: [
          function (require, module, exports) {
            'use strict';
            var charAt = require('../internals/string-multibyte').charAt;

            // `AdvanceStringIndex` abstract operation
            // https://tc39.es/ecma262/#sec-advancestringindex
            module.exports = function (S, index, unicode) {
              return index + (unicode ? charAt(S, index).length : 1);
            };
          },
          { '../internals/string-multibyte': 236 }
        ],
        97: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isPrototypeOf = require('../internals/object-is-prototype-of');

            var TypeError = global.TypeError;

            module.exports = function (it, Prototype) {
              if (isPrototypeOf(Prototype, it)) return it;
              throw TypeError('Incorrect invocation');
            };
          },
          { '../internals/global': 160, '../internals/object-is-prototype-of': 201 }
        ],
        98: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isObject = require('../internals/is-object');

            var String = global.String;
            var TypeError = global.TypeError;

            // `Assert: Type(argument) is Object`
            module.exports = function (argument) {
              if (isObject(argument)) return argument;
              throw TypeError(String(argument) + ' is not an object');
            };
          },
          { '../internals/global': 160, '../internals/is-object': 177 }
        ],
        99: [
          function (require, module, exports) {
            // eslint-disable-next-line es-x/no-typed-arrays -- safe
            module.exports = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';
          },
          {}
        ],
        100: [
          function (require, module, exports) {
            'use strict';
            var NATIVE_ARRAY_BUFFER = require('../internals/array-buffer-native');
            var DESCRIPTORS = require('../internals/descriptors');
            var global = require('../internals/global');
            var isCallable = require('../internals/is-callable');
            var isObject = require('../internals/is-object');
            var hasOwn = require('../internals/has-own-property');
            var classof = require('../internals/classof');
            var tryToString = require('../internals/try-to-string');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var redefine = require('../internals/redefine');
            var defineProperty = require('../internals/object-define-property').f;
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var getPrototypeOf = require('../internals/object-get-prototype-of');
            var setPrototypeOf = require('../internals/object-set-prototype-of');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var uid = require('../internals/uid');

            var Int8Array = global.Int8Array;
            var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
            var Uint8ClampedArray = global.Uint8ClampedArray;
            var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
            var TypedArray = Int8Array && getPrototypeOf(Int8Array);
            var TypedArrayPrototype = Int8ArrayPrototype && getPrototypeOf(Int8ArrayPrototype);
            var ObjectPrototype = Object.prototype;
            var TypeError = global.TypeError;

            var TO_STRING_TAG = wellKnownSymbol('toStringTag');
            var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG');
            var TYPED_ARRAY_CONSTRUCTOR = uid('TYPED_ARRAY_CONSTRUCTOR');
            // Fixing native typed arrays in Opera Presto crashes the browser, see #595
            var NATIVE_ARRAY_BUFFER_VIEWS =
              NATIVE_ARRAY_BUFFER && !!setPrototypeOf && classof(global.opera) !== 'Opera';
            var TYPED_ARRAY_TAG_REQUIRED = false;
            var NAME, Constructor, Prototype;

            var TypedArrayConstructorsList = {
              Int8Array: 1,
              Uint8Array: 1,
              Uint8ClampedArray: 1,
              Int16Array: 2,
              Uint16Array: 2,
              Int32Array: 4,
              Uint32Array: 4,
              Float32Array: 4,
              Float64Array: 8
            };

            var BigIntArrayConstructorsList = {
              BigInt64Array: 8,
              BigUint64Array: 8
            };

            var isView = function isView(it) {
              if (!isObject(it)) return false;
              var klass = classof(it);
              return (
                klass === 'DataView' ||
                hasOwn(TypedArrayConstructorsList, klass) ||
                hasOwn(BigIntArrayConstructorsList, klass)
              );
            };

            var isTypedArray = function (it) {
              if (!isObject(it)) return false;
              var klass = classof(it);
              return hasOwn(TypedArrayConstructorsList, klass) || hasOwn(BigIntArrayConstructorsList, klass);
            };

            var aTypedArray = function (it) {
              if (isTypedArray(it)) return it;
              throw TypeError('Target is not a typed array');
            };

            var aTypedArrayConstructor = function (C) {
              if (isCallable(C) && (!setPrototypeOf || isPrototypeOf(TypedArray, C))) return C;
              throw TypeError(tryToString(C) + ' is not a typed array constructor');
            };

            var exportTypedArrayMethod = function (KEY, property, forced, options) {
              if (!DESCRIPTORS) return;
              if (forced)
                for (var ARRAY in TypedArrayConstructorsList) {
                  var TypedArrayConstructor = global[ARRAY];
                  if (TypedArrayConstructor && hasOwn(TypedArrayConstructor.prototype, KEY))
                    try {
                      delete TypedArrayConstructor.prototype[KEY];
                    } catch (error) {
                      // old WebKit bug - some methods are non-configurable
                      try {
                        TypedArrayConstructor.prototype[KEY] = property;
                      } catch (error2) {
                        /* empty */
                      }
                    }
                }
              if (!TypedArrayPrototype[KEY] || forced) {
                redefine(
                  TypedArrayPrototype,
                  KEY,
                  forced ? property : (NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY]) || property,
                  options
                );
              }
            };

            var exportTypedArrayStaticMethod = function (KEY, property, forced) {
              var ARRAY, TypedArrayConstructor;
              if (!DESCRIPTORS) return;
              if (setPrototypeOf) {
                if (forced)
                  for (ARRAY in TypedArrayConstructorsList) {
                    TypedArrayConstructor = global[ARRAY];
                    if (TypedArrayConstructor && hasOwn(TypedArrayConstructor, KEY))
                      try {
                        delete TypedArrayConstructor[KEY];
                      } catch (error) {
                        /* empty */
                      }
                  }
                if (!TypedArray[KEY] || forced) {
                  // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
                  try {
                    return redefine(
                      TypedArray,
                      KEY,
                      forced ? property : (NATIVE_ARRAY_BUFFER_VIEWS && TypedArray[KEY]) || property
                    );
                  } catch (error) {
                    /* empty */
                  }
                } else return;
              }
              for (ARRAY in TypedArrayConstructorsList) {
                TypedArrayConstructor = global[ARRAY];
                if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
                  redefine(TypedArrayConstructor, KEY, property);
                }
              }
            };

            for (NAME in TypedArrayConstructorsList) {
              Constructor = global[NAME];
              Prototype = Constructor && Constructor.prototype;
              if (Prototype) createNonEnumerableProperty(Prototype, TYPED_ARRAY_CONSTRUCTOR, Constructor);
              else NATIVE_ARRAY_BUFFER_VIEWS = false;
            }

            for (NAME in BigIntArrayConstructorsList) {
              Constructor = global[NAME];
              Prototype = Constructor && Constructor.prototype;
              if (Prototype) createNonEnumerableProperty(Prototype, TYPED_ARRAY_CONSTRUCTOR, Constructor);
            }

            // WebKit bug - typed arrays constructors prototype is Object.prototype
            if (!NATIVE_ARRAY_BUFFER_VIEWS || !isCallable(TypedArray) || TypedArray === Function.prototype) {
              // eslint-disable-next-line no-shadow -- safe
              TypedArray = function TypedArray() {
                throw TypeError('Incorrect invocation');
              };
              if (NATIVE_ARRAY_BUFFER_VIEWS)
                for (NAME in TypedArrayConstructorsList) {
                  if (global[NAME]) setPrototypeOf(global[NAME], TypedArray);
                }
            }

            if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
              TypedArrayPrototype = TypedArray.prototype;
              if (NATIVE_ARRAY_BUFFER_VIEWS)
                for (NAME in TypedArrayConstructorsList) {
                  if (global[NAME]) setPrototypeOf(global[NAME].prototype, TypedArrayPrototype);
                }
            }

            // WebKit bug - one more object in Uint8ClampedArray prototype chain
            if (NATIVE_ARRAY_BUFFER_VIEWS && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
              setPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
            }

            if (DESCRIPTORS && !hasOwn(TypedArrayPrototype, TO_STRING_TAG)) {
              TYPED_ARRAY_TAG_REQUIRED = true;
              defineProperty(TypedArrayPrototype, TO_STRING_TAG, {
                get: function () {
                  return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
                }
              });
              for (NAME in TypedArrayConstructorsList)
                if (global[NAME]) {
                  createNonEnumerableProperty(global[NAME], TYPED_ARRAY_TAG, NAME);
                }
            }

            module.exports = {
              NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
              TYPED_ARRAY_CONSTRUCTOR: TYPED_ARRAY_CONSTRUCTOR,
              TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG,
              aTypedArray: aTypedArray,
              aTypedArrayConstructor: aTypedArrayConstructor,
              exportTypedArrayMethod: exportTypedArrayMethod,
              exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
              isView: isView,
              isTypedArray: isTypedArray,
              TypedArray: TypedArray,
              TypedArrayPrototype: TypedArrayPrototype
            };
          },
          {
            '../internals/array-buffer-native': 99,
            '../internals/classof': 121,
            '../internals/create-non-enumerable-property': 126,
            '../internals/descriptors': 131,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/is-callable': 173,
            '../internals/is-object': 177,
            '../internals/object-define-property': 195,
            '../internals/object-get-prototype-of': 200,
            '../internals/object-is-prototype-of': 201,
            '../internals/object-set-prototype-of': 205,
            '../internals/redefine': 219,
            '../internals/try-to-string': 254,
            '../internals/uid': 260,
            '../internals/well-known-symbol': 265
          }
        ],
        101: [
          function (require, module, exports) {
            'use strict';
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var DESCRIPTORS = require('../internals/descriptors');
            var NATIVE_ARRAY_BUFFER = require('../internals/array-buffer-native');
            var FunctionName = require('../internals/function-name');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var redefineAll = require('../internals/redefine-all');
            var fails = require('../internals/fails');
            var anInstance = require('../internals/an-instance');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');
            var toLength = require('../internals/to-length');
            var toIndex = require('../internals/to-index');
            var IEEE754 = require('../internals/ieee754');
            var getPrototypeOf = require('../internals/object-get-prototype-of');
            var setPrototypeOf = require('../internals/object-set-prototype-of');
            var getOwnPropertyNames = require('../internals/object-get-own-property-names').f;
            var defineProperty = require('../internals/object-define-property').f;
            var arrayFill = require('../internals/array-fill');
            var arraySlice = require('../internals/array-slice-simple');
            var setToStringTag = require('../internals/set-to-string-tag');
            var InternalStateModule = require('../internals/internal-state');

            var PROPER_FUNCTION_NAME = FunctionName.PROPER;
            var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
            var getInternalState = InternalStateModule.get;
            var setInternalState = InternalStateModule.set;
            var ARRAY_BUFFER = 'ArrayBuffer';
            var DATA_VIEW = 'DataView';
            var PROTOTYPE = 'prototype';
            var WRONG_LENGTH = 'Wrong length';
            var WRONG_INDEX = 'Wrong index';
            var NativeArrayBuffer = global[ARRAY_BUFFER];
            var $ArrayBuffer = NativeArrayBuffer;
            var ArrayBufferPrototype = $ArrayBuffer && $ArrayBuffer[PROTOTYPE];
            var $DataView = global[DATA_VIEW];
            var DataViewPrototype = $DataView && $DataView[PROTOTYPE];
            var ObjectPrototype = Object.prototype;
            var Array = global.Array;
            var RangeError = global.RangeError;
            var fill = uncurryThis(arrayFill);
            var reverse = uncurryThis([].reverse);

            var packIEEE754 = IEEE754.pack;
            var unpackIEEE754 = IEEE754.unpack;

            var packInt8 = function (number) {
              return [number & 0xff];
            };

            var packInt16 = function (number) {
              return [number & 0xff, (number >> 8) & 0xff];
            };

            var packInt32 = function (number) {
              return [number & 0xff, (number >> 8) & 0xff, (number >> 16) & 0xff, (number >> 24) & 0xff];
            };

            var unpackInt32 = function (buffer) {
              return (buffer[3] << 24) | (buffer[2] << 16) | (buffer[1] << 8) | buffer[0];
            };

            var packFloat32 = function (number) {
              return packIEEE754(number, 23, 4);
            };

            var packFloat64 = function (number) {
              return packIEEE754(number, 52, 8);
            };

            var addGetter = function (Constructor, key) {
              defineProperty(Constructor[PROTOTYPE], key, {
                get: function () {
                  return getInternalState(this)[key];
                }
              });
            };

            var get = function (view, count, index, isLittleEndian) {
              var intIndex = toIndex(index);
              var store = getInternalState(view);
              if (intIndex + count > store.byteLength) throw RangeError(WRONG_INDEX);
              var bytes = getInternalState(store.buffer).bytes;
              var start = intIndex + store.byteOffset;
              var pack = arraySlice(bytes, start, start + count);
              return isLittleEndian ? pack : reverse(pack);
            };

            var set = function (view, count, index, conversion, value, isLittleEndian) {
              var intIndex = toIndex(index);
              var store = getInternalState(view);
              if (intIndex + count > store.byteLength) throw RangeError(WRONG_INDEX);
              var bytes = getInternalState(store.buffer).bytes;
              var start = intIndex + store.byteOffset;
              var pack = conversion(+value);
              for (var i = 0; i < count; i++) bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
            };

            if (!NATIVE_ARRAY_BUFFER) {
              $ArrayBuffer = function ArrayBuffer(length) {
                anInstance(this, ArrayBufferPrototype);
                var byteLength = toIndex(length);
                setInternalState(this, {
                  bytes: fill(Array(byteLength), 0),
                  byteLength: byteLength
                });
                if (!DESCRIPTORS) this.byteLength = byteLength;
              };

              ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE];

              $DataView = function DataView(buffer, byteOffset, byteLength) {
                anInstance(this, DataViewPrototype);
                anInstance(buffer, ArrayBufferPrototype);
                var bufferLength = getInternalState(buffer).byteLength;
                var offset = toIntegerOrInfinity(byteOffset);
                if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset');
                byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
                if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);
                setInternalState(this, {
                  buffer: buffer,
                  byteLength: byteLength,
                  byteOffset: offset
                });
                if (!DESCRIPTORS) {
                  this.buffer = buffer;
                  this.byteLength = byteLength;
                  this.byteOffset = offset;
                }
              };

              DataViewPrototype = $DataView[PROTOTYPE];

              if (DESCRIPTORS) {
                addGetter($ArrayBuffer, 'byteLength');
                addGetter($DataView, 'buffer');
                addGetter($DataView, 'byteLength');
                addGetter($DataView, 'byteOffset');
              }

              redefineAll(DataViewPrototype, {
                getInt8: function getInt8(byteOffset) {
                  return (get(this, 1, byteOffset)[0] << 24) >> 24;
                },
                getUint8: function getUint8(byteOffset) {
                  return get(this, 1, byteOffset)[0];
                },
                getInt16: function getInt16(byteOffset /* , littleEndian */) {
                  var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
                  return (((bytes[1] << 8) | bytes[0]) << 16) >> 16;
                },
                getUint16: function getUint16(byteOffset /* , littleEndian */) {
                  var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
                  return (bytes[1] << 8) | bytes[0];
                },
                getInt32: function getInt32(byteOffset /* , littleEndian */) {
                  return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
                },
                getUint32: function getUint32(byteOffset /* , littleEndian */) {
                  return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
                },
                getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
                  return unpackIEEE754(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
                },
                getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
                  return unpackIEEE754(get(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
                },
                setInt8: function setInt8(byteOffset, value) {
                  set(this, 1, byteOffset, packInt8, value);
                },
                setUint8: function setUint8(byteOffset, value) {
                  set(this, 1, byteOffset, packInt8, value);
                },
                setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
                  set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
                },
                setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
                  set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
                },
                setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
                  set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
                },
                setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
                  set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
                },
                setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
                  set(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
                },
                setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
                  set(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
                }
              });
            } else {
              var INCORRECT_ARRAY_BUFFER_NAME = PROPER_FUNCTION_NAME && NativeArrayBuffer.name !== ARRAY_BUFFER;
              /* eslint-disable no-new -- required for testing */
              if (
                !fails(function () {
                  NativeArrayBuffer(1);
                }) ||
                !fails(function () {
                  new NativeArrayBuffer(-1);
                }) ||
                fails(function () {
                  new NativeArrayBuffer();
                  new NativeArrayBuffer(1.5);
                  new NativeArrayBuffer(NaN);
                  return INCORRECT_ARRAY_BUFFER_NAME && !CONFIGURABLE_FUNCTION_NAME;
                })
              ) {
                /* eslint-enable no-new -- required for testing */
                $ArrayBuffer = function ArrayBuffer(length) {
                  anInstance(this, ArrayBufferPrototype);
                  return new NativeArrayBuffer(toIndex(length));
                };

                $ArrayBuffer[PROTOTYPE] = ArrayBufferPrototype;

                for (var keys = getOwnPropertyNames(NativeArrayBuffer), j = 0, key; keys.length > j; ) {
                  if (!((key = keys[j++]) in $ArrayBuffer)) {
                    createNonEnumerableProperty($ArrayBuffer, key, NativeArrayBuffer[key]);
                  }
                }

                ArrayBufferPrototype.constructor = $ArrayBuffer;
              } else if (INCORRECT_ARRAY_BUFFER_NAME && CONFIGURABLE_FUNCTION_NAME) {
                createNonEnumerableProperty(NativeArrayBuffer, 'name', ARRAY_BUFFER);
              }

              // WebKit bug - the same parent prototype for typed arrays and data view
              if (setPrototypeOf && getPrototypeOf(DataViewPrototype) !== ObjectPrototype) {
                setPrototypeOf(DataViewPrototype, ObjectPrototype);
              }

              // iOS Safari 7.x bug
              var testView = new $DataView(new $ArrayBuffer(2));
              var $setInt8 = uncurryThis(DataViewPrototype.setInt8);
              testView.setInt8(0, 2147483648);
              testView.setInt8(1, 2147483649);
              if (testView.getInt8(0) || !testView.getInt8(1))
                redefineAll(
                  DataViewPrototype,
                  {
                    setInt8: function setInt8(byteOffset, value) {
                      $setInt8(this, byteOffset, (value << 24) >> 24);
                    },
                    setUint8: function setUint8(byteOffset, value) {
                      $setInt8(this, byteOffset, (value << 24) >> 24);
                    }
                  },
                  { unsafe: true }
                );
            }

            setToStringTag($ArrayBuffer, ARRAY_BUFFER);
            setToStringTag($DataView, DATA_VIEW);

            module.exports = {
              ArrayBuffer: $ArrayBuffer,
              DataView: $DataView
            };
          },
          {
            '../internals/an-instance': 97,
            '../internals/array-buffer-native': 99,
            '../internals/array-fill': 103,
            '../internals/array-slice-simple': 113,
            '../internals/create-non-enumerable-property': 126,
            '../internals/descriptors': 131,
            '../internals/fails': 147,
            '../internals/function-name': 153,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/ieee754': 166,
            '../internals/internal-state': 170,
            '../internals/object-define-property': 195,
            '../internals/object-get-own-property-names': 198,
            '../internals/object-get-prototype-of': 200,
            '../internals/object-set-prototype-of': 205,
            '../internals/redefine-all': 218,
            '../internals/set-to-string-tag': 231,
            '../internals/to-index': 243,
            '../internals/to-integer-or-infinity': 245,
            '../internals/to-length': 246
          }
        ],
        102: [
          function (require, module, exports) {
            'use strict';
            var toObject = require('../internals/to-object');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var lengthOfArrayLike = require('../internals/length-of-array-like');

            var min = Math.min;

            // `Array.prototype.copyWithin` method implementation
            // https://tc39.es/ecma262/#sec-array.prototype.copywithin
            // eslint-disable-next-line es-x/no-array-prototype-copywithin -- safe
            module.exports =
              [].copyWithin ||
              function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
                var O = toObject(this);
                var len = lengthOfArrayLike(O);
                var to = toAbsoluteIndex(target, len);
                var from = toAbsoluteIndex(start, len);
                var end = arguments.length > 2 ? arguments[2] : undefined;
                var count = min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
                var inc = 1;
                if (from < to && to < from + count) {
                  inc = -1;
                  from += count - 1;
                  to += count - 1;
                }
                while (count-- > 0) {
                  if (from in O) O[to] = O[from];
                  else delete O[to];
                  to += inc;
                  from += inc;
                }
                return O;
              };
          },
          {
            '../internals/length-of-array-like': 185,
            '../internals/to-absolute-index': 242,
            '../internals/to-object': 247
          }
        ],
        103: [
          function (require, module, exports) {
            'use strict';
            var toObject = require('../internals/to-object');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var lengthOfArrayLike = require('../internals/length-of-array-like');

            // `Array.prototype.fill` method implementation
            // https://tc39.es/ecma262/#sec-array.prototype.fill
            module.exports = function fill(value /* , start = 0, end = @length */) {
              var O = toObject(this);
              var length = lengthOfArrayLike(O);
              var argumentsLength = arguments.length;
              var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
              var end = argumentsLength > 2 ? arguments[2] : undefined;
              var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
              while (endPos > index) O[index++] = value;
              return O;
            };
          },
          {
            '../internals/length-of-array-like': 185,
            '../internals/to-absolute-index': 242,
            '../internals/to-object': 247
          }
        ],
        104: [
          function (require, module, exports) {
            'use strict';
            var $forEach = require('../internals/array-iteration').forEach;
            var arrayMethodIsStrict = require('../internals/array-method-is-strict');

            var STRICT_METHOD = arrayMethodIsStrict('forEach');

            // `Array.prototype.forEach` method implementation
            // https://tc39.es/ecma262/#sec-array.prototype.foreach
            module.exports = !STRICT_METHOD
              ? function forEach(callbackfn /* , thisArg */) {
                  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
                  // eslint-disable-next-line es-x/no-array-prototype-foreach -- safe
                }
              : [].forEach;
          },
          { '../internals/array-iteration': 108, '../internals/array-method-is-strict': 111 }
        ],
        105: [
          function (require, module, exports) {
            var lengthOfArrayLike = require('../internals/length-of-array-like');

            module.exports = function (Constructor, list) {
              var index = 0;
              var length = lengthOfArrayLike(list);
              var result = new Constructor(length);
              while (length > index) result[index] = list[index++];
              return result;
            };
          },
          { '../internals/length-of-array-like': 185 }
        ],
        106: [
          function (require, module, exports) {
            'use strict';
            var global = require('../internals/global');
            var bind = require('../internals/function-bind-context');
            var call = require('../internals/function-call');
            var toObject = require('../internals/to-object');
            var callWithSafeIterationClosing = require('../internals/call-with-safe-iteration-closing');
            var isArrayIteratorMethod = require('../internals/is-array-iterator-method');
            var isConstructor = require('../internals/is-constructor');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var createProperty = require('../internals/create-property');
            var getIterator = require('../internals/get-iterator');
            var getIteratorMethod = require('../internals/get-iterator-method');

            var Array = global.Array;

            // `Array.from` method implementation
            // https://tc39.es/ecma262/#sec-array.from
            module.exports = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
              var O = toObject(arrayLike);
              var IS_CONSTRUCTOR = isConstructor(this);
              var argumentsLength = arguments.length;
              var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
              var mapping = mapfn !== undefined;
              if (mapping) mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
              var iteratorMethod = getIteratorMethod(O);
              var index = 0;
              var length, result, step, iterator, next, value;
              // if the target is not iterable or it's an array with the default iterator - use a simple case
              if (iteratorMethod && !(this == Array && isArrayIteratorMethod(iteratorMethod))) {
                iterator = getIterator(O, iteratorMethod);
                next = iterator.next;
                result = IS_CONSTRUCTOR ? new this() : [];
                for (; !(step = call(next, iterator)).done; index++) {
                  value = mapping
                    ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true)
                    : step.value;
                  createProperty(result, index, value);
                }
              } else {
                length = lengthOfArrayLike(O);
                result = IS_CONSTRUCTOR ? new this(length) : Array(length);
                for (; length > index; index++) {
                  value = mapping ? mapfn(O[index], index) : O[index];
                  createProperty(result, index, value);
                }
              }
              result.length = index;
              return result;
            };
          },
          {
            '../internals/call-with-safe-iteration-closing': 118,
            '../internals/create-property': 128,
            '../internals/function-bind-context': 150,
            '../internals/function-call': 152,
            '../internals/get-iterator': 157,
            '../internals/get-iterator-method': 156,
            '../internals/global': 160,
            '../internals/is-array-iterator-method': 171,
            '../internals/is-constructor': 174,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247
          }
        ],
        107: [
          function (require, module, exports) {
            var toIndexedObject = require('../internals/to-indexed-object');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var lengthOfArrayLike = require('../internals/length-of-array-like');

            // `Array.prototype.{ indexOf, includes }` methods implementation
            var createMethod = function (IS_INCLUDES) {
              return function ($this, el, fromIndex) {
                var O = toIndexedObject($this);
                var length = lengthOfArrayLike(O);
                var index = toAbsoluteIndex(fromIndex, length);
                var value;
                // Array#includes uses SameValueZero equality algorithm
                // eslint-disable-next-line no-self-compare -- NaN check
                if (IS_INCLUDES && el != el)
                  while (length > index) {
                    value = O[index++];
                    // eslint-disable-next-line no-self-compare -- NaN check
                    if (value != value) return true;
                    // Array#indexOf ignores holes, Array#includes - not
                  }
                else
                  for (; length > index; index++) {
                    if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
                  }
                return !IS_INCLUDES && -1;
              };
            };

            module.exports = {
              // `Array.prototype.includes` method
              // https://tc39.es/ecma262/#sec-array.prototype.includes
              includes: createMethod(true),
              // `Array.prototype.indexOf` method
              // https://tc39.es/ecma262/#sec-array.prototype.indexof
              indexOf: createMethod(false)
            };
          },
          {
            '../internals/length-of-array-like': 185,
            '../internals/to-absolute-index': 242,
            '../internals/to-indexed-object': 244
          }
        ],
        108: [
          function (require, module, exports) {
            var bind = require('../internals/function-bind-context');
            var uncurryThis = require('../internals/function-uncurry-this');
            var IndexedObject = require('../internals/indexed-object');
            var toObject = require('../internals/to-object');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var arraySpeciesCreate = require('../internals/array-species-create');

            var push = uncurryThis([].push);

            // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
            var createMethod = function (TYPE) {
              var IS_MAP = TYPE == 1;
              var IS_FILTER = TYPE == 2;
              var IS_SOME = TYPE == 3;
              var IS_EVERY = TYPE == 4;
              var IS_FIND_INDEX = TYPE == 6;
              var IS_FILTER_REJECT = TYPE == 7;
              var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
              return function ($this, callbackfn, that, specificCreate) {
                var O = toObject($this);
                var self = IndexedObject(O);
                var boundFunction = bind(callbackfn, that);
                var length = lengthOfArrayLike(self);
                var index = 0;
                var create = specificCreate || arraySpeciesCreate;
                var target = IS_MAP
                  ? create($this, length)
                  : IS_FILTER || IS_FILTER_REJECT
                  ? create($this, 0)
                  : undefined;
                var value, result;
                for (; length > index; index++)
                  if (NO_HOLES || index in self) {
                    value = self[index];
                    result = boundFunction(value, index, O);
                    if (TYPE) {
                      if (IS_MAP) target[index] = result; // map
                      else if (result)
                        switch (TYPE) {
                          case 3:
                            return true; // some
                          case 5:
                            return value; // find
                          case 6:
                            return index; // findIndex
                          case 2:
                            push(target, value); // filter
                        }
                      else
                        switch (TYPE) {
                          case 4:
                            return false; // every
                          case 7:
                            push(target, value); // filterReject
                        }
                    }
                  }
                return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
              };
            };

            module.exports = {
              // `Array.prototype.forEach` method
              // https://tc39.es/ecma262/#sec-array.prototype.foreach
              forEach: createMethod(0),
              // `Array.prototype.map` method
              // https://tc39.es/ecma262/#sec-array.prototype.map
              map: createMethod(1),
              // `Array.prototype.filter` method
              // https://tc39.es/ecma262/#sec-array.prototype.filter
              filter: createMethod(2),
              // `Array.prototype.some` method
              // https://tc39.es/ecma262/#sec-array.prototype.some
              some: createMethod(3),
              // `Array.prototype.every` method
              // https://tc39.es/ecma262/#sec-array.prototype.every
              every: createMethod(4),
              // `Array.prototype.find` method
              // https://tc39.es/ecma262/#sec-array.prototype.find
              find: createMethod(5),
              // `Array.prototype.findIndex` method
              // https://tc39.es/ecma262/#sec-array.prototype.findIndex
              findIndex: createMethod(6),
              // `Array.prototype.filterReject` method
              // https://github.com/tc39/proposal-array-filtering
              filterReject: createMethod(7)
            };
          },
          {
            '../internals/array-species-create': 117,
            '../internals/function-bind-context': 150,
            '../internals/function-uncurry-this': 154,
            '../internals/indexed-object': 167,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247
          }
        ],
        109: [
          function (require, module, exports) {
            'use strict';
            /* eslint-disable es-x/no-array-prototype-lastindexof -- safe */
            var apply = require('../internals/function-apply');
            var toIndexedObject = require('../internals/to-indexed-object');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var arrayMethodIsStrict = require('../internals/array-method-is-strict');

            var min = Math.min;
            var $lastIndexOf = [].lastIndexOf;
            var NEGATIVE_ZERO = !!$lastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
            var STRICT_METHOD = arrayMethodIsStrict('lastIndexOf');
            var FORCED = NEGATIVE_ZERO || !STRICT_METHOD;

            // `Array.prototype.lastIndexOf` method implementation
            // https://tc39.es/ecma262/#sec-array.prototype.lastindexof
            module.exports = FORCED
              ? function lastIndexOf(searchElement /* , fromIndex = @[*-1] */) {
                  // convert -0 to +0
                  if (NEGATIVE_ZERO) return apply($lastIndexOf, this, arguments) || 0;
                  var O = toIndexedObject(this);
                  var length = lengthOfArrayLike(O);
                  var index = length - 1;
                  if (arguments.length > 1) index = min(index, toIntegerOrInfinity(arguments[1]));
                  if (index < 0) index = length + index;
                  for (; index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;
                  return -1;
                }
              : $lastIndexOf;
          },
          {
            '../internals/array-method-is-strict': 111,
            '../internals/function-apply': 149,
            '../internals/length-of-array-like': 185,
            '../internals/to-indexed-object': 244,
            '../internals/to-integer-or-infinity': 245
          }
        ],
        110: [
          function (require, module, exports) {
            var fails = require('../internals/fails');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var V8_VERSION = require('../internals/engine-v8-version');

            var SPECIES = wellKnownSymbol('species');

            module.exports = function (METHOD_NAME) {
              // We can't use this feature detection in V8 since it causes
              // deoptimization and serious performance degradation
              // https://github.com/zloirock/core-js/issues/677
              return (
                V8_VERSION >= 51 ||
                !fails(function () {
                  var array = [];
                  var constructor = (array.constructor = {});
                  constructor[SPECIES] = function () {
                    return { foo: 1 };
                  };
                  return array[METHOD_NAME](Boolean).foo !== 1;
                })
              );
            };
          },
          { '../internals/engine-v8-version': 143, '../internals/fails': 147, '../internals/well-known-symbol': 265 }
        ],
        111: [
          function (require, module, exports) {
            'use strict';
            var fails = require('../internals/fails');

            module.exports = function (METHOD_NAME, argument) {
              var method = [][METHOD_NAME];
              return (
                !!method &&
                fails(function () {
                  // eslint-disable-next-line no-useless-call -- required for testing
                  method.call(
                    null,
                    argument ||
                      function () {
                        return 1;
                      },
                    1
                  );
                })
              );
            };
          },
          { '../internals/fails': 147 }
        ],
        112: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var aCallable = require('../internals/a-callable');
            var toObject = require('../internals/to-object');
            var IndexedObject = require('../internals/indexed-object');
            var lengthOfArrayLike = require('../internals/length-of-array-like');

            var TypeError = global.TypeError;

            // `Array.prototype.{ reduce, reduceRight }` methods implementation
            var createMethod = function (IS_RIGHT) {
              return function (that, callbackfn, argumentsLength, memo) {
                aCallable(callbackfn);
                var O = toObject(that);
                var self = IndexedObject(O);
                var length = lengthOfArrayLike(O);
                var index = IS_RIGHT ? length - 1 : 0;
                var i = IS_RIGHT ? -1 : 1;
                if (argumentsLength < 2)
                  while (true) {
                    if (index in self) {
                      memo = self[index];
                      index += i;
                      break;
                    }
                    index += i;
                    if (IS_RIGHT ? index < 0 : length <= index) {
                      throw TypeError('Reduce of empty array with no initial value');
                    }
                  }
                for (; IS_RIGHT ? index >= 0 : length > index; index += i)
                  if (index in self) {
                    memo = callbackfn(memo, self[index], index, O);
                  }
                return memo;
              };
            };

            module.exports = {
              // `Array.prototype.reduce` method
              // https://tc39.es/ecma262/#sec-array.prototype.reduce
              left: createMethod(false),
              // `Array.prototype.reduceRight` method
              // https://tc39.es/ecma262/#sec-array.prototype.reduceright
              right: createMethod(true)
            };
          },
          {
            '../internals/a-callable': 92,
            '../internals/global': 160,
            '../internals/indexed-object': 167,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247
          }
        ],
        113: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var createProperty = require('../internals/create-property');

            var Array = global.Array;
            var max = Math.max;

            module.exports = function (O, start, end) {
              var length = lengthOfArrayLike(O);
              var k = toAbsoluteIndex(start, length);
              var fin = toAbsoluteIndex(end === undefined ? length : end, length);
              var result = Array(max(fin - k, 0));
              for (var n = 0; k < fin; k++, n++) createProperty(result, n, O[k]);
              result.length = n;
              return result;
            };
          },
          {
            '../internals/create-property': 128,
            '../internals/global': 160,
            '../internals/length-of-array-like': 185,
            '../internals/to-absolute-index': 242
          }
        ],
        114: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');

            module.exports = uncurryThis([].slice);
          },
          { '../internals/function-uncurry-this': 154 }
        ],
        115: [
          function (require, module, exports) {
            var arraySlice = require('../internals/array-slice-simple');

            var floor = Math.floor;

            var mergeSort = function (array, comparefn) {
              var length = array.length;
              var middle = floor(length / 2);
              return length < 8
                ? insertionSort(array, comparefn)
                : merge(
                    array,
                    mergeSort(arraySlice(array, 0, middle), comparefn),
                    mergeSort(arraySlice(array, middle), comparefn),
                    comparefn
                  );
            };

            var insertionSort = function (array, comparefn) {
              var length = array.length;
              var i = 1;
              var element, j;

              while (i < length) {
                j = i;
                element = array[i];
                while (j && comparefn(array[j - 1], element) > 0) {
                  array[j] = array[--j];
                }
                if (j !== i++) array[j] = element;
              }
              return array;
            };

            var merge = function (array, left, right, comparefn) {
              var llength = left.length;
              var rlength = right.length;
              var lindex = 0;
              var rindex = 0;

              while (lindex < llength || rindex < rlength) {
                array[lindex + rindex] =
                  lindex < llength && rindex < rlength
                    ? comparefn(left[lindex], right[rindex]) <= 0
                      ? left[lindex++]
                      : right[rindex++]
                    : lindex < llength
                    ? left[lindex++]
                    : right[rindex++];
              }
              return array;
            };

            module.exports = mergeSort;
          },
          { '../internals/array-slice-simple': 113 }
        ],
        116: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isArray = require('../internals/is-array');
            var isConstructor = require('../internals/is-constructor');
            var isObject = require('../internals/is-object');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var SPECIES = wellKnownSymbol('species');
            var Array = global.Array;

            // a part of `ArraySpeciesCreate` abstract operation
            // https://tc39.es/ecma262/#sec-arrayspeciescreate
            module.exports = function (originalArray) {
              var C;
              if (isArray(originalArray)) {
                C = originalArray.constructor;
                // cross-realm fallback
                if (isConstructor(C) && (C === Array || isArray(C.prototype))) C = undefined;
                else if (isObject(C)) {
                  C = C[SPECIES];
                  if (C === null) C = undefined;
                }
              }
              return C === undefined ? Array : C;
            };
          },
          {
            '../internals/global': 160,
            '../internals/is-array': 172,
            '../internals/is-constructor': 174,
            '../internals/is-object': 177,
            '../internals/well-known-symbol': 265
          }
        ],
        117: [
          function (require, module, exports) {
            var arraySpeciesConstructor = require('../internals/array-species-constructor');

            // `ArraySpeciesCreate` abstract operation
            // https://tc39.es/ecma262/#sec-arrayspeciescreate
            module.exports = function (originalArray, length) {
              return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
            };
          },
          { '../internals/array-species-constructor': 116 }
        ],
        118: [
          function (require, module, exports) {
            var anObject = require('../internals/an-object');
            var iteratorClose = require('../internals/iterator-close');

            // call something on iterator step with safe closing on error
            module.exports = function (iterator, fn, value, ENTRIES) {
              try {
                return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
              } catch (error) {
                iteratorClose(iterator, 'throw', error);
              }
            };
          },
          { '../internals/an-object': 98, '../internals/iterator-close': 182 }
        ],
        119: [
          function (require, module, exports) {
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var ITERATOR = wellKnownSymbol('iterator');
            var SAFE_CLOSING = false;

            try {
              var called = 0;
              var iteratorWithReturn = {
                next: function () {
                  return { done: !!called++ };
                },
                return: function () {
                  SAFE_CLOSING = true;
                }
              };
              iteratorWithReturn[ITERATOR] = function () {
                return this;
              };
              // eslint-disable-next-line es-x/no-array-from, no-throw-literal -- required for testing
              Array.from(iteratorWithReturn, function () {
                throw 2;
              });
            } catch (error) {
              /* empty */
            }

            module.exports = function (exec, SKIP_CLOSING) {
              if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
              var ITERATION_SUPPORT = false;
              try {
                var object = {};
                object[ITERATOR] = function () {
                  return {
                    next: function () {
                      return { done: (ITERATION_SUPPORT = true) };
                    }
                  };
                };
                exec(object);
              } catch (error) {
                /* empty */
              }
              return ITERATION_SUPPORT;
            };
          },
          { '../internals/well-known-symbol': 265 }
        ],
        120: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');

            var toString = uncurryThis({}.toString);
            var stringSlice = uncurryThis(''.slice);

            module.exports = function (it) {
              return stringSlice(toString(it), 8, -1);
            };
          },
          { '../internals/function-uncurry-this': 154 }
        ],
        121: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var TO_STRING_TAG_SUPPORT = require('../internals/to-string-tag-support');
            var isCallable = require('../internals/is-callable');
            var classofRaw = require('../internals/classof-raw');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var TO_STRING_TAG = wellKnownSymbol('toStringTag');
            var Object = global.Object;

            // ES3 wrong here
            var CORRECT_ARGUMENTS =
              classofRaw(
                (function () {
                  return arguments;
                })()
              ) == 'Arguments';

            // fallback for IE11 Script Access Denied error
            var tryGet = function (it, key) {
              try {
                return it[key];
              } catch (error) {
                /* empty */
              }
            };

            // getting tag from ES6+ `Object.prototype.toString`
            module.exports = TO_STRING_TAG_SUPPORT
              ? classofRaw
              : function (it) {
                  var O, tag, result;
                  return it === undefined
                    ? 'Undefined'
                    : it === null
                    ? 'Null'
                    : // @@toStringTag case
                    typeof (tag = tryGet((O = Object(it)), TO_STRING_TAG)) == 'string'
                    ? tag
                    : // builtinTag case
                    CORRECT_ARGUMENTS
                    ? classofRaw(O)
                    : // ES3 arguments fallback
                    (result = classofRaw(O)) == 'Object' && isCallable(O.callee)
                    ? 'Arguments'
                    : result;
                };
          },
          {
            '../internals/classof-raw': 120,
            '../internals/global': 160,
            '../internals/is-callable': 173,
            '../internals/to-string-tag-support': 252,
            '../internals/well-known-symbol': 265
          }
        ],
        122: [
          function (require, module, exports) {
            var hasOwn = require('../internals/has-own-property');
            var ownKeys = require('../internals/own-keys');
            var getOwnPropertyDescriptorModule = require('../internals/object-get-own-property-descriptor');
            var definePropertyModule = require('../internals/object-define-property');

            module.exports = function (target, source, exceptions) {
              var keys = ownKeys(source);
              var defineProperty = definePropertyModule.f;
              var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
              for (var i = 0; i < keys.length; i++) {
                var key = keys[i];
                if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
                  defineProperty(target, key, getOwnPropertyDescriptor(source, key));
                }
              }
            };
          },
          {
            '../internals/has-own-property': 161,
            '../internals/object-define-property': 195,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/own-keys': 209
          }
        ],
        123: [
          function (require, module, exports) {
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var MATCH = wellKnownSymbol('match');

            module.exports = function (METHOD_NAME) {
              var regexp = /./;
              try {
                '/./'[METHOD_NAME](regexp);
              } catch (error1) {
                try {
                  regexp[MATCH] = false;
                  return '/./'[METHOD_NAME](regexp);
                } catch (error2) {
                  /* empty */
                }
              }
              return false;
            };
          },
          { '../internals/well-known-symbol': 265 }
        ],
        124: [
          function (require, module, exports) {
            var fails = require('../internals/fails');

            module.exports = !fails(function () {
              function F() {
                /* empty */
              }
              F.prototype.constructor = null;
              // eslint-disable-next-line es-x/no-object-getprototypeof -- required for testing
              return Object.getPrototypeOf(new F()) !== F.prototype;
            });
          },
          { '../internals/fails': 147 }
        ],
        125: [
          function (require, module, exports) {
            'use strict';
            var IteratorPrototype = require('../internals/iterators-core').IteratorPrototype;
            var create = require('../internals/object-create');
            var createPropertyDescriptor = require('../internals/create-property-descriptor');
            var setToStringTag = require('../internals/set-to-string-tag');
            var Iterators = require('../internals/iterators');

            var returnThis = function () {
              return this;
            };

            module.exports = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
              var TO_STRING_TAG = NAME + ' Iterator';
              IteratorConstructor.prototype = create(IteratorPrototype, {
                next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next)
              });
              setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
              Iterators[TO_STRING_TAG] = returnThis;
              return IteratorConstructor;
            };
          },
          {
            '../internals/create-property-descriptor': 127,
            '../internals/iterators': 184,
            '../internals/iterators-core': 183,
            '../internals/object-create': 193,
            '../internals/set-to-string-tag': 231
          }
        ],
        126: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var definePropertyModule = require('../internals/object-define-property');
            var createPropertyDescriptor = require('../internals/create-property-descriptor');

            module.exports = DESCRIPTORS
              ? function (object, key, value) {
                  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
                }
              : function (object, key, value) {
                  object[key] = value;
                  return object;
                };
          },
          {
            '../internals/create-property-descriptor': 127,
            '../internals/descriptors': 131,
            '../internals/object-define-property': 195
          }
        ],
        127: [
          function (require, module, exports) {
            module.exports = function (bitmap, value) {
              return {
                enumerable: !(bitmap & 1),
                configurable: !(bitmap & 2),
                writable: !(bitmap & 4),
                value: value
              };
            };
          },
          {}
        ],
        128: [
          function (require, module, exports) {
            'use strict';
            var toPropertyKey = require('../internals/to-property-key');
            var definePropertyModule = require('../internals/object-define-property');
            var createPropertyDescriptor = require('../internals/create-property-descriptor');

            module.exports = function (object, key, value) {
              var propertyKey = toPropertyKey(key);
              if (propertyKey in object)
                definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
              else object[propertyKey] = value;
            };
          },
          {
            '../internals/create-property-descriptor': 127,
            '../internals/object-define-property': 195,
            '../internals/to-property-key': 251
          }
        ],
        129: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var call = require('../internals/function-call');
            var IS_PURE = require('../internals/is-pure');
            var FunctionName = require('../internals/function-name');
            var isCallable = require('../internals/is-callable');
            var createIteratorConstructor = require('../internals/create-iterator-constructor');
            var getPrototypeOf = require('../internals/object-get-prototype-of');
            var setPrototypeOf = require('../internals/object-set-prototype-of');
            var setToStringTag = require('../internals/set-to-string-tag');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var redefine = require('../internals/redefine');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var Iterators = require('../internals/iterators');
            var IteratorsCore = require('../internals/iterators-core');

            var PROPER_FUNCTION_NAME = FunctionName.PROPER;
            var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
            var IteratorPrototype = IteratorsCore.IteratorPrototype;
            var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
            var ITERATOR = wellKnownSymbol('iterator');
            var KEYS = 'keys';
            var VALUES = 'values';
            var ENTRIES = 'entries';

            var returnThis = function () {
              return this;
            };

            module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
              createIteratorConstructor(IteratorConstructor, NAME, next);

              var getIterationMethod = function (KIND) {
                if (KIND === DEFAULT && defaultIterator) return defaultIterator;
                if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
                switch (KIND) {
                  case KEYS:
                    return function keys() {
                      return new IteratorConstructor(this, KIND);
                    };
                  case VALUES:
                    return function values() {
                      return new IteratorConstructor(this, KIND);
                    };
                  case ENTRIES:
                    return function entries() {
                      return new IteratorConstructor(this, KIND);
                    };
                }
                return function () {
                  return new IteratorConstructor(this);
                };
              };

              var TO_STRING_TAG = NAME + ' Iterator';
              var INCORRECT_VALUES_NAME = false;
              var IterablePrototype = Iterable.prototype;
              var nativeIterator =
                IterablePrototype[ITERATOR] ||
                IterablePrototype['@@iterator'] ||
                (DEFAULT && IterablePrototype[DEFAULT]);
              var defaultIterator = (!BUGGY_SAFARI_ITERATORS && nativeIterator) || getIterationMethod(DEFAULT);
              var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
              var CurrentIteratorPrototype, methods, KEY;

              // fix native
              if (anyNativeIterator) {
                CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
                if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
                  if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
                    if (setPrototypeOf) {
                      setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
                    } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
                      redefine(CurrentIteratorPrototype, ITERATOR, returnThis);
                    }
                  }
                  // Set @@toStringTag to native iterators
                  setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
                  if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
                }
              }

              // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
              if (PROPER_FUNCTION_NAME && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
                if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
                  createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
                } else {
                  INCORRECT_VALUES_NAME = true;
                  defaultIterator = function values() {
                    return call(nativeIterator, this);
                  };
                }
              }

              // export additional methods
              if (DEFAULT) {
                methods = {
                  values: getIterationMethod(VALUES),
                  keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
                  entries: getIterationMethod(ENTRIES)
                };
                if (FORCED)
                  for (KEY in methods) {
                    if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
                      redefine(IterablePrototype, KEY, methods[KEY]);
                    }
                  }
                else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
              }

              // define iterator
              if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
                redefine(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
              }
              Iterators[NAME] = defaultIterator;

              return methods;
            };
          },
          {
            '../internals/create-iterator-constructor': 125,
            '../internals/create-non-enumerable-property': 126,
            '../internals/export': 146,
            '../internals/function-call': 152,
            '../internals/function-name': 153,
            '../internals/is-callable': 173,
            '../internals/is-pure': 178,
            '../internals/iterators': 184,
            '../internals/iterators-core': 183,
            '../internals/object-get-prototype-of': 200,
            '../internals/object-set-prototype-of': 205,
            '../internals/redefine': 219,
            '../internals/set-to-string-tag': 231,
            '../internals/well-known-symbol': 265
          }
        ],
        130: [
          function (require, module, exports) {
            var path = require('../internals/path');
            var hasOwn = require('../internals/has-own-property');
            var wrappedWellKnownSymbolModule = require('../internals/well-known-symbol-wrapped');
            var defineProperty = require('../internals/object-define-property').f;

            module.exports = function (NAME) {
              var Symbol = path.Symbol || (path.Symbol = {});
              if (!hasOwn(Symbol, NAME))
                defineProperty(Symbol, NAME, {
                  value: wrappedWellKnownSymbolModule.f(NAME)
                });
            };
          },
          {
            '../internals/has-own-property': 161,
            '../internals/object-define-property': 195,
            '../internals/path': 210,
            '../internals/well-known-symbol-wrapped': 264
          }
        ],
        131: [
          function (require, module, exports) {
            var fails = require('../internals/fails');

            // Detect IE8's incomplete defineProperty implementation
            module.exports = !fails(function () {
              // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
              return (
                Object.defineProperty({}, 1, {
                  get: function () {
                    return 7;
                  }
                })[1] != 7
              );
            });
          },
          { '../internals/fails': 147 }
        ],
        132: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isObject = require('../internals/is-object');

            var document = global.document;
            // typeof document.createElement is 'object' in old IE
            var EXISTS = isObject(document) && isObject(document.createElement);

            module.exports = function (it) {
              return EXISTS ? document.createElement(it) : {};
            };
          },
          { '../internals/global': 160, '../internals/is-object': 177 }
        ],
        133: [
          function (require, module, exports) {
            // iterable DOM collections
            // flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
            module.exports = {
              CSSRuleList: 0,
              CSSStyleDeclaration: 0,
              CSSValueList: 0,
              ClientRectList: 0,
              DOMRectList: 0,
              DOMStringList: 0,
              DOMTokenList: 1,
              DataTransferItemList: 0,
              FileList: 0,
              HTMLAllCollection: 0,
              HTMLCollection: 0,
              HTMLFormElement: 0,
              HTMLSelectElement: 0,
              MediaList: 0,
              MimeTypeArray: 0,
              NamedNodeMap: 0,
              NodeList: 1,
              PaintRequestList: 0,
              Plugin: 0,
              PluginArray: 0,
              SVGLengthList: 0,
              SVGNumberList: 0,
              SVGPathSegList: 0,
              SVGPointList: 0,
              SVGStringList: 0,
              SVGTransformList: 0,
              SourceBufferList: 0,
              StyleSheetList: 0,
              TextTrackCueList: 0,
              TextTrackList: 0,
              TouchList: 0
            };
          },
          {}
        ],
        134: [
          function (require, module, exports) {
            // in old WebKit versions, `element.classList` is not an instance of global `DOMTokenList`
            var documentCreateElement = require('../internals/document-create-element');

            var classList = documentCreateElement('span').classList;
            var DOMTokenListPrototype = classList && classList.constructor && classList.constructor.prototype;

            module.exports = DOMTokenListPrototype === Object.prototype ? undefined : DOMTokenListPrototype;
          },
          { '../internals/document-create-element': 132 }
        ],
        135: [
          function (require, module, exports) {
            var userAgent = require('../internals/engine-user-agent');

            var firefox = userAgent.match(/firefox\/(\d+)/i);

            module.exports = !!firefox && +firefox[1];
          },
          { '../internals/engine-user-agent': 142 }
        ],
        136: [
          function (require, module, exports) {
            module.exports = typeof window == 'object' && typeof Deno != 'object';
          },
          {}
        ],
        137: [
          function (require, module, exports) {
            var UA = require('../internals/engine-user-agent');

            module.exports = /MSIE|Trident/.test(UA);
          },
          { '../internals/engine-user-agent': 142 }
        ],
        138: [
          function (require, module, exports) {
            var userAgent = require('../internals/engine-user-agent');
            var global = require('../internals/global');

            module.exports = /ipad|iphone|ipod/i.test(userAgent) && global.Pebble !== undefined;
          },
          { '../internals/engine-user-agent': 142, '../internals/global': 160 }
        ],
        139: [
          function (require, module, exports) {
            var userAgent = require('../internals/engine-user-agent');

            module.exports = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent);
          },
          { '../internals/engine-user-agent': 142 }
        ],
        140: [
          function (require, module, exports) {
            var classof = require('../internals/classof-raw');
            var global = require('../internals/global');

            module.exports = classof(global.process) == 'process';
          },
          { '../internals/classof-raw': 120, '../internals/global': 160 }
        ],
        141: [
          function (require, module, exports) {
            var userAgent = require('../internals/engine-user-agent');

            module.exports = /web0s(?!.*chrome)/i.test(userAgent);
          },
          { '../internals/engine-user-agent': 142 }
        ],
        142: [
          function (require, module, exports) {
            var getBuiltIn = require('../internals/get-built-in');

            module.exports = getBuiltIn('navigator', 'userAgent') || '';
          },
          { '../internals/get-built-in': 155 }
        ],
        143: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var userAgent = require('../internals/engine-user-agent');

            var process = global.process;
            var Deno = global.Deno;
            var versions = (process && process.versions) || (Deno && Deno.version);
            var v8 = versions && versions.v8;
            var match, version;

            if (v8) {
              match = v8.split('.');
              // in old Chrome, versions of V8 isn't V8 = Chrome / 10
              // but their correct versions are not interesting for us
              version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
            }

            // BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
            // so check `userAgent` even if `.v8` exists, but 0
            if (!version && userAgent) {
              match = userAgent.match(/Edge\/(\d+)/);
              if (!match || match[1] >= 74) {
                match = userAgent.match(/Chrome\/(\d+)/);
                if (match) version = +match[1];
              }
            }

            module.exports = version;
          },
          { '../internals/engine-user-agent': 142, '../internals/global': 160 }
        ],
        144: [
          function (require, module, exports) {
            var userAgent = require('../internals/engine-user-agent');

            var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

            module.exports = !!webkit && +webkit[1];
          },
          { '../internals/engine-user-agent': 142 }
        ],
        145: [
          function (require, module, exports) {
            // IE8- don't enum bug keys
            module.exports = [
              'constructor',
              'hasOwnProperty',
              'isPrototypeOf',
              'propertyIsEnumerable',
              'toLocaleString',
              'toString',
              'valueOf'
            ];
          },
          {}
        ],
        146: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var getOwnPropertyDescriptor = require('../internals/object-get-own-property-descriptor').f;
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var redefine = require('../internals/redefine');
            var setGlobal = require('../internals/set-global');
            var copyConstructorProperties = require('../internals/copy-constructor-properties');
            var isForced = require('../internals/is-forced');

            /*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
  options.name        - the .name of the function if it does not match the key
*/
            module.exports = function (options, source) {
              var TARGET = options.target;
              var GLOBAL = options.global;
              var STATIC = options.stat;
              var FORCED, target, key, targetProperty, sourceProperty, descriptor;
              if (GLOBAL) {
                target = global;
              } else if (STATIC) {
                target = global[TARGET] || setGlobal(TARGET, {});
              } else {
                target = (global[TARGET] || {}).prototype;
              }
              if (target)
                for (key in source) {
                  sourceProperty = source[key];
                  if (options.noTargetGet) {
                    descriptor = getOwnPropertyDescriptor(target, key);
                    targetProperty = descriptor && descriptor.value;
                  } else targetProperty = target[key];
                  FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
                  // contained in target
                  if (!FORCED && targetProperty !== undefined) {
                    if (typeof sourceProperty == typeof targetProperty) continue;
                    copyConstructorProperties(sourceProperty, targetProperty);
                  }
                  // add a flag to not completely full polyfills
                  if (options.sham || (targetProperty && targetProperty.sham)) {
                    createNonEnumerableProperty(sourceProperty, 'sham', true);
                  }
                  // extend global
                  redefine(target, key, sourceProperty, options);
                }
            };
          },
          {
            '../internals/copy-constructor-properties': 122,
            '../internals/create-non-enumerable-property': 126,
            '../internals/global': 160,
            '../internals/is-forced': 175,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/redefine': 219,
            '../internals/set-global': 229
          }
        ],
        147: [
          function (require, module, exports) {
            module.exports = function (exec) {
              try {
                return !!exec();
              } catch (error) {
                return true;
              }
            };
          },
          {}
        ],
        148: [
          function (require, module, exports) {
            'use strict';
            // TODO: Remove from `core-js@4` since it's moved to entry points
            require('../modules/es.regexp.exec');
            var uncurryThis = require('../internals/function-uncurry-this');
            var redefine = require('../internals/redefine');
            var regexpExec = require('../internals/regexp-exec');
            var fails = require('../internals/fails');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');

            var SPECIES = wellKnownSymbol('species');
            var RegExpPrototype = RegExp.prototype;

            module.exports = function (KEY, exec, FORCED, SHAM) {
              var SYMBOL = wellKnownSymbol(KEY);

              var DELEGATES_TO_SYMBOL = !fails(function () {
                // String methods call symbol-named RegEp methods
                var O = {};
                O[SYMBOL] = function () {
                  return 7;
                };
                return ''[KEY](O) != 7;
              });

              var DELEGATES_TO_EXEC =
                DELEGATES_TO_SYMBOL &&
                !fails(function () {
                  // Symbol-named RegExp methods call .exec
                  var execCalled = false;
                  var re = /a/;

                  if (KEY === 'split') {
                    // We can't use real regex here since it causes deoptimization
                    // and serious performance degradation in V8
                    // https://github.com/zloirock/core-js/issues/306
                    re = {};
                    // RegExp[@@split] doesn't call the regex's exec method, but first creates
                    // a new one. We need to return the patched regex when creating the new one.
                    re.constructor = {};
                    re.constructor[SPECIES] = function () {
                      return re;
                    };
                    re.flags = '';
                    re[SYMBOL] = /./[SYMBOL];
                  }

                  re.exec = function () {
                    execCalled = true;
                    return null;
                  };

                  re[SYMBOL]('');
                  return !execCalled;
                });

              if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || FORCED) {
                var uncurriedNativeRegExpMethod = uncurryThis(/./[SYMBOL]);
                var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
                  var uncurriedNativeMethod = uncurryThis(nativeMethod);
                  var $exec = regexp.exec;
                  if ($exec === regexpExec || $exec === RegExpPrototype.exec) {
                    if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
                      // The native String method already delegates to @@method (this
                      // polyfilled function), leasing to infinite recursion.
                      // We avoid it by directly calling the native @@method method.
                      return { done: true, value: uncurriedNativeRegExpMethod(regexp, str, arg2) };
                    }
                    return { done: true, value: uncurriedNativeMethod(str, regexp, arg2) };
                  }
                  return { done: false };
                });

                redefine(String.prototype, KEY, methods[0]);
                redefine(RegExpPrototype, SYMBOL, methods[1]);
              }

              if (SHAM) createNonEnumerableProperty(RegExpPrototype[SYMBOL], 'sham', true);
            };
          },
          {
            '../internals/create-non-enumerable-property': 126,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/redefine': 219,
            '../internals/regexp-exec': 221,
            '../internals/well-known-symbol': 265,
            '../modules/es.regexp.exec': 299
          }
        ],
        149: [
          function (require, module, exports) {
            var NATIVE_BIND = require('../internals/function-bind-native');

            var FunctionPrototype = Function.prototype;
            var apply = FunctionPrototype.apply;
            var call = FunctionPrototype.call;

            // eslint-disable-next-line es-x/no-reflect -- safe
            module.exports =
              (typeof Reflect == 'object' && Reflect.apply) ||
              (NATIVE_BIND
                ? call.bind(apply)
                : function () {
                    return call.apply(apply, arguments);
                  });
          },
          { '../internals/function-bind-native': 151 }
        ],
        150: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var aCallable = require('../internals/a-callable');
            var NATIVE_BIND = require('../internals/function-bind-native');

            var bind = uncurryThis(uncurryThis.bind);

            // optional / simple context binding
            module.exports = function (fn, that) {
              aCallable(fn);
              return that === undefined
                ? fn
                : NATIVE_BIND
                ? bind(fn, that)
                : function (/* ...args */) {
                    return fn.apply(that, arguments);
                  };
            };
          },
          {
            '../internals/a-callable': 92,
            '../internals/function-bind-native': 151,
            '../internals/function-uncurry-this': 154
          }
        ],
        151: [
          function (require, module, exports) {
            var fails = require('../internals/fails');

            module.exports = !fails(function () {
              // eslint-disable-next-line es-x/no-function-prototype-bind -- safe
              var test = function () {
                /* empty */
              }.bind();
              // eslint-disable-next-line no-prototype-builtins -- safe
              return typeof test != 'function' || test.hasOwnProperty('prototype');
            });
          },
          { '../internals/fails': 147 }
        ],
        152: [
          function (require, module, exports) {
            var NATIVE_BIND = require('../internals/function-bind-native');

            var call = Function.prototype.call;

            module.exports = NATIVE_BIND
              ? call.bind(call)
              : function () {
                  return call.apply(call, arguments);
                };
          },
          { '../internals/function-bind-native': 151 }
        ],
        153: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var hasOwn = require('../internals/has-own-property');

            var FunctionPrototype = Function.prototype;
            // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
            var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;

            var EXISTS = hasOwn(FunctionPrototype, 'name');
            // additional protection from minified / mangled / dropped function names
            var PROPER =
              EXISTS &&
              function something() {
                /* empty */
              }.name === 'something';
            var CONFIGURABLE =
              EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));

            module.exports = {
              EXISTS: EXISTS,
              PROPER: PROPER,
              CONFIGURABLE: CONFIGURABLE
            };
          },
          { '../internals/descriptors': 131, '../internals/has-own-property': 161 }
        ],
        154: [
          function (require, module, exports) {
            var NATIVE_BIND = require('../internals/function-bind-native');

            var FunctionPrototype = Function.prototype;
            var bind = FunctionPrototype.bind;
            var call = FunctionPrototype.call;
            var uncurryThis = NATIVE_BIND && bind.bind(call, call);

            module.exports = NATIVE_BIND
              ? function (fn) {
                  return fn && uncurryThis(fn);
                }
              : function (fn) {
                  return (
                    fn &&
                    function () {
                      return call.apply(fn, arguments);
                    }
                  );
                };
          },
          { '../internals/function-bind-native': 151 }
        ],
        155: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isCallable = require('../internals/is-callable');

            var aFunction = function (argument) {
              return isCallable(argument) ? argument : undefined;
            };

            module.exports = function (namespace, method) {
              return arguments.length < 2
                ? aFunction(global[namespace])
                : global[namespace] && global[namespace][method];
            };
          },
          { '../internals/global': 160, '../internals/is-callable': 173 }
        ],
        156: [
          function (require, module, exports) {
            var classof = require('../internals/classof');
            var getMethod = require('../internals/get-method');
            var Iterators = require('../internals/iterators');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var ITERATOR = wellKnownSymbol('iterator');

            module.exports = function (it) {
              if (it != undefined)
                return getMethod(it, ITERATOR) || getMethod(it, '@@iterator') || Iterators[classof(it)];
            };
          },
          {
            '../internals/classof': 121,
            '../internals/get-method': 158,
            '../internals/iterators': 184,
            '../internals/well-known-symbol': 265
          }
        ],
        157: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var aCallable = require('../internals/a-callable');
            var anObject = require('../internals/an-object');
            var tryToString = require('../internals/try-to-string');
            var getIteratorMethod = require('../internals/get-iterator-method');

            var TypeError = global.TypeError;

            module.exports = function (argument, usingIterator) {
              var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
              if (aCallable(iteratorMethod)) return anObject(call(iteratorMethod, argument));
              throw TypeError(tryToString(argument) + ' is not iterable');
            };
          },
          {
            '../internals/a-callable': 92,
            '../internals/an-object': 98,
            '../internals/function-call': 152,
            '../internals/get-iterator-method': 156,
            '../internals/global': 160,
            '../internals/try-to-string': 254
          }
        ],
        158: [
          function (require, module, exports) {
            var aCallable = require('../internals/a-callable');

            // `GetMethod` abstract operation
            // https://tc39.es/ecma262/#sec-getmethod
            module.exports = function (V, P) {
              var func = V[P];
              return func == null ? undefined : aCallable(func);
            };
          },
          { '../internals/a-callable': 92 }
        ],
        159: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var toObject = require('../internals/to-object');

            var floor = Math.floor;
            var charAt = uncurryThis(''.charAt);
            var replace = uncurryThis(''.replace);
            var stringSlice = uncurryThis(''.slice);
            var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
            var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;

            // `GetSubstitution` abstract operation
            // https://tc39.es/ecma262/#sec-getsubstitution
            module.exports = function (matched, str, position, captures, namedCaptures, replacement) {
              var tailPos = position + matched.length;
              var m = captures.length;
              var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
              if (namedCaptures !== undefined) {
                namedCaptures = toObject(namedCaptures);
                symbols = SUBSTITUTION_SYMBOLS;
              }
              return replace(replacement, symbols, function (match, ch) {
                var capture;
                switch (charAt(ch, 0)) {
                  case '$':
                    return '$';
                  case '&':
                    return matched;
                  case '`':
                    return stringSlice(str, 0, position);
                  case "'":
                    return stringSlice(str, tailPos);
                  case '<':
                    capture = namedCaptures[stringSlice(ch, 1, -1)];
                    break;
                  default: // \d\d?
                    var n = +ch;
                    if (n === 0) return match;
                    if (n > m) {
                      var f = floor(n / 10);
                      if (f === 0) return match;
                      if (f <= m)
                        return captures[f - 1] === undefined ? charAt(ch, 1) : captures[f - 1] + charAt(ch, 1);
                      return match;
                    }
                    capture = captures[n - 1];
                }
                return capture === undefined ? '' : capture;
              });
            };
          },
          { '../internals/function-uncurry-this': 154, '../internals/to-object': 247 }
        ],
        160: [
          function (require, module, exports) {
            (function (global) {
              (function () {
                var check = function (it) {
                  return it && it.Math == Math && it;
                };

                // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
                module.exports =
                  // eslint-disable-next-line es-x/no-global-this -- safe
                  check(typeof globalThis == 'object' && globalThis) ||
                  check(typeof window == 'object' && window) ||
                  // eslint-disable-next-line no-restricted-globals -- safe
                  check(typeof self == 'object' && self) ||
                  check(typeof global == 'object' && global) ||
                  // eslint-disable-next-line no-new-func -- fallback
                  (function () {
                    return this;
                  })() ||
                  Function('return this')();
              }).call(this);
            }).call(
              this,
              typeof global !== 'undefined'
                ? global
                : typeof self !== 'undefined'
                ? self
                : typeof window !== 'undefined'
                ? window
                : {}
            );
          },
          {}
        ],
        161: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var toObject = require('../internals/to-object');

            var hasOwnProperty = uncurryThis({}.hasOwnProperty);

            // `HasOwnProperty` abstract operation
            // https://tc39.es/ecma262/#sec-hasownproperty
            // eslint-disable-next-line es-x/no-object-hasown -- safe
            module.exports =
              Object.hasOwn ||
              function hasOwn(it, key) {
                return hasOwnProperty(toObject(it), key);
              };
          },
          { '../internals/function-uncurry-this': 154, '../internals/to-object': 247 }
        ],
        162: [
          function (require, module, exports) {
            module.exports = {};
          },
          {}
        ],
        163: [
          function (require, module, exports) {
            var global = require('../internals/global');

            module.exports = function (a, b) {
              var console = global.console;
              if (console && console.error) {
                arguments.length == 1 ? console.error(a) : console.error(a, b);
              }
            };
          },
          { '../internals/global': 160 }
        ],
        164: [
          function (require, module, exports) {
            var getBuiltIn = require('../internals/get-built-in');

            module.exports = getBuiltIn('document', 'documentElement');
          },
          { '../internals/get-built-in': 155 }
        ],
        165: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var fails = require('../internals/fails');
            var createElement = require('../internals/document-create-element');

            // Thanks to IE8 for its funny defineProperty
            module.exports =
              !DESCRIPTORS &&
              !fails(function () {
                // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
                return (
                  Object.defineProperty(createElement('div'), 'a', {
                    get: function () {
                      return 7;
                    }
                  }).a != 7
                );
              });
          },
          { '../internals/descriptors': 131, '../internals/document-create-element': 132, '../internals/fails': 147 }
        ],
        166: [
          function (require, module, exports) {
            // IEEE754 conversions based on https://github.com/feross/ieee754
            var global = require('../internals/global');

            var Array = global.Array;
            var abs = Math.abs;
            var pow = Math.pow;
            var floor = Math.floor;
            var log = Math.log;
            var LN2 = Math.LN2;

            var pack = function (number, mantissaLength, bytes) {
              var buffer = Array(bytes);
              var exponentLength = bytes * 8 - mantissaLength - 1;
              var eMax = (1 << exponentLength) - 1;
              var eBias = eMax >> 1;
              var rt = mantissaLength === 23 ? pow(2, -24) - pow(2, -77) : 0;
              var sign = number < 0 || (number === 0 && 1 / number < 0) ? 1 : 0;
              var index = 0;
              var exponent, mantissa, c;
              number = abs(number);
              // eslint-disable-next-line no-self-compare -- NaN check
              if (number != number || number === Infinity) {
                // eslint-disable-next-line no-self-compare -- NaN check
                mantissa = number != number ? 1 : 0;
                exponent = eMax;
              } else {
                exponent = floor(log(number) / LN2);
                c = pow(2, -exponent);
                if (number * c < 1) {
                  exponent--;
                  c *= 2;
                }
                if (exponent + eBias >= 1) {
                  number += rt / c;
                } else {
                  number += rt * pow(2, 1 - eBias);
                }
                if (number * c >= 2) {
                  exponent++;
                  c /= 2;
                }
                if (exponent + eBias >= eMax) {
                  mantissa = 0;
                  exponent = eMax;
                } else if (exponent + eBias >= 1) {
                  mantissa = (number * c - 1) * pow(2, mantissaLength);
                  exponent = exponent + eBias;
                } else {
                  mantissa = number * pow(2, eBias - 1) * pow(2, mantissaLength);
                  exponent = 0;
                }
              }
              while (mantissaLength >= 8) {
                buffer[index++] = mantissa & 255;
                mantissa /= 256;
                mantissaLength -= 8;
              }
              exponent = (exponent << mantissaLength) | mantissa;
              exponentLength += mantissaLength;
              while (exponentLength > 0) {
                buffer[index++] = exponent & 255;
                exponent /= 256;
                exponentLength -= 8;
              }
              buffer[--index] |= sign * 128;
              return buffer;
            };

            var unpack = function (buffer, mantissaLength) {
              var bytes = buffer.length;
              var exponentLength = bytes * 8 - mantissaLength - 1;
              var eMax = (1 << exponentLength) - 1;
              var eBias = eMax >> 1;
              var nBits = exponentLength - 7;
              var index = bytes - 1;
              var sign = buffer[index--];
              var exponent = sign & 127;
              var mantissa;
              sign >>= 7;
              while (nBits > 0) {
                exponent = exponent * 256 + buffer[index--];
                nBits -= 8;
              }
              mantissa = exponent & ((1 << -nBits) - 1);
              exponent >>= -nBits;
              nBits += mantissaLength;
              while (nBits > 0) {
                mantissa = mantissa * 256 + buffer[index--];
                nBits -= 8;
              }
              if (exponent === 0) {
                exponent = 1 - eBias;
              } else if (exponent === eMax) {
                return mantissa ? NaN : sign ? -Infinity : Infinity;
              } else {
                mantissa = mantissa + pow(2, mantissaLength);
                exponent = exponent - eBias;
              }
              return (sign ? -1 : 1) * mantissa * pow(2, exponent - mantissaLength);
            };

            module.exports = {
              pack: pack,
              unpack: unpack
            };
          },
          { '../internals/global': 160 }
        ],
        167: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var fails = require('../internals/fails');
            var classof = require('../internals/classof-raw');

            var Object = global.Object;
            var split = uncurryThis(''.split);

            // fallback for non-array-like ES3 and non-enumerable old V8 strings
            module.exports = fails(function () {
              // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
              // eslint-disable-next-line no-prototype-builtins -- safe
              return !Object('z').propertyIsEnumerable(0);
            })
              ? function (it) {
                  return classof(it) == 'String' ? split(it, '') : Object(it);
                }
              : Object;
          },
          {
            '../internals/classof-raw': 120,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160
          }
        ],
        168: [
          function (require, module, exports) {
            var isCallable = require('../internals/is-callable');
            var isObject = require('../internals/is-object');
            var setPrototypeOf = require('../internals/object-set-prototype-of');

            // makes subclassing work correct for wrapped built-ins
            module.exports = function ($this, dummy, Wrapper) {
              var NewTarget, NewTargetPrototype;
              if (
                // it can work only with native `setPrototypeOf`
                setPrototypeOf &&
                // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
                isCallable((NewTarget = dummy.constructor)) &&
                NewTarget !== Wrapper &&
                isObject((NewTargetPrototype = NewTarget.prototype)) &&
                NewTargetPrototype !== Wrapper.prototype
              )
                setPrototypeOf($this, NewTargetPrototype);
              return $this;
            };
          },
          {
            '../internals/is-callable': 173,
            '../internals/is-object': 177,
            '../internals/object-set-prototype-of': 205
          }
        ],
        169: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var isCallable = require('../internals/is-callable');
            var store = require('../internals/shared-store');

            var functionToString = uncurryThis(Function.toString);

            // this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
            if (!isCallable(store.inspectSource)) {
              store.inspectSource = function (it) {
                return functionToString(it);
              };
            }

            module.exports = store.inspectSource;
          },
          {
            '../internals/function-uncurry-this': 154,
            '../internals/is-callable': 173,
            '../internals/shared-store': 233
          }
        ],
        170: [
          function (require, module, exports) {
            var NATIVE_WEAK_MAP = require('../internals/native-weak-map');
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var isObject = require('../internals/is-object');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var hasOwn = require('../internals/has-own-property');
            var shared = require('../internals/shared-store');
            var sharedKey = require('../internals/shared-key');
            var hiddenKeys = require('../internals/hidden-keys');

            var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
            var TypeError = global.TypeError;
            var WeakMap = global.WeakMap;
            var set, get, has;

            var enforce = function (it) {
              return has(it) ? get(it) : set(it, {});
            };

            var getterFor = function (TYPE) {
              return function (it) {
                var state;
                if (!isObject(it) || (state = get(it)).type !== TYPE) {
                  throw TypeError('Incompatible receiver, ' + TYPE + ' required');
                }
                return state;
              };
            };

            if (NATIVE_WEAK_MAP || shared.state) {
              var store = shared.state || (shared.state = new WeakMap());
              var wmget = uncurryThis(store.get);
              var wmhas = uncurryThis(store.has);
              var wmset = uncurryThis(store.set);
              set = function (it, metadata) {
                if (wmhas(store, it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
                metadata.facade = it;
                wmset(store, it, metadata);
                return metadata;
              };
              get = function (it) {
                return wmget(store, it) || {};
              };
              has = function (it) {
                return wmhas(store, it);
              };
            } else {
              var STATE = sharedKey('state');
              hiddenKeys[STATE] = true;
              set = function (it, metadata) {
                if (hasOwn(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
                metadata.facade = it;
                createNonEnumerableProperty(it, STATE, metadata);
                return metadata;
              };
              get = function (it) {
                return hasOwn(it, STATE) ? it[STATE] : {};
              };
              has = function (it) {
                return hasOwn(it, STATE);
              };
            }

            module.exports = {
              set: set,
              get: get,
              has: has,
              enforce: enforce,
              getterFor: getterFor
            };
          },
          {
            '../internals/create-non-enumerable-property': 126,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/hidden-keys': 162,
            '../internals/is-object': 177,
            '../internals/native-weak-map': 189,
            '../internals/shared-key': 232,
            '../internals/shared-store': 233
          }
        ],
        171: [
          function (require, module, exports) {
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var Iterators = require('../internals/iterators');

            var ITERATOR = wellKnownSymbol('iterator');
            var ArrayPrototype = Array.prototype;

            // check on default Array iterator
            module.exports = function (it) {
              return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
            };
          },
          { '../internals/iterators': 184, '../internals/well-known-symbol': 265 }
        ],
        172: [
          function (require, module, exports) {
            var classof = require('../internals/classof-raw');

            // `IsArray` abstract operation
            // https://tc39.es/ecma262/#sec-isarray
            // eslint-disable-next-line es-x/no-array-isarray -- safe
            module.exports =
              Array.isArray ||
              function isArray(argument) {
                return classof(argument) == 'Array';
              };
          },
          { '../internals/classof-raw': 120 }
        ],
        173: [
          function (require, module, exports) {
            // `IsCallable` abstract operation
            // https://tc39.es/ecma262/#sec-iscallable
            module.exports = function (argument) {
              return typeof argument == 'function';
            };
          },
          {}
        ],
        174: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var fails = require('../internals/fails');
            var isCallable = require('../internals/is-callable');
            var classof = require('../internals/classof');
            var getBuiltIn = require('../internals/get-built-in');
            var inspectSource = require('../internals/inspect-source');

            var noop = function () {
              /* empty */
            };
            var empty = [];
            var construct = getBuiltIn('Reflect', 'construct');
            var constructorRegExp = /^\s*(?:class|function)\b/;
            var exec = uncurryThis(constructorRegExp.exec);
            var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

            var isConstructorModern = function isConstructor(argument) {
              if (!isCallable(argument)) return false;
              try {
                construct(noop, empty, argument);
                return true;
              } catch (error) {
                return false;
              }
            };

            var isConstructorLegacy = function isConstructor(argument) {
              if (!isCallable(argument)) return false;
              switch (classof(argument)) {
                case 'AsyncFunction':
                case 'GeneratorFunction':
                case 'AsyncGeneratorFunction':
                  return false;
              }
              try {
                // we can't check .prototype since constructors produced by .bind haven't it
                // `Function#toString` throws on some built-it function in some legacy engines
                // (for example, `DOMQuad` and similar in FF41-)
                return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
              } catch (error) {
                return true;
              }
            };

            isConstructorLegacy.sham = true;

            // `IsConstructor` abstract operation
            // https://tc39.es/ecma262/#sec-isconstructor
            module.exports =
              !construct ||
              fails(function () {
                var called;
                return (
                  isConstructorModern(isConstructorModern.call) ||
                  !isConstructorModern(Object) ||
                  !isConstructorModern(function () {
                    called = true;
                  }) ||
                  called
                );
              })
                ? isConstructorLegacy
                : isConstructorModern;
          },
          {
            '../internals/classof': 121,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/get-built-in': 155,
            '../internals/inspect-source': 169,
            '../internals/is-callable': 173
          }
        ],
        175: [
          function (require, module, exports) {
            var fails = require('../internals/fails');
            var isCallable = require('../internals/is-callable');

            var replacement = /#|\.prototype\./;

            var isForced = function (feature, detection) {
              var value = data[normalize(feature)];
              return value == POLYFILL
                ? true
                : value == NATIVE
                ? false
                : isCallable(detection)
                ? fails(detection)
                : !!detection;
            };

            var normalize = (isForced.normalize = function (string) {
              return String(string).replace(replacement, '.').toLowerCase();
            });

            var data = (isForced.data = {});
            var NATIVE = (isForced.NATIVE = 'N');
            var POLYFILL = (isForced.POLYFILL = 'P');

            module.exports = isForced;
          },
          { '../internals/fails': 147, '../internals/is-callable': 173 }
        ],
        176: [
          function (require, module, exports) {
            var isObject = require('../internals/is-object');

            var floor = Math.floor;

            // `IsIntegralNumber` abstract operation
            // https://tc39.es/ecma262/#sec-isintegralnumber
            // eslint-disable-next-line es-x/no-number-isinteger -- safe
            module.exports =
              Number.isInteger ||
              function isInteger(it) {
                return !isObject(it) && isFinite(it) && floor(it) === it;
              };
          },
          { '../internals/is-object': 177 }
        ],
        177: [
          function (require, module, exports) {
            var isCallable = require('../internals/is-callable');

            module.exports = function (it) {
              return typeof it == 'object' ? it !== null : isCallable(it);
            };
          },
          { '../internals/is-callable': 173 }
        ],
        178: [
          function (require, module, exports) {
            module.exports = false;
          },
          {}
        ],
        179: [
          function (require, module, exports) {
            var isObject = require('../internals/is-object');
            var classof = require('../internals/classof-raw');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var MATCH = wellKnownSymbol('match');

            // `IsRegExp` abstract operation
            // https://tc39.es/ecma262/#sec-isregexp
            module.exports = function (it) {
              var isRegExp;
              return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classof(it) == 'RegExp');
            };
          },
          { '../internals/classof-raw': 120, '../internals/is-object': 177, '../internals/well-known-symbol': 265 }
        ],
        180: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var getBuiltIn = require('../internals/get-built-in');
            var isCallable = require('../internals/is-callable');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var USE_SYMBOL_AS_UID = require('../internals/use-symbol-as-uid');

            var Object = global.Object;

            module.exports = USE_SYMBOL_AS_UID
              ? function (it) {
                  return typeof it == 'symbol';
                }
              : function (it) {
                  var $Symbol = getBuiltIn('Symbol');
                  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, Object(it));
                };
          },
          {
            '../internals/get-built-in': 155,
            '../internals/global': 160,
            '../internals/is-callable': 173,
            '../internals/object-is-prototype-of': 201,
            '../internals/use-symbol-as-uid': 261
          }
        ],
        181: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var bind = require('../internals/function-bind-context');
            var call = require('../internals/function-call');
            var anObject = require('../internals/an-object');
            var tryToString = require('../internals/try-to-string');
            var isArrayIteratorMethod = require('../internals/is-array-iterator-method');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var getIterator = require('../internals/get-iterator');
            var getIteratorMethod = require('../internals/get-iterator-method');
            var iteratorClose = require('../internals/iterator-close');

            var TypeError = global.TypeError;

            var Result = function (stopped, result) {
              this.stopped = stopped;
              this.result = result;
            };

            var ResultPrototype = Result.prototype;

            module.exports = function (iterable, unboundFunction, options) {
              var that = options && options.that;
              var AS_ENTRIES = !!(options && options.AS_ENTRIES);
              var IS_ITERATOR = !!(options && options.IS_ITERATOR);
              var INTERRUPTED = !!(options && options.INTERRUPTED);
              var fn = bind(unboundFunction, that);
              var iterator, iterFn, index, length, result, next, step;

              var stop = function (condition) {
                if (iterator) iteratorClose(iterator, 'normal', condition);
                return new Result(true, condition);
              };

              var callFn = function (value) {
                if (AS_ENTRIES) {
                  anObject(value);
                  return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
                }
                return INTERRUPTED ? fn(value, stop) : fn(value);
              };

              if (IS_ITERATOR) {
                iterator = iterable;
              } else {
                iterFn = getIteratorMethod(iterable);
                if (!iterFn) throw TypeError(tryToString(iterable) + ' is not iterable');
                // optimisation for array iterators
                if (isArrayIteratorMethod(iterFn)) {
                  for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
                    result = callFn(iterable[index]);
                    if (result && isPrototypeOf(ResultPrototype, result)) return result;
                  }
                  return new Result(false);
                }
                iterator = getIterator(iterable, iterFn);
              }

              next = iterator.next;
              while (!(step = call(next, iterator)).done) {
                try {
                  result = callFn(step.value);
                } catch (error) {
                  iteratorClose(iterator, 'throw', error);
                }
                if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
              }
              return new Result(false);
            };
          },
          {
            '../internals/an-object': 98,
            '../internals/function-bind-context': 150,
            '../internals/function-call': 152,
            '../internals/get-iterator': 157,
            '../internals/get-iterator-method': 156,
            '../internals/global': 160,
            '../internals/is-array-iterator-method': 171,
            '../internals/iterator-close': 182,
            '../internals/length-of-array-like': 185,
            '../internals/object-is-prototype-of': 201,
            '../internals/try-to-string': 254
          }
        ],
        182: [
          function (require, module, exports) {
            var call = require('../internals/function-call');
            var anObject = require('../internals/an-object');
            var getMethod = require('../internals/get-method');

            module.exports = function (iterator, kind, value) {
              var innerResult, innerError;
              anObject(iterator);
              try {
                innerResult = getMethod(iterator, 'return');
                if (!innerResult) {
                  if (kind === 'throw') throw value;
                  return value;
                }
                innerResult = call(innerResult, iterator);
              } catch (error) {
                innerError = true;
                innerResult = error;
              }
              if (kind === 'throw') throw value;
              if (innerError) throw innerResult;
              anObject(innerResult);
              return value;
            };
          },
          { '../internals/an-object': 98, '../internals/function-call': 152, '../internals/get-method': 158 }
        ],
        183: [
          function (require, module, exports) {
            'use strict';
            var fails = require('../internals/fails');
            var isCallable = require('../internals/is-callable');
            var create = require('../internals/object-create');
            var getPrototypeOf = require('../internals/object-get-prototype-of');
            var redefine = require('../internals/redefine');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var IS_PURE = require('../internals/is-pure');

            var ITERATOR = wellKnownSymbol('iterator');
            var BUGGY_SAFARI_ITERATORS = false;

            // `%IteratorPrototype%` object
            // https://tc39.es/ecma262/#sec-%iteratorprototype%-object
            var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

            /* eslint-disable es-x/no-array-prototype-keys -- safe */
            if ([].keys) {
              arrayIterator = [].keys();
              // Safari 8 has buggy iterators w/o `next`
              if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
              else {
                PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
                if (PrototypeOfArrayIteratorPrototype !== Object.prototype)
                  IteratorPrototype = PrototypeOfArrayIteratorPrototype;
              }
            }

            var NEW_ITERATOR_PROTOTYPE =
              IteratorPrototype == undefined ||
              fails(function () {
                var test = {};
                // FF44- legacy iterators case
                return IteratorPrototype[ITERATOR].call(test) !== test;
              });

            if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
            else if (IS_PURE) IteratorPrototype = create(IteratorPrototype);

            // `%IteratorPrototype%[@@iterator]()` method
            // https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
            if (!isCallable(IteratorPrototype[ITERATOR])) {
              redefine(IteratorPrototype, ITERATOR, function () {
                return this;
              });
            }

            module.exports = {
              IteratorPrototype: IteratorPrototype,
              BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
            };
          },
          {
            '../internals/fails': 147,
            '../internals/is-callable': 173,
            '../internals/is-pure': 178,
            '../internals/object-create': 193,
            '../internals/object-get-prototype-of': 200,
            '../internals/redefine': 219,
            '../internals/well-known-symbol': 265
          }
        ],
        184: [
          function (require, module, exports) {
            arguments[4][162][0].apply(exports, arguments);
          },
          { dup: 162 }
        ],
        185: [
          function (require, module, exports) {
            var toLength = require('../internals/to-length');

            // `LengthOfArrayLike` abstract operation
            // https://tc39.es/ecma262/#sec-lengthofarraylike
            module.exports = function (obj) {
              return toLength(obj.length);
            };
          },
          { '../internals/to-length': 246 }
        ],
        186: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var bind = require('../internals/function-bind-context');
            var getOwnPropertyDescriptor = require('../internals/object-get-own-property-descriptor').f;
            var macrotask = require('../internals/task').set;
            var IS_IOS = require('../internals/engine-is-ios');
            var IS_IOS_PEBBLE = require('../internals/engine-is-ios-pebble');
            var IS_WEBOS_WEBKIT = require('../internals/engine-is-webos-webkit');
            var IS_NODE = require('../internals/engine-is-node');

            var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
            var document = global.document;
            var process = global.process;
            var Promise = global.Promise;
            // Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
            var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
            var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;

            var flush, head, last, notify, toggle, node, promise, then;

            // modern engines have queueMicrotask method
            if (!queueMicrotask) {
              flush = function () {
                var parent, fn;
                if (IS_NODE && (parent = process.domain)) parent.exit();
                while (head) {
                  fn = head.fn;
                  head = head.next;
                  try {
                    fn();
                  } catch (error) {
                    if (head) notify();
                    else last = undefined;
                    throw error;
                  }
                }
                last = undefined;
                if (parent) parent.enter();
              };

              // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
              // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
              if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
                toggle = true;
                node = document.createTextNode('');
                new MutationObserver(flush).observe(node, { characterData: true });
                notify = function () {
                  node.data = toggle = !toggle;
                };
                // environments with maybe non-completely correct, but existent Promise
              } else if (!IS_IOS_PEBBLE && Promise && Promise.resolve) {
                // Promise.resolve without an argument throws an error in LG WebOS 2
                promise = Promise.resolve(undefined);
                // workaround of WebKit ~ iOS Safari 10.1 bug
                promise.constructor = Promise;
                then = bind(promise.then, promise);
                notify = function () {
                  then(flush);
                };
                // Node.js without promises
              } else if (IS_NODE) {
                notify = function () {
                  process.nextTick(flush);
                };
                // for other environments - macrotask based on:
                // - setImmediate
                // - MessageChannel
                // - window.postMessage
                // - onreadystatechange
                // - setTimeout
              } else {
                // strange IE + webpack dev server bug - use .bind(global)
                macrotask = bind(macrotask, global);
                notify = function () {
                  macrotask(flush);
                };
              }
            }

            module.exports =
              queueMicrotask ||
              function (fn) {
                var task = { fn: fn, next: undefined };
                if (last) last.next = task;
                if (!head) {
                  head = task;
                  notify();
                }
                last = task;
              };
          },
          {
            '../internals/engine-is-ios': 139,
            '../internals/engine-is-ios-pebble': 138,
            '../internals/engine-is-node': 140,
            '../internals/engine-is-webos-webkit': 141,
            '../internals/function-bind-context': 150,
            '../internals/global': 160,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/task': 240
          }
        ],
        187: [
          function (require, module, exports) {
            var NATIVE_SYMBOL = require('../internals/native-symbol');

            /* eslint-disable es-x/no-symbol -- safe */
            module.exports = NATIVE_SYMBOL && !!Symbol['for'] && !!Symbol.keyFor;
          },
          { '../internals/native-symbol': 188 }
        ],
        188: [
          function (require, module, exports) {
            /* eslint-disable es-x/no-symbol -- required for testing */
            var V8_VERSION = require('../internals/engine-v8-version');
            var fails = require('../internals/fails');

            // eslint-disable-next-line es-x/no-object-getownpropertysymbols -- required for testing
            module.exports =
              !!Object.getOwnPropertySymbols &&
              !fails(function () {
                var symbol = Symbol();
                // Chrome 38 Symbol has incorrect toString conversion
                // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
                return (
                  !String(symbol) ||
                  !(Object(symbol) instanceof Symbol) ||
                  // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
                  (!Symbol.sham && V8_VERSION && V8_VERSION < 41)
                );
              });
          },
          { '../internals/engine-v8-version': 143, '../internals/fails': 147 }
        ],
        189: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isCallable = require('../internals/is-callable');
            var inspectSource = require('../internals/inspect-source');

            var WeakMap = global.WeakMap;

            module.exports = isCallable(WeakMap) && /native code/.test(inspectSource(WeakMap));
          },
          { '../internals/global': 160, '../internals/inspect-source': 169, '../internals/is-callable': 173 }
        ],
        190: [
          function (require, module, exports) {
            'use strict';
            var aCallable = require('../internals/a-callable');

            var PromiseCapability = function (C) {
              var resolve, reject;
              this.promise = new C(function ($$resolve, $$reject) {
                if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
                resolve = $$resolve;
                reject = $$reject;
              });
              this.resolve = aCallable(resolve);
              this.reject = aCallable(reject);
            };

            // `NewPromiseCapability` abstract operation
            // https://tc39.es/ecma262/#sec-newpromisecapability
            module.exports.f = function (C) {
              return new PromiseCapability(C);
            };
          },
          { '../internals/a-callable': 92 }
        ],
        191: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isRegExp = require('../internals/is-regexp');

            var TypeError = global.TypeError;

            module.exports = function (it) {
              if (isRegExp(it)) {
                throw TypeError("The method doesn't accept regular expressions");
              }
              return it;
            };
          },
          { '../internals/global': 160, '../internals/is-regexp': 179 }
        ],
        192: [
          function (require, module, exports) {
            'use strict';
            var DESCRIPTORS = require('../internals/descriptors');
            var uncurryThis = require('../internals/function-uncurry-this');
            var call = require('../internals/function-call');
            var fails = require('../internals/fails');
            var objectKeys = require('../internals/object-keys');
            var getOwnPropertySymbolsModule = require('../internals/object-get-own-property-symbols');
            var propertyIsEnumerableModule = require('../internals/object-property-is-enumerable');
            var toObject = require('../internals/to-object');
            var IndexedObject = require('../internals/indexed-object');

            // eslint-disable-next-line es-x/no-object-assign -- safe
            var $assign = Object.assign;
            // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
            var defineProperty = Object.defineProperty;
            var concat = uncurryThis([].concat);

            // `Object.assign` method
            // https://tc39.es/ecma262/#sec-object.assign
            module.exports =
              !$assign ||
              fails(function () {
                // should have correct order of operations (Edge bug)
                if (
                  DESCRIPTORS &&
                  $assign(
                    { b: 1 },
                    $assign(
                      defineProperty({}, 'a', {
                        enumerable: true,
                        get: function () {
                          defineProperty(this, 'b', {
                            value: 3,
                            enumerable: false
                          });
                        }
                      }),
                      { b: 2 }
                    )
                  ).b !== 1
                )
                  return true;
                // should work with symbols and should have deterministic property order (V8 bug)
                var A = {};
                var B = {};
                // eslint-disable-next-line es-x/no-symbol -- safe
                var symbol = Symbol();
                var alphabet = 'abcdefghijklmnopqrst';
                A[symbol] = 7;
                alphabet.split('').forEach(function (chr) {
                  B[chr] = chr;
                });
                return $assign({}, A)[symbol] != 7 || objectKeys($assign({}, B)).join('') != alphabet;
              })
                ? function assign(target, source) {
                    // eslint-disable-line no-unused-vars -- required for `.length`
                    var T = toObject(target);
                    var argumentsLength = arguments.length;
                    var index = 1;
                    var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
                    var propertyIsEnumerable = propertyIsEnumerableModule.f;
                    while (argumentsLength > index) {
                      var S = IndexedObject(arguments[index++]);
                      var keys = getOwnPropertySymbols
                        ? concat(objectKeys(S), getOwnPropertySymbols(S))
                        : objectKeys(S);
                      var length = keys.length;
                      var j = 0;
                      var key;
                      while (length > j) {
                        key = keys[j++];
                        if (!DESCRIPTORS || call(propertyIsEnumerable, S, key)) T[key] = S[key];
                      }
                    }
                    return T;
                  }
                : $assign;
          },
          {
            '../internals/descriptors': 131,
            '../internals/fails': 147,
            '../internals/function-call': 152,
            '../internals/function-uncurry-this': 154,
            '../internals/indexed-object': 167,
            '../internals/object-get-own-property-symbols': 199,
            '../internals/object-keys': 203,
            '../internals/object-property-is-enumerable': 204,
            '../internals/to-object': 247
          }
        ],
        193: [
          function (require, module, exports) {
            /* global ActiveXObject -- old IE, WSH */
            var anObject = require('../internals/an-object');
            var definePropertiesModule = require('../internals/object-define-properties');
            var enumBugKeys = require('../internals/enum-bug-keys');
            var hiddenKeys = require('../internals/hidden-keys');
            var html = require('../internals/html');
            var documentCreateElement = require('../internals/document-create-element');
            var sharedKey = require('../internals/shared-key');

            var GT = '>';
            var LT = '<';
            var PROTOTYPE = 'prototype';
            var SCRIPT = 'script';
            var IE_PROTO = sharedKey('IE_PROTO');

            var EmptyConstructor = function () {
              /* empty */
            };

            var scriptTag = function (content) {
              return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
            };

            // Create object with fake `null` prototype: use ActiveX Object with cleared prototype
            var NullProtoObjectViaActiveX = function (activeXDocument) {
              activeXDocument.write(scriptTag(''));
              activeXDocument.close();
              var temp = activeXDocument.parentWindow.Object;
              activeXDocument = null; // avoid memory leak
              return temp;
            };

            // Create object with fake `null` prototype: use iframe Object with cleared prototype
            var NullProtoObjectViaIFrame = function () {
              // Thrash, waste and sodomy: IE GC bug
              var iframe = documentCreateElement('iframe');
              var JS = 'java' + SCRIPT + ':';
              var iframeDocument;
              iframe.style.display = 'none';
              html.appendChild(iframe);
              // https://github.com/zloirock/core-js/issues/475
              iframe.src = String(JS);
              iframeDocument = iframe.contentWindow.document;
              iframeDocument.open();
              iframeDocument.write(scriptTag('document.F=Object'));
              iframeDocument.close();
              return iframeDocument.F;
            };

            // Check for document.domain and active x support
            // No need to use active x approach when document.domain is not set
            // see https://github.com/es-shims/es5-shim/issues/150
            // variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
            // avoid IE GC bug
            var activeXDocument;
            var NullProtoObject = function () {
              try {
                activeXDocument = new ActiveXObject('htmlfile');
              } catch (error) {
                /* ignore */
              }
              NullProtoObject =
                typeof document != 'undefined'
                  ? document.domain && activeXDocument
                    ? NullProtoObjectViaActiveX(activeXDocument) // old IE
                    : NullProtoObjectViaIFrame()
                  : NullProtoObjectViaActiveX(activeXDocument); // WSH
              var length = enumBugKeys.length;
              while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
              return NullProtoObject();
            };

            hiddenKeys[IE_PROTO] = true;

            // `Object.create` method
            // https://tc39.es/ecma262/#sec-object.create
            // eslint-disable-next-line es-x/no-object-create -- safe
            module.exports =
              Object.create ||
              function create(O, Properties) {
                var result;
                if (O !== null) {
                  EmptyConstructor[PROTOTYPE] = anObject(O);
                  result = new EmptyConstructor();
                  EmptyConstructor[PROTOTYPE] = null;
                  // add "__proto__" for Object.getPrototypeOf polyfill
                  result[IE_PROTO] = O;
                } else result = NullProtoObject();
                return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
              };
          },
          {
            '../internals/an-object': 98,
            '../internals/document-create-element': 132,
            '../internals/enum-bug-keys': 145,
            '../internals/hidden-keys': 162,
            '../internals/html': 164,
            '../internals/object-define-properties': 194,
            '../internals/shared-key': 232
          }
        ],
        194: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var V8_PROTOTYPE_DEFINE_BUG = require('../internals/v8-prototype-define-bug');
            var definePropertyModule = require('../internals/object-define-property');
            var anObject = require('../internals/an-object');
            var toIndexedObject = require('../internals/to-indexed-object');
            var objectKeys = require('../internals/object-keys');

            // `Object.defineProperties` method
            // https://tc39.es/ecma262/#sec-object.defineproperties
            // eslint-disable-next-line es-x/no-object-defineproperties -- safe
            exports.f =
              DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG
                ? Object.defineProperties
                : function defineProperties(O, Properties) {
                    anObject(O);
                    var props = toIndexedObject(Properties);
                    var keys = objectKeys(Properties);
                    var length = keys.length;
                    var index = 0;
                    var key;
                    while (length > index) definePropertyModule.f(O, (key = keys[index++]), props[key]);
                    return O;
                  };
          },
          {
            '../internals/an-object': 98,
            '../internals/descriptors': 131,
            '../internals/object-define-property': 195,
            '../internals/object-keys': 203,
            '../internals/to-indexed-object': 244,
            '../internals/v8-prototype-define-bug': 262
          }
        ],
        195: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var DESCRIPTORS = require('../internals/descriptors');
            var IE8_DOM_DEFINE = require('../internals/ie8-dom-define');
            var V8_PROTOTYPE_DEFINE_BUG = require('../internals/v8-prototype-define-bug');
            var anObject = require('../internals/an-object');
            var toPropertyKey = require('../internals/to-property-key');

            var TypeError = global.TypeError;
            // eslint-disable-next-line es-x/no-object-defineproperty -- safe
            var $defineProperty = Object.defineProperty;
            // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
            var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
            var ENUMERABLE = 'enumerable';
            var CONFIGURABLE = 'configurable';
            var WRITABLE = 'writable';

            // `Object.defineProperty` method
            // https://tc39.es/ecma262/#sec-object.defineproperty
            exports.f = DESCRIPTORS
              ? V8_PROTOTYPE_DEFINE_BUG
                ? function defineProperty(O, P, Attributes) {
                    anObject(O);
                    P = toPropertyKey(P);
                    anObject(Attributes);
                    if (
                      typeof O === 'function' &&
                      P === 'prototype' &&
                      'value' in Attributes &&
                      WRITABLE in Attributes &&
                      !Attributes[WRITABLE]
                    ) {
                      var current = $getOwnPropertyDescriptor(O, P);
                      if (current && current[WRITABLE]) {
                        O[P] = Attributes.value;
                        Attributes = {
                          configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
                          enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
                          writable: false
                        };
                      }
                    }
                    return $defineProperty(O, P, Attributes);
                  }
                : $defineProperty
              : function defineProperty(O, P, Attributes) {
                  anObject(O);
                  P = toPropertyKey(P);
                  anObject(Attributes);
                  if (IE8_DOM_DEFINE)
                    try {
                      return $defineProperty(O, P, Attributes);
                    } catch (error) {
                      /* empty */
                    }
                  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
                  if ('value' in Attributes) O[P] = Attributes.value;
                  return O;
                };
          },
          {
            '../internals/an-object': 98,
            '../internals/descriptors': 131,
            '../internals/global': 160,
            '../internals/ie8-dom-define': 165,
            '../internals/to-property-key': 251,
            '../internals/v8-prototype-define-bug': 262
          }
        ],
        196: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var call = require('../internals/function-call');
            var propertyIsEnumerableModule = require('../internals/object-property-is-enumerable');
            var createPropertyDescriptor = require('../internals/create-property-descriptor');
            var toIndexedObject = require('../internals/to-indexed-object');
            var toPropertyKey = require('../internals/to-property-key');
            var hasOwn = require('../internals/has-own-property');
            var IE8_DOM_DEFINE = require('../internals/ie8-dom-define');

            // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
            var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

            // `Object.getOwnPropertyDescriptor` method
            // https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
            exports.f = DESCRIPTORS
              ? $getOwnPropertyDescriptor
              : function getOwnPropertyDescriptor(O, P) {
                  O = toIndexedObject(O);
                  P = toPropertyKey(P);
                  if (IE8_DOM_DEFINE)
                    try {
                      return $getOwnPropertyDescriptor(O, P);
                    } catch (error) {
                      /* empty */
                    }
                  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
                };
          },
          {
            '../internals/create-property-descriptor': 127,
            '../internals/descriptors': 131,
            '../internals/function-call': 152,
            '../internals/has-own-property': 161,
            '../internals/ie8-dom-define': 165,
            '../internals/object-property-is-enumerable': 204,
            '../internals/to-indexed-object': 244,
            '../internals/to-property-key': 251
          }
        ],
        197: [
          function (require, module, exports) {
            /* eslint-disable es-x/no-object-getownpropertynames -- safe */
            var classof = require('../internals/classof-raw');
            var toIndexedObject = require('../internals/to-indexed-object');
            var $getOwnPropertyNames = require('../internals/object-get-own-property-names').f;
            var arraySlice = require('../internals/array-slice-simple');

            var windowNames =
              typeof window == 'object' && window && Object.getOwnPropertyNames
                ? Object.getOwnPropertyNames(window)
                : [];

            var getWindowNames = function (it) {
              try {
                return $getOwnPropertyNames(it);
              } catch (error) {
                return arraySlice(windowNames);
              }
            };

            // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
            module.exports.f = function getOwnPropertyNames(it) {
              return windowNames && classof(it) == 'Window'
                ? getWindowNames(it)
                : $getOwnPropertyNames(toIndexedObject(it));
            };
          },
          {
            '../internals/array-slice-simple': 113,
            '../internals/classof-raw': 120,
            '../internals/object-get-own-property-names': 198,
            '../internals/to-indexed-object': 244
          }
        ],
        198: [
          function (require, module, exports) {
            var internalObjectKeys = require('../internals/object-keys-internal');
            var enumBugKeys = require('../internals/enum-bug-keys');

            var hiddenKeys = enumBugKeys.concat('length', 'prototype');

            // `Object.getOwnPropertyNames` method
            // https://tc39.es/ecma262/#sec-object.getownpropertynames
            // eslint-disable-next-line es-x/no-object-getownpropertynames -- safe
            exports.f =
              Object.getOwnPropertyNames ||
              function getOwnPropertyNames(O) {
                return internalObjectKeys(O, hiddenKeys);
              };
          },
          { '../internals/enum-bug-keys': 145, '../internals/object-keys-internal': 202 }
        ],
        199: [
          function (require, module, exports) {
            // eslint-disable-next-line es-x/no-object-getownpropertysymbols -- safe
            exports.f = Object.getOwnPropertySymbols;
          },
          {}
        ],
        200: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var hasOwn = require('../internals/has-own-property');
            var isCallable = require('../internals/is-callable');
            var toObject = require('../internals/to-object');
            var sharedKey = require('../internals/shared-key');
            var CORRECT_PROTOTYPE_GETTER = require('../internals/correct-prototype-getter');

            var IE_PROTO = sharedKey('IE_PROTO');
            var Object = global.Object;
            var ObjectPrototype = Object.prototype;

            // `Object.getPrototypeOf` method
            // https://tc39.es/ecma262/#sec-object.getprototypeof
            module.exports = CORRECT_PROTOTYPE_GETTER
              ? Object.getPrototypeOf
              : function (O) {
                  var object = toObject(O);
                  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
                  var constructor = object.constructor;
                  if (isCallable(constructor) && object instanceof constructor) {
                    return constructor.prototype;
                  }
                  return object instanceof Object ? ObjectPrototype : null;
                };
          },
          {
            '../internals/correct-prototype-getter': 124,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/is-callable': 173,
            '../internals/shared-key': 232,
            '../internals/to-object': 247
          }
        ],
        201: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');

            module.exports = uncurryThis({}.isPrototypeOf);
          },
          { '../internals/function-uncurry-this': 154 }
        ],
        202: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var hasOwn = require('../internals/has-own-property');
            var toIndexedObject = require('../internals/to-indexed-object');
            var indexOf = require('../internals/array-includes').indexOf;
            var hiddenKeys = require('../internals/hidden-keys');

            var push = uncurryThis([].push);

            module.exports = function (object, names) {
              var O = toIndexedObject(object);
              var i = 0;
              var result = [];
              var key;
              for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
              // Don't enum bug & hidden keys
              while (names.length > i)
                if (hasOwn(O, (key = names[i++]))) {
                  ~indexOf(result, key) || push(result, key);
                }
              return result;
            };
          },
          {
            '../internals/array-includes': 107,
            '../internals/function-uncurry-this': 154,
            '../internals/has-own-property': 161,
            '../internals/hidden-keys': 162,
            '../internals/to-indexed-object': 244
          }
        ],
        203: [
          function (require, module, exports) {
            var internalObjectKeys = require('../internals/object-keys-internal');
            var enumBugKeys = require('../internals/enum-bug-keys');

            // `Object.keys` method
            // https://tc39.es/ecma262/#sec-object.keys
            // eslint-disable-next-line es-x/no-object-keys -- safe
            module.exports =
              Object.keys ||
              function keys(O) {
                return internalObjectKeys(O, enumBugKeys);
              };
          },
          { '../internals/enum-bug-keys': 145, '../internals/object-keys-internal': 202 }
        ],
        204: [
          function (require, module, exports) {
            'use strict';
            var $propertyIsEnumerable = {}.propertyIsEnumerable;
            // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
            var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

            // Nashorn ~ JDK8 bug
            var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

            // `Object.prototype.propertyIsEnumerable` method implementation
            // https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
            exports.f = NASHORN_BUG
              ? function propertyIsEnumerable(V) {
                  var descriptor = getOwnPropertyDescriptor(this, V);
                  return !!descriptor && descriptor.enumerable;
                }
              : $propertyIsEnumerable;
          },
          {}
        ],
        205: [
          function (require, module, exports) {
            /* eslint-disable no-proto -- safe */
            var uncurryThis = require('../internals/function-uncurry-this');
            var anObject = require('../internals/an-object');
            var aPossiblePrototype = require('../internals/a-possible-prototype');

            // `Object.setPrototypeOf` method
            // https://tc39.es/ecma262/#sec-object.setprototypeof
            // Works with __proto__ only. Old v8 can't work with null proto objects.
            // eslint-disable-next-line es-x/no-object-setprototypeof -- safe
            module.exports =
              Object.setPrototypeOf ||
              ('__proto__' in {}
                ? (function () {
                    var CORRECT_SETTER = false;
                    var test = {};
                    var setter;
                    try {
                      // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
                      setter = uncurryThis(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
                      setter(test, []);
                      CORRECT_SETTER = test instanceof Array;
                    } catch (error) {
                      /* empty */
                    }
                    return function setPrototypeOf(O, proto) {
                      anObject(O);
                      aPossiblePrototype(proto);
                      if (CORRECT_SETTER) setter(O, proto);
                      else O.__proto__ = proto;
                      return O;
                    };
                  })()
                : undefined);
          },
          {
            '../internals/a-possible-prototype': 94,
            '../internals/an-object': 98,
            '../internals/function-uncurry-this': 154
          }
        ],
        206: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var uncurryThis = require('../internals/function-uncurry-this');
            var objectKeys = require('../internals/object-keys');
            var toIndexedObject = require('../internals/to-indexed-object');
            var $propertyIsEnumerable = require('../internals/object-property-is-enumerable').f;

            var propertyIsEnumerable = uncurryThis($propertyIsEnumerable);
            var push = uncurryThis([].push);

            // `Object.{ entries, values }` methods implementation
            var createMethod = function (TO_ENTRIES) {
              return function (it) {
                var O = toIndexedObject(it);
                var keys = objectKeys(O);
                var length = keys.length;
                var i = 0;
                var result = [];
                var key;
                while (length > i) {
                  key = keys[i++];
                  if (!DESCRIPTORS || propertyIsEnumerable(O, key)) {
                    push(result, TO_ENTRIES ? [key, O[key]] : O[key]);
                  }
                }
                return result;
              };
            };

            module.exports = {
              // `Object.entries` method
              // https://tc39.es/ecma262/#sec-object.entries
              entries: createMethod(true),
              // `Object.values` method
              // https://tc39.es/ecma262/#sec-object.values
              values: createMethod(false)
            };
          },
          {
            '../internals/descriptors': 131,
            '../internals/function-uncurry-this': 154,
            '../internals/object-keys': 203,
            '../internals/object-property-is-enumerable': 204,
            '../internals/to-indexed-object': 244
          }
        ],
        207: [
          function (require, module, exports) {
            'use strict';
            var TO_STRING_TAG_SUPPORT = require('../internals/to-string-tag-support');
            var classof = require('../internals/classof');

            // `Object.prototype.toString` method implementation
            // https://tc39.es/ecma262/#sec-object.prototype.tostring
            module.exports = TO_STRING_TAG_SUPPORT
              ? {}.toString
              : function toString() {
                  return '[object ' + classof(this) + ']';
                };
          },
          { '../internals/classof': 121, '../internals/to-string-tag-support': 252 }
        ],
        208: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var isCallable = require('../internals/is-callable');
            var isObject = require('../internals/is-object');

            var TypeError = global.TypeError;

            // `OrdinaryToPrimitive` abstract operation
            // https://tc39.es/ecma262/#sec-ordinarytoprimitive
            module.exports = function (input, pref) {
              var fn, val;
              if (pref === 'string' && isCallable((fn = input.toString)) && !isObject((val = call(fn, input))))
                return val;
              if (isCallable((fn = input.valueOf)) && !isObject((val = call(fn, input)))) return val;
              if (pref !== 'string' && isCallable((fn = input.toString)) && !isObject((val = call(fn, input))))
                return val;
              throw TypeError("Can't convert object to primitive value");
            };
          },
          {
            '../internals/function-call': 152,
            '../internals/global': 160,
            '../internals/is-callable': 173,
            '../internals/is-object': 177
          }
        ],
        209: [
          function (require, module, exports) {
            var getBuiltIn = require('../internals/get-built-in');
            var uncurryThis = require('../internals/function-uncurry-this');
            var getOwnPropertyNamesModule = require('../internals/object-get-own-property-names');
            var getOwnPropertySymbolsModule = require('../internals/object-get-own-property-symbols');
            var anObject = require('../internals/an-object');

            var concat = uncurryThis([].concat);

            // all object keys, includes non-enumerable and symbols
            module.exports =
              getBuiltIn('Reflect', 'ownKeys') ||
              function ownKeys(it) {
                var keys = getOwnPropertyNamesModule.f(anObject(it));
                var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
                return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
              };
          },
          {
            '../internals/an-object': 98,
            '../internals/function-uncurry-this': 154,
            '../internals/get-built-in': 155,
            '../internals/object-get-own-property-names': 198,
            '../internals/object-get-own-property-symbols': 199
          }
        ],
        210: [
          function (require, module, exports) {
            var global = require('../internals/global');

            module.exports = global;
          },
          { '../internals/global': 160 }
        ],
        211: [
          function (require, module, exports) {
            module.exports = function (exec) {
              try {
                return { error: false, value: exec() };
              } catch (error) {
                return { error: true, value: error };
              }
            };
          },
          {}
        ],
        212: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var NativePromiseConstructor = require('../internals/promise-native-constructor');
            var isCallable = require('../internals/is-callable');
            var isForced = require('../internals/is-forced');
            var inspectSource = require('../internals/inspect-source');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var IS_BROWSER = require('../internals/engine-is-browser');
            var IS_PURE = require('../internals/is-pure');
            var V8_VERSION = require('../internals/engine-v8-version');

            var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
            var SPECIES = wellKnownSymbol('species');
            var SUBCLASSING = false;
            var NATIVE_PROMISE_REJECTION_EVENT = isCallable(global.PromiseRejectionEvent);

            var FORCED_PROMISE_CONSTRUCTOR = isForced('Promise', function () {
              var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor);
              var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor);
              // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
              // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
              // We can't detect it synchronously, so just check versions
              if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
              // We need Promise#{ catch, finally } in the pure version for preventing prototype pollution
              if (IS_PURE && !(NativePromisePrototype['catch'] && NativePromisePrototype['finally'])) return true;
              // We can't use @@species feature detection in V8 since it causes
              // deoptimization and performance degradation
              // https://github.com/zloirock/core-js/issues/679
              if (V8_VERSION >= 51 && /native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) return false;
              // Detect correctness of subclassing with @@species support
              var promise = new NativePromiseConstructor(function (resolve) {
                resolve(1);
              });
              var FakePromise = function (exec) {
                exec(
                  function () {
                    /* empty */
                  },
                  function () {
                    /* empty */
                  }
                );
              };
              var constructor = (promise.constructor = {});
              constructor[SPECIES] = FakePromise;
              SUBCLASSING =
                promise.then(function () {
                  /* empty */
                }) instanceof FakePromise;
              if (!SUBCLASSING) return true;
              // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
              return !GLOBAL_CORE_JS_PROMISE && IS_BROWSER && !NATIVE_PROMISE_REJECTION_EVENT;
            });

            module.exports = {
              CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR,
              REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT,
              SUBCLASSING: SUBCLASSING
            };
          },
          {
            '../internals/engine-is-browser': 136,
            '../internals/engine-v8-version': 143,
            '../internals/global': 160,
            '../internals/inspect-source': 169,
            '../internals/is-callable': 173,
            '../internals/is-forced': 175,
            '../internals/is-pure': 178,
            '../internals/promise-native-constructor': 213,
            '../internals/well-known-symbol': 265
          }
        ],
        213: [
          function (require, module, exports) {
            var global = require('../internals/global');

            module.exports = global.Promise;
          },
          { '../internals/global': 160 }
        ],
        214: [
          function (require, module, exports) {
            var anObject = require('../internals/an-object');
            var isObject = require('../internals/is-object');
            var newPromiseCapability = require('../internals/new-promise-capability');

            module.exports = function (C, x) {
              anObject(C);
              if (isObject(x) && x.constructor === C) return x;
              var promiseCapability = newPromiseCapability.f(C);
              var resolve = promiseCapability.resolve;
              resolve(x);
              return promiseCapability.promise;
            };
          },
          { '../internals/an-object': 98, '../internals/is-object': 177, '../internals/new-promise-capability': 190 }
        ],
        215: [
          function (require, module, exports) {
            var NativePromiseConstructor = require('../internals/promise-native-constructor');
            var checkCorrectnessOfIteration = require('../internals/check-correctness-of-iteration');
            var FORCED_PROMISE_CONSTRUCTOR = require('../internals/promise-constructor-detection').CONSTRUCTOR;

            module.exports =
              FORCED_PROMISE_CONSTRUCTOR ||
              !checkCorrectnessOfIteration(function (iterable) {
                NativePromiseConstructor.all(iterable).then(undefined, function () {
                  /* empty */
                });
              });
          },
          {
            '../internals/check-correctness-of-iteration': 119,
            '../internals/promise-constructor-detection': 212,
            '../internals/promise-native-constructor': 213
          }
        ],
        216: [
          function (require, module, exports) {
            var defineProperty = require('../internals/object-define-property').f;

            module.exports = function (Target, Source, key) {
              key in Target ||
                defineProperty(Target, key, {
                  configurable: true,
                  get: function () {
                    return Source[key];
                  },
                  set: function (it) {
                    Source[key] = it;
                  }
                });
            };
          },
          { '../internals/object-define-property': 195 }
        ],
        217: [
          function (require, module, exports) {
            var Queue = function () {
              this.head = null;
              this.tail = null;
            };

            Queue.prototype = {
              add: function (item) {
                var entry = { item: item, next: null };
                if (this.head) this.tail.next = entry;
                else this.head = entry;
                this.tail = entry;
              },
              get: function () {
                var entry = this.head;
                if (entry) {
                  this.head = entry.next;
                  if (this.tail === entry) this.tail = null;
                  return entry.item;
                }
              }
            };

            module.exports = Queue;
          },
          {}
        ],
        218: [
          function (require, module, exports) {
            var redefine = require('../internals/redefine');

            module.exports = function (target, src, options) {
              for (var key in src) redefine(target, key, src[key], options);
              return target;
            };
          },
          { '../internals/redefine': 219 }
        ],
        219: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var isCallable = require('../internals/is-callable');
            var hasOwn = require('../internals/has-own-property');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var setGlobal = require('../internals/set-global');
            var inspectSource = require('../internals/inspect-source');
            var InternalStateModule = require('../internals/internal-state');
            var CONFIGURABLE_FUNCTION_NAME = require('../internals/function-name').CONFIGURABLE;

            var getInternalState = InternalStateModule.get;
            var enforceInternalState = InternalStateModule.enforce;
            var TEMPLATE = String(String).split('String');

            (module.exports = function (O, key, value, options) {
              var unsafe = options ? !!options.unsafe : false;
              var simple = options ? !!options.enumerable : false;
              var noTargetGet = options ? !!options.noTargetGet : false;
              var name = options && options.name !== undefined ? options.name : key;
              var state;
              if (isCallable(value)) {
                if (String(name).slice(0, 7) === 'Symbol(') {
                  name = '[' + String(name).replace(/^Symbol\(([^)]*)\)/, '$1') + ']';
                }
                if (!hasOwn(value, 'name') || (CONFIGURABLE_FUNCTION_NAME && value.name !== name)) {
                  createNonEnumerableProperty(value, 'name', name);
                }
                state = enforceInternalState(value);
                if (!state.source) {
                  state.source = TEMPLATE.join(typeof name == 'string' ? name : '');
                }
              }
              if (O === global) {
                if (simple) O[key] = value;
                else setGlobal(key, value);
                return;
              } else if (!unsafe) {
                delete O[key];
              } else if (!noTargetGet && O[key]) {
                simple = true;
              }
              if (simple) O[key] = value;
              else createNonEnumerableProperty(O, key, value);
              // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
            })(Function.prototype, 'toString', function toString() {
              return (isCallable(this) && getInternalState(this).source) || inspectSource(this);
            });
          },
          {
            '../internals/create-non-enumerable-property': 126,
            '../internals/function-name': 153,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/inspect-source': 169,
            '../internals/internal-state': 170,
            '../internals/is-callable': 173,
            '../internals/set-global': 229
          }
        ],
        220: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var anObject = require('../internals/an-object');
            var isCallable = require('../internals/is-callable');
            var classof = require('../internals/classof-raw');
            var regexpExec = require('../internals/regexp-exec');

            var TypeError = global.TypeError;

            // `RegExpExec` abstract operation
            // https://tc39.es/ecma262/#sec-regexpexec
            module.exports = function (R, S) {
              var exec = R.exec;
              if (isCallable(exec)) {
                var result = call(exec, R, S);
                if (result !== null) anObject(result);
                return result;
              }
              if (classof(R) === 'RegExp') return call(regexpExec, R, S);
              throw TypeError('RegExp#exec called on incompatible receiver');
            };
          },
          {
            '../internals/an-object': 98,
            '../internals/classof-raw': 120,
            '../internals/function-call': 152,
            '../internals/global': 160,
            '../internals/is-callable': 173,
            '../internals/regexp-exec': 221
          }
        ],
        221: [
          function (require, module, exports) {
            'use strict';
            /* eslint-disable regexp/no-empty-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
            /* eslint-disable regexp/no-useless-quantifier -- testing */
            var call = require('../internals/function-call');
            var uncurryThis = require('../internals/function-uncurry-this');
            var toString = require('../internals/to-string');
            var regexpFlags = require('../internals/regexp-flags');
            var stickyHelpers = require('../internals/regexp-sticky-helpers');
            var shared = require('../internals/shared');
            var create = require('../internals/object-create');
            var getInternalState = require('../internals/internal-state').get;
            var UNSUPPORTED_DOT_ALL = require('../internals/regexp-unsupported-dot-all');
            var UNSUPPORTED_NCG = require('../internals/regexp-unsupported-ncg');

            var nativeReplace = shared('native-string-replace', String.prototype.replace);
            var nativeExec = RegExp.prototype.exec;
            var patchedExec = nativeExec;
            var charAt = uncurryThis(''.charAt);
            var indexOf = uncurryThis(''.indexOf);
            var replace = uncurryThis(''.replace);
            var stringSlice = uncurryThis(''.slice);

            var UPDATES_LAST_INDEX_WRONG = (function () {
              var re1 = /a/;
              var re2 = /b*/g;
              call(nativeExec, re1, 'a');
              call(nativeExec, re2, 'a');
              return re1.lastIndex !== 0 || re2.lastIndex !== 0;
            })();

            var UNSUPPORTED_Y = stickyHelpers.BROKEN_CARET;

            // nonparticipating capturing group, copied from es5-shim's String#split patch.
            var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

            var PATCH =
              UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;

            if (PATCH) {
              patchedExec = function exec(string) {
                var re = this;
                var state = getInternalState(re);
                var str = toString(string);
                var raw = state.raw;
                var result, reCopy, lastIndex, match, i, object, group;

                if (raw) {
                  raw.lastIndex = re.lastIndex;
                  result = call(patchedExec, raw, str);
                  re.lastIndex = raw.lastIndex;
                  return result;
                }

                var groups = state.groups;
                var sticky = UNSUPPORTED_Y && re.sticky;
                var flags = call(regexpFlags, re);
                var source = re.source;
                var charsAdded = 0;
                var strCopy = str;

                if (sticky) {
                  flags = replace(flags, 'y', '');
                  if (indexOf(flags, 'g') === -1) {
                    flags += 'g';
                  }

                  strCopy = stringSlice(str, re.lastIndex);
                  // Support anchored sticky behavior.
                  if (re.lastIndex > 0 && (!re.multiline || (re.multiline && charAt(str, re.lastIndex - 1) !== '\n'))) {
                    source = '(?: ' + source + ')';
                    strCopy = ' ' + strCopy;
                    charsAdded++;
                  }
                  // ^(? + rx + ) is needed, in combination with some str slicing, to
                  // simulate the 'y' flag.
                  reCopy = new RegExp('^(?:' + source + ')', flags);
                }

                if (NPCG_INCLUDED) {
                  reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
                }
                if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;

                match = call(nativeExec, sticky ? reCopy : re, strCopy);

                if (sticky) {
                  if (match) {
                    match.input = stringSlice(match.input, charsAdded);
                    match[0] = stringSlice(match[0], charsAdded);
                    match.index = re.lastIndex;
                    re.lastIndex += match[0].length;
                  } else re.lastIndex = 0;
                } else if (UPDATES_LAST_INDEX_WRONG && match) {
                  re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
                }
                if (NPCG_INCLUDED && match && match.length > 1) {
                  // Fix browsers whose `exec` methods don't consistently return `undefined`
                  // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
                  call(nativeReplace, match[0], reCopy, function () {
                    for (i = 1; i < arguments.length - 2; i++) {
                      if (arguments[i] === undefined) match[i] = undefined;
                    }
                  });
                }

                if (match && groups) {
                  match.groups = object = create(null);
                  for (i = 0; i < groups.length; i++) {
                    group = groups[i];
                    object[group[0]] = match[group[1]];
                  }
                }

                return match;
              };
            }

            module.exports = patchedExec;
          },
          {
            '../internals/function-call': 152,
            '../internals/function-uncurry-this': 154,
            '../internals/internal-state': 170,
            '../internals/object-create': 193,
            '../internals/regexp-flags': 222,
            '../internals/regexp-sticky-helpers': 224,
            '../internals/regexp-unsupported-dot-all': 225,
            '../internals/regexp-unsupported-ncg': 226,
            '../internals/shared': 234,
            '../internals/to-string': 253
          }
        ],
        222: [
          function (require, module, exports) {
            'use strict';
            var anObject = require('../internals/an-object');

            // `RegExp.prototype.flags` getter implementation
            // https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
            module.exports = function () {
              var that = anObject(this);
              var result = '';
              if (that.hasIndices) result += 'd';
              if (that.global) result += 'g';
              if (that.ignoreCase) result += 'i';
              if (that.multiline) result += 'm';
              if (that.dotAll) result += 's';
              if (that.unicode) result += 'u';
              if (that.sticky) result += 'y';
              return result;
            };
          },
          { '../internals/an-object': 98 }
        ],
        223: [
          function (require, module, exports) {
            var call = require('../internals/function-call');
            var hasOwn = require('../internals/has-own-property');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var regExpFlags = require('../internals/regexp-flags');

            var RegExpPrototype = RegExp.prototype;

            module.exports = function (R) {
              var flags = R.flags;
              return flags === undefined &&
                !('flags' in RegExpPrototype) &&
                !hasOwn(R, 'flags') &&
                isPrototypeOf(RegExpPrototype, R)
                ? call(regExpFlags, R)
                : flags;
            };
          },
          {
            '../internals/function-call': 152,
            '../internals/has-own-property': 161,
            '../internals/object-is-prototype-of': 201,
            '../internals/regexp-flags': 222
          }
        ],
        224: [
          function (require, module, exports) {
            var fails = require('../internals/fails');
            var global = require('../internals/global');

            // babel-minify and Closure Compiler transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
            var $RegExp = global.RegExp;

            var UNSUPPORTED_Y = fails(function () {
              var re = $RegExp('a', 'y');
              re.lastIndex = 2;
              return re.exec('abcd') != null;
            });

            // UC Browser bug
            // https://github.com/zloirock/core-js/issues/1008
            var MISSED_STICKY =
              UNSUPPORTED_Y ||
              fails(function () {
                return !$RegExp('a', 'y').sticky;
              });

            var BROKEN_CARET =
              UNSUPPORTED_Y ||
              fails(function () {
                // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
                var re = $RegExp('^r', 'gy');
                re.lastIndex = 2;
                return re.exec('str') != null;
              });

            module.exports = {
              BROKEN_CARET: BROKEN_CARET,
              MISSED_STICKY: MISSED_STICKY,
              UNSUPPORTED_Y: UNSUPPORTED_Y
            };
          },
          { '../internals/fails': 147, '../internals/global': 160 }
        ],
        225: [
          function (require, module, exports) {
            var fails = require('../internals/fails');
            var global = require('../internals/global');

            // babel-minify and Closure Compiler transpiles RegExp('.', 's') -> /./s and it causes SyntaxError
            var $RegExp = global.RegExp;

            module.exports = fails(function () {
              var re = $RegExp('.', 's');
              return !(re.dotAll && re.exec('\n') && re.flags === 's');
            });
          },
          { '../internals/fails': 147, '../internals/global': 160 }
        ],
        226: [
          function (require, module, exports) {
            var fails = require('../internals/fails');
            var global = require('../internals/global');

            // babel-minify and Closure Compiler transpiles RegExp('(?<a>b)', 'g') -> /(?<a>b)/g and it causes SyntaxError
            var $RegExp = global.RegExp;

            module.exports = fails(function () {
              var re = $RegExp('(?<a>b)', 'g');
              return re.exec('b').groups.a !== 'b' || 'b'.replace(re, '$<a>c') !== 'bc';
            });
          },
          { '../internals/fails': 147, '../internals/global': 160 }
        ],
        227: [
          function (require, module, exports) {
            var global = require('../internals/global');

            var TypeError = global.TypeError;

            // `RequireObjectCoercible` abstract operation
            // https://tc39.es/ecma262/#sec-requireobjectcoercible
            module.exports = function (it) {
              if (it == undefined) throw TypeError("Can't call method on " + it);
              return it;
            };
          },
          { '../internals/global': 160 }
        ],
        228: [
          function (require, module, exports) {
            // `SameValue` abstract operation
            // https://tc39.es/ecma262/#sec-samevalue
            // eslint-disable-next-line es-x/no-object-is -- safe
            module.exports =
              Object.is ||
              function is(x, y) {
                // eslint-disable-next-line no-self-compare -- NaN check
                return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
              };
          },
          {}
        ],
        229: [
          function (require, module, exports) {
            var global = require('../internals/global');

            // eslint-disable-next-line es-x/no-object-defineproperty -- safe
            var defineProperty = Object.defineProperty;

            module.exports = function (key, value) {
              try {
                defineProperty(global, key, { value: value, configurable: true, writable: true });
              } catch (error) {
                global[key] = value;
              }
              return value;
            };
          },
          { '../internals/global': 160 }
        ],
        230: [
          function (require, module, exports) {
            'use strict';
            var getBuiltIn = require('../internals/get-built-in');
            var definePropertyModule = require('../internals/object-define-property');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var DESCRIPTORS = require('../internals/descriptors');

            var SPECIES = wellKnownSymbol('species');

            module.exports = function (CONSTRUCTOR_NAME) {
              var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
              var defineProperty = definePropertyModule.f;

              if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
                defineProperty(Constructor, SPECIES, {
                  configurable: true,
                  get: function () {
                    return this;
                  }
                });
              }
            };
          },
          {
            '../internals/descriptors': 131,
            '../internals/get-built-in': 155,
            '../internals/object-define-property': 195,
            '../internals/well-known-symbol': 265
          }
        ],
        231: [
          function (require, module, exports) {
            var defineProperty = require('../internals/object-define-property').f;
            var hasOwn = require('../internals/has-own-property');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var TO_STRING_TAG = wellKnownSymbol('toStringTag');

            module.exports = function (target, TAG, STATIC) {
              if (target && !STATIC) target = target.prototype;
              if (target && !hasOwn(target, TO_STRING_TAG)) {
                defineProperty(target, TO_STRING_TAG, { configurable: true, value: TAG });
              }
            };
          },
          {
            '../internals/has-own-property': 161,
            '../internals/object-define-property': 195,
            '../internals/well-known-symbol': 265
          }
        ],
        232: [
          function (require, module, exports) {
            var shared = require('../internals/shared');
            var uid = require('../internals/uid');

            var keys = shared('keys');

            module.exports = function (key) {
              return keys[key] || (keys[key] = uid(key));
            };
          },
          { '../internals/shared': 234, '../internals/uid': 260 }
        ],
        233: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var setGlobal = require('../internals/set-global');

            var SHARED = '__core-js_shared__';
            var store = global[SHARED] || setGlobal(SHARED, {});

            module.exports = store;
          },
          { '../internals/global': 160, '../internals/set-global': 229 }
        ],
        234: [
          function (require, module, exports) {
            var IS_PURE = require('../internals/is-pure');
            var store = require('../internals/shared-store');

            (module.exports = function (key, value) {
              return store[key] || (store[key] = value !== undefined ? value : {});
            })('versions', []).push({
              version: '3.22.1',
              mode: IS_PURE ? 'pure' : 'global',
              copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
              license: 'https://github.com/zloirock/core-js/blob/v3.22.1/LICENSE',
              source: 'https://github.com/zloirock/core-js'
            });
          },
          { '../internals/is-pure': 178, '../internals/shared-store': 233 }
        ],
        235: [
          function (require, module, exports) {
            var anObject = require('../internals/an-object');
            var aConstructor = require('../internals/a-constructor');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var SPECIES = wellKnownSymbol('species');

            // `SpeciesConstructor` abstract operation
            // https://tc39.es/ecma262/#sec-speciesconstructor
            module.exports = function (O, defaultConstructor) {
              var C = anObject(O).constructor;
              var S;
              return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? defaultConstructor : aConstructor(S);
            };
          },
          { '../internals/a-constructor': 93, '../internals/an-object': 98, '../internals/well-known-symbol': 265 }
        ],
        236: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');
            var toString = require('../internals/to-string');
            var requireObjectCoercible = require('../internals/require-object-coercible');

            var charAt = uncurryThis(''.charAt);
            var charCodeAt = uncurryThis(''.charCodeAt);
            var stringSlice = uncurryThis(''.slice);

            var createMethod = function (CONVERT_TO_STRING) {
              return function ($this, pos) {
                var S = toString(requireObjectCoercible($this));
                var position = toIntegerOrInfinity(pos);
                var size = S.length;
                var first, second;
                if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
                first = charCodeAt(S, position);
                return first < 0xd800 ||
                  first > 0xdbff ||
                  position + 1 === size ||
                  (second = charCodeAt(S, position + 1)) < 0xdc00 ||
                  second > 0xdfff
                  ? CONVERT_TO_STRING
                    ? charAt(S, position)
                    : first
                  : CONVERT_TO_STRING
                  ? stringSlice(S, position, position + 2)
                  : ((first - 0xd800) << 10) + (second - 0xdc00) + 0x10000;
              };
            };

            module.exports = {
              // `String.prototype.codePointAt` method
              // https://tc39.es/ecma262/#sec-string.prototype.codepointat
              codeAt: createMethod(false),
              // `String.prototype.at` method
              // https://github.com/mathiasbynens/String.prototype.at
              charAt: createMethod(true)
            };
          },
          {
            '../internals/function-uncurry-this': 154,
            '../internals/require-object-coercible': 227,
            '../internals/to-integer-or-infinity': 245,
            '../internals/to-string': 253
          }
        ],
        237: [
          function (require, module, exports) {
            var PROPER_FUNCTION_NAME = require('../internals/function-name').PROPER;
            var fails = require('../internals/fails');
            var whitespaces = require('../internals/whitespaces');

            var non = '\u200B\u0085\u180E';

            // check that a method works with the correct list
            // of whitespaces and has a correct name
            module.exports = function (METHOD_NAME) {
              return fails(function () {
                return (
                  !!whitespaces[METHOD_NAME]() ||
                  non[METHOD_NAME]() !== non ||
                  (PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME)
                );
              });
            };
          },
          { '../internals/fails': 147, '../internals/function-name': 153, '../internals/whitespaces': 266 }
        ],
        238: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');
            var requireObjectCoercible = require('../internals/require-object-coercible');
            var toString = require('../internals/to-string');
            var whitespaces = require('../internals/whitespaces');

            var replace = uncurryThis(''.replace);
            var whitespace = '[' + whitespaces + ']';
            var ltrim = RegExp('^' + whitespace + whitespace + '*');
            var rtrim = RegExp(whitespace + whitespace + '*$');

            // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
            var createMethod = function (TYPE) {
              return function ($this) {
                var string = toString(requireObjectCoercible($this));
                if (TYPE & 1) string = replace(string, ltrim, '');
                if (TYPE & 2) string = replace(string, rtrim, '');
                return string;
              };
            };

            module.exports = {
              // `String.prototype.{ trimLeft, trimStart }` methods
              // https://tc39.es/ecma262/#sec-string.prototype.trimstart
              start: createMethod(1),
              // `String.prototype.{ trimRight, trimEnd }` methods
              // https://tc39.es/ecma262/#sec-string.prototype.trimend
              end: createMethod(2),
              // `String.prototype.trim` method
              // https://tc39.es/ecma262/#sec-string.prototype.trim
              trim: createMethod(3)
            };
          },
          {
            '../internals/function-uncurry-this': 154,
            '../internals/require-object-coercible': 227,
            '../internals/to-string': 253,
            '../internals/whitespaces': 266
          }
        ],
        239: [
          function (require, module, exports) {
            var call = require('../internals/function-call');
            var getBuiltIn = require('../internals/get-built-in');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var redefine = require('../internals/redefine');

            module.exports = function () {
              var Symbol = getBuiltIn('Symbol');
              var SymbolPrototype = Symbol && Symbol.prototype;
              var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
              var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

              if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
                // `Symbol.prototype[@@toPrimitive]` method
                // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
                // eslint-disable-next-line no-unused-vars -- required for .length
                redefine(SymbolPrototype, TO_PRIMITIVE, function (hint) {
                  return call(valueOf, this);
                });
              }
            };
          },
          {
            '../internals/function-call': 152,
            '../internals/get-built-in': 155,
            '../internals/redefine': 219,
            '../internals/well-known-symbol': 265
          }
        ],
        240: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var apply = require('../internals/function-apply');
            var bind = require('../internals/function-bind-context');
            var isCallable = require('../internals/is-callable');
            var hasOwn = require('../internals/has-own-property');
            var fails = require('../internals/fails');
            var html = require('../internals/html');
            var arraySlice = require('../internals/array-slice');
            var createElement = require('../internals/document-create-element');
            var validateArgumentsLength = require('../internals/validate-arguments-length');
            var IS_IOS = require('../internals/engine-is-ios');
            var IS_NODE = require('../internals/engine-is-node');

            var set = global.setImmediate;
            var clear = global.clearImmediate;
            var process = global.process;
            var Dispatch = global.Dispatch;
            var Function = global.Function;
            var MessageChannel = global.MessageChannel;
            var String = global.String;
            var counter = 0;
            var queue = {};
            var ONREADYSTATECHANGE = 'onreadystatechange';
            var location, defer, channel, port;

            try {
              // Deno throws a ReferenceError on `location` access without `--location` flag
              location = global.location;
            } catch (error) {
              /* empty */
            }

            var run = function (id) {
              if (hasOwn(queue, id)) {
                var fn = queue[id];
                delete queue[id];
                fn();
              }
            };

            var runner = function (id) {
              return function () {
                run(id);
              };
            };

            var listener = function (event) {
              run(event.data);
            };

            var post = function (id) {
              // old engines have not location.origin
              global.postMessage(String(id), location.protocol + '//' + location.host);
            };

            // Node.js 0.9+ & IE10+ has setImmediate, otherwise:
            if (!set || !clear) {
              set = function setImmediate(handler) {
                validateArgumentsLength(arguments.length, 1);
                var fn = isCallable(handler) ? handler : Function(handler);
                var args = arraySlice(arguments, 1);
                queue[++counter] = function () {
                  apply(fn, undefined, args);
                };
                defer(counter);
                return counter;
              };
              clear = function clearImmediate(id) {
                delete queue[id];
              };
              // Node.js 0.8-
              if (IS_NODE) {
                defer = function (id) {
                  process.nextTick(runner(id));
                };
                // Sphere (JS game engine) Dispatch API
              } else if (Dispatch && Dispatch.now) {
                defer = function (id) {
                  Dispatch.now(runner(id));
                };
                // Browsers with MessageChannel, includes WebWorkers
                // except iOS - https://github.com/zloirock/core-js/issues/624
              } else if (MessageChannel && !IS_IOS) {
                channel = new MessageChannel();
                port = channel.port2;
                channel.port1.onmessage = listener;
                defer = bind(port.postMessage, port);
                // Browsers with postMessage, skip WebWorkers
                // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
              } else if (
                global.addEventListener &&
                isCallable(global.postMessage) &&
                !global.importScripts &&
                location &&
                location.protocol !== 'file:' &&
                !fails(post)
              ) {
                defer = post;
                global.addEventListener('message', listener, false);
                // IE8-
              } else if (ONREADYSTATECHANGE in createElement('script')) {
                defer = function (id) {
                  html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
                    html.removeChild(this);
                    run(id);
                  };
                };
                // Rest old browsers
              } else {
                defer = function (id) {
                  setTimeout(runner(id), 0);
                };
              }
            }

            module.exports = {
              set: set,
              clear: clear
            };
          },
          {
            '../internals/array-slice': 114,
            '../internals/document-create-element': 132,
            '../internals/engine-is-ios': 139,
            '../internals/engine-is-node': 140,
            '../internals/fails': 147,
            '../internals/function-apply': 149,
            '../internals/function-bind-context': 150,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/html': 164,
            '../internals/is-callable': 173,
            '../internals/validate-arguments-length': 263
          }
        ],
        241: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');

            // `thisNumberValue` abstract operation
            // https://tc39.es/ecma262/#sec-thisnumbervalue
            module.exports = uncurryThis((1.0).valueOf);
          },
          { '../internals/function-uncurry-this': 154 }
        ],
        242: [
          function (require, module, exports) {
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');

            var max = Math.max;
            var min = Math.min;

            // Helper for a popular repeating case of the spec:
            // Let integer be ? ToInteger(index).
            // If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
            module.exports = function (index, length) {
              var integer = toIntegerOrInfinity(index);
              return integer < 0 ? max(integer + length, 0) : min(integer, length);
            };
          },
          { '../internals/to-integer-or-infinity': 245 }
        ],
        243: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');
            var toLength = require('../internals/to-length');

            var RangeError = global.RangeError;

            // `ToIndex` abstract operation
            // https://tc39.es/ecma262/#sec-toindex
            module.exports = function (it) {
              if (it === undefined) return 0;
              var number = toIntegerOrInfinity(it);
              var length = toLength(number);
              if (number !== length) throw RangeError('Wrong length or index');
              return length;
            };
          },
          { '../internals/global': 160, '../internals/to-integer-or-infinity': 245, '../internals/to-length': 246 }
        ],
        244: [
          function (require, module, exports) {
            // toObject with fallback for non-array-like ES3 strings
            var IndexedObject = require('../internals/indexed-object');
            var requireObjectCoercible = require('../internals/require-object-coercible');

            module.exports = function (it) {
              return IndexedObject(requireObjectCoercible(it));
            };
          },
          { '../internals/indexed-object': 167, '../internals/require-object-coercible': 227 }
        ],
        245: [
          function (require, module, exports) {
            var ceil = Math.ceil;
            var floor = Math.floor;

            // `ToIntegerOrInfinity` abstract operation
            // https://tc39.es/ecma262/#sec-tointegerorinfinity
            module.exports = function (argument) {
              var number = +argument;
              // eslint-disable-next-line no-self-compare -- safe
              return number !== number || number === 0 ? 0 : (number > 0 ? floor : ceil)(number);
            };
          },
          {}
        ],
        246: [
          function (require, module, exports) {
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');

            var min = Math.min;

            // `ToLength` abstract operation
            // https://tc39.es/ecma262/#sec-tolength
            module.exports = function (argument) {
              return argument > 0 ? min(toIntegerOrInfinity(argument), 0x1fffffffffffff) : 0; // 2 ** 53 - 1 == 9007199254740991
            };
          },
          { '../internals/to-integer-or-infinity': 245 }
        ],
        247: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var requireObjectCoercible = require('../internals/require-object-coercible');

            var Object = global.Object;

            // `ToObject` abstract operation
            // https://tc39.es/ecma262/#sec-toobject
            module.exports = function (argument) {
              return Object(requireObjectCoercible(argument));
            };
          },
          { '../internals/global': 160, '../internals/require-object-coercible': 227 }
        ],
        248: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var toPositiveInteger = require('../internals/to-positive-integer');

            var RangeError = global.RangeError;

            module.exports = function (it, BYTES) {
              var offset = toPositiveInteger(it);
              if (offset % BYTES) throw RangeError('Wrong offset');
              return offset;
            };
          },
          { '../internals/global': 160, '../internals/to-positive-integer': 249 }
        ],
        249: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');

            var RangeError = global.RangeError;

            module.exports = function (it) {
              var result = toIntegerOrInfinity(it);
              if (result < 0) throw RangeError("The argument can't be less than 0");
              return result;
            };
          },
          { '../internals/global': 160, '../internals/to-integer-or-infinity': 245 }
        ],
        250: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var isObject = require('../internals/is-object');
            var isSymbol = require('../internals/is-symbol');
            var getMethod = require('../internals/get-method');
            var ordinaryToPrimitive = require('../internals/ordinary-to-primitive');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var TypeError = global.TypeError;
            var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

            // `ToPrimitive` abstract operation
            // https://tc39.es/ecma262/#sec-toprimitive
            module.exports = function (input, pref) {
              if (!isObject(input) || isSymbol(input)) return input;
              var exoticToPrim = getMethod(input, TO_PRIMITIVE);
              var result;
              if (exoticToPrim) {
                if (pref === undefined) pref = 'default';
                result = call(exoticToPrim, input, pref);
                if (!isObject(result) || isSymbol(result)) return result;
                throw TypeError("Can't convert object to primitive value");
              }
              if (pref === undefined) pref = 'number';
              return ordinaryToPrimitive(input, pref);
            };
          },
          {
            '../internals/function-call': 152,
            '../internals/get-method': 158,
            '../internals/global': 160,
            '../internals/is-object': 177,
            '../internals/is-symbol': 180,
            '../internals/ordinary-to-primitive': 208,
            '../internals/well-known-symbol': 265
          }
        ],
        251: [
          function (require, module, exports) {
            var toPrimitive = require('../internals/to-primitive');
            var isSymbol = require('../internals/is-symbol');

            // `ToPropertyKey` abstract operation
            // https://tc39.es/ecma262/#sec-topropertykey
            module.exports = function (argument) {
              var key = toPrimitive(argument, 'string');
              return isSymbol(key) ? key : key + '';
            };
          },
          { '../internals/is-symbol': 180, '../internals/to-primitive': 250 }
        ],
        252: [
          function (require, module, exports) {
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var TO_STRING_TAG = wellKnownSymbol('toStringTag');
            var test = {};

            test[TO_STRING_TAG] = 'z';

            module.exports = String(test) === '[object z]';
          },
          { '../internals/well-known-symbol': 265 }
        ],
        253: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var classof = require('../internals/classof');

            var String = global.String;

            module.exports = function (argument) {
              if (classof(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
              return String(argument);
            };
          },
          { '../internals/classof': 121, '../internals/global': 160 }
        ],
        254: [
          function (require, module, exports) {
            var global = require('../internals/global');

            var String = global.String;

            module.exports = function (argument) {
              try {
                return String(argument);
              } catch (error) {
                return 'Object';
              }
            };
          },
          { '../internals/global': 160 }
        ],
        255: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var DESCRIPTORS = require('../internals/descriptors');
            var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS = require('../internals/typed-array-constructors-require-wrappers');
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var ArrayBufferModule = require('../internals/array-buffer');
            var anInstance = require('../internals/an-instance');
            var createPropertyDescriptor = require('../internals/create-property-descriptor');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var isIntegralNumber = require('../internals/is-integral-number');
            var toLength = require('../internals/to-length');
            var toIndex = require('../internals/to-index');
            var toOffset = require('../internals/to-offset');
            var toPropertyKey = require('../internals/to-property-key');
            var hasOwn = require('../internals/has-own-property');
            var classof = require('../internals/classof');
            var isObject = require('../internals/is-object');
            var isSymbol = require('../internals/is-symbol');
            var create = require('../internals/object-create');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var setPrototypeOf = require('../internals/object-set-prototype-of');
            var getOwnPropertyNames = require('../internals/object-get-own-property-names').f;
            var typedArrayFrom = require('../internals/typed-array-from');
            var forEach = require('../internals/array-iteration').forEach;
            var setSpecies = require('../internals/set-species');
            var definePropertyModule = require('../internals/object-define-property');
            var getOwnPropertyDescriptorModule = require('../internals/object-get-own-property-descriptor');
            var InternalStateModule = require('../internals/internal-state');
            var inheritIfRequired = require('../internals/inherit-if-required');

            var getInternalState = InternalStateModule.get;
            var setInternalState = InternalStateModule.set;
            var nativeDefineProperty = definePropertyModule.f;
            var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
            var round = Math.round;
            var RangeError = global.RangeError;
            var ArrayBuffer = ArrayBufferModule.ArrayBuffer;
            var ArrayBufferPrototype = ArrayBuffer.prototype;
            var DataView = ArrayBufferModule.DataView;
            var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
            var TYPED_ARRAY_CONSTRUCTOR = ArrayBufferViewCore.TYPED_ARRAY_CONSTRUCTOR;
            var TYPED_ARRAY_TAG = ArrayBufferViewCore.TYPED_ARRAY_TAG;
            var TypedArray = ArrayBufferViewCore.TypedArray;
            var TypedArrayPrototype = ArrayBufferViewCore.TypedArrayPrototype;
            var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
            var isTypedArray = ArrayBufferViewCore.isTypedArray;
            var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
            var WRONG_LENGTH = 'Wrong length';

            var fromList = function (C, list) {
              aTypedArrayConstructor(C);
              var index = 0;
              var length = list.length;
              var result = new C(length);
              while (length > index) result[index] = list[index++];
              return result;
            };

            var addGetter = function (it, key) {
              nativeDefineProperty(it, key, {
                get: function () {
                  return getInternalState(this)[key];
                }
              });
            };

            var isArrayBuffer = function (it) {
              var klass;
              return (
                isPrototypeOf(ArrayBufferPrototype, it) ||
                (klass = classof(it)) == 'ArrayBuffer' ||
                klass == 'SharedArrayBuffer'
              );
            };

            var isTypedArrayIndex = function (target, key) {
              return isTypedArray(target) && !isSymbol(key) && key in target && isIntegralNumber(+key) && key >= 0;
            };

            var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
              key = toPropertyKey(key);
              return isTypedArrayIndex(target, key)
                ? createPropertyDescriptor(2, target[key])
                : nativeGetOwnPropertyDescriptor(target, key);
            };

            var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
              key = toPropertyKey(key);
              if (
                isTypedArrayIndex(target, key) &&
                isObject(descriptor) &&
                hasOwn(descriptor, 'value') &&
                !hasOwn(descriptor, 'get') &&
                !hasOwn(descriptor, 'set') &&
                // TODO: add validation descriptor w/o calling accessors
                !descriptor.configurable &&
                (!hasOwn(descriptor, 'writable') || descriptor.writable) &&
                (!hasOwn(descriptor, 'enumerable') || descriptor.enumerable)
              ) {
                target[key] = descriptor.value;
                return target;
              }
              return nativeDefineProperty(target, key, descriptor);
            };

            if (DESCRIPTORS) {
              if (!NATIVE_ARRAY_BUFFER_VIEWS) {
                getOwnPropertyDescriptorModule.f = wrappedGetOwnPropertyDescriptor;
                definePropertyModule.f = wrappedDefineProperty;
                addGetter(TypedArrayPrototype, 'buffer');
                addGetter(TypedArrayPrototype, 'byteOffset');
                addGetter(TypedArrayPrototype, 'byteLength');
                addGetter(TypedArrayPrototype, 'length');
              }

              $(
                { target: 'Object', stat: true, forced: !NATIVE_ARRAY_BUFFER_VIEWS },
                {
                  getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
                  defineProperty: wrappedDefineProperty
                }
              );

              module.exports = function (TYPE, wrapper, CLAMPED) {
                var BYTES = TYPE.match(/\d+$/)[0] / 8;
                var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
                var GETTER = 'get' + TYPE;
                var SETTER = 'set' + TYPE;
                var NativeTypedArrayConstructor = global[CONSTRUCTOR_NAME];
                var TypedArrayConstructor = NativeTypedArrayConstructor;
                var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
                var exported = {};

                var getter = function (that, index) {
                  var data = getInternalState(that);
                  return data.view[GETTER](index * BYTES + data.byteOffset, true);
                };

                var setter = function (that, index, value) {
                  var data = getInternalState(that);
                  if (CLAMPED) value = (value = round(value)) < 0 ? 0 : value > 0xff ? 0xff : value & 0xff;
                  data.view[SETTER](index * BYTES + data.byteOffset, value, true);
                };

                var addElement = function (that, index) {
                  nativeDefineProperty(that, index, {
                    get: function () {
                      return getter(this, index);
                    },
                    set: function (value) {
                      return setter(this, index, value);
                    },
                    enumerable: true
                  });
                };

                if (!NATIVE_ARRAY_BUFFER_VIEWS) {
                  TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
                    anInstance(that, TypedArrayConstructorPrototype);
                    var index = 0;
                    var byteOffset = 0;
                    var buffer, byteLength, length;
                    if (!isObject(data)) {
                      length = toIndex(data);
                      byteLength = length * BYTES;
                      buffer = new ArrayBuffer(byteLength);
                    } else if (isArrayBuffer(data)) {
                      buffer = data;
                      byteOffset = toOffset(offset, BYTES);
                      var $len = data.byteLength;
                      if ($length === undefined) {
                        if ($len % BYTES) throw RangeError(WRONG_LENGTH);
                        byteLength = $len - byteOffset;
                        if (byteLength < 0) throw RangeError(WRONG_LENGTH);
                      } else {
                        byteLength = toLength($length) * BYTES;
                        if (byteLength + byteOffset > $len) throw RangeError(WRONG_LENGTH);
                      }
                      length = byteLength / BYTES;
                    } else if (isTypedArray(data)) {
                      return fromList(TypedArrayConstructor, data);
                    } else {
                      return call(typedArrayFrom, TypedArrayConstructor, data);
                    }
                    setInternalState(that, {
                      buffer: buffer,
                      byteOffset: byteOffset,
                      byteLength: byteLength,
                      length: length,
                      view: new DataView(buffer)
                    });
                    while (index < length) addElement(that, index++);
                  });

                  if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
                  TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = create(TypedArrayPrototype);
                } else if (TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS) {
                  TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
                    anInstance(dummy, TypedArrayConstructorPrototype);
                    return inheritIfRequired(
                      (function () {
                        if (!isObject(data)) return new NativeTypedArrayConstructor(toIndex(data));
                        if (isArrayBuffer(data))
                          return $length !== undefined
                            ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES), $length)
                            : typedArrayOffset !== undefined
                            ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES))
                            : new NativeTypedArrayConstructor(data);
                        if (isTypedArray(data)) return fromList(TypedArrayConstructor, data);
                        return call(typedArrayFrom, TypedArrayConstructor, data);
                      })(),
                      dummy,
                      TypedArrayConstructor
                    );
                  });

                  if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
                  forEach(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
                    if (!(key in TypedArrayConstructor)) {
                      createNonEnumerableProperty(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
                    }
                  });
                  TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
                }

                if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
                  createNonEnumerableProperty(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
                }

                createNonEnumerableProperty(
                  TypedArrayConstructorPrototype,
                  TYPED_ARRAY_CONSTRUCTOR,
                  TypedArrayConstructor
                );

                if (TYPED_ARRAY_TAG) {
                  createNonEnumerableProperty(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
                }

                exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;

                $(
                  {
                    global: true,
                    forced: TypedArrayConstructor != NativeTypedArrayConstructor,
                    sham: !NATIVE_ARRAY_BUFFER_VIEWS
                  },
                  exported
                );

                if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
                  createNonEnumerableProperty(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
                }

                if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
                  createNonEnumerableProperty(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
                }

                setSpecies(CONSTRUCTOR_NAME);
              };
            } else
              module.exports = function () {
                /* empty */
              };
          },
          {
            '../internals/an-instance': 97,
            '../internals/array-buffer': 101,
            '../internals/array-buffer-view-core': 100,
            '../internals/array-iteration': 108,
            '../internals/classof': 121,
            '../internals/create-non-enumerable-property': 126,
            '../internals/create-property-descriptor': 127,
            '../internals/descriptors': 131,
            '../internals/export': 146,
            '../internals/function-call': 152,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/inherit-if-required': 168,
            '../internals/internal-state': 170,
            '../internals/is-integral-number': 176,
            '../internals/is-object': 177,
            '../internals/is-symbol': 180,
            '../internals/object-create': 193,
            '../internals/object-define-property': 195,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/object-get-own-property-names': 198,
            '../internals/object-is-prototype-of': 201,
            '../internals/object-set-prototype-of': 205,
            '../internals/set-species': 230,
            '../internals/to-index': 243,
            '../internals/to-length': 246,
            '../internals/to-offset': 248,
            '../internals/to-property-key': 251,
            '../internals/typed-array-constructors-require-wrappers': 256,
            '../internals/typed-array-from': 258
          }
        ],
        256: [
          function (require, module, exports) {
            /* eslint-disable no-new -- required for testing */
            var global = require('../internals/global');
            var fails = require('../internals/fails');
            var checkCorrectnessOfIteration = require('../internals/check-correctness-of-iteration');
            var NATIVE_ARRAY_BUFFER_VIEWS = require('../internals/array-buffer-view-core').NATIVE_ARRAY_BUFFER_VIEWS;

            var ArrayBuffer = global.ArrayBuffer;
            var Int8Array = global.Int8Array;

            module.exports =
              !NATIVE_ARRAY_BUFFER_VIEWS ||
              !fails(function () {
                Int8Array(1);
              }) ||
              !fails(function () {
                new Int8Array(-1);
              }) ||
              !checkCorrectnessOfIteration(function (iterable) {
                new Int8Array();
                new Int8Array(null);
                new Int8Array(1.5);
                new Int8Array(iterable);
              }, true) ||
              fails(function () {
                // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
                return new Int8Array(new ArrayBuffer(2), 1, undefined).length !== 1;
              });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/check-correctness-of-iteration': 119,
            '../internals/fails': 147,
            '../internals/global': 160
          }
        ],
        257: [
          function (require, module, exports) {
            var arrayFromConstructorAndList = require('../internals/array-from-constructor-and-list');
            var typedArraySpeciesConstructor = require('../internals/typed-array-species-constructor');

            module.exports = function (instance, list) {
              return arrayFromConstructorAndList(typedArraySpeciesConstructor(instance), list);
            };
          },
          { '../internals/array-from-constructor-and-list': 105, '../internals/typed-array-species-constructor': 259 }
        ],
        258: [
          function (require, module, exports) {
            var bind = require('../internals/function-bind-context');
            var call = require('../internals/function-call');
            var aConstructor = require('../internals/a-constructor');
            var toObject = require('../internals/to-object');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var getIterator = require('../internals/get-iterator');
            var getIteratorMethod = require('../internals/get-iterator-method');
            var isArrayIteratorMethod = require('../internals/is-array-iterator-method');
            var aTypedArrayConstructor = require('../internals/array-buffer-view-core').aTypedArrayConstructor;

            module.exports = function from(source /* , mapfn, thisArg */) {
              var C = aConstructor(this);
              var O = toObject(source);
              var argumentsLength = arguments.length;
              var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
              var mapping = mapfn !== undefined;
              var iteratorMethod = getIteratorMethod(O);
              var i, length, result, step, iterator, next;
              if (iteratorMethod && !isArrayIteratorMethod(iteratorMethod)) {
                iterator = getIterator(O, iteratorMethod);
                next = iterator.next;
                O = [];
                while (!(step = call(next, iterator)).done) {
                  O.push(step.value);
                }
              }
              if (mapping && argumentsLength > 2) {
                mapfn = bind(mapfn, arguments[2]);
              }
              length = lengthOfArrayLike(O);
              result = new (aTypedArrayConstructor(C))(length);
              for (i = 0; length > i; i++) {
                result[i] = mapping ? mapfn(O[i], i) : O[i];
              }
              return result;
            };
          },
          {
            '../internals/a-constructor': 93,
            '../internals/array-buffer-view-core': 100,
            '../internals/function-bind-context': 150,
            '../internals/function-call': 152,
            '../internals/get-iterator': 157,
            '../internals/get-iterator-method': 156,
            '../internals/is-array-iterator-method': 171,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247
          }
        ],
        259: [
          function (require, module, exports) {
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var speciesConstructor = require('../internals/species-constructor');

            var TYPED_ARRAY_CONSTRUCTOR = ArrayBufferViewCore.TYPED_ARRAY_CONSTRUCTOR;
            var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;

            // a part of `TypedArraySpeciesCreate` abstract operation
            // https://tc39.es/ecma262/#typedarray-species-create
            module.exports = function (originalArray) {
              return aTypedArrayConstructor(speciesConstructor(originalArray, originalArray[TYPED_ARRAY_CONSTRUCTOR]));
            };
          },
          { '../internals/array-buffer-view-core': 100, '../internals/species-constructor': 235 }
        ],
        260: [
          function (require, module, exports) {
            var uncurryThis = require('../internals/function-uncurry-this');

            var id = 0;
            var postfix = Math.random();
            var toString = uncurryThis((1.0).toString);

            module.exports = function (key) {
              return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
            };
          },
          { '../internals/function-uncurry-this': 154 }
        ],
        261: [
          function (require, module, exports) {
            /* eslint-disable es-x/no-symbol -- required for testing */
            var NATIVE_SYMBOL = require('../internals/native-symbol');

            module.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == 'symbol';
          },
          { '../internals/native-symbol': 188 }
        ],
        262: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var fails = require('../internals/fails');

            // V8 ~ Chrome 36-
            // https://bugs.chromium.org/p/v8/issues/detail?id=3334
            module.exports =
              DESCRIPTORS &&
              fails(function () {
                // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
                return (
                  Object.defineProperty(
                    function () {
                      /* empty */
                    },
                    'prototype',
                    {
                      value: 42,
                      writable: false
                    }
                  ).prototype != 42
                );
              });
          },
          { '../internals/descriptors': 131, '../internals/fails': 147 }
        ],
        263: [
          function (require, module, exports) {
            var global = require('../internals/global');

            var TypeError = global.TypeError;

            module.exports = function (passed, required) {
              if (passed < required) throw TypeError('Not enough arguments');
              return passed;
            };
          },
          { '../internals/global': 160 }
        ],
        264: [
          function (require, module, exports) {
            var wellKnownSymbol = require('../internals/well-known-symbol');

            exports.f = wellKnownSymbol;
          },
          { '../internals/well-known-symbol': 265 }
        ],
        265: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var shared = require('../internals/shared');
            var hasOwn = require('../internals/has-own-property');
            var uid = require('../internals/uid');
            var NATIVE_SYMBOL = require('../internals/native-symbol');
            var USE_SYMBOL_AS_UID = require('../internals/use-symbol-as-uid');

            var WellKnownSymbolsStore = shared('wks');
            var Symbol = global.Symbol;
            var symbolFor = Symbol && Symbol['for'];
            var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : (Symbol && Symbol.withoutSetter) || uid;

            module.exports = function (name) {
              if (
                !hasOwn(WellKnownSymbolsStore, name) ||
                !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')
              ) {
                var description = 'Symbol.' + name;
                if (NATIVE_SYMBOL && hasOwn(Symbol, name)) {
                  WellKnownSymbolsStore[name] = Symbol[name];
                } else if (USE_SYMBOL_AS_UID && symbolFor) {
                  WellKnownSymbolsStore[name] = symbolFor(description);
                } else {
                  WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
                }
              }
              return WellKnownSymbolsStore[name];
            };
          },
          {
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/native-symbol': 188,
            '../internals/shared': 234,
            '../internals/uid': 260,
            '../internals/use-symbol-as-uid': 261
          }
        ],
        266: [
          function (require, module, exports) {
            // a string of all valid unicode whitespaces
            module.exports =
              '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
              '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
          },
          {}
        ],
        267: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var global = require('../internals/global');
            var arrayBufferModule = require('../internals/array-buffer');
            var setSpecies = require('../internals/set-species');

            var ARRAY_BUFFER = 'ArrayBuffer';
            var ArrayBuffer = arrayBufferModule[ARRAY_BUFFER];
            var NativeArrayBuffer = global[ARRAY_BUFFER];

            // `ArrayBuffer` constructor
            // https://tc39.es/ecma262/#sec-arraybuffer-constructor
            $(
              { global: true, forced: NativeArrayBuffer !== ArrayBuffer },
              {
                ArrayBuffer: ArrayBuffer
              }
            );

            setSpecies(ARRAY_BUFFER);
          },
          {
            '../internals/array-buffer': 101,
            '../internals/export': 146,
            '../internals/global': 160,
            '../internals/set-species': 230
          }
        ],
        268: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var uncurryThis = require('../internals/function-uncurry-this');
            var fails = require('../internals/fails');
            var ArrayBufferModule = require('../internals/array-buffer');
            var anObject = require('../internals/an-object');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var toLength = require('../internals/to-length');
            var speciesConstructor = require('../internals/species-constructor');

            var ArrayBuffer = ArrayBufferModule.ArrayBuffer;
            var DataView = ArrayBufferModule.DataView;
            var DataViewPrototype = DataView.prototype;
            var un$ArrayBufferSlice = uncurryThis(ArrayBuffer.prototype.slice);
            var getUint8 = uncurryThis(DataViewPrototype.getUint8);
            var setUint8 = uncurryThis(DataViewPrototype.setUint8);

            var INCORRECT_SLICE = fails(function () {
              return !new ArrayBuffer(2).slice(1, undefined).byteLength;
            });

            // `ArrayBuffer.prototype.slice` method
            // https://tc39.es/ecma262/#sec-arraybuffer.prototype.slice
            $(
              { target: 'ArrayBuffer', proto: true, unsafe: true, forced: INCORRECT_SLICE },
              {
                slice: function slice(start, end) {
                  if (un$ArrayBufferSlice && end === undefined) {
                    return un$ArrayBufferSlice(anObject(this), start); // FF fix
                  }
                  var length = anObject(this).byteLength;
                  var first = toAbsoluteIndex(start, length);
                  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
                  var result = new (speciesConstructor(this, ArrayBuffer))(toLength(fin - first));
                  var viewSource = new DataView(this);
                  var viewTarget = new DataView(result);
                  var index = 0;
                  while (first < fin) {
                    setUint8(viewTarget, index++, getUint8(viewSource, first++));
                  }
                  return result;
                }
              }
            );
          },
          {
            '../internals/an-object': 98,
            '../internals/array-buffer': 101,
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/species-constructor': 235,
            '../internals/to-absolute-index': 242,
            '../internals/to-length': 246
          }
        ],
        269: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var global = require('../internals/global');
            var fails = require('../internals/fails');
            var isArray = require('../internals/is-array');
            var isObject = require('../internals/is-object');
            var toObject = require('../internals/to-object');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var createProperty = require('../internals/create-property');
            var arraySpeciesCreate = require('../internals/array-species-create');
            var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var V8_VERSION = require('../internals/engine-v8-version');

            var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
            var MAX_SAFE_INTEGER = 0x1fffffffffffff;
            var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded';
            var TypeError = global.TypeError;

            // We can't use this feature detection in V8 since it causes
            // deoptimization and serious performance degradation
            // https://github.com/zloirock/core-js/issues/679
            var IS_CONCAT_SPREADABLE_SUPPORT =
              V8_VERSION >= 51 ||
              !fails(function () {
                var array = [];
                array[IS_CONCAT_SPREADABLE] = false;
                return array.concat()[0] !== array;
              });

            var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

            var isConcatSpreadable = function (O) {
              if (!isObject(O)) return false;
              var spreadable = O[IS_CONCAT_SPREADABLE];
              return spreadable !== undefined ? !!spreadable : isArray(O);
            };

            var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT;

            // `Array.prototype.concat` method
            // https://tc39.es/ecma262/#sec-array.prototype.concat
            // with adding support of @@isConcatSpreadable and @@species
            $(
              { target: 'Array', proto: true, forced: FORCED },
              {
                // eslint-disable-next-line no-unused-vars -- required for `.length`
                concat: function concat(arg) {
                  var O = toObject(this);
                  var A = arraySpeciesCreate(O, 0);
                  var n = 0;
                  var i, k, length, len, E;
                  for (i = -1, length = arguments.length; i < length; i++) {
                    E = i === -1 ? O : arguments[i];
                    if (isConcatSpreadable(E)) {
                      len = lengthOfArrayLike(E);
                      if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
                      for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
                    } else {
                      if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
                      createProperty(A, n++, E);
                    }
                  }
                  A.length = n;
                  return A;
                }
              }
            );
          },
          {
            '../internals/array-method-has-species-support': 110,
            '../internals/array-species-create': 117,
            '../internals/create-property': 128,
            '../internals/engine-v8-version': 143,
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/global': 160,
            '../internals/is-array': 172,
            '../internals/is-object': 177,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247,
            '../internals/well-known-symbol': 265
          }
        ],
        270: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var fill = require('../internals/array-fill');
            var addToUnscopables = require('../internals/add-to-unscopables');

            // `Array.prototype.fill` method
            // https://tc39.es/ecma262/#sec-array.prototype.fill
            $(
              { target: 'Array', proto: true },
              {
                fill: fill
              }
            );

            // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
            addToUnscopables('fill');
          },
          { '../internals/add-to-unscopables': 95, '../internals/array-fill': 103, '../internals/export': 146 }
        ],
        271: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var $filter = require('../internals/array-iteration').filter;
            var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');

            var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

            // `Array.prototype.filter` method
            // https://tc39.es/ecma262/#sec-array.prototype.filter
            // with adding support of @@species
            $(
              { target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT },
              {
                filter: function filter(callbackfn /* , thisArg */) {
                  return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
                }
              }
            );
          },
          {
            '../internals/array-iteration': 108,
            '../internals/array-method-has-species-support': 110,
            '../internals/export': 146
          }
        ],
        272: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var $find = require('../internals/array-iteration').find;
            var addToUnscopables = require('../internals/add-to-unscopables');

            var FIND = 'find';
            var SKIPS_HOLES = true;

            // Shouldn't skip holes
            if (FIND in [])
              Array(1)[FIND](function () {
                SKIPS_HOLES = false;
              });

            // `Array.prototype.find` method
            // https://tc39.es/ecma262/#sec-array.prototype.find
            $(
              { target: 'Array', proto: true, forced: SKIPS_HOLES },
              {
                find: function find(callbackfn /* , that = undefined */) {
                  return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
                }
              }
            );

            // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
            addToUnscopables(FIND);
          },
          { '../internals/add-to-unscopables': 95, '../internals/array-iteration': 108, '../internals/export': 146 }
        ],
        273: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var from = require('../internals/array-from');
            var checkCorrectnessOfIteration = require('../internals/check-correctness-of-iteration');

            var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
              // eslint-disable-next-line es-x/no-array-from -- required for testing
              Array.from(iterable);
            });

            // `Array.from` method
            // https://tc39.es/ecma262/#sec-array.from
            $(
              { target: 'Array', stat: true, forced: INCORRECT_ITERATION },
              {
                from: from
              }
            );
          },
          {
            '../internals/array-from': 106,
            '../internals/check-correctness-of-iteration': 119,
            '../internals/export': 146
          }
        ],
        274: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var $includes = require('../internals/array-includes').includes;
            var addToUnscopables = require('../internals/add-to-unscopables');

            // `Array.prototype.includes` method
            // https://tc39.es/ecma262/#sec-array.prototype.includes
            $(
              { target: 'Array', proto: true },
              {
                includes: function includes(el /* , fromIndex = 0 */) {
                  return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
                }
              }
            );

            // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
            addToUnscopables('includes');
          },
          { '../internals/add-to-unscopables': 95, '../internals/array-includes': 107, '../internals/export': 146 }
        ],
        275: [
          function (require, module, exports) {
            'use strict';
            var toIndexedObject = require('../internals/to-indexed-object');
            var addToUnscopables = require('../internals/add-to-unscopables');
            var Iterators = require('../internals/iterators');
            var InternalStateModule = require('../internals/internal-state');
            var defineProperty = require('../internals/object-define-property').f;
            var defineIterator = require('../internals/define-iterator');
            var IS_PURE = require('../internals/is-pure');
            var DESCRIPTORS = require('../internals/descriptors');

            var ARRAY_ITERATOR = 'Array Iterator';
            var setInternalState = InternalStateModule.set;
            var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);

            // `Array.prototype.entries` method
            // https://tc39.es/ecma262/#sec-array.prototype.entries
            // `Array.prototype.keys` method
            // https://tc39.es/ecma262/#sec-array.prototype.keys
            // `Array.prototype.values` method
            // https://tc39.es/ecma262/#sec-array.prototype.values
            // `Array.prototype[@@iterator]` method
            // https://tc39.es/ecma262/#sec-array.prototype-@@iterator
            // `CreateArrayIterator` internal method
            // https://tc39.es/ecma262/#sec-createarrayiterator
            module.exports = defineIterator(
              Array,
              'Array',
              function (iterated, kind) {
                setInternalState(this, {
                  type: ARRAY_ITERATOR,
                  target: toIndexedObject(iterated), // target
                  index: 0, // next index
                  kind: kind // kind
                });
                // `%ArrayIteratorPrototype%.next` method
                // https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
              },
              function () {
                var state = getInternalState(this);
                var target = state.target;
                var kind = state.kind;
                var index = state.index++;
                if (!target || index >= target.length) {
                  state.target = undefined;
                  return { value: undefined, done: true };
                }
                if (kind == 'keys') return { value: index, done: false };
                if (kind == 'values') return { value: target[index], done: false };
                return { value: [index, target[index]], done: false };
              },
              'values'
            );

            // argumentsList[@@iterator] is %ArrayProto_values%
            // https://tc39.es/ecma262/#sec-createunmappedargumentsobject
            // https://tc39.es/ecma262/#sec-createmappedargumentsobject
            var values = (Iterators.Arguments = Iterators.Array);

            // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
            addToUnscopables('keys');
            addToUnscopables('values');
            addToUnscopables('entries');

            // V8 ~ Chrome 45- bug
            if (!IS_PURE && DESCRIPTORS && values.name !== 'values')
              try {
                defineProperty(values, 'name', { value: 'values' });
              } catch (error) {
                /* empty */
              }
          },
          {
            '../internals/add-to-unscopables': 95,
            '../internals/define-iterator': 129,
            '../internals/descriptors': 131,
            '../internals/internal-state': 170,
            '../internals/is-pure': 178,
            '../internals/iterators': 184,
            '../internals/object-define-property': 195,
            '../internals/to-indexed-object': 244
          }
        ],
        276: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var uncurryThis = require('../internals/function-uncurry-this');
            var IndexedObject = require('../internals/indexed-object');
            var toIndexedObject = require('../internals/to-indexed-object');
            var arrayMethodIsStrict = require('../internals/array-method-is-strict');

            var un$Join = uncurryThis([].join);

            var ES3_STRINGS = IndexedObject != Object;
            var STRICT_METHOD = arrayMethodIsStrict('join', ',');

            // `Array.prototype.join` method
            // https://tc39.es/ecma262/#sec-array.prototype.join
            $(
              { target: 'Array', proto: true, forced: ES3_STRINGS || !STRICT_METHOD },
              {
                join: function join(separator) {
                  return un$Join(toIndexedObject(this), separator === undefined ? ',' : separator);
                }
              }
            );
          },
          {
            '../internals/array-method-is-strict': 111,
            '../internals/export': 146,
            '../internals/function-uncurry-this': 154,
            '../internals/indexed-object': 167,
            '../internals/to-indexed-object': 244
          }
        ],
        277: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var $map = require('../internals/array-iteration').map;
            var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');

            var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map');

            // `Array.prototype.map` method
            // https://tc39.es/ecma262/#sec-array.prototype.map
            // with adding support of @@species
            $(
              { target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT },
              {
                map: function map(callbackfn /* , thisArg */) {
                  return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
                }
              }
            );
          },
          {
            '../internals/array-iteration': 108,
            '../internals/array-method-has-species-support': 110,
            '../internals/export': 146
          }
        ],
        278: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var global = require('../internals/global');
            var isArray = require('../internals/is-array');
            var isConstructor = require('../internals/is-constructor');
            var isObject = require('../internals/is-object');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var toIndexedObject = require('../internals/to-indexed-object');
            var createProperty = require('../internals/create-property');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');
            var un$Slice = require('../internals/array-slice');

            var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('slice');

            var SPECIES = wellKnownSymbol('species');
            var Array = global.Array;
            var max = Math.max;

            // `Array.prototype.slice` method
            // https://tc39.es/ecma262/#sec-array.prototype.slice
            // fallback for not array-like ES3 strings and DOM objects
            $(
              { target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT },
              {
                slice: function slice(start, end) {
                  var O = toIndexedObject(this);
                  var length = lengthOfArrayLike(O);
                  var k = toAbsoluteIndex(start, length);
                  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
                  // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
                  var Constructor, result, n;
                  if (isArray(O)) {
                    Constructor = O.constructor;
                    // cross-realm fallback
                    if (isConstructor(Constructor) && (Constructor === Array || isArray(Constructor.prototype))) {
                      Constructor = undefined;
                    } else if (isObject(Constructor)) {
                      Constructor = Constructor[SPECIES];
                      if (Constructor === null) Constructor = undefined;
                    }
                    if (Constructor === Array || Constructor === undefined) {
                      return un$Slice(O, k, fin);
                    }
                  }
                  result = new (Constructor === undefined ? Array : Constructor)(max(fin - k, 0));
                  for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);
                  result.length = n;
                  return result;
                }
              }
            );
          },
          {
            '../internals/array-method-has-species-support': 110,
            '../internals/array-slice': 114,
            '../internals/create-property': 128,
            '../internals/export': 146,
            '../internals/global': 160,
            '../internals/is-array': 172,
            '../internals/is-constructor': 174,
            '../internals/is-object': 177,
            '../internals/length-of-array-like': 185,
            '../internals/to-absolute-index': 242,
            '../internals/to-indexed-object': 244,
            '../internals/well-known-symbol': 265
          }
        ],
        279: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var uncurryThis = require('../internals/function-uncurry-this');
            var aCallable = require('../internals/a-callable');
            var toObject = require('../internals/to-object');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var toString = require('../internals/to-string');
            var fails = require('../internals/fails');
            var internalSort = require('../internals/array-sort');
            var arrayMethodIsStrict = require('../internals/array-method-is-strict');
            var FF = require('../internals/engine-ff-version');
            var IE_OR_EDGE = require('../internals/engine-is-ie-or-edge');
            var V8 = require('../internals/engine-v8-version');
            var WEBKIT = require('../internals/engine-webkit-version');

            var test = [];
            var un$Sort = uncurryThis(test.sort);
            var push = uncurryThis(test.push);

            // IE8-
            var FAILS_ON_UNDEFINED = fails(function () {
              test.sort(undefined);
            });
            // V8 bug
            var FAILS_ON_NULL = fails(function () {
              test.sort(null);
            });
            // Old WebKit
            var STRICT_METHOD = arrayMethodIsStrict('sort');

            var STABLE_SORT = !fails(function () {
              // feature detection can be too slow, so check engines versions
              if (V8) return V8 < 70;
              if (FF && FF > 3) return;
              if (IE_OR_EDGE) return true;
              if (WEBKIT) return WEBKIT < 603;

              var result = '';
              var code, chr, value, index;

              // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
              for (code = 65; code < 76; code++) {
                chr = String.fromCharCode(code);

                switch (code) {
                  case 66:
                  case 69:
                  case 70:
                  case 72:
                    value = 3;
                    break;
                  case 68:
                  case 71:
                    value = 4;
                    break;
                  default:
                    value = 2;
                }

                for (index = 0; index < 47; index++) {
                  test.push({ k: chr + index, v: value });
                }
              }

              test.sort(function (a, b) {
                return b.v - a.v;
              });

              for (index = 0; index < test.length; index++) {
                chr = test[index].k.charAt(0);
                if (result.charAt(result.length - 1) !== chr) result += chr;
              }

              return result !== 'DGBEFHACIJK';
            });

            var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD || !STABLE_SORT;

            var getSortCompare = function (comparefn) {
              return function (x, y) {
                if (y === undefined) return -1;
                if (x === undefined) return 1;
                if (comparefn !== undefined) return +comparefn(x, y) || 0;
                return toString(x) > toString(y) ? 1 : -1;
              };
            };

            // `Array.prototype.sort` method
            // https://tc39.es/ecma262/#sec-array.prototype.sort
            $(
              { target: 'Array', proto: true, forced: FORCED },
              {
                sort: function sort(comparefn) {
                  if (comparefn !== undefined) aCallable(comparefn);

                  var array = toObject(this);

                  if (STABLE_SORT) return comparefn === undefined ? un$Sort(array) : un$Sort(array, comparefn);

                  var items = [];
                  var arrayLength = lengthOfArrayLike(array);
                  var itemsLength, index;

                  for (index = 0; index < arrayLength; index++) {
                    if (index in array) push(items, array[index]);
                  }

                  internalSort(items, getSortCompare(comparefn));

                  itemsLength = items.length;
                  index = 0;

                  while (index < itemsLength) array[index] = items[index++];
                  while (index < arrayLength) delete array[index++];

                  return array;
                }
              }
            );
          },
          {
            '../internals/a-callable': 92,
            '../internals/array-method-is-strict': 111,
            '../internals/array-sort': 115,
            '../internals/engine-ff-version': 135,
            '../internals/engine-is-ie-or-edge': 137,
            '../internals/engine-v8-version': 143,
            '../internals/engine-webkit-version': 144,
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247,
            '../internals/to-string': 253
          }
        ],
        280: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var global = require('../internals/global');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var toObject = require('../internals/to-object');
            var arraySpeciesCreate = require('../internals/array-species-create');
            var createProperty = require('../internals/create-property');
            var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');

            var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');

            var TypeError = global.TypeError;
            var max = Math.max;
            var min = Math.min;
            var MAX_SAFE_INTEGER = 0x1fffffffffffff;
            var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded';

            // `Array.prototype.splice` method
            // https://tc39.es/ecma262/#sec-array.prototype.splice
            // with adding support of @@species
            $(
              { target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT },
              {
                splice: function splice(start, deleteCount /* , ...items */) {
                  var O = toObject(this);
                  var len = lengthOfArrayLike(O);
                  var actualStart = toAbsoluteIndex(start, len);
                  var argumentsLength = arguments.length;
                  var insertCount, actualDeleteCount, A, k, from, to;
                  if (argumentsLength === 0) {
                    insertCount = actualDeleteCount = 0;
                  } else if (argumentsLength === 1) {
                    insertCount = 0;
                    actualDeleteCount = len - actualStart;
                  } else {
                    insertCount = argumentsLength - 2;
                    actualDeleteCount = min(max(toIntegerOrInfinity(deleteCount), 0), len - actualStart);
                  }
                  if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER) {
                    throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
                  }
                  A = arraySpeciesCreate(O, actualDeleteCount);
                  for (k = 0; k < actualDeleteCount; k++) {
                    from = actualStart + k;
                    if (from in O) createProperty(A, k, O[from]);
                  }
                  A.length = actualDeleteCount;
                  if (insertCount < actualDeleteCount) {
                    for (k = actualStart; k < len - actualDeleteCount; k++) {
                      from = k + actualDeleteCount;
                      to = k + insertCount;
                      if (from in O) O[to] = O[from];
                      else delete O[to];
                    }
                    for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
                  } else if (insertCount > actualDeleteCount) {
                    for (k = len - actualDeleteCount; k > actualStart; k--) {
                      from = k + actualDeleteCount - 1;
                      to = k + insertCount - 1;
                      if (from in O) O[to] = O[from];
                      else delete O[to];
                    }
                  }
                  for (k = 0; k < insertCount; k++) {
                    O[k + actualStart] = arguments[k + 2];
                  }
                  O.length = len - actualDeleteCount + insertCount;
                  return A;
                }
              }
            );
          },
          {
            '../internals/array-method-has-species-support': 110,
            '../internals/array-species-create': 117,
            '../internals/create-property': 128,
            '../internals/export': 146,
            '../internals/global': 160,
            '../internals/length-of-array-like': 185,
            '../internals/to-absolute-index': 242,
            '../internals/to-integer-or-infinity': 245,
            '../internals/to-object': 247
          }
        ],
        281: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var FUNCTION_NAME_EXISTS = require('../internals/function-name').EXISTS;
            var uncurryThis = require('../internals/function-uncurry-this');
            var defineProperty = require('../internals/object-define-property').f;

            var FunctionPrototype = Function.prototype;
            var functionToString = uncurryThis(FunctionPrototype.toString);
            var nameRE = /function\b(?:\s|\/\*[\S\s]*?\*\/|\/\/[^\n\r]*[\n\r]+)*([^\s(/]*)/;
            var regExpExec = uncurryThis(nameRE.exec);
            var NAME = 'name';

            // Function instances `.name` property
            // https://tc39.es/ecma262/#sec-function-instances-name
            if (DESCRIPTORS && !FUNCTION_NAME_EXISTS) {
              defineProperty(FunctionPrototype, NAME, {
                configurable: true,
                get: function () {
                  try {
                    return regExpExec(nameRE, functionToString(this))[1];
                  } catch (error) {
                    return '';
                  }
                }
              });
            }
          },
          {
            '../internals/descriptors': 131,
            '../internals/function-name': 153,
            '../internals/function-uncurry-this': 154,
            '../internals/object-define-property': 195
          }
        ],
        282: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var getBuiltIn = require('../internals/get-built-in');
            var apply = require('../internals/function-apply');
            var call = require('../internals/function-call');
            var uncurryThis = require('../internals/function-uncurry-this');
            var fails = require('../internals/fails');
            var isArray = require('../internals/is-array');
            var isCallable = require('../internals/is-callable');
            var isObject = require('../internals/is-object');
            var isSymbol = require('../internals/is-symbol');
            var arraySlice = require('../internals/array-slice');
            var NATIVE_SYMBOL = require('../internals/native-symbol');

            var $stringify = getBuiltIn('JSON', 'stringify');
            var exec = uncurryThis(/./.exec);
            var charAt = uncurryThis(''.charAt);
            var charCodeAt = uncurryThis(''.charCodeAt);
            var replace = uncurryThis(''.replace);
            var numberToString = uncurryThis((1.0).toString);

            var tester = /[\uD800-\uDFFF]/g;
            var low = /^[\uD800-\uDBFF]$/;
            var hi = /^[\uDC00-\uDFFF]$/;

            var WRONG_SYMBOLS_CONVERSION =
              !NATIVE_SYMBOL ||
              fails(function () {
                var symbol = getBuiltIn('Symbol')();
                // MS Edge converts symbol values to JSON as {}
                return (
                  $stringify([symbol]) != '[null]' ||
                  // WebKit converts symbol values to JSON as null
                  $stringify({ a: symbol }) != '{}' ||
                  // V8 throws on boxed symbols
                  $stringify(Object(symbol)) != '{}'
                );
              });

            // https://github.com/tc39/proposal-well-formed-stringify
            var ILL_FORMED_UNICODE = fails(function () {
              return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"' || $stringify('\uDEAD') !== '"\\udead"';
            });

            var stringifyWithSymbolsFix = function (it, replacer) {
              var args = arraySlice(arguments);
              var $replacer = replacer;
              if ((!isObject(replacer) && it === undefined) || isSymbol(it)) return; // IE8 returns string on undefined
              if (!isArray(replacer))
                replacer = function (key, value) {
                  if (isCallable($replacer)) value = call($replacer, this, key, value);
                  if (!isSymbol(value)) return value;
                };
              args[1] = replacer;
              return apply($stringify, null, args);
            };

            var fixIllFormed = function (match, offset, string) {
              var prev = charAt(string, offset - 1);
              var next = charAt(string, offset + 1);
              if ((exec(low, match) && !exec(hi, next)) || (exec(hi, match) && !exec(low, prev))) {
                return '\\u' + numberToString(charCodeAt(match, 0), 16);
              }
              return match;
            };

            if ($stringify) {
              // `JSON.stringify` method
              // https://tc39.es/ecma262/#sec-json.stringify
              $(
                { target: 'JSON', stat: true, forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE },
                {
                  // eslint-disable-next-line no-unused-vars -- required for `.length`
                  stringify: function stringify(it, replacer, space) {
                    var args = arraySlice(arguments);
                    var result = apply(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
                    return ILL_FORMED_UNICODE && typeof result == 'string'
                      ? replace(result, tester, fixIllFormed)
                      : result;
                  }
                }
              );
            }
          },
          {
            '../internals/array-slice': 114,
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/function-apply': 149,
            '../internals/function-call': 152,
            '../internals/function-uncurry-this': 154,
            '../internals/get-built-in': 155,
            '../internals/is-array': 172,
            '../internals/is-callable': 173,
            '../internals/is-object': 177,
            '../internals/is-symbol': 180,
            '../internals/native-symbol': 188
          }
        ],
        283: [
          function (require, module, exports) {
            'use strict';
            var DESCRIPTORS = require('../internals/descriptors');
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var isForced = require('../internals/is-forced');
            var redefine = require('../internals/redefine');
            var hasOwn = require('../internals/has-own-property');
            var inheritIfRequired = require('../internals/inherit-if-required');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var isSymbol = require('../internals/is-symbol');
            var toPrimitive = require('../internals/to-primitive');
            var fails = require('../internals/fails');
            var getOwnPropertyNames = require('../internals/object-get-own-property-names').f;
            var getOwnPropertyDescriptor = require('../internals/object-get-own-property-descriptor').f;
            var defineProperty = require('../internals/object-define-property').f;
            var thisNumberValue = require('../internals/this-number-value');
            var trim = require('../internals/string-trim').trim;

            var NUMBER = 'Number';
            var NativeNumber = global[NUMBER];
            var NumberPrototype = NativeNumber.prototype;
            var TypeError = global.TypeError;
            var arraySlice = uncurryThis(''.slice);
            var charCodeAt = uncurryThis(''.charCodeAt);

            // `ToNumeric` abstract operation
            // https://tc39.es/ecma262/#sec-tonumeric
            var toNumeric = function (value) {
              var primValue = toPrimitive(value, 'number');
              return typeof primValue == 'bigint' ? primValue : toNumber(primValue);
            };

            // `ToNumber` abstract operation
            // https://tc39.es/ecma262/#sec-tonumber
            var toNumber = function (argument) {
              var it = toPrimitive(argument, 'number');
              var first, third, radix, maxCode, digits, length, index, code;
              if (isSymbol(it)) throw TypeError('Cannot convert a Symbol value to a number');
              if (typeof it == 'string' && it.length > 2) {
                it = trim(it);
                first = charCodeAt(it, 0);
                if (first === 43 || first === 45) {
                  third = charCodeAt(it, 2);
                  if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
                } else if (first === 48) {
                  switch (charCodeAt(it, 1)) {
                    case 66:
                    case 98:
                      radix = 2;
                      maxCode = 49;
                      break; // fast equal of /^0b[01]+$/i
                    case 79:
                    case 111:
                      radix = 8;
                      maxCode = 55;
                      break; // fast equal of /^0o[0-7]+$/i
                    default:
                      return +it;
                  }
                  digits = arraySlice(it, 2);
                  length = digits.length;
                  for (index = 0; index < length; index++) {
                    code = charCodeAt(digits, index);
                    // parseInt parses a string to a first unavailable symbol
                    // but ToNumber should return NaN if a string contains unavailable symbols
                    if (code < 48 || code > maxCode) return NaN;
                  }
                  return parseInt(digits, radix);
                }
              }
              return +it;
            };

            // `Number` constructor
            // https://tc39.es/ecma262/#sec-number-constructor
            if (isForced(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
              var NumberWrapper = function Number(value) {
                var n = arguments.length < 1 ? 0 : NativeNumber(toNumeric(value));
                var dummy = this;
                // check on 1..constructor(foo) case
                return isPrototypeOf(NumberPrototype, dummy) &&
                  fails(function () {
                    thisNumberValue(dummy);
                  })
                  ? inheritIfRequired(Object(n), dummy, NumberWrapper)
                  : n;
              };
              for (
                var keys = DESCRIPTORS
                    ? getOwnPropertyNames(NativeNumber)
                    : // ES3:
                      (
                        'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +
                        // ES2015 (in case, if modules with ES2015 Number statics required before):
                        'EPSILON,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,isFinite,isInteger,isNaN,isSafeInteger,parseFloat,parseInt,' +
                        // ESNext
                        'fromString,range'
                      ).split(','),
                  j = 0,
                  key;
                keys.length > j;
                j++
              ) {
                if (hasOwn(NativeNumber, (key = keys[j])) && !hasOwn(NumberWrapper, key)) {
                  defineProperty(NumberWrapper, key, getOwnPropertyDescriptor(NativeNumber, key));
                }
              }
              NumberWrapper.prototype = NumberPrototype;
              NumberPrototype.constructor = NumberWrapper;
              redefine(global, NUMBER, NumberWrapper);
            }
          },
          {
            '../internals/descriptors': 131,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/inherit-if-required': 168,
            '../internals/is-forced': 175,
            '../internals/is-symbol': 180,
            '../internals/object-define-property': 195,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/object-get-own-property-names': 198,
            '../internals/object-is-prototype-of': 201,
            '../internals/redefine': 219,
            '../internals/string-trim': 238,
            '../internals/this-number-value': 241,
            '../internals/to-primitive': 250
          }
        ],
        284: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var assign = require('../internals/object-assign');

            // `Object.assign` method
            // https://tc39.es/ecma262/#sec-object.assign
            // eslint-disable-next-line es-x/no-object-assign -- required for testing
            $(
              { target: 'Object', stat: true, forced: Object.assign !== assign },
              {
                assign: assign
              }
            );
          },
          { '../internals/export': 146, '../internals/object-assign': 192 }
        ],
        285: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var $entries = require('../internals/object-to-array').entries;

            // `Object.entries` method
            // https://tc39.es/ecma262/#sec-object.entries
            $(
              { target: 'Object', stat: true },
              {
                entries: function entries(O) {
                  return $entries(O);
                }
              }
            );
          },
          { '../internals/export': 146, '../internals/object-to-array': 206 }
        ],
        286: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var fails = require('../internals/fails');
            var toIndexedObject = require('../internals/to-indexed-object');
            var nativeGetOwnPropertyDescriptor = require('../internals/object-get-own-property-descriptor').f;
            var DESCRIPTORS = require('../internals/descriptors');

            var FAILS_ON_PRIMITIVES = fails(function () {
              nativeGetOwnPropertyDescriptor(1);
            });
            var FORCED = !DESCRIPTORS || FAILS_ON_PRIMITIVES;

            // `Object.getOwnPropertyDescriptor` method
            // https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
            $(
              { target: 'Object', stat: true, forced: FORCED, sham: !DESCRIPTORS },
              {
                getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
                  return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
                }
              }
            );
          },
          {
            '../internals/descriptors': 131,
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/to-indexed-object': 244
          }
        ],
        287: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var DESCRIPTORS = require('../internals/descriptors');
            var ownKeys = require('../internals/own-keys');
            var toIndexedObject = require('../internals/to-indexed-object');
            var getOwnPropertyDescriptorModule = require('../internals/object-get-own-property-descriptor');
            var createProperty = require('../internals/create-property');

            // `Object.getOwnPropertyDescriptors` method
            // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
            $(
              { target: 'Object', stat: true, sham: !DESCRIPTORS },
              {
                getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
                  var O = toIndexedObject(object);
                  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
                  var keys = ownKeys(O);
                  var result = {};
                  var index = 0;
                  var key, descriptor;
                  while (keys.length > index) {
                    descriptor = getOwnPropertyDescriptor(O, (key = keys[index++]));
                    if (descriptor !== undefined) createProperty(result, key, descriptor);
                  }
                  return result;
                }
              }
            );
          },
          {
            '../internals/create-property': 128,
            '../internals/descriptors': 131,
            '../internals/export': 146,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/own-keys': 209,
            '../internals/to-indexed-object': 244
          }
        ],
        288: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var NATIVE_SYMBOL = require('../internals/native-symbol');
            var fails = require('../internals/fails');
            var getOwnPropertySymbolsModule = require('../internals/object-get-own-property-symbols');
            var toObject = require('../internals/to-object');

            // V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
            // https://bugs.chromium.org/p/v8/issues/detail?id=3443
            var FORCED =
              !NATIVE_SYMBOL ||
              fails(function () {
                getOwnPropertySymbolsModule.f(1);
              });

            // `Object.getOwnPropertySymbols` method
            // https://tc39.es/ecma262/#sec-object.getownpropertysymbols
            $(
              { target: 'Object', stat: true, forced: FORCED },
              {
                getOwnPropertySymbols: function getOwnPropertySymbols(it) {
                  var $getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
                  return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject(it)) : [];
                }
              }
            );
          },
          {
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/native-symbol': 188,
            '../internals/object-get-own-property-symbols': 199,
            '../internals/to-object': 247
          }
        ],
        289: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var toObject = require('../internals/to-object');
            var nativeKeys = require('../internals/object-keys');
            var fails = require('../internals/fails');

            var FAILS_ON_PRIMITIVES = fails(function () {
              nativeKeys(1);
            });

            // `Object.keys` method
            // https://tc39.es/ecma262/#sec-object.keys
            $(
              { target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES },
              {
                keys: function keys(it) {
                  return nativeKeys(toObject(it));
                }
              }
            );
          },
          {
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/object-keys': 203,
            '../internals/to-object': 247
          }
        ],
        290: [
          function (require, module, exports) {
            var TO_STRING_TAG_SUPPORT = require('../internals/to-string-tag-support');
            var redefine = require('../internals/redefine');
            var toString = require('../internals/object-to-string');

            // `Object.prototype.toString` method
            // https://tc39.es/ecma262/#sec-object.prototype.tostring
            if (!TO_STRING_TAG_SUPPORT) {
              redefine(Object.prototype, 'toString', toString, { unsafe: true });
            }
          },
          {
            '../internals/object-to-string': 207,
            '../internals/redefine': 219,
            '../internals/to-string-tag-support': 252
          }
        ],
        291: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var call = require('../internals/function-call');
            var aCallable = require('../internals/a-callable');
            var newPromiseCapabilityModule = require('../internals/new-promise-capability');
            var perform = require('../internals/perform');
            var iterate = require('../internals/iterate');
            var PROMISE_STATICS_INCORRECT_ITERATION = require('../internals/promise-statics-incorrect-iteration');

            // `Promise.all` method
            // https://tc39.es/ecma262/#sec-promise.all
            $(
              { target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION },
              {
                all: function all(iterable) {
                  var C = this;
                  var capability = newPromiseCapabilityModule.f(C);
                  var resolve = capability.resolve;
                  var reject = capability.reject;
                  var result = perform(function () {
                    var $promiseResolve = aCallable(C.resolve);
                    var values = [];
                    var counter = 0;
                    var remaining = 1;
                    iterate(iterable, function (promise) {
                      var index = counter++;
                      var alreadyCalled = false;
                      remaining++;
                      call($promiseResolve, C, promise).then(function (value) {
                        if (alreadyCalled) return;
                        alreadyCalled = true;
                        values[index] = value;
                        --remaining || resolve(values);
                      }, reject);
                    });
                    --remaining || resolve(values);
                  });
                  if (result.error) reject(result.value);
                  return capability.promise;
                }
              }
            );
          },
          {
            '../internals/a-callable': 92,
            '../internals/export': 146,
            '../internals/function-call': 152,
            '../internals/iterate': 181,
            '../internals/new-promise-capability': 190,
            '../internals/perform': 211,
            '../internals/promise-statics-incorrect-iteration': 215
          }
        ],
        292: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var IS_PURE = require('../internals/is-pure');
            var FORCED_PROMISE_CONSTRUCTOR = require('../internals/promise-constructor-detection').CONSTRUCTOR;
            var NativePromiseConstructor = require('../internals/promise-native-constructor');
            var getBuiltIn = require('../internals/get-built-in');
            var isCallable = require('../internals/is-callable');
            var redefine = require('../internals/redefine');

            var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

            // `Promise.prototype.catch` method
            // https://tc39.es/ecma262/#sec-promise.prototype.catch
            $(
              { target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR, real: true },
              {
                catch: function (onRejected) {
                  return this.then(undefined, onRejected);
                }
              }
            );

            // makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
            if (!IS_PURE && isCallable(NativePromiseConstructor)) {
              var method = getBuiltIn('Promise').prototype['catch'];
              if (NativePromisePrototype['catch'] !== method) {
                redefine(NativePromisePrototype, 'catch', method, { unsafe: true });
              }
            }
          },
          {
            '../internals/export': 146,
            '../internals/get-built-in': 155,
            '../internals/is-callable': 173,
            '../internals/is-pure': 178,
            '../internals/promise-constructor-detection': 212,
            '../internals/promise-native-constructor': 213,
            '../internals/redefine': 219
          }
        ],
        293: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var IS_PURE = require('../internals/is-pure');
            var IS_NODE = require('../internals/engine-is-node');
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var redefine = require('../internals/redefine');
            var redefineAll = require('../internals/redefine-all');
            var setPrototypeOf = require('../internals/object-set-prototype-of');
            var setToStringTag = require('../internals/set-to-string-tag');
            var setSpecies = require('../internals/set-species');
            var aCallable = require('../internals/a-callable');
            var isCallable = require('../internals/is-callable');
            var isObject = require('../internals/is-object');
            var anInstance = require('../internals/an-instance');
            var speciesConstructor = require('../internals/species-constructor');
            var task = require('../internals/task').set;
            var microtask = require('../internals/microtask');
            var hostReportErrors = require('../internals/host-report-errors');
            var perform = require('../internals/perform');
            var Queue = require('../internals/queue');
            var InternalStateModule = require('../internals/internal-state');
            var NativePromiseConstructor = require('../internals/promise-native-constructor');
            var PromiseConstructorDetection = require('../internals/promise-constructor-detection');
            var newPromiseCapabilityModule = require('../internals/new-promise-capability');

            var PROMISE = 'Promise';
            var FORCED_PROMISE_CONSTRUCTOR = PromiseConstructorDetection.CONSTRUCTOR;
            var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
            var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
            var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
            var setInternalState = InternalStateModule.set;
            var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
            var PromiseConstructor = NativePromiseConstructor;
            var PromisePrototype = NativePromisePrototype;
            var TypeError = global.TypeError;
            var document = global.document;
            var process = global.process;
            var newPromiseCapability = newPromiseCapabilityModule.f;
            var newGenericPromiseCapability = newPromiseCapability;

            var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
            var UNHANDLED_REJECTION = 'unhandledrejection';
            var REJECTION_HANDLED = 'rejectionhandled';
            var PENDING = 0;
            var FULFILLED = 1;
            var REJECTED = 2;
            var HANDLED = 1;
            var UNHANDLED = 2;

            var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

            // helpers
            var isThenable = function (it) {
              var then;
              return isObject(it) && isCallable((then = it.then)) ? then : false;
            };

            var callReaction = function (reaction, state) {
              var value = state.value;
              var ok = state.state == FULFILLED;
              var handler = ok ? reaction.ok : reaction.fail;
              var resolve = reaction.resolve;
              var reject = reaction.reject;
              var domain = reaction.domain;
              var result, then, exited;
              try {
                if (handler) {
                  if (!ok) {
                    if (state.rejection === UNHANDLED) onHandleUnhandled(state);
                    state.rejection = HANDLED;
                  }
                  if (handler === true) result = value;
                  else {
                    if (domain) domain.enter();
                    result = handler(value); // can throw
                    if (domain) {
                      domain.exit();
                      exited = true;
                    }
                  }
                  if (result === reaction.promise) {
                    reject(TypeError('Promise-chain cycle'));
                  } else if ((then = isThenable(result))) {
                    call(then, result, resolve, reject);
                  } else resolve(result);
                } else reject(value);
              } catch (error) {
                if (domain && !exited) domain.exit();
                reject(error);
              }
            };

            var notify = function (state, isReject) {
              if (state.notified) return;
              state.notified = true;
              microtask(function () {
                var reactions = state.reactions;
                var reaction;
                while ((reaction = reactions.get())) {
                  callReaction(reaction, state);
                }
                state.notified = false;
                if (isReject && !state.rejection) onUnhandled(state);
              });
            };

            var dispatchEvent = function (name, promise, reason) {
              var event, handler;
              if (DISPATCH_EVENT) {
                event = document.createEvent('Event');
                event.promise = promise;
                event.reason = reason;
                event.initEvent(name, false, true);
                global.dispatchEvent(event);
              } else event = { promise: promise, reason: reason };
              if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global['on' + name])) handler(event);
              else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
            };

            var onUnhandled = function (state) {
              call(task, global, function () {
                var promise = state.facade;
                var value = state.value;
                var IS_UNHANDLED = isUnhandled(state);
                var result;
                if (IS_UNHANDLED) {
                  result = perform(function () {
                    if (IS_NODE) {
                      process.emit('unhandledRejection', value, promise);
                    } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
                  });
                  // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
                  state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
                  if (result.error) throw result.value;
                }
              });
            };

            var isUnhandled = function (state) {
              return state.rejection !== HANDLED && !state.parent;
            };

            var onHandleUnhandled = function (state) {
              call(task, global, function () {
                var promise = state.facade;
                if (IS_NODE) {
                  process.emit('rejectionHandled', promise);
                } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
              });
            };

            var bind = function (fn, state, unwrap) {
              return function (value) {
                fn(state, value, unwrap);
              };
            };

            var internalReject = function (state, value, unwrap) {
              if (state.done) return;
              state.done = true;
              if (unwrap) state = unwrap;
              state.value = value;
              state.state = REJECTED;
              notify(state, true);
            };

            var internalResolve = function (state, value, unwrap) {
              if (state.done) return;
              state.done = true;
              if (unwrap) state = unwrap;
              try {
                if (state.facade === value) throw TypeError("Promise can't be resolved itself");
                var then = isThenable(value);
                if (then) {
                  microtask(function () {
                    var wrapper = { done: false };
                    try {
                      call(then, value, bind(internalResolve, wrapper, state), bind(internalReject, wrapper, state));
                    } catch (error) {
                      internalReject(wrapper, error, state);
                    }
                  });
                } else {
                  state.value = value;
                  state.state = FULFILLED;
                  notify(state, false);
                }
              } catch (error) {
                internalReject({ done: false }, error, state);
              }
            };

            // constructor polyfill
            if (FORCED_PROMISE_CONSTRUCTOR) {
              // 25.4.3.1 Promise(executor)
              PromiseConstructor = function Promise(executor) {
                anInstance(this, PromisePrototype);
                aCallable(executor);
                call(Internal, this);
                var state = getInternalPromiseState(this);
                try {
                  executor(bind(internalResolve, state), bind(internalReject, state));
                } catch (error) {
                  internalReject(state, error);
                }
              };

              PromisePrototype = PromiseConstructor.prototype;

              // eslint-disable-next-line no-unused-vars -- required for `.length`
              Internal = function Promise(executor) {
                setInternalState(this, {
                  type: PROMISE,
                  done: false,
                  notified: false,
                  parent: false,
                  reactions: new Queue(),
                  rejection: false,
                  state: PENDING,
                  value: undefined
                });
              };

              Internal.prototype = redefineAll(PromisePrototype, {
                // `Promise.prototype.then` method
                // https://tc39.es/ecma262/#sec-promise.prototype.then
                // eslint-disable-next-line unicorn/no-thenable -- safe
                then: function then(onFulfilled, onRejected) {
                  var state = getInternalPromiseState(this);
                  var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
                  state.parent = true;
                  reaction.ok = isCallable(onFulfilled) ? onFulfilled : true;
                  reaction.fail = isCallable(onRejected) && onRejected;
                  reaction.domain = IS_NODE ? process.domain : undefined;
                  if (state.state == PENDING) state.reactions.add(reaction);
                  else
                    microtask(function () {
                      callReaction(reaction, state);
                    });
                  return reaction.promise;
                }
              });

              OwnPromiseCapability = function () {
                var promise = new Internal();
                var state = getInternalPromiseState(promise);
                this.promise = promise;
                this.resolve = bind(internalResolve, state);
                this.reject = bind(internalReject, state);
              };

              newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
                return C === PromiseConstructor || C === PromiseWrapper
                  ? new OwnPromiseCapability(C)
                  : newGenericPromiseCapability(C);
              };

              if (!IS_PURE && isCallable(NativePromiseConstructor) && NativePromisePrototype !== Object.prototype) {
                nativeThen = NativePromisePrototype.then;

                if (!NATIVE_PROMISE_SUBCLASSING) {
                  // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
                  redefine(
                    NativePromisePrototype,
                    'then',
                    function then(onFulfilled, onRejected) {
                      var that = this;
                      return new PromiseConstructor(function (resolve, reject) {
                        call(nativeThen, that, resolve, reject);
                      }).then(onFulfilled, onRejected);
                      // https://github.com/zloirock/core-js/issues/640
                    },
                    { unsafe: true }
                  );
                }

                // make `.constructor === Promise` work for native promise-based APIs
                try {
                  delete NativePromisePrototype.constructor;
                } catch (error) {
                  /* empty */
                }

                // make `instanceof Promise` work for native promise-based APIs
                if (setPrototypeOf) {
                  setPrototypeOf(NativePromisePrototype, PromisePrototype);
                }
              }
            }

            $(
              { global: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR },
              {
                Promise: PromiseConstructor
              }
            );

            setToStringTag(PromiseConstructor, PROMISE, false, true);
            setSpecies(PROMISE);
          },
          {
            '../internals/a-callable': 92,
            '../internals/an-instance': 97,
            '../internals/engine-is-node': 140,
            '../internals/export': 146,
            '../internals/function-call': 152,
            '../internals/global': 160,
            '../internals/host-report-errors': 163,
            '../internals/internal-state': 170,
            '../internals/is-callable': 173,
            '../internals/is-object': 177,
            '../internals/is-pure': 178,
            '../internals/microtask': 186,
            '../internals/new-promise-capability': 190,
            '../internals/object-set-prototype-of': 205,
            '../internals/perform': 211,
            '../internals/promise-constructor-detection': 212,
            '../internals/promise-native-constructor': 213,
            '../internals/queue': 217,
            '../internals/redefine': 219,
            '../internals/redefine-all': 218,
            '../internals/set-species': 230,
            '../internals/set-to-string-tag': 231,
            '../internals/species-constructor': 235,
            '../internals/task': 240
          }
        ],
        294: [
          function (require, module, exports) {
            // TODO: Remove this module from `core-js@4` since it's split to modules listed below
            require('../modules/es.promise.constructor');
            require('../modules/es.promise.all');
            require('../modules/es.promise.catch');
            require('../modules/es.promise.race');
            require('../modules/es.promise.reject');
            require('../modules/es.promise.resolve');
          },
          {
            '../modules/es.promise.all': 291,
            '../modules/es.promise.catch': 292,
            '../modules/es.promise.constructor': 293,
            '../modules/es.promise.race': 295,
            '../modules/es.promise.reject': 296,
            '../modules/es.promise.resolve': 297
          }
        ],
        295: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var call = require('../internals/function-call');
            var aCallable = require('../internals/a-callable');
            var newPromiseCapabilityModule = require('../internals/new-promise-capability');
            var perform = require('../internals/perform');
            var iterate = require('../internals/iterate');
            var PROMISE_STATICS_INCORRECT_ITERATION = require('../internals/promise-statics-incorrect-iteration');

            // `Promise.race` method
            // https://tc39.es/ecma262/#sec-promise.race
            $(
              { target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION },
              {
                race: function race(iterable) {
                  var C = this;
                  var capability = newPromiseCapabilityModule.f(C);
                  var reject = capability.reject;
                  var result = perform(function () {
                    var $promiseResolve = aCallable(C.resolve);
                    iterate(iterable, function (promise) {
                      call($promiseResolve, C, promise).then(capability.resolve, reject);
                    });
                  });
                  if (result.error) reject(result.value);
                  return capability.promise;
                }
              }
            );
          },
          {
            '../internals/a-callable': 92,
            '../internals/export': 146,
            '../internals/function-call': 152,
            '../internals/iterate': 181,
            '../internals/new-promise-capability': 190,
            '../internals/perform': 211,
            '../internals/promise-statics-incorrect-iteration': 215
          }
        ],
        296: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var call = require('../internals/function-call');
            var newPromiseCapabilityModule = require('../internals/new-promise-capability');
            var FORCED_PROMISE_CONSTRUCTOR = require('../internals/promise-constructor-detection').CONSTRUCTOR;

            // `Promise.reject` method
            // https://tc39.es/ecma262/#sec-promise.reject
            $(
              { target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR },
              {
                reject: function reject(r) {
                  var capability = newPromiseCapabilityModule.f(this);
                  call(capability.reject, undefined, r);
                  return capability.promise;
                }
              }
            );
          },
          {
            '../internals/export': 146,
            '../internals/function-call': 152,
            '../internals/new-promise-capability': 190,
            '../internals/promise-constructor-detection': 212
          }
        ],
        297: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var getBuiltIn = require('../internals/get-built-in');
            var IS_PURE = require('../internals/is-pure');
            var NativePromiseConstructor = require('../internals/promise-native-constructor');
            var FORCED_PROMISE_CONSTRUCTOR = require('../internals/promise-constructor-detection').CONSTRUCTOR;
            var promiseResolve = require('../internals/promise-resolve');

            var PromiseConstructorWrapper = getBuiltIn('Promise');
            var CHECK_WRAPPER = IS_PURE && !FORCED_PROMISE_CONSTRUCTOR;

            // `Promise.resolve` method
            // https://tc39.es/ecma262/#sec-promise.resolve
            $(
              { target: 'Promise', stat: true, forced: IS_PURE || FORCED_PROMISE_CONSTRUCTOR },
              {
                resolve: function resolve(x) {
                  return promiseResolve(
                    CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor : this,
                    x
                  );
                }
              }
            );
          },
          {
            '../internals/export': 146,
            '../internals/get-built-in': 155,
            '../internals/is-pure': 178,
            '../internals/promise-constructor-detection': 212,
            '../internals/promise-native-constructor': 213,
            '../internals/promise-resolve': 214
          }
        ],
        298: [
          function (require, module, exports) {
            var DESCRIPTORS = require('../internals/descriptors');
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var isForced = require('../internals/is-forced');
            var inheritIfRequired = require('../internals/inherit-if-required');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var getOwnPropertyNames = require('../internals/object-get-own-property-names').f;
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var isRegExp = require('../internals/is-regexp');
            var toString = require('../internals/to-string');
            var getRegExpFlags = require('../internals/regexp-get-flags');
            var stickyHelpers = require('../internals/regexp-sticky-helpers');
            var proxyAccessor = require('../internals/proxy-accessor');
            var redefine = require('../internals/redefine');
            var fails = require('../internals/fails');
            var hasOwn = require('../internals/has-own-property');
            var enforceInternalState = require('../internals/internal-state').enforce;
            var setSpecies = require('../internals/set-species');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var UNSUPPORTED_DOT_ALL = require('../internals/regexp-unsupported-dot-all');
            var UNSUPPORTED_NCG = require('../internals/regexp-unsupported-ncg');

            var MATCH = wellKnownSymbol('match');
            var NativeRegExp = global.RegExp;
            var RegExpPrototype = NativeRegExp.prototype;
            var SyntaxError = global.SyntaxError;
            var exec = uncurryThis(RegExpPrototype.exec);
            var charAt = uncurryThis(''.charAt);
            var replace = uncurryThis(''.replace);
            var stringIndexOf = uncurryThis(''.indexOf);
            var stringSlice = uncurryThis(''.slice);
            // TODO: Use only propper RegExpIdentifierName
            var IS_NCG = /^\?<[^\s\d!#%&*+<=>@^][^\s!#%&*+<=>@^]*>/;
            var re1 = /a/g;
            var re2 = /a/g;

            // "new" should create a new object, old webkit bug
            var CORRECT_NEW = new NativeRegExp(re1) !== re1;

            var MISSED_STICKY = stickyHelpers.MISSED_STICKY;
            var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;

            var BASE_FORCED =
              DESCRIPTORS &&
              (!CORRECT_NEW ||
                MISSED_STICKY ||
                UNSUPPORTED_DOT_ALL ||
                UNSUPPORTED_NCG ||
                fails(function () {
                  re2[MATCH] = false;
                  // RegExp constructor can alter flags and IsRegExp works correct with @@match
                  return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
                }));

            var handleDotAll = function (string) {
              var length = string.length;
              var index = 0;
              var result = '';
              var brackets = false;
              var chr;
              for (; index <= length; index++) {
                chr = charAt(string, index);
                if (chr === '\\') {
                  result += chr + charAt(string, ++index);
                  continue;
                }
                if (!brackets && chr === '.') {
                  result += '[\\s\\S]';
                } else {
                  if (chr === '[') {
                    brackets = true;
                  } else if (chr === ']') {
                    brackets = false;
                  }
                  result += chr;
                }
              }
              return result;
            };

            var handleNCG = function (string) {
              var length = string.length;
              var index = 0;
              var result = '';
              var named = [];
              var names = {};
              var brackets = false;
              var ncg = false;
              var groupid = 0;
              var groupname = '';
              var chr;
              for (; index <= length; index++) {
                chr = charAt(string, index);
                if (chr === '\\') {
                  chr = chr + charAt(string, ++index);
                } else if (chr === ']') {
                  brackets = false;
                } else if (!brackets)
                  switch (true) {
                    case chr === '[':
                      brackets = true;
                      break;
                    case chr === '(':
                      if (exec(IS_NCG, stringSlice(string, index + 1))) {
                        index += 2;
                        ncg = true;
                      }
                      result += chr;
                      groupid++;
                      continue;
                    case chr === '>' && ncg:
                      if (groupname === '' || hasOwn(names, groupname)) {
                        throw new SyntaxError('Invalid capture group name');
                      }
                      names[groupname] = true;
                      named[named.length] = [groupname, groupid];
                      ncg = false;
                      groupname = '';
                      continue;
                  }
                if (ncg) groupname += chr;
                else result += chr;
              }
              return [result, named];
            };

            // `RegExp` constructor
            // https://tc39.es/ecma262/#sec-regexp-constructor
            if (isForced('RegExp', BASE_FORCED)) {
              var RegExpWrapper = function RegExp(pattern, flags) {
                var thisIsRegExp = isPrototypeOf(RegExpPrototype, this);
                var patternIsRegExp = isRegExp(pattern);
                var flagsAreUndefined = flags === undefined;
                var groups = [];
                var rawPattern = pattern;
                var rawFlags, dotAll, sticky, handled, result, state;

                if (!thisIsRegExp && patternIsRegExp && flagsAreUndefined && pattern.constructor === RegExpWrapper) {
                  return pattern;
                }

                if (patternIsRegExp || isPrototypeOf(RegExpPrototype, pattern)) {
                  pattern = pattern.source;
                  if (flagsAreUndefined) flags = getRegExpFlags(rawPattern);
                }

                pattern = pattern === undefined ? '' : toString(pattern);
                flags = flags === undefined ? '' : toString(flags);
                rawPattern = pattern;

                if (UNSUPPORTED_DOT_ALL && 'dotAll' in re1) {
                  dotAll = !!flags && stringIndexOf(flags, 's') > -1;
                  if (dotAll) flags = replace(flags, /s/g, '');
                }

                rawFlags = flags;

                if (MISSED_STICKY && 'sticky' in re1) {
                  sticky = !!flags && stringIndexOf(flags, 'y') > -1;
                  if (sticky && UNSUPPORTED_Y) flags = replace(flags, /y/g, '');
                }

                if (UNSUPPORTED_NCG) {
                  handled = handleNCG(pattern);
                  pattern = handled[0];
                  groups = handled[1];
                }

                result = inheritIfRequired(
                  NativeRegExp(pattern, flags),
                  thisIsRegExp ? this : RegExpPrototype,
                  RegExpWrapper
                );

                if (dotAll || sticky || groups.length) {
                  state = enforceInternalState(result);
                  if (dotAll) {
                    state.dotAll = true;
                    state.raw = RegExpWrapper(handleDotAll(pattern), rawFlags);
                  }
                  if (sticky) state.sticky = true;
                  if (groups.length) state.groups = groups;
                }

                if (pattern !== rawPattern)
                  try {
                    // fails in old engines, but we have no alternatives for unsupported regex syntax
                    createNonEnumerableProperty(result, 'source', rawPattern === '' ? '(?:)' : rawPattern);
                  } catch (error) {
                    /* empty */
                  }

                return result;
              };

              for (var keys = getOwnPropertyNames(NativeRegExp), index = 0; keys.length > index; ) {
                proxyAccessor(RegExpWrapper, NativeRegExp, keys[index++]);
              }

              RegExpPrototype.constructor = RegExpWrapper;
              RegExpWrapper.prototype = RegExpPrototype;
              redefine(global, 'RegExp', RegExpWrapper);
            }

            // https://tc39.es/ecma262/#sec-get-regexp-@@species
            setSpecies('RegExp');
          },
          {
            '../internals/create-non-enumerable-property': 126,
            '../internals/descriptors': 131,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/inherit-if-required': 168,
            '../internals/internal-state': 170,
            '../internals/is-forced': 175,
            '../internals/is-regexp': 179,
            '../internals/object-get-own-property-names': 198,
            '../internals/object-is-prototype-of': 201,
            '../internals/proxy-accessor': 216,
            '../internals/redefine': 219,
            '../internals/regexp-get-flags': 223,
            '../internals/regexp-sticky-helpers': 224,
            '../internals/regexp-unsupported-dot-all': 225,
            '../internals/regexp-unsupported-ncg': 226,
            '../internals/set-species': 230,
            '../internals/to-string': 253,
            '../internals/well-known-symbol': 265
          }
        ],
        299: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var exec = require('../internals/regexp-exec');

            // `RegExp.prototype.exec` method
            // https://tc39.es/ecma262/#sec-regexp.prototype.exec
            $(
              { target: 'RegExp', proto: true, forced: /./.exec !== exec },
              {
                exec: exec
              }
            );
          },
          { '../internals/export': 146, '../internals/regexp-exec': 221 }
        ],
        300: [
          function (require, module, exports) {
            'use strict';
            var PROPER_FUNCTION_NAME = require('../internals/function-name').PROPER;
            var redefine = require('../internals/redefine');
            var anObject = require('../internals/an-object');
            var $toString = require('../internals/to-string');
            var fails = require('../internals/fails');
            var getRegExpFlags = require('../internals/regexp-get-flags');

            var TO_STRING = 'toString';
            var RegExpPrototype = RegExp.prototype;
            var n$ToString = RegExpPrototype[TO_STRING];

            var NOT_GENERIC = fails(function () {
              return n$ToString.call({ source: 'a', flags: 'b' }) != '/a/b';
            });
            // FF44- RegExp#toString has a wrong name
            var INCORRECT_NAME = PROPER_FUNCTION_NAME && n$ToString.name != TO_STRING;

            // `RegExp.prototype.toString` method
            // https://tc39.es/ecma262/#sec-regexp.prototype.tostring
            if (NOT_GENERIC || INCORRECT_NAME) {
              redefine(
                RegExp.prototype,
                TO_STRING,
                function toString() {
                  var R = anObject(this);
                  var pattern = $toString(R.source);
                  var flags = $toString(getRegExpFlags(R));
                  return '/' + pattern + '/' + flags;
                },
                { unsafe: true }
              );
            }
          },
          {
            '../internals/an-object': 98,
            '../internals/fails': 147,
            '../internals/function-name': 153,
            '../internals/redefine': 219,
            '../internals/regexp-get-flags': 223,
            '../internals/to-string': 253
          }
        ],
        301: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var uncurryThis = require('../internals/function-uncurry-this');
            var notARegExp = require('../internals/not-a-regexp');
            var requireObjectCoercible = require('../internals/require-object-coercible');
            var toString = require('../internals/to-string');
            var correctIsRegExpLogic = require('../internals/correct-is-regexp-logic');

            var stringIndexOf = uncurryThis(''.indexOf);

            // `String.prototype.includes` method
            // https://tc39.es/ecma262/#sec-string.prototype.includes
            $(
              { target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') },
              {
                includes: function includes(searchString /* , position = 0 */) {
                  return !!~stringIndexOf(
                    toString(requireObjectCoercible(this)),
                    toString(notARegExp(searchString)),
                    arguments.length > 1 ? arguments[1] : undefined
                  );
                }
              }
            );
          },
          {
            '../internals/correct-is-regexp-logic': 123,
            '../internals/export': 146,
            '../internals/function-uncurry-this': 154,
            '../internals/not-a-regexp': 191,
            '../internals/require-object-coercible': 227,
            '../internals/to-string': 253
          }
        ],
        302: [
          function (require, module, exports) {
            'use strict';
            var charAt = require('../internals/string-multibyte').charAt;
            var toString = require('../internals/to-string');
            var InternalStateModule = require('../internals/internal-state');
            var defineIterator = require('../internals/define-iterator');

            var STRING_ITERATOR = 'String Iterator';
            var setInternalState = InternalStateModule.set;
            var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);

            // `String.prototype[@@iterator]` method
            // https://tc39.es/ecma262/#sec-string.prototype-@@iterator
            defineIterator(
              String,
              'String',
              function (iterated) {
                setInternalState(this, {
                  type: STRING_ITERATOR,
                  string: toString(iterated),
                  index: 0
                });
                // `%StringIteratorPrototype%.next` method
                // https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
              },
              function next() {
                var state = getInternalState(this);
                var string = state.string;
                var index = state.index;
                var point;
                if (index >= string.length) return { value: undefined, done: true };
                point = charAt(string, index);
                state.index += point.length;
                return { value: point, done: false };
              }
            );
          },
          {
            '../internals/define-iterator': 129,
            '../internals/internal-state': 170,
            '../internals/string-multibyte': 236,
            '../internals/to-string': 253
          }
        ],
        303: [
          function (require, module, exports) {
            'use strict';
            var call = require('../internals/function-call');
            var fixRegExpWellKnownSymbolLogic = require('../internals/fix-regexp-well-known-symbol-logic');
            var anObject = require('../internals/an-object');
            var toLength = require('../internals/to-length');
            var toString = require('../internals/to-string');
            var requireObjectCoercible = require('../internals/require-object-coercible');
            var getMethod = require('../internals/get-method');
            var advanceStringIndex = require('../internals/advance-string-index');
            var regExpExec = require('../internals/regexp-exec-abstract');

            // @@match logic
            fixRegExpWellKnownSymbolLogic('match', function (MATCH, nativeMatch, maybeCallNative) {
              return [
                // `String.prototype.match` method
                // https://tc39.es/ecma262/#sec-string.prototype.match
                function match(regexp) {
                  var O = requireObjectCoercible(this);
                  var matcher = regexp == undefined ? undefined : getMethod(regexp, MATCH);
                  return matcher ? call(matcher, regexp, O) : new RegExp(regexp)[MATCH](toString(O));
                },
                // `RegExp.prototype[@@match]` method
                // https://tc39.es/ecma262/#sec-regexp.prototype-@@match
                function (string) {
                  var rx = anObject(this);
                  var S = toString(string);
                  var res = maybeCallNative(nativeMatch, rx, S);

                  if (res.done) return res.value;

                  if (!rx.global) return regExpExec(rx, S);

                  var fullUnicode = rx.unicode;
                  rx.lastIndex = 0;
                  var A = [];
                  var n = 0;
                  var result;
                  while ((result = regExpExec(rx, S)) !== null) {
                    var matchStr = toString(result[0]);
                    A[n] = matchStr;
                    if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
                    n++;
                  }
                  return n === 0 ? null : A;
                }
              ];
            });
          },
          {
            '../internals/advance-string-index': 96,
            '../internals/an-object': 98,
            '../internals/fix-regexp-well-known-symbol-logic': 148,
            '../internals/function-call': 152,
            '../internals/get-method': 158,
            '../internals/regexp-exec-abstract': 220,
            '../internals/require-object-coercible': 227,
            '../internals/to-length': 246,
            '../internals/to-string': 253
          }
        ],
        304: [
          function (require, module, exports) {
            'use strict';
            var apply = require('../internals/function-apply');
            var call = require('../internals/function-call');
            var uncurryThis = require('../internals/function-uncurry-this');
            var fixRegExpWellKnownSymbolLogic = require('../internals/fix-regexp-well-known-symbol-logic');
            var fails = require('../internals/fails');
            var anObject = require('../internals/an-object');
            var isCallable = require('../internals/is-callable');
            var toIntegerOrInfinity = require('../internals/to-integer-or-infinity');
            var toLength = require('../internals/to-length');
            var toString = require('../internals/to-string');
            var requireObjectCoercible = require('../internals/require-object-coercible');
            var advanceStringIndex = require('../internals/advance-string-index');
            var getMethod = require('../internals/get-method');
            var getSubstitution = require('../internals/get-substitution');
            var regExpExec = require('../internals/regexp-exec-abstract');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var REPLACE = wellKnownSymbol('replace');
            var max = Math.max;
            var min = Math.min;
            var concat = uncurryThis([].concat);
            var push = uncurryThis([].push);
            var stringIndexOf = uncurryThis(''.indexOf);
            var stringSlice = uncurryThis(''.slice);

            var maybeToString = function (it) {
              return it === undefined ? it : String(it);
            };

            // IE <= 11 replaces $0 with the whole match, as if it was $&
            // https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0
            var REPLACE_KEEPS_$0 = (function () {
              // eslint-disable-next-line regexp/prefer-escape-replacement-dollar-char -- required for testing
              return 'a'.replace(/./, '$0') === '$0';
            })();

            // Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string
            var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = (function () {
              if (/./[REPLACE]) {
                return /./[REPLACE]('a', '$0') === '';
              }
              return false;
            })();

            var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
              var re = /./;
              re.exec = function () {
                var result = [];
                result.groups = { a: '7' };
                return result;
              };
              // eslint-disable-next-line regexp/no-useless-dollar-replacements -- false positive
              return ''.replace(re, '$<a>') !== '7';
            });

            // @@replace logic
            fixRegExpWellKnownSymbolLogic(
              'replace',
              function (_, nativeReplace, maybeCallNative) {
                var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';

                return [
                  // `String.prototype.replace` method
                  // https://tc39.es/ecma262/#sec-string.prototype.replace
                  function replace(searchValue, replaceValue) {
                    var O = requireObjectCoercible(this);
                    var replacer = searchValue == undefined ? undefined : getMethod(searchValue, REPLACE);
                    return replacer
                      ? call(replacer, searchValue, O, replaceValue)
                      : call(nativeReplace, toString(O), searchValue, replaceValue);
                  },
                  // `RegExp.prototype[@@replace]` method
                  // https://tc39.es/ecma262/#sec-regexp.prototype-@@replace
                  function (string, replaceValue) {
                    var rx = anObject(this);
                    var S = toString(string);

                    if (
                      typeof replaceValue == 'string' &&
                      stringIndexOf(replaceValue, UNSAFE_SUBSTITUTE) === -1 &&
                      stringIndexOf(replaceValue, '$<') === -1
                    ) {
                      var res = maybeCallNative(nativeReplace, rx, S, replaceValue);
                      if (res.done) return res.value;
                    }

                    var functionalReplace = isCallable(replaceValue);
                    if (!functionalReplace) replaceValue = toString(replaceValue);

                    var global = rx.global;
                    if (global) {
                      var fullUnicode = rx.unicode;
                      rx.lastIndex = 0;
                    }
                    var results = [];
                    while (true) {
                      var result = regExpExec(rx, S);
                      if (result === null) break;

                      push(results, result);
                      if (!global) break;

                      var matchStr = toString(result[0]);
                      if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
                    }

                    var accumulatedResult = '';
                    var nextSourcePosition = 0;
                    for (var i = 0; i < results.length; i++) {
                      result = results[i];

                      var matched = toString(result[0]);
                      var position = max(min(toIntegerOrInfinity(result.index), S.length), 0);
                      var captures = [];
                      // NOTE: This is equivalent to
                      //   captures = result.slice(1).map(maybeToString)
                      // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
                      // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
                      // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
                      for (var j = 1; j < result.length; j++) push(captures, maybeToString(result[j]));
                      var namedCaptures = result.groups;
                      if (functionalReplace) {
                        var replacerArgs = concat([matched], captures, position, S);
                        if (namedCaptures !== undefined) push(replacerArgs, namedCaptures);
                        var replacement = toString(apply(replaceValue, undefined, replacerArgs));
                      } else {
                        replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
                      }
                      if (position >= nextSourcePosition) {
                        accumulatedResult += stringSlice(S, nextSourcePosition, position) + replacement;
                        nextSourcePosition = position + matched.length;
                      }
                    }
                    return accumulatedResult + stringSlice(S, nextSourcePosition);
                  }
                ];
              },
              !REPLACE_SUPPORTS_NAMED_GROUPS || !REPLACE_KEEPS_$0 || REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
            );
          },
          {
            '../internals/advance-string-index': 96,
            '../internals/an-object': 98,
            '../internals/fails': 147,
            '../internals/fix-regexp-well-known-symbol-logic': 148,
            '../internals/function-apply': 149,
            '../internals/function-call': 152,
            '../internals/function-uncurry-this': 154,
            '../internals/get-method': 158,
            '../internals/get-substitution': 159,
            '../internals/is-callable': 173,
            '../internals/regexp-exec-abstract': 220,
            '../internals/require-object-coercible': 227,
            '../internals/to-integer-or-infinity': 245,
            '../internals/to-length': 246,
            '../internals/to-string': 253,
            '../internals/well-known-symbol': 265
          }
        ],
        305: [
          function (require, module, exports) {
            'use strict';
            var call = require('../internals/function-call');
            var fixRegExpWellKnownSymbolLogic = require('../internals/fix-regexp-well-known-symbol-logic');
            var anObject = require('../internals/an-object');
            var requireObjectCoercible = require('../internals/require-object-coercible');
            var sameValue = require('../internals/same-value');
            var toString = require('../internals/to-string');
            var getMethod = require('../internals/get-method');
            var regExpExec = require('../internals/regexp-exec-abstract');

            // @@search logic
            fixRegExpWellKnownSymbolLogic('search', function (SEARCH, nativeSearch, maybeCallNative) {
              return [
                // `String.prototype.search` method
                // https://tc39.es/ecma262/#sec-string.prototype.search
                function search(regexp) {
                  var O = requireObjectCoercible(this);
                  var searcher = regexp == undefined ? undefined : getMethod(regexp, SEARCH);
                  return searcher ? call(searcher, regexp, O) : new RegExp(regexp)[SEARCH](toString(O));
                },
                // `RegExp.prototype[@@search]` method
                // https://tc39.es/ecma262/#sec-regexp.prototype-@@search
                function (string) {
                  var rx = anObject(this);
                  var S = toString(string);
                  var res = maybeCallNative(nativeSearch, rx, S);

                  if (res.done) return res.value;

                  var previousLastIndex = rx.lastIndex;
                  if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
                  var result = regExpExec(rx, S);
                  if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
                  return result === null ? -1 : result.index;
                }
              ];
            });
          },
          {
            '../internals/an-object': 98,
            '../internals/fix-regexp-well-known-symbol-logic': 148,
            '../internals/function-call': 152,
            '../internals/get-method': 158,
            '../internals/regexp-exec-abstract': 220,
            '../internals/require-object-coercible': 227,
            '../internals/same-value': 228,
            '../internals/to-string': 253
          }
        ],
        306: [
          function (require, module, exports) {
            'use strict';
            var apply = require('../internals/function-apply');
            var call = require('../internals/function-call');
            var uncurryThis = require('../internals/function-uncurry-this');
            var fixRegExpWellKnownSymbolLogic = require('../internals/fix-regexp-well-known-symbol-logic');
            var isRegExp = require('../internals/is-regexp');
            var anObject = require('../internals/an-object');
            var requireObjectCoercible = require('../internals/require-object-coercible');
            var speciesConstructor = require('../internals/species-constructor');
            var advanceStringIndex = require('../internals/advance-string-index');
            var toLength = require('../internals/to-length');
            var toString = require('../internals/to-string');
            var getMethod = require('../internals/get-method');
            var arraySlice = require('../internals/array-slice-simple');
            var callRegExpExec = require('../internals/regexp-exec-abstract');
            var regexpExec = require('../internals/regexp-exec');
            var stickyHelpers = require('../internals/regexp-sticky-helpers');
            var fails = require('../internals/fails');

            var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
            var MAX_UINT32 = 0xffffffff;
            var min = Math.min;
            var $push = [].push;
            var exec = uncurryThis(/./.exec);
            var push = uncurryThis($push);
            var stringSlice = uncurryThis(''.slice);

            // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
            // Weex JS has frozen built-in prototypes, so use try / catch wrapper
            var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
              // eslint-disable-next-line regexp/no-empty-group -- required for testing
              var re = /(?:)/;
              var originalExec = re.exec;
              re.exec = function () {
                return originalExec.apply(this, arguments);
              };
              var result = 'ab'.split(re);
              return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
            });

            // @@split logic
            fixRegExpWellKnownSymbolLogic(
              'split',
              function (SPLIT, nativeSplit, maybeCallNative) {
                var internalSplit;
                if (
                  'abbc'.split(/(b)*/)[1] == 'c' ||
                  // eslint-disable-next-line regexp/no-empty-group -- required for testing
                  'test'.split(/(?:)/, -1).length != 4 ||
                  'ab'.split(/(?:ab)*/).length != 2 ||
                  '.'.split(/(.?)(.?)/).length != 4 ||
                  // eslint-disable-next-line regexp/no-empty-capturing-group, regexp/no-empty-group -- required for testing
                  '.'.split(/()()/).length > 1 ||
                  ''.split(/.?/).length
                ) {
                  // based on es5-shim implementation, need to rework it
                  internalSplit = function (separator, limit) {
                    var string = toString(requireObjectCoercible(this));
                    var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
                    if (lim === 0) return [];
                    if (separator === undefined) return [string];
                    // If `separator` is not a regex, use native split
                    if (!isRegExp(separator)) {
                      return call(nativeSplit, string, separator, lim);
                    }
                    var output = [];
                    var flags =
                      (separator.ignoreCase ? 'i' : '') +
                      (separator.multiline ? 'm' : '') +
                      (separator.unicode ? 'u' : '') +
                      (separator.sticky ? 'y' : '');
                    var lastLastIndex = 0;
                    // Make `global` and avoid `lastIndex` issues by working with a copy
                    var separatorCopy = new RegExp(separator.source, flags + 'g');
                    var match, lastIndex, lastLength;
                    while ((match = call(regexpExec, separatorCopy, string))) {
                      lastIndex = separatorCopy.lastIndex;
                      if (lastIndex > lastLastIndex) {
                        push(output, stringSlice(string, lastLastIndex, match.index));
                        if (match.length > 1 && match.index < string.length) apply($push, output, arraySlice(match, 1));
                        lastLength = match[0].length;
                        lastLastIndex = lastIndex;
                        if (output.length >= lim) break;
                      }
                      if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
                    }
                    if (lastLastIndex === string.length) {
                      if (lastLength || !exec(separatorCopy, '')) push(output, '');
                    } else push(output, stringSlice(string, lastLastIndex));
                    return output.length > lim ? arraySlice(output, 0, lim) : output;
                  };
                  // Chakra, V8
                } else if ('0'.split(undefined, 0).length) {
                  internalSplit = function (separator, limit) {
                    return separator === undefined && limit === 0 ? [] : call(nativeSplit, this, separator, limit);
                  };
                } else internalSplit = nativeSplit;

                return [
                  // `String.prototype.split` method
                  // https://tc39.es/ecma262/#sec-string.prototype.split
                  function split(separator, limit) {
                    var O = requireObjectCoercible(this);
                    var splitter = separator == undefined ? undefined : getMethod(separator, SPLIT);
                    return splitter
                      ? call(splitter, separator, O, limit)
                      : call(internalSplit, toString(O), separator, limit);
                  },
                  // `RegExp.prototype[@@split]` method
                  // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
                  //
                  // NOTE: This cannot be properly polyfilled in engines that don't support
                  // the 'y' flag.
                  function (string, limit) {
                    var rx = anObject(this);
                    var S = toString(string);
                    var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);

                    if (res.done) return res.value;

                    var C = speciesConstructor(rx, RegExp);

                    var unicodeMatching = rx.unicode;
                    var flags =
                      (rx.ignoreCase ? 'i' : '') +
                      (rx.multiline ? 'm' : '') +
                      (rx.unicode ? 'u' : '') +
                      (UNSUPPORTED_Y ? 'g' : 'y');

                    // ^(? + rx + ) is needed, in combination with some S slicing, to
                    // simulate the 'y' flag.
                    var splitter = new C(UNSUPPORTED_Y ? '^(?:' + rx.source + ')' : rx, flags);
                    var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
                    if (lim === 0) return [];
                    if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
                    var p = 0;
                    var q = 0;
                    var A = [];
                    while (q < S.length) {
                      splitter.lastIndex = UNSUPPORTED_Y ? 0 : q;
                      var z = callRegExpExec(splitter, UNSUPPORTED_Y ? stringSlice(S, q) : S);
                      var e;
                      if (
                        z === null ||
                        (e = min(toLength(splitter.lastIndex + (UNSUPPORTED_Y ? q : 0)), S.length)) === p
                      ) {
                        q = advanceStringIndex(S, q, unicodeMatching);
                      } else {
                        push(A, stringSlice(S, p, q));
                        if (A.length === lim) return A;
                        for (var i = 1; i <= z.length - 1; i++) {
                          push(A, z[i]);
                          if (A.length === lim) return A;
                        }
                        q = p = e;
                      }
                    }
                    push(A, stringSlice(S, p));
                    return A;
                  }
                ];
              },
              !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC,
              UNSUPPORTED_Y
            );
          },
          {
            '../internals/advance-string-index': 96,
            '../internals/an-object': 98,
            '../internals/array-slice-simple': 113,
            '../internals/fails': 147,
            '../internals/fix-regexp-well-known-symbol-logic': 148,
            '../internals/function-apply': 149,
            '../internals/function-call': 152,
            '../internals/function-uncurry-this': 154,
            '../internals/get-method': 158,
            '../internals/is-regexp': 179,
            '../internals/regexp-exec': 221,
            '../internals/regexp-exec-abstract': 220,
            '../internals/regexp-sticky-helpers': 224,
            '../internals/require-object-coercible': 227,
            '../internals/species-constructor': 235,
            '../internals/to-length': 246,
            '../internals/to-string': 253
          }
        ],
        307: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var $trim = require('../internals/string-trim').trim;
            var forcedStringTrimMethod = require('../internals/string-trim-forced');

            // `String.prototype.trim` method
            // https://tc39.es/ecma262/#sec-string.prototype.trim
            $(
              { target: 'String', proto: true, forced: forcedStringTrimMethod('trim') },
              {
                trim: function trim() {
                  return $trim(this);
                }
              }
            );
          },
          { '../internals/export': 146, '../internals/string-trim': 238, '../internals/string-trim-forced': 237 }
        ],
        308: [
          function (require, module, exports) {
            'use strict';
            var $ = require('../internals/export');
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var uncurryThis = require('../internals/function-uncurry-this');
            var IS_PURE = require('../internals/is-pure');
            var DESCRIPTORS = require('../internals/descriptors');
            var NATIVE_SYMBOL = require('../internals/native-symbol');
            var fails = require('../internals/fails');
            var hasOwn = require('../internals/has-own-property');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var anObject = require('../internals/an-object');
            var toIndexedObject = require('../internals/to-indexed-object');
            var toPropertyKey = require('../internals/to-property-key');
            var $toString = require('../internals/to-string');
            var createPropertyDescriptor = require('../internals/create-property-descriptor');
            var nativeObjectCreate = require('../internals/object-create');
            var objectKeys = require('../internals/object-keys');
            var getOwnPropertyNamesModule = require('../internals/object-get-own-property-names');
            var getOwnPropertyNamesExternal = require('../internals/object-get-own-property-names-external');
            var getOwnPropertySymbolsModule = require('../internals/object-get-own-property-symbols');
            var getOwnPropertyDescriptorModule = require('../internals/object-get-own-property-descriptor');
            var definePropertyModule = require('../internals/object-define-property');
            var definePropertiesModule = require('../internals/object-define-properties');
            var propertyIsEnumerableModule = require('../internals/object-property-is-enumerable');
            var redefine = require('../internals/redefine');
            var shared = require('../internals/shared');
            var sharedKey = require('../internals/shared-key');
            var hiddenKeys = require('../internals/hidden-keys');
            var uid = require('../internals/uid');
            var wellKnownSymbol = require('../internals/well-known-symbol');
            var wrappedWellKnownSymbolModule = require('../internals/well-known-symbol-wrapped');
            var defineWellKnownSymbol = require('../internals/define-well-known-symbol');
            var defineSymbolToPrimitive = require('../internals/symbol-define-to-primitive');
            var setToStringTag = require('../internals/set-to-string-tag');
            var InternalStateModule = require('../internals/internal-state');
            var $forEach = require('../internals/array-iteration').forEach;

            var HIDDEN = sharedKey('hidden');
            var SYMBOL = 'Symbol';
            var PROTOTYPE = 'prototype';

            var setInternalState = InternalStateModule.set;
            var getInternalState = InternalStateModule.getterFor(SYMBOL);

            var ObjectPrototype = Object[PROTOTYPE];
            var $Symbol = global.Symbol;
            var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
            var TypeError = global.TypeError;
            var QObject = global.QObject;
            var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
            var nativeDefineProperty = definePropertyModule.f;
            var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
            var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
            var push = uncurryThis([].push);

            var AllSymbols = shared('symbols');
            var ObjectPrototypeSymbols = shared('op-symbols');
            var WellKnownSymbolsStore = shared('wks');

            // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
            var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

            // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
            var setSymbolDescriptor =
              DESCRIPTORS &&
              fails(function () {
                return (
                  nativeObjectCreate(
                    nativeDefineProperty({}, 'a', {
                      get: function () {
                        return nativeDefineProperty(this, 'a', { value: 7 }).a;
                      }
                    })
                  ).a != 7
                );
              })
                ? function (O, P, Attributes) {
                    var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor(ObjectPrototype, P);
                    if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
                    nativeDefineProperty(O, P, Attributes);
                    if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
                      nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
                    }
                  }
                : nativeDefineProperty;

            var wrap = function (tag, description) {
              var symbol = (AllSymbols[tag] = nativeObjectCreate(SymbolPrototype));
              setInternalState(symbol, {
                type: SYMBOL,
                tag: tag,
                description: description
              });
              if (!DESCRIPTORS) symbol.description = description;
              return symbol;
            };

            var $defineProperty = function defineProperty(O, P, Attributes) {
              if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
              anObject(O);
              var key = toPropertyKey(P);
              anObject(Attributes);
              if (hasOwn(AllSymbols, key)) {
                if (!Attributes.enumerable) {
                  if (!hasOwn(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, {}));
                  O[HIDDEN][key] = true;
                } else {
                  if (hasOwn(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
                  Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor(0, false) });
                }
                return setSymbolDescriptor(O, key, Attributes);
              }
              return nativeDefineProperty(O, key, Attributes);
            };

            var $defineProperties = function defineProperties(O, Properties) {
              anObject(O);
              var properties = toIndexedObject(Properties);
              var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
              $forEach(keys, function (key) {
                if (!DESCRIPTORS || call($propertyIsEnumerable, properties, key))
                  $defineProperty(O, key, properties[key]);
              });
              return O;
            };

            var $create = function create(O, Properties) {
              return Properties === undefined
                ? nativeObjectCreate(O)
                : $defineProperties(nativeObjectCreate(O), Properties);
            };

            var $propertyIsEnumerable = function propertyIsEnumerable(V) {
              var P = toPropertyKey(V);
              var enumerable = call(nativePropertyIsEnumerable, this, P);
              if (this === ObjectPrototype && hasOwn(AllSymbols, P) && !hasOwn(ObjectPrototypeSymbols, P)) return false;
              return enumerable ||
                !hasOwn(this, P) ||
                !hasOwn(AllSymbols, P) ||
                (hasOwn(this, HIDDEN) && this[HIDDEN][P])
                ? enumerable
                : true;
            };

            var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
              var it = toIndexedObject(O);
              var key = toPropertyKey(P);
              if (it === ObjectPrototype && hasOwn(AllSymbols, key) && !hasOwn(ObjectPrototypeSymbols, key)) return;
              var descriptor = nativeGetOwnPropertyDescriptor(it, key);
              if (descriptor && hasOwn(AllSymbols, key) && !(hasOwn(it, HIDDEN) && it[HIDDEN][key])) {
                descriptor.enumerable = true;
              }
              return descriptor;
            };

            var $getOwnPropertyNames = function getOwnPropertyNames(O) {
              var names = nativeGetOwnPropertyNames(toIndexedObject(O));
              var result = [];
              $forEach(names, function (key) {
                if (!hasOwn(AllSymbols, key) && !hasOwn(hiddenKeys, key)) push(result, key);
              });
              return result;
            };

            var $getOwnPropertySymbols = function (O) {
              var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
              var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
              var result = [];
              $forEach(names, function (key) {
                if (hasOwn(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn(ObjectPrototype, key))) {
                  push(result, AllSymbols[key]);
                }
              });
              return result;
            };

            // `Symbol` constructor
            // https://tc39.es/ecma262/#sec-symbol-constructor
            if (!NATIVE_SYMBOL) {
              $Symbol = function Symbol() {
                if (isPrototypeOf(SymbolPrototype, this)) throw TypeError('Symbol is not a constructor');
                var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
                var tag = uid(description);
                var setter = function (value) {
                  if (this === ObjectPrototype) call(setter, ObjectPrototypeSymbols, value);
                  if (hasOwn(this, HIDDEN) && hasOwn(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
                  setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
                };
                if (DESCRIPTORS && USE_SETTER)
                  setSymbolDescriptor(ObjectPrototype, tag, { configurable: true, set: setter });
                return wrap(tag, description);
              };

              SymbolPrototype = $Symbol[PROTOTYPE];

              redefine(SymbolPrototype, 'toString', function toString() {
                return getInternalState(this).tag;
              });

              redefine($Symbol, 'withoutSetter', function (description) {
                return wrap(uid(description), description);
              });

              propertyIsEnumerableModule.f = $propertyIsEnumerable;
              definePropertyModule.f = $defineProperty;
              definePropertiesModule.f = $defineProperties;
              getOwnPropertyDescriptorModule.f = $getOwnPropertyDescriptor;
              getOwnPropertyNamesModule.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
              getOwnPropertySymbolsModule.f = $getOwnPropertySymbols;

              wrappedWellKnownSymbolModule.f = function (name) {
                return wrap(wellKnownSymbol(name), name);
              };

              if (DESCRIPTORS) {
                // https://github.com/tc39/proposal-Symbol-description
                nativeDefineProperty(SymbolPrototype, 'description', {
                  configurable: true,
                  get: function description() {
                    return getInternalState(this).description;
                  }
                });
                if (!IS_PURE) {
                  redefine(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, { unsafe: true });
                }
              }
            }

            $(
              { global: true, wrap: true, forced: !NATIVE_SYMBOL, sham: !NATIVE_SYMBOL },
              {
                Symbol: $Symbol
              }
            );

            $forEach(objectKeys(WellKnownSymbolsStore), function (name) {
              defineWellKnownSymbol(name);
            });

            $(
              { target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL },
              {
                useSetter: function () {
                  USE_SETTER = true;
                },
                useSimple: function () {
                  USE_SETTER = false;
                }
              }
            );

            $(
              { target: 'Object', stat: true, forced: !NATIVE_SYMBOL, sham: !DESCRIPTORS },
              {
                // `Object.create` method
                // https://tc39.es/ecma262/#sec-object.create
                create: $create,
                // `Object.defineProperty` method
                // https://tc39.es/ecma262/#sec-object.defineproperty
                defineProperty: $defineProperty,
                // `Object.defineProperties` method
                // https://tc39.es/ecma262/#sec-object.defineproperties
                defineProperties: $defineProperties,
                // `Object.getOwnPropertyDescriptor` method
                // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
                getOwnPropertyDescriptor: $getOwnPropertyDescriptor
              }
            );

            $(
              { target: 'Object', stat: true, forced: !NATIVE_SYMBOL },
              {
                // `Object.getOwnPropertyNames` method
                // https://tc39.es/ecma262/#sec-object.getownpropertynames
                getOwnPropertyNames: $getOwnPropertyNames
              }
            );

            // `Symbol.prototype[@@toPrimitive]` method
            // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
            defineSymbolToPrimitive();

            // `Symbol.prototype[@@toStringTag]` property
            // https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
            setToStringTag($Symbol, SYMBOL);

            hiddenKeys[HIDDEN] = true;
          },
          {
            '../internals/an-object': 98,
            '../internals/array-iteration': 108,
            '../internals/create-property-descriptor': 127,
            '../internals/define-well-known-symbol': 130,
            '../internals/descriptors': 131,
            '../internals/export': 146,
            '../internals/fails': 147,
            '../internals/function-call': 152,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/hidden-keys': 162,
            '../internals/internal-state': 170,
            '../internals/is-pure': 178,
            '../internals/native-symbol': 188,
            '../internals/object-create': 193,
            '../internals/object-define-properties': 194,
            '../internals/object-define-property': 195,
            '../internals/object-get-own-property-descriptor': 196,
            '../internals/object-get-own-property-names': 198,
            '../internals/object-get-own-property-names-external': 197,
            '../internals/object-get-own-property-symbols': 199,
            '../internals/object-is-prototype-of': 201,
            '../internals/object-keys': 203,
            '../internals/object-property-is-enumerable': 204,
            '../internals/redefine': 219,
            '../internals/set-to-string-tag': 231,
            '../internals/shared': 234,
            '../internals/shared-key': 232,
            '../internals/symbol-define-to-primitive': 239,
            '../internals/to-indexed-object': 244,
            '../internals/to-property-key': 251,
            '../internals/to-string': 253,
            '../internals/uid': 260,
            '../internals/well-known-symbol': 265,
            '../internals/well-known-symbol-wrapped': 264
          }
        ],
        309: [
          function (require, module, exports) {
            // `Symbol.prototype.description` getter
            // https://tc39.es/ecma262/#sec-symbol.prototype.description
            'use strict';
            var $ = require('../internals/export');
            var DESCRIPTORS = require('../internals/descriptors');
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var hasOwn = require('../internals/has-own-property');
            var isCallable = require('../internals/is-callable');
            var isPrototypeOf = require('../internals/object-is-prototype-of');
            var toString = require('../internals/to-string');
            var defineProperty = require('../internals/object-define-property').f;
            var copyConstructorProperties = require('../internals/copy-constructor-properties');

            var NativeSymbol = global.Symbol;
            var SymbolPrototype = NativeSymbol && NativeSymbol.prototype;

            if (
              DESCRIPTORS &&
              isCallable(NativeSymbol) &&
              (!('description' in SymbolPrototype) ||
                // Safari 12 bug
                NativeSymbol().description !== undefined)
            ) {
              var EmptyStringDescriptionStore = {};
              // wrap Symbol constructor for correct work with undefined description
              var SymbolWrapper = function Symbol() {
                var description =
                  arguments.length < 1 || arguments[0] === undefined ? undefined : toString(arguments[0]);
                var result = isPrototypeOf(SymbolPrototype, this)
                  ? new NativeSymbol(description)
                  : // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
                  description === undefined
                  ? NativeSymbol()
                  : NativeSymbol(description);
                if (description === '') EmptyStringDescriptionStore[result] = true;
                return result;
              };

              copyConstructorProperties(SymbolWrapper, NativeSymbol);
              SymbolWrapper.prototype = SymbolPrototype;
              SymbolPrototype.constructor = SymbolWrapper;

              var NATIVE_SYMBOL = String(NativeSymbol('test')) == 'Symbol(test)';
              var symbolToString = uncurryThis(SymbolPrototype.toString);
              var symbolValueOf = uncurryThis(SymbolPrototype.valueOf);
              var regexp = /^Symbol\((.*)\)[^)]+$/;
              var replace = uncurryThis(''.replace);
              var stringSlice = uncurryThis(''.slice);

              defineProperty(SymbolPrototype, 'description', {
                configurable: true,
                get: function description() {
                  var symbol = symbolValueOf(this);
                  var string = symbolToString(symbol);
                  if (hasOwn(EmptyStringDescriptionStore, symbol)) return '';
                  var desc = NATIVE_SYMBOL ? stringSlice(string, 7, -1) : replace(string, regexp, '$1');
                  return desc === '' ? undefined : desc;
                }
              });

              $(
                { global: true, forced: true },
                {
                  Symbol: SymbolWrapper
                }
              );
            }
          },
          {
            '../internals/copy-constructor-properties': 122,
            '../internals/descriptors': 131,
            '../internals/export': 146,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/has-own-property': 161,
            '../internals/is-callable': 173,
            '../internals/object-define-property': 195,
            '../internals/object-is-prototype-of': 201,
            '../internals/to-string': 253
          }
        ],
        310: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var getBuiltIn = require('../internals/get-built-in');
            var hasOwn = require('../internals/has-own-property');
            var toString = require('../internals/to-string');
            var shared = require('../internals/shared');
            var NATIVE_SYMBOL_REGISTRY = require('../internals/native-symbol-registry');

            var StringToSymbolRegistry = shared('string-to-symbol-registry');
            var SymbolToStringRegistry = shared('symbol-to-string-registry');

            // `Symbol.for` method
            // https://tc39.es/ecma262/#sec-symbol.for
            $(
              { target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY },
              {
                for: function (key) {
                  var string = toString(key);
                  if (hasOwn(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
                  var symbol = getBuiltIn('Symbol')(string);
                  StringToSymbolRegistry[string] = symbol;
                  SymbolToStringRegistry[symbol] = string;
                  return symbol;
                }
              }
            );
          },
          {
            '../internals/export': 146,
            '../internals/get-built-in': 155,
            '../internals/has-own-property': 161,
            '../internals/native-symbol-registry': 187,
            '../internals/shared': 234,
            '../internals/to-string': 253
          }
        ],
        311: [
          function (require, module, exports) {
            var defineWellKnownSymbol = require('../internals/define-well-known-symbol');

            // `Symbol.iterator` well-known symbol
            // https://tc39.es/ecma262/#sec-symbol.iterator
            defineWellKnownSymbol('iterator');
          },
          { '../internals/define-well-known-symbol': 130 }
        ],
        312: [
          function (require, module, exports) {
            // TODO: Remove this module from `core-js@4` since it's split to modules listed below
            require('../modules/es.symbol.constructor');
            require('../modules/es.symbol.for');
            require('../modules/es.symbol.key-for');
            require('../modules/es.json.stringify');
            require('../modules/es.object.get-own-property-symbols');
          },
          {
            '../modules/es.json.stringify': 282,
            '../modules/es.object.get-own-property-symbols': 288,
            '../modules/es.symbol.constructor': 308,
            '../modules/es.symbol.for': 310,
            '../modules/es.symbol.key-for': 313
          }
        ],
        313: [
          function (require, module, exports) {
            var $ = require('../internals/export');
            var hasOwn = require('../internals/has-own-property');
            var isSymbol = require('../internals/is-symbol');
            var tryToString = require('../internals/try-to-string');
            var shared = require('../internals/shared');
            var NATIVE_SYMBOL_REGISTRY = require('../internals/native-symbol-registry');

            var SymbolToStringRegistry = shared('symbol-to-string-registry');

            // `Symbol.keyFor` method
            // https://tc39.es/ecma262/#sec-symbol.keyfor
            $(
              { target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY },
              {
                keyFor: function keyFor(sym) {
                  if (!isSymbol(sym)) throw TypeError(tryToString(sym) + ' is not a symbol');
                  if (hasOwn(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
                }
              }
            );
          },
          {
            '../internals/export': 146,
            '../internals/has-own-property': 161,
            '../internals/is-symbol': 180,
            '../internals/native-symbol-registry': 187,
            '../internals/shared': 234,
            '../internals/try-to-string': 254
          }
        ],
        314: [
          function (require, module, exports) {
            'use strict';
            var uncurryThis = require('../internals/function-uncurry-this');
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $ArrayCopyWithin = require('../internals/array-copy-within');

            var u$ArrayCopyWithin = uncurryThis($ArrayCopyWithin);
            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.copyWithin` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.copywithin
            exportTypedArrayMethod('copyWithin', function copyWithin(target, start /* , end */) {
              return u$ArrayCopyWithin(
                aTypedArray(this),
                target,
                start,
                arguments.length > 2 ? arguments[2] : undefined
              );
            });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-copy-within': 102,
            '../internals/function-uncurry-this': 154
          }
        ],
        315: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $every = require('../internals/array-iteration').every;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.every` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.every
            exportTypedArrayMethod('every', function every(callbackfn /* , thisArg */) {
              return $every(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-iteration': 108 }
        ],
        316: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var call = require('../internals/function-call');
            var $fill = require('../internals/array-fill');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.fill` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.fill
            exportTypedArrayMethod('fill', function fill(value /* , start, end */) {
              var length = arguments.length;
              return call(
                $fill,
                aTypedArray(this),
                value,
                length > 1 ? arguments[1] : undefined,
                length > 2 ? arguments[2] : undefined
              );
            });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-fill': 103,
            '../internals/function-call': 152
          }
        ],
        317: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $filter = require('../internals/array-iteration').filter;
            var fromSpeciesAndList = require('../internals/typed-array-from-species-and-list');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.filter` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.filter
            exportTypedArrayMethod('filter', function filter(callbackfn /* , thisArg */) {
              var list = $filter(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
              return fromSpeciesAndList(this, list);
            });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-iteration': 108,
            '../internals/typed-array-from-species-and-list': 257
          }
        ],
        318: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $findIndex = require('../internals/array-iteration').findIndex;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.findIndex` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.findindex
            exportTypedArrayMethod('findIndex', function findIndex(predicate /* , thisArg */) {
              return $findIndex(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-iteration': 108 }
        ],
        319: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $find = require('../internals/array-iteration').find;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.find` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.find
            exportTypedArrayMethod('find', function find(predicate /* , thisArg */) {
              return $find(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-iteration': 108 }
        ],
        320: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $forEach = require('../internals/array-iteration').forEach;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.forEach` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.foreach
            exportTypedArrayMethod('forEach', function forEach(callbackfn /* , thisArg */) {
              $forEach(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-iteration': 108 }
        ],
        321: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $includes = require('../internals/array-includes').includes;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.includes` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.includes
            exportTypedArrayMethod('includes', function includes(searchElement /* , fromIndex */) {
              return $includes(aTypedArray(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-includes': 107 }
        ],
        322: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $indexOf = require('../internals/array-includes').indexOf;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.indexOf` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.indexof
            exportTypedArrayMethod('indexOf', function indexOf(searchElement /* , fromIndex */) {
              return $indexOf(aTypedArray(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-includes': 107 }
        ],
        323: [
          function (require, module, exports) {
            'use strict';
            var global = require('../internals/global');
            var fails = require('../internals/fails');
            var uncurryThis = require('../internals/function-uncurry-this');
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var ArrayIterators = require('../modules/es.array.iterator');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var ITERATOR = wellKnownSymbol('iterator');
            var Uint8Array = global.Uint8Array;
            var arrayValues = uncurryThis(ArrayIterators.values);
            var arrayKeys = uncurryThis(ArrayIterators.keys);
            var arrayEntries = uncurryThis(ArrayIterators.entries);
            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
            var TypedArrayPrototype = Uint8Array && Uint8Array.prototype;

            var GENERIC = !fails(function () {
              TypedArrayPrototype[ITERATOR].call([1]);
            });

            var ITERATOR_IS_VALUES =
              !!TypedArrayPrototype &&
              TypedArrayPrototype.values &&
              TypedArrayPrototype[ITERATOR] === TypedArrayPrototype.values &&
              TypedArrayPrototype.values.name === 'values';

            var typedArrayValues = function values() {
              return arrayValues(aTypedArray(this));
            };

            // `%TypedArray%.prototype.entries` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.entries
            exportTypedArrayMethod(
              'entries',
              function entries() {
                return arrayEntries(aTypedArray(this));
              },
              GENERIC
            );
            // `%TypedArray%.prototype.keys` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.keys
            exportTypedArrayMethod(
              'keys',
              function keys() {
                return arrayKeys(aTypedArray(this));
              },
              GENERIC
            );
            // `%TypedArray%.prototype.values` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.values
            exportTypedArrayMethod('values', typedArrayValues, GENERIC || !ITERATOR_IS_VALUES, { name: 'values' });
            // `%TypedArray%.prototype[@@iterator]` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype-@@iterator
            exportTypedArrayMethod(ITERATOR, typedArrayValues, GENERIC || !ITERATOR_IS_VALUES, { name: 'values' });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160,
            '../internals/well-known-symbol': 265,
            '../modules/es.array.iterator': 275
          }
        ],
        324: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var uncurryThis = require('../internals/function-uncurry-this');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
            var $join = uncurryThis([].join);

            // `%TypedArray%.prototype.join` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.join
            exportTypedArrayMethod('join', function join(separator) {
              return $join(aTypedArray(this), separator);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/function-uncurry-this': 154 }
        ],
        325: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var apply = require('../internals/function-apply');
            var $lastIndexOf = require('../internals/array-last-index-of');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.lastIndexOf` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.lastindexof
            exportTypedArrayMethod('lastIndexOf', function lastIndexOf(searchElement /* , fromIndex */) {
              var length = arguments.length;
              return apply(
                $lastIndexOf,
                aTypedArray(this),
                length > 1 ? [searchElement, arguments[1]] : [searchElement]
              );
            });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-last-index-of': 109,
            '../internals/function-apply': 149
          }
        ],
        326: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $map = require('../internals/array-iteration').map;
            var typedArraySpeciesConstructor = require('../internals/typed-array-species-constructor');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.map` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.map
            exportTypedArrayMethod('map', function map(mapfn /* , thisArg */) {
              return $map(
                aTypedArray(this),
                mapfn,
                arguments.length > 1 ? arguments[1] : undefined,
                function (O, length) {
                  return new (typedArraySpeciesConstructor(O))(length);
                }
              );
            });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-iteration': 108,
            '../internals/typed-array-species-constructor': 259
          }
        ],
        327: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $reduceRight = require('../internals/array-reduce').right;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.reduceRicht` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.reduceright
            exportTypedArrayMethod('reduceRight', function reduceRight(callbackfn /* , initialValue */) {
              var length = arguments.length;
              return $reduceRight(aTypedArray(this), callbackfn, length, length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-reduce': 112 }
        ],
        328: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $reduce = require('../internals/array-reduce').left;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.reduce` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.reduce
            exportTypedArrayMethod('reduce', function reduce(callbackfn /* , initialValue */) {
              var length = arguments.length;
              return $reduce(aTypedArray(this), callbackfn, length, length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-reduce': 112 }
        ],
        329: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
            var floor = Math.floor;

            // `%TypedArray%.prototype.reverse` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.reverse
            exportTypedArrayMethod('reverse', function reverse() {
              var that = this;
              var length = aTypedArray(that).length;
              var middle = floor(length / 2);
              var index = 0;
              var value;
              while (index < middle) {
                value = that[index];
                that[index++] = that[--length];
                that[length] = value;
              }
              return that;
            });
          },
          { '../internals/array-buffer-view-core': 100 }
        ],
        330: [
          function (require, module, exports) {
            'use strict';
            var global = require('../internals/global');
            var call = require('../internals/function-call');
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var lengthOfArrayLike = require('../internals/length-of-array-like');
            var toOffset = require('../internals/to-offset');
            var toIndexedObject = require('../internals/to-object');
            var fails = require('../internals/fails');

            var RangeError = global.RangeError;
            var Int8Array = global.Int8Array;
            var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
            var $set = Int8ArrayPrototype && Int8ArrayPrototype.set;
            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            var WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS = !fails(function () {
              // eslint-disable-next-line es-x/no-typed-arrays -- required for testing
              var array = new Uint8ClampedArray(2);
              call($set, array, { length: 1, 0: 3 }, 1);
              return array[1] !== 3;
            });

            // https://bugs.chromium.org/p/v8/issues/detail?id=11294 and other
            var TO_OBJECT_BUG =
              WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS &&
              ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS &&
              fails(function () {
                var array = new Int8Array(2);
                array.set(1);
                array.set('2', 1);
                return array[0] !== 0 || array[1] !== 2;
              });

            // `%TypedArray%.prototype.set` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.set
            exportTypedArrayMethod(
              'set',
              function set(arrayLike /* , offset */) {
                aTypedArray(this);
                var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
                var src = toIndexedObject(arrayLike);
                if (WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS) return call($set, this, src, offset);
                var length = this.length;
                var len = lengthOfArrayLike(src);
                var index = 0;
                if (len + offset > length) throw RangeError('Wrong length');
                while (index < len) this[offset + index] = src[index++];
              },
              !WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS || TO_OBJECT_BUG
            );
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/fails': 147,
            '../internals/function-call': 152,
            '../internals/global': 160,
            '../internals/length-of-array-like': 185,
            '../internals/to-object': 247,
            '../internals/to-offset': 248
          }
        ],
        331: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var typedArraySpeciesConstructor = require('../internals/typed-array-species-constructor');
            var fails = require('../internals/fails');
            var arraySlice = require('../internals/array-slice');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            var FORCED = fails(function () {
              // eslint-disable-next-line es-x/no-typed-arrays -- required for testing
              new Int8Array(1).slice();
            });

            // `%TypedArray%.prototype.slice` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.slice
            exportTypedArrayMethod(
              'slice',
              function slice(start, end) {
                var list = arraySlice(aTypedArray(this), start, end);
                var C = typedArraySpeciesConstructor(this);
                var index = 0;
                var length = list.length;
                var result = new C(length);
                while (length > index) result[index] = list[index++];
                return result;
              },
              FORCED
            );
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-slice': 114,
            '../internals/fails': 147,
            '../internals/typed-array-species-constructor': 259
          }
        ],
        332: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var $some = require('../internals/array-iteration').some;

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.some` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.some
            exportTypedArrayMethod('some', function some(callbackfn /* , thisArg */) {
              return $some(aTypedArray(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
            });
          },
          { '../internals/array-buffer-view-core': 100, '../internals/array-iteration': 108 }
        ],
        333: [
          function (require, module, exports) {
            'use strict';
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');
            var fails = require('../internals/fails');
            var aCallable = require('../internals/a-callable');
            var internalSort = require('../internals/array-sort');
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var FF = require('../internals/engine-ff-version');
            var IE_OR_EDGE = require('../internals/engine-is-ie-or-edge');
            var V8 = require('../internals/engine-v8-version');
            var WEBKIT = require('../internals/engine-webkit-version');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
            var Uint16Array = global.Uint16Array;
            var un$Sort = Uint16Array && uncurryThis(Uint16Array.prototype.sort);

            // WebKit
            var ACCEPT_INCORRECT_ARGUMENTS =
              !!un$Sort &&
              !(
                fails(function () {
                  un$Sort(new Uint16Array(2), null);
                }) &&
                fails(function () {
                  un$Sort(new Uint16Array(2), {});
                })
              );

            var STABLE_SORT =
              !!un$Sort &&
              !fails(function () {
                // feature detection can be too slow, so check engines versions
                if (V8) return V8 < 74;
                if (FF) return FF < 67;
                if (IE_OR_EDGE) return true;
                if (WEBKIT) return WEBKIT < 602;

                var array = new Uint16Array(516);
                var expected = Array(516);
                var index, mod;

                for (index = 0; index < 516; index++) {
                  mod = index % 4;
                  array[index] = 515 - index;
                  expected[index] = index - 2 * mod + 3;
                }

                un$Sort(array, function (a, b) {
                  return ((a / 4) | 0) - ((b / 4) | 0);
                });

                for (index = 0; index < 516; index++) {
                  if (array[index] !== expected[index]) return true;
                }
              });

            var getSortCompare = function (comparefn) {
              return function (x, y) {
                if (comparefn !== undefined) return +comparefn(x, y) || 0;
                // eslint-disable-next-line no-self-compare -- NaN check
                if (y !== y) return -1;
                // eslint-disable-next-line no-self-compare -- NaN check
                if (x !== x) return 1;
                if (x === 0 && y === 0) return 1 / x > 0 && 1 / y < 0 ? 1 : -1;
                return x > y;
              };
            };

            // `%TypedArray%.prototype.sort` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.sort
            exportTypedArrayMethod(
              'sort',
              function sort(comparefn) {
                if (comparefn !== undefined) aCallable(comparefn);
                if (STABLE_SORT) return un$Sort(this, comparefn);

                return internalSort(aTypedArray(this), getSortCompare(comparefn));
              },
              !STABLE_SORT || ACCEPT_INCORRECT_ARGUMENTS
            );
          },
          {
            '../internals/a-callable': 92,
            '../internals/array-buffer-view-core': 100,
            '../internals/array-sort': 115,
            '../internals/engine-ff-version': 135,
            '../internals/engine-is-ie-or-edge': 137,
            '../internals/engine-v8-version': 143,
            '../internals/engine-webkit-version': 144,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160
          }
        ],
        334: [
          function (require, module, exports) {
            'use strict';
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var toLength = require('../internals/to-length');
            var toAbsoluteIndex = require('../internals/to-absolute-index');
            var typedArraySpeciesConstructor = require('../internals/typed-array-species-constructor');

            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

            // `%TypedArray%.prototype.subarray` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.subarray
            exportTypedArrayMethod('subarray', function subarray(begin, end) {
              var O = aTypedArray(this);
              var length = O.length;
              var beginIndex = toAbsoluteIndex(begin, length);
              var C = typedArraySpeciesConstructor(O);
              return new C(
                O.buffer,
                O.byteOffset + beginIndex * O.BYTES_PER_ELEMENT,
                toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - beginIndex)
              );
            });
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/to-absolute-index': 242,
            '../internals/to-length': 246,
            '../internals/typed-array-species-constructor': 259
          }
        ],
        335: [
          function (require, module, exports) {
            'use strict';
            var global = require('../internals/global');
            var apply = require('../internals/function-apply');
            var ArrayBufferViewCore = require('../internals/array-buffer-view-core');
            var fails = require('../internals/fails');
            var arraySlice = require('../internals/array-slice');

            var Int8Array = global.Int8Array;
            var aTypedArray = ArrayBufferViewCore.aTypedArray;
            var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
            var $toLocaleString = [].toLocaleString;

            // iOS Safari 6.x fails here
            var TO_LOCALE_STRING_BUG =
              !!Int8Array &&
              fails(function () {
                $toLocaleString.call(new Int8Array(1));
              });

            var FORCED =
              fails(function () {
                return [1, 2].toLocaleString() != new Int8Array([1, 2]).toLocaleString();
              }) ||
              !fails(function () {
                Int8Array.prototype.toLocaleString.call([1, 2]);
              });

            // `%TypedArray%.prototype.toLocaleString` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.tolocalestring
            exportTypedArrayMethod(
              'toLocaleString',
              function toLocaleString() {
                return apply(
                  $toLocaleString,
                  TO_LOCALE_STRING_BUG ? arraySlice(aTypedArray(this)) : aTypedArray(this),
                  arraySlice(arguments)
                );
              },
              FORCED
            );
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/array-slice': 114,
            '../internals/fails': 147,
            '../internals/function-apply': 149,
            '../internals/global': 160
          }
        ],
        336: [
          function (require, module, exports) {
            'use strict';
            var exportTypedArrayMethod = require('../internals/array-buffer-view-core').exportTypedArrayMethod;
            var fails = require('../internals/fails');
            var global = require('../internals/global');
            var uncurryThis = require('../internals/function-uncurry-this');

            var Uint8Array = global.Uint8Array;
            var Uint8ArrayPrototype = (Uint8Array && Uint8Array.prototype) || {};
            var arrayToString = [].toString;
            var join = uncurryThis([].join);

            if (
              fails(function () {
                arrayToString.call({});
              })
            ) {
              arrayToString = function toString() {
                return join(this);
              };
            }

            var IS_NOT_ARRAY_METHOD = Uint8ArrayPrototype.toString != arrayToString;

            // `%TypedArray%.prototype.toString` method
            // https://tc39.es/ecma262/#sec-%typedarray%.prototype.tostring
            exportTypedArrayMethod('toString', arrayToString, IS_NOT_ARRAY_METHOD);
          },
          {
            '../internals/array-buffer-view-core': 100,
            '../internals/fails': 147,
            '../internals/function-uncurry-this': 154,
            '../internals/global': 160
          }
        ],
        337: [
          function (require, module, exports) {
            var createTypedArrayConstructor = require('../internals/typed-array-constructor');

            // `Uint8Array` constructor
            // https://tc39.es/ecma262/#sec-typedarray-objects
            createTypedArrayConstructor('Uint8', function (init) {
              return function Uint8Array(data, byteOffset, length) {
                return init(this, data, byteOffset, length);
              };
            });
          },
          { '../internals/typed-array-constructor': 255 }
        ],
        338: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var DOMIterables = require('../internals/dom-iterables');
            var DOMTokenListPrototype = require('../internals/dom-token-list-prototype');
            var forEach = require('../internals/array-for-each');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');

            var handlePrototype = function (CollectionPrototype) {
              // some Chrome versions have non-configurable methods on DOMTokenList
              if (CollectionPrototype && CollectionPrototype.forEach !== forEach)
                try {
                  createNonEnumerableProperty(CollectionPrototype, 'forEach', forEach);
                } catch (error) {
                  CollectionPrototype.forEach = forEach;
                }
            };

            for (var COLLECTION_NAME in DOMIterables) {
              if (DOMIterables[COLLECTION_NAME]) {
                handlePrototype(global[COLLECTION_NAME] && global[COLLECTION_NAME].prototype);
              }
            }

            handlePrototype(DOMTokenListPrototype);
          },
          {
            '../internals/array-for-each': 104,
            '../internals/create-non-enumerable-property': 126,
            '../internals/dom-iterables': 133,
            '../internals/dom-token-list-prototype': 134,
            '../internals/global': 160
          }
        ],
        339: [
          function (require, module, exports) {
            var global = require('../internals/global');
            var DOMIterables = require('../internals/dom-iterables');
            var DOMTokenListPrototype = require('../internals/dom-token-list-prototype');
            var ArrayIteratorMethods = require('../modules/es.array.iterator');
            var createNonEnumerableProperty = require('../internals/create-non-enumerable-property');
            var wellKnownSymbol = require('../internals/well-known-symbol');

            var ITERATOR = wellKnownSymbol('iterator');
            var TO_STRING_TAG = wellKnownSymbol('toStringTag');
            var ArrayValues = ArrayIteratorMethods.values;

            var handlePrototype = function (CollectionPrototype, COLLECTION_NAME) {
              if (CollectionPrototype) {
                // some Chrome versions have non-configurable methods on DOMTokenList
                if (CollectionPrototype[ITERATOR] !== ArrayValues)
                  try {
                    createNonEnumerableProperty(CollectionPrototype, ITERATOR, ArrayValues);
                  } catch (error) {
                    CollectionPrototype[ITERATOR] = ArrayValues;
                  }
                if (!CollectionPrototype[TO_STRING_TAG]) {
                  createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
                }
                if (DOMIterables[COLLECTION_NAME])
                  for (var METHOD_NAME in ArrayIteratorMethods) {
                    // some Chrome versions have non-configurable methods on DOMTokenList
                    if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME])
                      try {
                        createNonEnumerableProperty(
                          CollectionPrototype,
                          METHOD_NAME,
                          ArrayIteratorMethods[METHOD_NAME]
                        );
                      } catch (error) {
                        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
                      }
                  }
              }
            };

            for (var COLLECTION_NAME in DOMIterables) {
              handlePrototype(global[COLLECTION_NAME] && global[COLLECTION_NAME].prototype, COLLECTION_NAME);
            }

            handlePrototype(DOMTokenListPrototype, 'DOMTokenList');
          },
          {
            '../internals/create-non-enumerable-property': 126,
            '../internals/dom-iterables': 133,
            '../internals/dom-token-list-prototype': 134,
            '../internals/global': 160,
            '../internals/well-known-symbol': 265,
            '../modules/es.array.iterator': 275
          }
        ],
        340: [
          function (require, module, exports) {
            // Copyright Joyent, Inc. and other Node contributors.
            //
            // Permission is hereby granted, free of charge, to any person obtaining a
            // copy of this software and associated documentation files (the
            // "Software"), to deal in the Software without restriction, including
            // without limitation the rights to use, copy, modify, merge, publish,
            // distribute, sublicense, and/or sell copies of the Software, and to permit
            // persons to whom the Software is furnished to do so, subject to the
            // following conditions:
            //
            // The above copyright notice and this permission notice shall be included
            // in all copies or substantial portions of the Software.
            //
            // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
            // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
            // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
            // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
            // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
            // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
            // USE OR OTHER DEALINGS IN THE SOFTWARE.

            // NOTE: These type checking functions intentionally don't use `instanceof`
            // because it is fragile and can be easily faked with `Object.create()`.

            function isArray(arg) {
              if (Array.isArray) {
                return Array.isArray(arg);
              }
              return objectToString(arg) === '[object Array]';
            }
            exports.isArray = isArray;

            function isBoolean(arg) {
              return typeof arg === 'boolean';
            }
          