const config = require('../config');

module.exports = {
  registerRoute: function() {
    this.options.app.use(async(ctx, next)=>{
      const url = ctx.request.url;
      const host = ctx.request.header.host;
      if (url === config.checkUrl) {
        if (this.serverStatus === 'SHUTDOWN') {
          ctx.status = 503;
          ctx.body = 'INVALID';
        } else {
          ctx.body = 'OK';
        }
      } else if (url === config.stopUrl) {
        if (host.split(':')[0] !== '127.0.0.1') {
          ctx.body = 'NO PERMISSION';
        } else {
          ctx.body = 'SHUTDOWN';
          this.stopServer();
        }
      } else {
        await next()
      }
    })
  }
}