class CounterStore {
  count = 0
  loading = false

  constructor() {
    makeAutoObservable(this) // 自动推断类型
  }

  //   Computed：计算属性
  get doubleCount() {
    return this.count * 2
  }

  // Action：同步修改状态
  syncIncrement = () => {
    this.count += 1
  }

  // Action：异步修改状态
  asyncIncrement = async () => {
    this.loading = true
    await new Promise((resolve) => setTimeout(resolve, 1000))
    this.count = 100
    this.loading = false
  }
}

export const counterStore = new CounterStore()
