import type { TableProps } from 'antd'

import AddModal from './addAccount.tsx'

interface DataType {
  key: string
  name: string
  age: number
  address: string
}
const List: React.FC = observer(() => {
  const [isModalOpen, setIsModalOpen] = useState(false)
  const handleShowAddModal = () => {
    setIsModalOpen(true)
  }

  const columns: TableProps<DataType>['columns'] = [
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name',
    },
    {
      title: '年龄',
      dataIndex: 'age',
      key: 'age',
    },
    {
      title: '住址',
      dataIndex: 'address',
      key: 'address',
    },
    {
      title: 'Action',
      key: 'action',
      render: () => (
        <Space size='middle'>
          <a onClick={handleShowAddModal}>查看</a>
        </Space>
      ),
    },
  ]
  const dataSource: DataType[] = [
    {
      key: '1',
      name: '胡彦斌',
      age: 32,
      address: '西湖区湖底公园1号',
    },
    {
      key: '2',
      name: '胡彦祖',
      age: 42,
      address: '西湖区湖底公园1号',
    },
  ]
  return (
    <>
      <Table dataSource={dataSource} columns={columns} />
      <AddModal open={isModalOpen} handleClose={() => setIsModalOpen(false)} />
    </>
  )
})

export default List
