# adx-manager-node

此工程为推啊ADX后台管理系统，通用项目结构tuia-manager-system-demo，基于React + TypeScript + Vite + Mobx搭建。

[TOC]

## 项目结构
**工程目录结构**

```
adx-manager-node
├── dist                    # 构建目录
├── mock                    # 模拟数据
├── server                  # 部署脚本
├── src
│   ├── apis                # 接口服务
│   ├── components 
│   │   ├── common          # 公共组件库
│   │   ├── **/*            # 业务组件库（不接入autoImport）
│   ├── constants           # 常量
│   ├── hooks               # 常用hooks
│   ├── layouts             # 布局组件（不接入autoImport）
│   ├── pages               # 页面组件（已接入文件系统路由）
│   ├── stores              # mobx store
│   │   utils               # 工具库
│   │   main.tsx            # 入口文件
├── README.md
└── vite.config.ts
```

## Proxy
### Yapi-MOCK助手插件
1. 安装YAPI-MOCK助手(https://marketplace.visualstudio.com/items?itemName=Hidetoxic.yapi-mock-helper)
2. 在yapi-mock.config.json中指定项目代理服务器端口
3. 在vite.config.ts的server.proxy指定代理地址为本地指定端口（adx-manager-node端口为10089，建议fork后修改）
4. 启动项目后，从资源管理器，启动YAPI-MOCK助手
![alt text](https://yun.dui88.com/jjq/images/d2skfpns6sl6jgf1rylpd.png)
5. 通过VSCode状态栏，以切换代理地址
![alt text](https://yun.dui88.com/jjq/images/e5b63_q7vskpu9_v3s14_.png)
![alt text](https://yun.dui88.com/jjq/images/sxemnih-qnsdesqkhaxi8.png)

Tips: 虽然目前无法配置Yapi，但启用【YAPI-MOCK缓存模式（默认）】时，可通过手动维护mock文件夹目录，使用本地代理。支持热更新。

### vite代理
你也可以通过修改vite.config.ts的server.proxy配置，自定义代理。

## Auto Import
除业务组件、布局组件（见目录结构）外，项目绝大部份类型声明及变量定义，使用unplugin-auto-import自动导入，无需手动引入。

tips: 请注意开发过程中终端输出的错误提示，<span style="color:red">[重复导入错误]</span>。此错误会导致构建失败。


## 文件系统路由
此工程使用文件系统路由，参考[nuxt路由](https://nuxt.zhcndoc.com/docs/getting-started/routing)

## TODO
- 组件库完善: 大家在系统开发过程中，如编写了通用的组件，请同步到demo中。