import AuthLayout from './AuthLayout'
import BasicLayout from './BasicLayout'

const Layout: React.FC<React.PropsWithChildren> = ({ children }) => {
  const location = useLocation()

  const Layout = useMemo(() => (location.pathname === '/login' ? AuthLayout : BasicLayout), [location.pathname])

  const navigate = useNavigate()
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    const token = localStorage.getItem('token')
    if (location.pathname !== '/login' && !token) {
      navigate('/login')
    } else {
      setLoading(false)
    }
  }, [location.pathname, navigate])

  if (loading) return <Spin fullscreen />

  return <Layout>{children}</Layout>
}

export default Layout
