class MediaAuditStore {
  isModalOpen = false

  searchParams: auditMediaSearchP = {
    mediaId: '',
    pageSize: 15,
    currentPage: 1,
  }
  mediaAccount: mediaAccount = {
    mediaId: '',
    mediaName: '',
    cName: '',
    pe: '',
    phone: '',
    email: '',
    account: '',
    pic1: '',
    pic2: '',
  }
  refuseModeOpen = false

  refuseMsg = ''
  constructor() {
    makeAutoObservable(this) // 自动推断类型
  }

  getModalOpen = () => {
    return this.isModalOpen
  }

  setModalOpen = (value: boolean) => {
    this.isModalOpen = value
  }

  setSearchParams = (value: auditMediaSearchP) => {
    this.searchParams = { ...this.searchParams, ...value }
  }

  setMediaAccount = (value: mediaAccount | undefined) => {
    this.mediaAccount = value
      ? value
      : {
          mediaId: '',
          mediaName: '',
          cName: '',
          pe: '',
          phone: '',
          email: '',
          account: '',
          pic1: '',
          pic2: '',
        }
  }

  setRefuseMsg = (value: string) => {
    this.refuseMsg = value
  }

  setRefuseModeOpen = (value: boolean) => {
    this.setRefuseMsg('')
    this.refuseModeOpen = value
  }

  getMediaAccountFc = (id: number | string) => {
    const res = getMediaAccountAPI(id)
    console.log(res)
    if (id === 1) {
      this.setMediaAccount({
        mediaId: 1,
        mediaName: 'text',
        cName: 'text',
        pe: 'text',
        phone: 'text',
        email: 'text',
        account: 'text',
        pic1: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
        pic2: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
      })
    } else if (id === 2) {
      setTimeout(() => {
        this.setMediaAccount({
          mediaId: 2,
          mediaName: 'text2',
          cName: 'text2',
          pe: 'text2',
          phone: 'text2',
          email: 'text2',
          account: 'text2',
          pic1: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
          pic2: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
        })
      })
    } else if (id === 3) {
      setTimeout(() => {
        this.setMediaAccount({
          mediaId: 3,
          mediaName: 'text3',
          cName: 'text3',
          pe: 'text3',
          phone: 'text3',
          email: 'text3',
          account: 'text3',
          pic1: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
          pic2: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
        })
      })
    }
  }

  passOrRefuseAccount = (id: string | number, type: number, msg = '') => {
    passOrRefuseAccount(id, type, msg)
  }
}

export const mediaAuditStore = new MediaAuditStore()
