import List from './list.tsx'
import Search from './search.tsx'
import { dspAuditStore } from './store.ts'

const DSPAccountIndex = observer(() => {
  const { searchParams } = dspAuditStore
  // 接口获取数据
  const {
    data = [
      {
        time: '2025-04-01',
        mediaId: 1,
        mediaName: 'test',
      },
      {
        time: '2025-04-01',
        mediaId: 2,
        mediaName: 'test2',
      },
    ],
    run,
    loading,
  } = useRequest(getMediaAuditListAPI, { defaultParams: [searchParams] })

  return (
    <Spin spinning={loading}>
      <Space direction='vertical' style={{ display: 'flex' }} size='middle'>
        <Search searchRun={run} />
        <List data={data} searchRun={run} />
      </Space>
    </Spin>
  )
})

export default DSPAccountIndex
