/**
 * 权限工具类
 */

let permissionCodes: string[] = []

const Permissions = {
  getPermissions() {
    return permissionCodes
  },
  setPermissions(permissions: string[]) {
    if (permissions && permissions.length) {
      permissionCodes = [...permissions]
    }
  },
  authRender<T>(item: T, code: string | string[]) {
    if (this.ifRender(code)) {
      return item
    } else {
      return null
    }
  },
  // 判断是否需要渲染权限组件
  ifRender(code: string | string[]): boolean {
    // 用于判断是否需要渲染
    let shouldRender = false
    // 如果传入的是个权限数组，那么需要所有权限都有的情况下才能渲染
    if (typeof code !== 'string') {
      shouldRender = code.every((el) => {
        return permissionCodes.some((item) => item.includes(el))
      })
    } else {
      // 传入的是字符串则匹配是否有该权限
      shouldRender = permissionCodes.some((item) => item.includes(code))
    }
    return shouldRender
  },
}

export default Permissions
