const { Item: FormItem } = Form
import { mediaAuditStore } from './store'
interface SearchProp {
  searchRun: (param: auditMediaSearchP) => void
}
const Search: React.FC<SearchProp> = observer((prop: SearchProp) => {
  const [form] = Form.useForm()
  const { searchRun } = prop
  const { searchParams, setSearchParams } = mediaAuditStore
  function handleSearch(e: React.MouseEvent<HTMLElement, MouseEvent>) {
    e.preventDefault()
    form
      .validateFields()
      .then((values) => {
        setSearchParams({ ...values })
        searchRun({ ...searchParams, ...values })
      })
      .catch((err) => {
        console.error('Validation Failed:', err)
      })
  }
  return (
    <Form className='searchContext' layout='inline' form={form}>
      <FormItem name='mediaId'>
        <Input style={{ width: 200 }} placeholder='请输入媒体ID或者媒体名称' />
      </FormItem>
      <FormItem>
        <Button
          type='primary'
          htmlType='submit'
          onClick={(e: React.MouseEvent<HTMLElement, MouseEvent>) => handleSearch(e)}>
          搜索
        </Button>
      </FormItem>
    </Form>
  )
})

export default Search
