import type { TableColumnsType } from 'antd'

import AddModal from './addAccount.tsx'
import { mediaAuditStore } from './store.ts'
interface ListProp {
  data: mediaAuditList[]
  searchRun: (param: auditMediaSearchP) => void
}

const List: React.FC<ListProp> = observer((prop: ListProp) => {
  const { data, searchRun } = prop
  const {
    setModalOpen,
    searchParams,
    getMediaAccountFc,
    passOrRefuseAccount,
    refuseModeOpen,
    refuseMsg,
    setRefuseMsg,
    setRefuseModeOpen,
  } = mediaAuditStore
  const editAddModal = (id: number | string) => {
    setModalOpen(true)
    getMediaAccountFc(id)
  }
  const handlePageChange = async (page: number, pageSize: number) => {
    const param = {
      ...searchParams,
      pageSize: pageSize,
      currentPage: page,
    }
    searchRun(param)
    console.log('handlePageChange', param)
  }
  const passAccount = (id: number | string) => {
    passOrRefuseAccount(id, 1)
  }
  const [refuseId, setRefuseId] = useState<number | string>(1)
  const requestRefuseReason = () => {
    passOrRefuseAccount(refuseId, 0, refuseMsg)
  }

  const columns: TableColumnsType<mediaAuditList> = [
    {
      title: '创建时间',
      dataIndex: 'time',
      key: 'time',
    },
    {
      title: '媒体ID',
      dataIndex: 'mediaId',
      key: 'mediaId',
    },
    {
      title: '媒体名称',
      dataIndex: 'mediaName',
      key: 'mediaName',
    },
    {
      title: '操作',
      key: 'action',
      render: (_, record) => (
        <Space size='middle'>
          <a onClick={() => passAccount(record.mediaId)}>审核通过</a>
          <a
            onClick={() => {
              setRefuseModeOpen(true)
              setRefuseId(record.mediaId)
            }}>
            审核拒绝
          </a>
          <a onClick={() => editAddModal(record.mediaId)}>查看</a>
        </Space>
      ),
    },
  ]

  return (
    <>
      <Table<mediaAuditList>
        dataSource={data}
        columns={columns}
        pagination={{ pageSizeOptions: [10, 20, 50], showQuickJumper: true, total: 500, onChange: handlePageChange }}
      />
      <AddModal />
      <RejectReason
        value={refuseMsg}
        open={refuseModeOpen}
        onOk={requestRefuseReason}
        onCancel={() => setRefuseModeOpen(false)}
        onChange={(value) => setRefuseMsg(value)}
      />
    </>
  )
})

export default List
