const { Item: FormItem } = Form
import { mediaAccountStore } from './store'
interface SearchProp {
  searchRun: (param: mediaSearchP) => void
}
const Search: React.FC<SearchProp> = observer((prop: SearchProp) => {
  const [form] = Form.useForm()
  const { searchRun } = prop
  const { setModalOpen, searchParams, setSearchParams } = mediaAccountStore
  function handleSearch(e: React.MouseEvent<HTMLElement, MouseEvent>) {
    e.preventDefault()
    form
      .validateFields()
      .then((values) => {
        setSearchParams({ ...values })
        searchRun({ ...searchParams, ...values })
      })
      .catch((err) => {
        console.error('Validation Failed:', err)
      })
  }

  const handleAdd = () => {
    setModalOpen(true)
  }
  return (
    <Form layout='inline' form={form}>
      <Space wrap>
        <FormItem name='mediaId' rules={[Rules.ids]}>
          <Input style={{ width: 200 }} placeholder='请输入媒体ID间隔用,隔开' />
        </FormItem>
        <FormItem name='mediaName' rules={[Rules.name]}>
          <Input style={{ width: 200 }} placeholder='请输入媒体名称' />
        </FormItem>
        <FormItem name='AE' rules={[Rules.name]}>
          <Input style={{ width: 200 }} placeholder='请输入运营' />
        </FormItem>
        <FormItem name='PE' rules={[Rules.name]}>
          <Input style={{ width: 200 }} placeholder='请输入媒介' />
        </FormItem>
        <FormItem>
          <Button type='primary' onClick={handleAdd}>
            创建媒体
          </Button>
        </FormItem>
        <FormItem>
          <Button
            type='primary'
            htmlType='submit'
            onClick={(e: React.MouseEvent<HTMLElement, MouseEvent>) => handleSearch(e)}>
            搜索
          </Button>
        </FormItem>
      </Space>
    </Form>
  )
})

export default Search
