import type { TableColumnsType } from 'antd'

import AddModal from './addAccount.tsx'
import { dspAccountStore } from './store.ts'
interface ListProp {
  data: mediaAccountList[]
  searchRun: (param: mediaSearchP) => void
}

const List: React.FC<ListProp> = observer((prop: ListProp) => {
  const { data, searchRun } = prop
  const { setModalOpen, searchParams, getMediaAccountFc, changeAE, changeAEList, changePE, changeStatue } =
    dspAccountStore
  const editAddModal = (id: number | string) => {
    setModalOpen(true)
    getMediaAccountFc(id)
  }
  const handlePageChange = async (page: number, pageSize: number) => {
    const param = {
      ...searchParams,
      pageSize: pageSize,
      currentPage: page,
    }
    searchRun(param)
    console.log('handlePageChange', param)
  }

  const columns: TableColumnsType<mediaAccountList> = [
    {
      title: '媒体ID',
      dataIndex: 'mediaId',
      key: 'mediaId',
    },
    {
      title: '媒体名称',
      dataIndex: 'mediaName',
      key: 'mediaName',
    },
    {
      title: '媒体类型',
      dataIndex: 'mediaType',
      key: 'mediaType',
    },
    {
      title: '媒体接入方式',
      dataIndex: 'mediaC',
      key: 'mediaC',
    },
    {
      title: '媒体接入时间',
      dataIndex: 'mediaTime',
      key: 'mediaTime',
    },
    {
      title: '所属主运营',
      dataIndex: 'AE',
      key: 'AE',
      render: (AE, record) => {
        return (
          <TableSelect
            text={AE}
            selectValue={record.AEId}
            options={[
              { label: 'text', value: 1 },
              { label: 'text2', value: 2 },
              { label: 'text3', value: 3 },
            ]}
            callback={(value) => changeAE(record.mediaId, value as number)}
          />
        )
      },
    },
    {
      title: '其他运营',
      dataIndex: 'AEName',
      key: 'AEName',
      render: (AEName, record) => {
        return (
          <TableSelect
            text={AEName}
            mode='multiple'
            selectValue={AEName}
            options={[
              { label: 'text', value: 'text' },
              { label: 'text2', value: 'text2' },
              { label: 'text3', value: 'text3' },
            ]}
            callback={(value) => changeAEList(record.mediaId, value as string[])}
          />
        )
      },
    },
    {
      title: '所属媒介',
      dataIndex: 'PE',
      key: 'PE',
      render: (PE, record) => {
        return (
          <TableSelect
            text={PE}
            selectValue={PE}
            options={[
              { label: 'text', value: 'text' },
              { label: 'text2', value: 'text2' },
              { label: 'text3', value: 'text3' },
            ]}
            callback={(value) => changePE(record.mediaId, value as string)}
          />
        )
      },
    },
    {
      title: '审核状态',
      dataIndex: 'statue',
      key: 'statue',
      render: (statue, record) => (
        <Space size='middle'>
          <Switch checked={statue} onChange={(checked: boolean) => changeStatue(record.mediaId, checked)} />
        </Space>
      ),
    },
    {
      title: '操作',
      key: 'action',
      render: (_, record) => (
        <Space size='middle'>
          <a onClick={() => editAddModal(record.mediaId)}>设置</a>
        </Space>
      ),
    },
  ]

  return (
    <>
      <Table<mediaAccountList>
        dataSource={data}
        columns={columns}
        pagination={{ pageSizeOptions: [10, 20, 50], showQuickJumper: true, total: 500, onChange: handlePageChange }}
      />
      <AddModal />
    </>
  )
})

export default List
