import { dspAccountStore } from './store.ts'

const AddModal: React.FC = observer(() => {
  const { isModalOpen: open, setModalOpen, addMediaAccountFc, mediaAccount, setMediaAccount } = dspAccountStore
  const [form] = Form.useForm()
  const [imageUrl, setImageUrl] = useState<string>()
  const [imageUrl2, setImageUrl2] = useState<string>()

  const handleCancel = () => {
    setModalOpen(false)
  }

  const handleOk = async (e: React.MouseEvent<HTMLElement, MouseEvent>) => {
    e.preventDefault()
    form
      .validateFields()
      .then((values) => {
        console.log(values)
        addMediaAccountFc({ ...values })
        handleCancel()
      })
      .catch((err) => {
        console.error('Validation Failed:', err)
      })
  }

  useEffect(() => {
    if (open) {
      form.setFieldsValue(mediaAccount)
    } else {
      // ?
      setTimeout(() => {
        form.resetFields()
        setMediaAccount(undefined)
      }, 100)
    }
  }, [mediaAccount, open])

  return (
    <Modal title='创建媒体' open={open} onOk={handleOk} onCancel={handleCancel} okText='提交审核'>
      <Form
        form={form}
        labelCol={{ flex: '110px' }}
        wrapperCol={{ flex: 1 }}
        labelAlign='left'
        labelWrap
        colon={false}
        style={{ maxWidth: 600 }}>
        <Form.Item label='媒体名称' name='mediaName' rules={[{ required: true }]}>
          <Input />
        </Form.Item>

        <Form.Item label='公司名称' name='cName' rules={[{ required: true }]}>
          <Input />
        </Form.Item>

        <Form.Item label='对接人姓名' name='pe' rules={[{ required: true }]}>
          <Input />
        </Form.Item>

        <Form.Item label='对接人电话' name='phone' rules={[{ required: true }]}>
          <Input />
        </Form.Item>

        <Form.Item label='对接人邮箱' name='email' rules={[{ required: true }]}>
          <Input />
        </Form.Item>

        <Form.Item label='收款账户信息' name='account' rules={[{ required: true }]}>
          <Input />
        </Form.Item>

        <Form.Item label='营业执照' name='pic1' rules={[{ required: true }]}>
          <DraggerUpload
            value={imageUrl}
            data={{ id: 1, name: 'yhcj' }}
            getUploadUrl={(url: string) => {
              form.setFieldValue('pic1', url)
              setImageUrl(url)
            }}
          />
        </Form.Item>

        <Form.Item label='基本账户信息（开户许可证）' name='pic2' rules={[{ required: true }]}>
          <DraggerUpload
            value={imageUrl2}
            data={{ id: 1, name: 'yhcj' }}
            getUploadUrl={(url: string) => {
              form.setFieldValue('pic2', url)
              setImageUrl2(url)
            }}
          />
        </Form.Item>
      </Form>
    </Modal>
  )
})

export default AddModal
