import { Suspense } from 'react'

import { StyleProvider } from '@ant-design/cssinjs'
import routes from '~react-pages'
import { ConfigProvider } from 'antd'
import zhCN from 'antd/lib/locale/zh_CN'

import Layouts from './layouts/index.tsx'

const App: React.FC = () => {
  return (
    <Suspense fallback={<Spin fullscreen />}>
      <StyleProvider layer>
        <ConfigProvider locale={zhCN}>
          <Layouts>{useRoutes(routes)}</Layouts>
        </ConfigProvider>
      </StyleProvider>
    </Suspense>
  )
}

export default App
