import { ReactNode } from 'react'
export function isNothing(value: number | void | string | null | undefined): boolean {
  return (
    value === '' ||
    value === undefined ||
    value === null ||
    (typeof value === 'number' && (isNaN(value) || !isFinite(value)))
  )
}

export function checkEmpty(data: number | string | null | undefined): ReactNode {
  return isNothing(data) ? '-' : data
}
