interface IProps {
  open: boolean
  value: string
  onOk: () => void
  onCancel: () => void
  onChange: (value: string) => void
}

const RejectReason: React.FC<IProps> = memo(({ open, value, onCancel, onOk, onChange, ...rest }) => {
  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    onChange(e.target.value)
  }
  return (
    <Modal title='拒绝原因' open={open} onCancel={onCancel} onOk={onOk} {...rest}>
      <Input.TextArea value={value} onChange={handleChange} />
    </Modal>
  )
})

export default RejectReason
