import { dspAuditStore } from './store.ts'

const AddModal: React.FC = observer(() => {
  const [messageApi, contextHolder] = message.useMessage()
  const {
    isModalOpen: open,
    setModalOpen,
    mediaAccount,
    getMediaAccountFc,
    refuseModeOpen,
    refuseMsg,
    setRefuseMsg,
    setRefuseModeOpen,
  } = dspAuditStore
  const [form] = Form.useForm()

  const idList = [1, 2, 3, 4, 5, 6, 7]
  let [indexNumber, setIndexNumber] = useState<number>(1)

  const handleCancel = () => {
    setModalOpen(false)
  }

  useEffect(() => {
    if (open) {
      form.setFieldsValue(mediaAccount)
    }
  }, [mediaAccount, open, form])

  const passAccount = () => {
    passOrRefuseAccount(mediaAccount.mediaId, 1)
    handleNext()
  }

  const requestRefuseReason = () => {
    passOrRefuseAccount(mediaAccount.mediaId, 0, refuseMsg)
    handleNext()
    setRefuseModeOpen(false)
  }
  const handleNext = () => {
    if (idList.length > indexNumber) {
      getMediaAccountFc(idList[indexNumber])
      setIndexNumber(++indexNumber)
    } else {
      messageApi.info('所有媒体已审核完毕')
    }
  }

  const AuditFooter = (
    <Space style={{ display: 'flex', justifyContent: 'flex-end' }}>
      <Button onClick={passAccount} type='primary'>
        通过
      </Button>
      <Button onClick={() => setRefuseModeOpen(true)} color='danger'>
        拒绝
      </Button>
      <Button type='primary' onClick={handleNext}>
        下一个
      </Button>
    </Space>
  )
  return (
    <>
      <Drawer onClose={handleCancel} title='创建媒体' open={open} footer={AuditFooter} width='720'>
        {contextHolder}
        <Form
          form={form}
          labelCol={{ flex: '110px' }}
          wrapperCol={{ flex: 1 }}
          labelAlign='left'
          labelWrap
          colon={false}
          style={{ maxWidth: 600 }}>
          <Form.Item label='媒体名称' name='mediaName' rules={[{ required: true }]}>
            <Input disabled={true} />
          </Form.Item>

          <Form.Item label='公司名称' name='cName' rules={[{ required: true }]}>
            <Input disabled={true} />
          </Form.Item>

          <Form.Item label='对接人姓名' name='pe' rules={[{ required: true }]}>
            <Input disabled={true} />
          </Form.Item>

          <Form.Item label='对接人电话' name='phone' rules={[{ required: true }]}>
            <Input disabled={true} />
          </Form.Item>

          <Form.Item label='对接人邮箱' name='email' rules={[{ required: true }]}>
            <Input disabled={true} />
          </Form.Item>

          <Form.Item label='收款账户信息' name='account' rules={[{ required: true }]}>
            <Input disabled={true} />
          </Form.Item>

          <Form.Item label='营业执照' name='pic1' rules={[{ required: true }]}>
            <DraggerUpload value={form.getFieldValue('pic1')} disabled={true} />
          </Form.Item>

          <Form.Item label='基本账户信息（开户许可证）' name='pic2' rules={[{ required: true }]}>
            <DraggerUpload value={form.getFieldValue('pic2')} disabled={true} />
          </Form.Item>
        </Form>
      </Drawer>
      <RejectReason
        value={refuseMsg}
        open={refuseModeOpen}
        onOk={requestRefuseReason}
        onCancel={() => setRefuseModeOpen(false)}
        onChange={(value) => setRefuseMsg(value)}
      />
    </>
  )
})

export default AddModal
