import dayjs from 'dayjs'

import { PARAMS_TYPE } from '../common/const'

class Store {
  today = dayjs().format()
  currentTag = 'media'
  slotSearchParams: QuerySlotParams = {
    startDate: this.today,
    endDate: this.today,
    date: [dayjs(this.today), dayjs(this.today)],
    relName: '',
    relId: void 0,
    id: void 0,
    thirdName: '',
    thirdId: void 0,
    slotType: void 0,
    pageSize: 10,
    pageNum: 1,
    type: PARAMS_TYPE.MEDIA,
  }
  mediaSearchParams: QueryMediaParams = {
    startDate: this.today,
    endDate: this.today,
    date: [dayjs(this.today), dayjs(this.today)],
    mediaName: '',
    id: void 0,
    pageSize: 10,
    pageNum: 1,
  }
  modalOpen = false
  modalData: SlotModalData = {
    materialStyle: void 0,
    relName: '',
    slotType: void 0,
    thirdId: void 0,
    thirdStyle: void 0,
    type: PARAMS_TYPE.MEDIA,
  }
  constructor() {
    makeAutoObservable(this) // 自动推断类型
  }
  setTag = (tag: string) => {
    this.currentTag = tag
  }
  get idEdit() {
    return !!this.modalData.thirdId
  }

  /**
   * 设置媒体查询参数
   */
  setMediaSearchParams = (value: QueryMediaParams) => {
    this.mediaSearchParams = { ...this.mediaSearchParams, ...value }
  }
  /**
   * 操作广告位弹窗
   * @param openStatus 是否开启
   * @param data 数据
   */
  setModalOpen = (openStatus: boolean, data: SlotModalData) => {
    this.modalOpen = openStatus
    this.modalData = { ...this.modalData, ...data }
  }
  /**
   * 设置广告位查询参数
   */
  setSlotSearchParams = (value: QuerySlotParams) => {
    this.slotSearchParams = { ...this.slotSearchParams, ...value }
  }
}

const store = new Store()
export default store
