import { Form, DatePicker, Input, Button } from 'antd'
import { observer } from 'mobx-react-lite'

import { SLOT_TYPE_OPTIONS } from '../common/const'
import store from '../store'

const { Item: FormItem } = Form
const { RangePicker } = DatePicker
interface SearchProp {
  searchRun: (param: QuerySlotParams) => void
}
const Search: React.FC<SearchProp> = observer((prop: SearchProp) => {
  const [form] = Form.useForm<QuerySlotParams>()
  const { searchRun } = prop
  const { setSlotSearchParams, slotSearchParams } = store
  useEffect(() => {
    form.setFieldsValue(slotSearchParams)
  }, [form, slotSearchParams])
  const handleSearch = async (e: React.MouseEvent<HTMLElement, MouseEvent>) => {
    e.preventDefault()
    const values = await form.validateFields()

    // 安全地处理日期，防止 values.date 未定义
    const [startDate, endDate] = values.date && Array.isArray(values.date) ? values.date : [null, null]

    // 构造新的搜索参数
    const newParams = {
      ...slotSearchParams,
      ...values,
      startDate: startDate ? startDate.format('YYYY-MM-DD') : undefined,
      endDate: endDate ? endDate.format('YYYY-MM-DD') : undefined,
    }

    setSlotSearchParams(newParams) // 更新搜索参数
    searchRun(newParams) // 执行搜索
  }

  return (
    <Form form={form} layout='inline'>
      <FormItem<QuerySlotParams> name='date'>
        <RangePicker format='YYYY-MM-DD' />
      </FormItem>
      <FormItem<QuerySlotParams> label='媒体ID' name='relId' rules={[Rules.id]}>
        <Input style={{ width: 200 }} placeholder='请输入媒体ID' />
      </FormItem>
      <FormItem<QuerySlotParams> label='媒体名称' name='relName' rules={[Rules.name]}>
        <Input style={{ width: 200 }} placeholder='请输入媒体名称' />
      </FormItem>
      <FormItem<QuerySlotParams> label='推啊广告位ID' name='id' rules={[Rules.id]}>
        <Input style={{ width: 200 }} placeholder='请输入推啊广告位ID' />
      </FormItem>
      <FormItem<QuerySlotParams> label='推啊广告位名称' name='thirdName' rules={[Rules.name]}>
        <Input style={{ width: 200 }} placeholder='请输入推啊广告位名称' />
      </FormItem>
      <FormItem<QuerySlotParams> label='媒体广告位ID' name='thirdId' rules={[Rules.id]}>
        <Input style={{ width: 200 }} placeholder='请输入媒体广告位ID' />
      </FormItem>
      <FormItem<QuerySlotParams> label='广告位类型' name='slotType'>
        <Select style={{ width: 200 }} placeholder='请选择广告位类型' options={SLOT_TYPE_OPTIONS} />
      </FormItem>
      <FormItem>
        <Button type='primary' onClick={handleSearch}>
          搜索
        </Button>
      </FormItem>
    </Form>
  )
})

export default Search
