import store from '../store/index.ts'
import List from './list'
import Search from './search'
import SlotModal from './slotModal.tsx'
const Media: React.FC = observer(() => {
  const { slotSearchParams } = store
  const { data, run, loading, refresh } = useRequest(getSlotList, { defaultParams: [slotSearchParams] })
  return (
    <Spin spinning={loading}>
      <Search searchRun={run} />
      <List data={data} searchRun={run} />
      <SlotModal refresh={refresh} />
    </Spin>
  )
})

export default Media
