import { type TableColumnsType } from 'antd'

import { statusColorMap } from '../common/const.ts'
import store from '../store/index.ts'

interface ListProp {
  data: MediaInfoList | undefined
  searchRun: (param: QueryMediaParams) => void
}
const List: React.FC<ListProp> = observer((prop: ListProp) => {
  const { data, searchRun } = prop
  const { mediaSearchParams, setTag, setSlotSearchParams, setModalOpen } = store

  const columns: TableColumnsType<MediaInfo> = [
    {
      title: '流量开关',
      dataIndex: 'status',
      key: 'status',
      render: (value: number) => <Switch checked={value === 1} />,
    },
    {
      title: '媒体名称',
      dataIndex: 'mediaName',
      key: 'mediaName',
      render: (text, record) => {
        return (
          <div className='flex flex-col items-center justify-center w-full h-[50px] group'>
            <a
              className='w-[120px] text-center'
              onClick={() => {
                setTag('slot')
                setSlotSearchParams({ relId: record.id, pageSize: 10, pageNum: 1 })
              }}>
              {text}
            </a>
            <div className='max-h-0 overflow-hidden group-hover:max-h-[30px]'>
              <a
                onClick={() => {
                  setTag('slot')
                  setModalOpen(true, { relId: record.id, relName: text })
                }}>
                创建广告位
              </a>
            </div>
          </div>
        )
      },
    },
    {
      title: '媒体ID',
      dataIndex: 'id',
      key: 'id',
    },
    {
      title: '审核状态',
      dataIndex: 'auditStatusDesc',
      key: 'auditStatusDesc',
      render: (text: string) => {
        const color = statusColorMap[text] || 'default'
        return <span style={{ color }}>{text}</span>
      },
    },
    {
      title: '曝光',
      dataIndex: 'exposePv',
      key: 'exposePv',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
    {
      title: '点击',
      dataIndex: 'clickPv',
      key: 'clickPv',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
    {
      title: '点击率',
      dataIndex: 'clickRate',
      key: 'clickRate',
      render: (text) => {
        return <div>{checkEmpty(text) + '%'}</div>
      },
    },
    {
      title: '消耗',
      dataIndex: 'consume',
      key: 'consume',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
  ]
  const handlePageChange = async (page: number, pageSize: number) => {
    const param = {
      ...mediaSearchParams,
      pageSize: pageSize,
      currentPage: page,
    }
    searchRun(param)
  }
  return (
    <Table<MediaInfo>
      rowKey='id'
      className='mt-5'
      dataSource={data?.list}
      columns={columns}
      pagination={{
        pageSizeOptions: [10, 20, 50],
        showQuickJumper: true,
        total: data?.total,
        onChange: handlePageChange,
      }}
    />
  )
})

export default List
