import store from '../store/index.ts'
import List from './list.tsx'
import Search from './search.tsx'
const Media: React.FC = observer(() => {
  const { mediaSearchParams } = store
  const { data, run, loading } = useRequest(getMediaList, { defaultParams: [mediaSearchParams] })
  return (
    <Spin spinning={loading}>
      <Search searchRun={run} />
      <List data={data} searchRun={run} />
    </Spin>
  )
})

export default Media
