import type { TableColumnsType } from 'antd'

import AddModal from './addAccount.tsx'
import { mediaAccountStore } from './store.ts'
interface ListProp {
  data: mediaAccountList[]
  searchRun: (param: mediaSearchP) => void
}

const List: React.FC<ListProp> = observer((prop: ListProp) => {
  const { data, searchRun } = prop
  const { setModalOpen, searchParams, getMediaAccountFc } = mediaAccountStore
  const editAddModal = (id: number | string) => {
    setModalOpen(true)
    getMediaAccountFc(id)
  }
  const handlePageChange = async (page: number, pageSize: number) => {
    const param = {
      ...searchParams,
      pageSize: pageSize,
      currentPage: page,
    }
    searchRun(param)
    console.log('handlePageChange', param)
  }

  const changeStatue = (id: string | number, statue: boolean) => {
    console.log(id, statue)
    const l = changeStatueByIdAPI({ mediaId: id, statue })
    console.log(l)
  }

  const [flag, changeFlag] = useState(false)
  const changeAE = (id: string | number, name: string) => {
    console.log(id, name)
    const l = changeAEByIdAPI({ mediaId: id, AE: name })
    console.log(l)
  }

  const changeAEList = (id: string | number, name: string[]) => {
    console.log(id, name)
    const l = changeAEListByIdAPI({ mediaId: id, AEList: name })
    console.log(l)
  }

  const changePE = (id: string | number, name: string) => {
    console.log(id, name)
    const l = changePEByIdAPI({ mediaId: id, PE: name })
    console.log(l)
  }

  const columns: TableColumnsType<mediaAccountList> = [
    {
      title: '媒体ID',
      dataIndex: 'mediaId',
      key: 'mediaId',
    },
    {
      title: '媒体名称',
      dataIndex: 'mediaName',
      key: 'mediaName',
    },
    {
      title: '媒体类型',
      dataIndex: 'mediaType',
      key: 'mediaType',
    },
    {
      title: '媒体接入方式',
      dataIndex: 'mediaC',
      key: 'mediaC',
    },
    {
      title: '媒体接入时间',
      dataIndex: 'mediaTime',
      key: 'mediaTime',
    },
    {
      title: '所属主运营',
      dataIndex: 'AE',
      key: 'AE',
      render: (AE, record) => {
        return (
          <Space size='middle'>
            {flag ? (
              <Select
                defaultValue={AE}
                style={{ width: 120 }}
                onChange={async (value) => {
                  await changeAE(record.mediaId, value)
                  changeFlag(false)
                }}>
                <Select.Option value='test'>test</Select.Option>
                <Select.Option value='test2'>test2</Select.Option>
              </Select>
            ) : AE ? (
              <a onClick={() => changeFlag(true)}>{AE}</a>
            ) : (
              <a onClick={() => changeFlag(true)}>-</a>
            )}
          </Space>
        )
      },
    },
    {
      title: '其他运营',
      dataIndex: 'AEName',
      key: 'AEName',
      render: (AEName, record) => {
        return (
          <Space size='middle'>
            {flag ? (
              <Select
                mode='multiple'
                defaultValue={AEName?.split(',')}
                style={{ width: 120 }}
                onChange={async (value) => {
                  await changeAEList(record.mediaId, value)
                  changeFlag(false)
                }}>
                <Select.Option value='test'>test</Select.Option>
                <Select.Option value='test1'>test1</Select.Option>
                <Select.Option value='test2'>test2</Select.Option>
              </Select>
            ) : AEName ? (
              <a onClick={() => changeFlag(true)}>{AEName}</a>
            ) : (
              <a onClick={() => changeFlag(true)}>-</a>
            )}
          </Space>
        )
      },
    },
    {
      title: '所属媒介',
      dataIndex: 'PE',
      key: 'PE',
      render: (PE, record) => {
        return (
          <Space size='middle'>
            {flag ? (
              <Select
                defaultValue={PE}
                style={{ width: 120 }}
                onChange={async (value) => {
                  await changePE(record.mediaId, value)
                  changeFlag(false)
                }}>
                <Select.Option value='test'>test</Select.Option>
                <Select.Option value='test2'>test2</Select.Option>
              </Select>
            ) : PE ? (
              <a onClick={() => changeFlag(true)}>{PE}</a>
            ) : (
              <a onClick={() => changeFlag(true)}>-</a>
            )}
          </Space>
        )
      },
    },
    {
      title: '审核状态',
      dataIndex: 'statue',
      key: 'statue',
      render: (statue, record) => (
        <Space size='middle'>
          <Switch checked={statue} onChange={(checked: boolean) => changeStatue(record.mediaId, checked)} />
        </Space>
      ),
    },
    {
      title: '操作',
      key: 'action',
      render: (_, record) => (
        <Space size='middle'>
          <a onClick={() => editAddModal(record.mediaId)}>设置</a>
        </Space>
      ),
    },
  ]

  return (
    <>
      <Table<mediaAccountList>
        dataSource={data}
        columns={columns}
        pagination={{ pageSizeOptions: [10, 20, 50], showQuickJumper: true, total: 500, onChange: handlePageChange }}
      />
      <AddModal />
    </>
  )
})

export default List
