import List from './list.tsx'
import Search from './search.tsx'
import { dspAccountStore } from './store.ts'

const DSPAccountIndex = observer(() => {
  const { searchParams } = dspAccountStore
  // 接口获取数据
  const {
    data = [
      {
        mediaId: 1234,
        mediaName: 'test',
        mediaType: 'test',
        mediaC: 'test',
        mediaTime: 'test',
        AE: 'test',
        AEId: 1,
        AEName: 'test,test2',
        PE: 'test',
        statue: true,
      },
      {
        mediaId: 2123,
        mediaName: 'test2',
        mediaType: 'test2',
        mediaC: 'test2',
        mediaTime: 'test2',
        AE: 'test2',
        AEId: 2,
        AEName: 'test1,test2',
        PE: 'test2',
        statue: false,
      },
    ],
    run,
    loading,
  } = useRequest(getMediaAccountListAPI, { defaultParams: [searchParams] })

  return (
    <Spin spinning={loading}>
      <Space direction='vertical' style={{ display: 'flex' }} size='middle'>
        <Search searchRun={run} />
        <List data={data} searchRun={run} />
      </Space>
    </Spin>
  )
})

export default DSPAccountIndex
