/**
 * @description: 获取广告位列表
 * @param {QuerySlotParams} params 请求参数
 * @return {SlotInfoList} 广告位列表
 */
export const getSlotList = (data: QuerySlotParams) =>
  request<QuerySlotParams, SlotInfoList>('/slot/getList', { method: 'post', data })
/**
 * @description: 添加/修改广告位
 * @param {SlotModalData} data 广告位修改表单
 * @return {void} 广告位列表
 */
export const saveSlot = (data: SlotModalData) => request<SlotModalData, void>('/slot/save', { method: 'post', data })
/**
 * @description: 获取广告位详情
 * @param {QueryDetail} params 请求参数
 * @return {SlotInfo} 广告位列表
 */
export const getSlotDetail = (data: QueryDetail) =>
  request<QueryDetail, SlotInfo>('/slot/detail', { method: 'post', data })
