const { Item: FormItem } = Form

const Search: React.FC = observer(() => {
  const [form] = Form.useForm()
  function handleSearch(e: React.MouseEvent<HTMLElement, MouseEvent>) {
    e.preventDefault()
    form
      .validateFields()
      .then((values) => {
        values.dealIdList = values.dealIdList?.split(',')
        console.log('Received values of form: ', values)
      })
      .catch((err) => {
        console.error('Validation Failed:', err)
      })
  }

  return (
    <Form layout='inline' form={form}>
      <FormItem name='dealIdList' rules={[Rules.ids]}>
        <Input style={{ width: 200 }} placeholder='请输入排期单ID间隔用,隔开' />
      </FormItem>
      <FormItem name='dealName' rules={[Rules.name]}>
        <Input style={{ width: 200 }} placeholder='请输入排期单名称' />
      </FormItem>
      <FormItem>
        <Button
          type='primary'
          htmlType='submit'
          onClick={(e: React.MouseEvent<HTMLElement, MouseEvent>) => handleSearch(e)}>
          搜索
        </Button>
      </FormItem>
    </Form>
  )
})

export default Search
