class MediaAccountStore {
  isModalOpen = false

  searchParams: mediaSearchP = {
    mediaId: '',
    mediaName: '',
    AE: '',
    PE: '',
    pageSize: 15,
    currentPage: 1,
  }
  mediaAccount: mediaAccount | undefined = {
    mediaName: '',
    cName: '',
    pe: '',
    phone: '',
    email: '',
    account: '',
    pic1: '',
    pic2: '',
  }
  constructor() {
    makeAutoObservable(this) // 自动推断类型
  }

  getModalOpen = () => {
    return this.isModalOpen
  }

  setModalOpen = (value: boolean) => {
    this.isModalOpen = value
  }

  setSearchParams = (value: mediaSearchP) => {
    this.searchParams = { ...this.searchParams, ...value }
  }

  setMediaAccount = (value: mediaAccount | undefined) => {
    this.mediaAccount = value ? { ...value } : undefined
  }

  addMediaAccountFc = (params: mediaAccount) => {
    console.log('params', params)
    const res = addMediaAccountAPI(params)
    console.log(res)
  }

  getMediaAccountFc = (id: number | string) => {
    const res = getMediaAccountAPI(id)
    console.log(res)
    this.setMediaAccount({
      mediaName: 'text',
      cName: 'text',
      pe: 'text',
      phone: 'text',
      email: 'text',
      account: 'text',
      pic1: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
      pic2: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
    })
  }
}

export const mediaAccountStore = new MediaAccountStore()
