import { useNavigate } from 'react-router-dom'

import { DashboardOutlined } from '@ant-design/icons'
// src/layouts/BasicLayout.tsx
import { Layout, Menu, theme } from 'antd'

const { Header, Content, Sider } = Layout

const menuItems = [
  {
    key: '/',
    icon: <DashboardOutlined />,
    label: 'Dashboard',
  },
]

const BasicLayout: React.FC<React.PropsWithChildren> = ({ children }) => {
  const {
    token: { colorBgContainer },
  } = theme.useToken()
  const navigate = useNavigate()

  return (
    <Layout style={{ minHeight: '100vh' }}>
      <Sider breakpoint='lg'>
        <div className='demo-logo-vertical' />
        <Menu theme='dark' mode='vertical' items={menuItems} onSelect={({ key }) => navigate(key)} />
      </Sider>
      <Layout>
        <Header style={{ padding: 0, background: colorBgContainer }} />
        <Content style={{ margin: '24px 16px 0' }}>
          <div style={{ padding: 24, background: colorBgContainer }}>{children}</div>
        </Content>
      </Layout>
    </Layout>
  )
}

export default BasicLayout
