import React from 'react'

const Home: React.FC = () => {
  const { data, run, loading } = useRequest(getUserList, { mannual: true })

  const { run: userRun } = useRequest(getUserById, { defaultParams: [1], mannual: true })

  const { data: failedRecords } = useRequest(getTopOnlineApp)

  useEffect(() => {
    userRun(1)

    run()
  }, [failedRecords, run, userRun])

  return (
    <div>
      <header>首页</header>
      <Button loading={loading} onClick={() => run()}>
        测试
      </Button>

      {data?.map((user) => (
        <React.Fragment key={user.id}>
          <div>
            <strong>id:</strong>
            {user.id}
          </div>
          <div>
            <strong>name:</strong>
            {user.name}
          </div>
        </React.Fragment>
      ))}
    </div>
  )
}

export default Home
