import { useNavigate } from 'react-router-dom'

import { DashboardOutlined } from '@ant-design/icons'
// src/layouts/BasicLayout.tsx
import { Layout, Menu, theme } from 'antd'

const { Header, Content, Sider } = Layout

const menuItems = [
  {
    key: '/',
    icon: <DashboardOutlined />,
    label: 'Dashboard',
  },
]

const BasicLayout: React.FC<React.PropsWithChildren> = ({ children }) => {
  const {
    token: { colorBgContainer },
  } = theme.useToken()
  const navigate = useNavigate()

  return (
    <Layout className='min-h-screen text-9xl'>
      <Header className='p-0' />
      <Layout>
        <Sider breakpoint='lg'>
          <Menu theme='dark' mode='vertical' items={menuItems} onSelect={({ key }) => navigate(key)} />
        </Sider>
        <Content className='mt-6 mx-4'>
          <div className='p-6' style={{ background: colorBgContainer }}>
            {children}
          </div>
        </Content>
      </Layout>
    </Layout>
  )
}

export default BasicLayout
