import tailwindcss from '@tailwindcss/vite'
import react from '@vitejs/plugin-react-swc'
import AutoImport from 'unplugin-auto-import'
import { defineConfig } from 'vite'
import Pages from 'vite-plugin-pages'

import { AutoImportError } from './vite-plugins/auto-import-error'

// https://vite.dev/config/
export default defineConfig({
  server: {
    proxy: {
      '^/(.*)': {
        target: 'http://localhost:10089',
        changeOrigin: true,
        bypass: (req) => {
          const url = req.url
          if (req.headers['x-proxy-enabled']) {
            return null
          }
          return url
        },
      },
    },
  },
  plugins: [
    AutoImportError(),
    AutoImport.vite({
      include: [/\.tsx?$/],
      dirs: [
        'src/apis/**',
        'src/components/common/**',
        'src/constants/**',
        'src/hooks/**',
        'src/utils/**',
        'src/stores/**',
      ],
      imports: [
        {
          antd: ['message', 'Spin', 'Layout', 'Menu', 'theme', 'Button', 'Form', 'Input', 'Card', 'Result'],
          axios: [['default', 'axios']],
          'pixiu-number-toolkit': ['REGEX'],
        },
        'react',
        'react-router-dom',
        'mobx',
        'mobx-react-lite',
      ],
    }),
    react(),
    Pages({
      routeStyle: 'next',
      importMode: 'async',
      dirs: 'src/pages',
      exclude: ['**/components/*.ts[x]?', '**/hooks/*.ts[x]?'],
      extendRoute(route) {
        if (route.path === '/login') {
          return route
        }

        return {
          ...route,
          meta: {
            requiresAuth: true,
            layout: 'index',
          },
        }
      },
    }),
    tailwindcss(),
  ],
})
