import { LockOutlined, UserOutlined } from '@ant-design/icons'

type FieldType = {
  username?: string
  password?: string
}

export default function LoginPage() {
  const navigate = useNavigate()
  const [messageApi, contextHolder] = message.useMessage()

  const onFinish = (values: FieldType) => {
    if (values.username === 'admin' && values.password === '123456') {
      localStorage.setItem('token', 'fake-jwt-token')
      navigate('/')
      messageApi.success('登录成功！')
    } else {
      messageApi.error('账号或密码错误')
    }
  }

  return (
    <div style={{ width: 360, margin: '100px auto' }}>
      {contextHolder}
      <h1 style={{ textAlign: 'center', marginBottom: 24 }}>后台管理系统</h1>
      <Form name='login' initialValues={{ remember: true }} onFinish={onFinish}>
        <Form.Item<FieldType> name='username' rules={[{ required: true, message: '请输入用户名' }]}>
          <Input prefix={<UserOutlined />} placeholder='用户名' />
        </Form.Item>

        <Form.Item<FieldType> name='password' rules={[{ required: true, message: '请输入密码' }]}>
          <Input.Password prefix={<LockOutlined />} placeholder='密码' />
        </Form.Item>

        <Form.Item>
          <Button type='primary' htmlType='submit' block>
            登录
          </Button>
        </Form.Item>
      </Form>
    </div>
  )
}
