import { currency } from 'pixiu-number-toolkit'
/**
 * 数据处理工具
 * /

/**
 * 百分比格式｜*100%
 * @param num 数字
 * @returns 百分比格式
 * @example currency(0.35, { style: 'percent' }) = 35%
 */
const precent = (num: number | string, precision = 2): string | number => {
  if (isNothing(num)) return '-'
  return currency(num, { style: 'percent', minimumFractionDigits: precision })
}

/**
 * 百分比格式|直接加后缀%
 * @param num 数字
 * @returns 百分比格式
 * @example currency(35, { suffix: '%', minimumFractionDigits: precision }) = 35%
 */
const precentAddSuffix = (num: number | string, precision = 2): string | number => {
  if (isNothing(num)) return '-'
  return currency(num, { suffix: '%', minimumFractionDigits: precision })
}

export { precent, precentAddSuffix }
