function getCookie(name: string) {
  const reg = new RegExp('(^| )' + name + '=([^;]*)(;|$)')
  const matches = reg.exec(document.cookie)
  return matches ? matches[2] : null
}

function setCookie(name: string, value: string, expired: number) {
  const d = new Date()
  d.setTime(d.getTime() + expired * 24 * 60 * 60 * 1000)
  const expires = 'expires=' + d.toUTCString()
  document.cookie = name + '=' + value + '; ' + expires
}

export default {
  get: getCookie,
  set: setCookie,
}
