import type { TimeRangePickerProps } from 'antd'

import dayjs from 'dayjs'
/**
 * 时间处理工具
 **/
export const rangePresets: TimeRangePickerProps['presets'] = [
  { label: '今天', value: [dayjs(), dayjs()] },
  { label: '昨天', value: [dayjs().add(-1, 'd'), dayjs().add(-1, 'd')] },
  { label: '最近三天', value: [dayjs().add(-2, 'd'), dayjs()] },
  { label: '最近七天', value: [dayjs().add(-6, 'd'), dayjs()] },
  { label: '最近三十一天', value: [dayjs().add(-31, 'd'), dayjs()] },
  { label: '本月', value: [dayjs().startOf('month'), dayjs().endOf('month')] },
]

export const changeDate = (num: number, format = 'YYYY-MM-DD') => {
  return dayjs().add(num, 'days').format(format)
}
