import { UserOutlined, SettingOutlined } from '@ant-design/icons'

const { Header, Content, Sider } = Layout

const menuItems = [
  {
    key: 'user',
    icon: <UserOutlined />,
    label: '用户管理',
    children: [
      {
        key: '/user/list',
        label: '人员列表',
      },
      {
        key: '/user/dept',
        label: '组织架构',
      },
    ],
  },
  {
    key: '/system',
    icon: <SettingOutlined />,
    label: '系统管理',
  },
]

const BasicLayout: React.FC<React.PropsWithChildren> = ({ children }) => {
  const {
    token: { colorBgContainer },
  } = theme.useToken()
  const navigate = useNavigate()

  return (
    <Layout className='h-screen text-9xl'>
      <Header className='p-0' />
      <Layout>
        <Sider breakpoint='lg' collapsible>
          <Menu theme='dark' mode='inline' items={menuItems} onSelect={({ key }) => navigate(key)} />
        </Sider>
        <Content className='mt-6 mx-4'>
          <div className='p-6' style={{ background: colorBgContainer }}>
            {children}
          </div>
        </Content>
      </Layout>
    </Layout>
  )
}

export default BasicLayout
