import { Suspense } from 'react'

import { StyleProvider } from '@ant-design/cssinjs'
import routes from '~react-pages'
import { ConfigProvider } from 'antd'

import Layouts from './layouts'

const App: React.FC = () => {
  return (
    <Suspense fallback={<Spin fullscreen />}>
      <StyleProvider layer>
        <ConfigProvider>
          <Layouts>{useRoutes(routes)}</Layouts>
        </ConfigProvider>
      </StyleProvider>
    </Suspense>
  )
}

export default App
