import { Dayjs } from 'dayjs'
/**
 * 广告位列表
 */
export interface SlotInfo {
  /** 广告位状态 */
  status?: string
  /** 推啊侧广告位id */
  id: number
  /** 媒体样式id */
  thirdStyle?: number
  /** 广告位名称 */
  thirdName?: string
  /** 关联的媒体id或dspId */
  relId?: number
  /** 关联的媒体名称或dsp名称 */
  relName?: string
  exposePv?: number
  clickPv?: number
  clickRate?: number
  cpc?: number
  /** 媒体广告位id */
  thirdId?: number
  /** 广告位类型 */
  slotType?: number
  type?: number
}

export type SlotInfoList = List<SlotInfo>
/**
 * 查询参数
 */
export interface QuerySlotParams extends paginationType {
  startDate?: string
  endDate?: string
  /** 关联的媒体名称或dsp名称 */
  relName?: string
  /** 关联的媒体id或dspId */
  relId?: number
  /** 媒体广告位id或dsp广告位id */
  thirdId?: number
  /** 推啊广告位id */
  id?: number
  /** 广告位名称 */
  thirdName?: string
  /** 广告位类型 */
  slotType?: number
  /** 类型  1-媒体 2-DSP */
  type?: number
  date?: Dayjs[]
}

export interface SlotModalData {
  relId?: number
  relName?: string
  slotType?: number
  /** 素材样式 */
  materialStyle?: string
  /** 媒体广告位id或dsp广告位id */
  thirdId?: number
  /** 广告位名称 */
  thirdName?: string
  /** 媒体样式id */
  thirdStyle?: number
  type?: number
}

export interface QueryDetail {
  id: number
}
