import type { Plugin } from 'vite'

// 自定义插件：将 unplugin-auto-import 的重复导入警告转为错误
export function AutoImportError(): Plugin {
  return {
    name: 'auto-import-error',
    configResolved() {
      // 在 Vite 配置解析后注入逻辑
      const logger = console
      const originalWarning = logger.warn

      // 劫持unimport的warn输出
      logger.warn = (msg: string) => {
        // 匹配 unplugin-auto-import 的重复导入警告
        const match = msg.match(/Duplicated imports "(.+)", the one from "(.+)" has been ignored and "(.+)" is used/)
        if (match) {
          // 抛出错误并终止进程
          const [, name, path1, path2] = match
          const modifiedMsg = `[重复导入错误] ${name} 在 ${path1} 和 ${path2} 中重复导入`
          // 提示：在开发环境下，抛出错误并终止进程
          if (process.env.NODE_ENV === 'production') {
            throw new Error(modifiedMsg)
          }
          logger.error(modifiedMsg)
          return
        }
        // 其他警告正常输出
        originalWarning.call(logger, msg)
      }
    },
  }
}
