interface Video {
  error?: boolean
  duration?: number
  width?: number
  height?: number
  type?: string
  size?: number
}
interface Image {
  width: number
  height: number
  size: number
}
export const getVideoInfo: (file: File) => Promise<Video> = (file) => {
  const videoDOM = document.createElement('video') as HTMLVideoElement
  videoDOM.src = URL.createObjectURL(file)
  const evt = 'loadedmetadata'
  return new Promise((resolve) => {
    videoDOM.onerror = () => {
      resolve({ error: true })
    }
    videoDOM.addEventListener(evt, function () {
      const { videoWidth: width, videoHeight: height } = this
      resolve({
        duration: videoDOM.duration || 0,
        type: 'MP4',
        size: file.size,
        width,
        height,
      })
    })
  })
}

export const getImgInfo: (file: File) => Promise<Image> = (file) => {
  return new Promise((res) => {
    if (typeof FileReader === 'function') {
      const { size } = file
      // 读取图片数据
      const reader = new FileReader()
      reader.onload = function (e: ProgressEvent<FileReader>) {
        const data = e.target?.result
        // 加载图片获取图片真实宽度和高度
        const image = new Image()
        image.onload = function () {
          const width = image.width
          const height = image.height
          res({ width, height, size })
        }
        image.src = data as string
      }
      reader.readAsDataURL(file)
    } else {
      console.log('你的浏览器不支持图片大小判断，请更换现代浏览器，例如Chrome')
    }
  })
}
const videoSnapshotSuffix = '?x-oss-process=video/snapshot,t_1000,m_fast,w_200'
export const getFileUrl = (fileUrl: string) => {
  if (fileUrl?.match(/.mp4$/) && !fileUrl?.includes(videoSnapshotSuffix)) {
    return fileUrl + videoSnapshotSuffix
  }
  return fileUrl
}

export const getSuffix = (url: string) => {
  return url?.replace(/.+\./, '')
}

export const checkIsVideo = (file: File): boolean => {
  return /.mp4/.test(file.name)
}
export const checkIsImage = (file: File): boolean => {
  return /.jpg|.jpeg|.png|.gif/.test(file.name)
}
