const XCsrfToken = cookie.get('csrf_token') || ''

export function createRequester() {
  const requester = axios.create({
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json',
      'X-Csrf-Token': XCsrfToken,
      'X-Proxy-Enabled': 'enabled',
    },
    withCredentials: true,
  })

  return requester
}

const request = createRequester()

request.interceptors.request.use(function (config) {
  const { params } = config
  for (const key in params) {
    if (isNothing(params[key])) {
      delete params[key]
    }
  }
  return { ...config, params }
})

request.interceptors.response.use(async function (response) {
  const { data, success, desc } = response.data
  if (success) return data
  message.error(desc)
  return Promise.reject(desc || '服务异常')
})

export default request

// const ssoRequest = createRequester()

// ssoRequest.interceptors.response.use(async function (response) {
//   const { success, message: desc, code } = response.data
//   if (success) return response.data
//   // 无应用访问权限
//   if (code === "SSO:01002") return response.data
//   // 未登录
//   message.error(desc)
//   window.location.href = `https://sso.duiba.com.cn/login?systemId=677&redirect=${encodeURIComponent(
//     window.location.origin
//   )}`
//   return response.data
// })

// export { ssoRequest }
