interface IOptions {
  label: string
  value: string | number
}

interface IProps {
  text: string
  selectValue: string | number | string[] | number[]
  options: IOptions[]
  callback: (value: string | number | string[] | number[]) => void
  mode?: undefined | 'tags' | 'multiple'
}

const TableSelect: React.FC<IProps> = memo(({ text, selectValue, options, mode = undefined, callback, ...rest }) => {
  const [edit, setEdit] = useState(false)
  const [value, setValue] = useState(selectValue)

  const handleAutoSave = (value: string | string[] | number | number[]) => {
    // 如果输入内容本质上没发生改变，则不做保存
    if (selectValue === value || (Array.isArray(value) && selectValue === value.join(','))) {
      setEdit(false)
      return
    }

    Modal.confirm({
      title: '确定修改',
      content: `确定当前内容吗？`,
      okText: '确定',
      cancelText: '取消',
      async onOk() {
        callback(value)
        setValue(value)
        setEdit(false)
      },
      onCancel() {
        setEdit(false)
        setValue(selectValue)
      },
    })
  }

  return edit ? (
    <Select mode={mode} value={value} onChange={handleAutoSave} options={options} style={{ width: 120 }} />
  ) : (
    <div>
      <a onClick={() => setEdit(true)} {...rest}>
        {isNothing(text) ? '-' : text}
      </a>
    </div>
  )
})

export default TableSelect
