import { Form, Input } from 'antd'
import { observer } from 'mobx-react-lite'

import { SLOT_TYPE_OPTIONS, MATERIAL_STYLE_OPTIONS, PARAMS_TYPE } from '../common/const'
import store from '../store'
const { Item: FormItem } = Form
interface ModalProp {
  refresh: () => void
}
const SlotModal: React.FC<ModalProp> = observer(({ refresh }) => {
  const [form] = Form.useForm<SlotModalData>()
  const { modalOpen, setModalOpen, idEdit, modalData } = store

  useEffect(() => {
    form.setFieldsValue(modalData)
  }, [form, modalData])

  const submit = async (e: React.MouseEvent<HTMLElement, MouseEvent>) => {
    e.preventDefault()
    const values = await form.validateFields()
    const params = { ...modalData, ...values, type: PARAMS_TYPE.MEDIA }
    await saveSlot(params)
    refresh()
    close()
  }
  const close = () => {
    setModalOpen(false, {})
    form.resetFields()
  }

  return (
    <Modal title={`${idEdit ? '修改' : '添加'}广告位`} open={modalOpen} okText='保存' onCancel={close} onOk={submit}>
      <Form form={form}>
        <FormItem<SlotModalData> label='媒体名称' name='relName' rules={[Rules.name]}>
          <Input style={{ width: 200 }} disabled />
        </FormItem>
        <FormItem<SlotModalData> label='广告位类型' name='slotType' rules={[Rules.required]}>
          <Select style={{ width: 200 }} placeholder='请选择广告位类型' options={SLOT_TYPE_OPTIONS} />
        </FormItem>
        <FormItem<SlotModalData> label='素材样式选择' name='materialStyle' rules={[Rules.required]}>
          <Checkbox.Group options={MATERIAL_STYLE_OPTIONS} />
        </FormItem>
        <FormItem<SlotModalData> label='媒体广告位ID' name='thirdId' rules={[Rules.required, Rules.id]}>
          <Input style={{ width: 200 }} placeholder='请输入媒体广告位ID' />
        </FormItem>
        <FormItem<SlotModalData> label='媒体样式ID' name='thirdStyle' rules={[Rules.required, Rules.id]}>
          <Input style={{ width: 200 }} placeholder='请输入媒体样式ID' />
        </FormItem>
      </Form>
    </Modal>
  )
})

export default SlotModal
