import type { TableColumnsType } from 'antd'

import store from '../store/index.ts'
interface ListProp {
  data: SlotInfoList | undefined
  searchRun: (param: QuerySlotParams) => void
}
const List: React.FC<ListProp> = observer((prop: ListProp) => {
  const { slotSearchParams, setModalOpen } = store
  const { data, searchRun } = prop

  const columns: TableColumnsType<SlotInfo> = [
    {
      title: '广告位状态',
      dataIndex: 'status',
      key: 'status',
      render: (value: number) => <Switch checked={value === 1} />,
    },
    {
      title: '推啊广告位ID',
      dataIndex: 'id',
      key: 'id',
    },
    {
      title: '媒体样式ID',
      dataIndex: 'thirdStyle',
      key: 'thirdStyle',
    },
    {
      title: '广告位名称',
      dataIndex: 'thirdName',
      key: 'thirdName',
      render: (text, record) => {
        return (
          <div className='flex flex-col items-center justify-center w-full h-[50px] group'>
            <a className='w-[120px] text-center'>{text}</a>
            <div className='max-h-0 overflow-hidden group-hover:max-h-[30px]'>
              <a
                onClick={async () => {
                  const res = await getSlotDetail({ id: record.id })
                  setModalOpen(true, res)
                }}>
                编辑
              </a>
            </div>
          </div>
        )
      },
    },
    {
      title: '媒体ID',
      dataIndex: 'relId',
      key: 'relId',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
    {
      title: '媒体名称',
      dataIndex: 'relName',
      key: 'relName',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
    {
      title: '曝光',
      dataIndex: 'exposePv',
      key: 'exposePv',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
    {
      title: '点击',
      dataIndex: 'clickPv',
      key: 'clickPv',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
    {
      title: '点击率',
      dataIndex: 'clickRate',
      key: 'clickRate',
      render: (text) => {
        return <div>{checkEmpty(text) + '%'}</div>
      },
    },
    {
      title: 'CPC',
      dataIndex: 'cpc',
      key: 'cpc',
      render: (text) => {
        return <div>{checkEmpty(text)}</div>
      },
    },
  ]
  const handlePageChange = async (page: number, pageSize: number) => {
    const param = {
      ...slotSearchParams,
      pageSize: pageSize,
      currentPage: page,
    }
    searchRun(param)
  }
  return (
    <Table<SlotInfo>
      className='mt-5'
      dataSource={data?.list}
      columns={columns}
      pagination={{
        pageSizeOptions: [10, 20, 50],
        showQuickJumper: true,
        total: data?.total,
        onChange: handlePageChange,
      }}
    />
  )
})

export default List
