import { Form, DatePicker, ConfigProvider, Input, Button } from 'antd'
import locale from 'antd/es/locale/zh_CN' // Ant Design 的中文语言包
import { observer } from 'mobx-react-lite'

import store from '../store'
const { Item: FormItem } = Form
const { RangePicker } = DatePicker
interface SearchProp {
  searchRun: (param: QueryMediaParams) => void
}
const Search: React.FC<SearchProp> = observer((prop: SearchProp) => {
  const [form] = Form.useForm<QueryMediaParams>()
  const { searchRun } = prop
  const { setMediaSearchParams, mediaSearchParams } = store
  useEffect(() => {
    form.setFieldsValue(mediaSearchParams)
  }, [form, mediaSearchParams])
  const handleSearch = (e: React.MouseEvent<HTMLElement, MouseEvent>) => {
    e.preventDefault()
    form.validateFields().then((values) => {
      const [startDate, endDate] = values.date || []
      const newParams = {
        ...mediaSearchParams,
        ...values,
        startDate: startDate.format('YYYY-MM-DD'),
        endDate: endDate.format('YYYY-MM-DD'),
        id: Number(values.id),
      }
      setMediaSearchParams(newParams)
      searchRun(newParams)
    })
  }

  return (
    <ConfigProvider locale={locale}>
      <Form form={form} layout='inline'>
        <FormItem name='date'>
          <RangePicker format='YYYY-MM-DD' />
        </FormItem>
        <FormItem<QueryMediaParams> label='媒体ID' name='id' rules={[Rules.id]}>
          <Input style={{ width: 200 }} placeholder='请输入媒体ID' />
        </FormItem>
        <FormItem<QueryMediaParams> label='媒体名称' name='mediaName' rules={[Rules.name]}>
          <Input style={{ width: 200 }} placeholder='请输入媒体名称' />
        </FormItem>
        <FormItem>
          <Button type='primary' onClick={handleSearch}>
            搜索
          </Button>
        </FormItem>
      </Form>
    </ConfigProvider>
  )
})

export default Search
